/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtActionElement;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ElementListener;
import cz.cuni.amis.utils.collections.ObservableList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewtContainer<T extends StoryAction, W extends NewtActionElement>
extends JLayeredPane {
    protected final EmoNewtFrame frame;
    protected final ViewController controller;
    protected final EmohawkCharacter ec;
    public static final int MAX_HEIGHT = 25;
    public static final int MIN_HEIGHT = 25;
    public static final int MAX_WIDTH = 32000;
    public static final int MIN_WIDTH = 640;
    public static int TOP_LAYER = 1;
    protected HashMap<T, W> actions = new HashMap();
    protected ActionsListener actionsListener;

    protected NewtContainer(EmoNewtFrame frame, ViewController controller, EmohawkCharacter ec, ObservableList<T> actions) {
        this.frame = frame;
        this.controller = controller;
        this.ec = ec;
        this.setLayout(null);
        Dimension myDim = new Dimension();
        myDim.setSize(32000, 25);
        for (StoryAction action : actions) {
            this.addAction(action);
            this.repaint();
        }
        this.actionsListener = new ActionsListener();
        actions.addCollectionListener((CollectionEventListener)this.actionsListener);
        ComponentAdapter resizeListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
            }
        };
        this.addComponentListener(resizeListener);
    }

    public void focusActiveAction(T action, boolean active) {
        if (!this.actions.containsKey(action)) {
            return;
        }
        if (StoryTools.DEBUG) {
            System.out.println("Active action: " + ((StoryAction)action).toString() + active);
        }
        if (active) {
            ((NewtActionElement)this.actions.get(action)).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.black, Color.gray), BorderFactory.createEtchedBorder(Color.black, Color.gray)));
        } else {
            ((NewtActionElement)this.actions.get(action)).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEtchedBorder()));
        }
    }

    protected abstract W createVisualElement(T var1);

    protected void addAction(T action) {
        if (this.getElement(action) != null) {
            return;
        }
        W element = this.createVisualElement(action);
        this.actions.put(action, element);
        this.add((Component)element);
    }

    private void repaintAllActions() {
        Iterator<W> i$ = this.actions.values().iterator();
        while (i$.hasNext()) {
            NewtActionElement ele;
            NewtActionElement element = ele = (NewtActionElement)i$.next();
            element.actionChanged();
        }
    }

    public HashMap<T, W> getActions() {
        return this.actions;
    }

    protected void actionClicked(W actionElement) {
        if (TOP_LAYER >= 10000) {
            for (NewtActionElement action : this.actions.values()) {
                this.setLayer(action, 0);
            }
            TOP_LAYER = 1;
        }
        this.setLayer((Component)actionElement, TOP_LAYER++);
    }

    protected abstract void changeAction(ChangeStoryAction var1);

    protected W getElement(T action) {
        return (W)((NewtActionElement)this.actions.get(action));
    }

    protected abstract void removeAction(T var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ActionsListener
    extends ElementListener<T> {
        protected ActionsListener() {
        }

        public void elementChanged(T action, boolean added) {
            if (added) {
                NewtContainer.this.addAction(action);
            } else {
                NewtContainer.this.removeAction(action);
            }
            NewtContainer.this.repaint();
        }
    }
}

