/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.emonewt.gui.AvatarState;
import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtActionElement;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtAnimationElement;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtCharPane;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryLenghtChangeListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryPlayerListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IUndoRedoListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeActionParent;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeContainer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ElementListener;
import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewtCharsPane
extends JPanel
implements IStoryPlayerListener,
IStoryLenghtChangeListener,
ViewController.ControllerSelectionListener {
    private final EmoNewtFrame frame;
    private final ViewController controller;
    private CharacterChangesListener changesListener;
    protected Map<Integer, NewtCharPane> chars = new HashMap<Integer, NewtCharPane>();
    private CharactersListener characterListener;

    public void redrawAllElements() {
        for (NewtCharPane p : this.chars.values()) {
            for (NewtActionElement a : p.getNewtActionsPane().getAnimationLayer().getActions().values()) {
                ((NewtAnimationElement)a).actionChanged();
            }
            for (NewtActionElement a : p.getNewtActionsPane().getMovementLayer().getActions().values()) {
                a.actionChanged();
            }
            for (NewtActionElement a : p.getNewtActionsPane().getRotationLayer().getActions().values()) {
                a.actionChanged();
            }
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void storyLengthChanged(long oldLength, long newLength) {
        this.redrawAllElements();
    }

    private void setCharActive(EmohawkCharacter ec, boolean active) {
        if (!this.chars.containsKey(ec.id)) {
            return;
        }
        if (active) {
            this.chars.get(ec.id).setBorder(BorderFactory.createLineBorder(Color.black, 2));
        } else {
            this.chars.get(ec.id).setBorder(BorderFactory.createEtchedBorder());
        }
    }

    @Override
    public void focusChanged(Object prevFocusedObject, Object focusedObject) {
        EmohawkCharacter ec;
        if (prevFocusedObject instanceof EmohawkCharacter) {
            ec = (EmohawkCharacter)prevFocusedObject;
            this.setCharActive(ec, false);
        } else if (prevFocusedObject instanceof StoryAction) {
            ec = ((StoryAction)prevFocusedObject).getOwner();
            this.setCharActive(ec, false);
        }
        if (focusedObject instanceof EmohawkCharacter) {
            ec = (EmohawkCharacter)focusedObject;
            this.setCharActive(ec, true);
        } else if (focusedObject instanceof StoryAction) {
            ec = ((StoryAction)focusedObject).getOwner();
            this.setCharActive(ec, true);
        }
    }

    @Override
    public void selectionChanged(Set<?> prevSelectedObjects, Set<?> selectedObject) {
    }

    @Override
    public void avatarsChanged(long time, Map<EmohawkCharacter, AvatarState> avataStates) {
    }

    public NewtCharsPane(EmoNewtFrame frame, StoryController model, ViewController controller) {
        this.frame = frame;
        this.controller = controller;
        this.initComponents();
        for (EmohawkCharacter ec : model.getStoryCharacters()) {
            this.addCharacter(ec);
        }
        this.characterListener = new CharactersListener();
        model.getStoryCharacters().addCollectionListener((CollectionEventListener)this.characterListener);
        this.changesListener = new CharacterChangesListener();
        model.getChangeActions().addCollectionListener((CollectionEventListener)this.changesListener);
        model.addUndoRedoListener(this.changesListener);
        controller.addStoryPlayerListener(this);
        model.addStoryLengthChangedListener(this);
        controller.addSWControllerListener(this);
    }

    protected synchronized void addCharacter(EmohawkCharacter ec) {
        if (this.getCharacter(ec) != null) {
            return;
        }
        NewtCharPane pane = new NewtCharPane(this.frame, this.controller, ec);
        this.chars.put(ec.id, pane);
        if (StoryTools.DEBUG) {
            System.out.println("Character pridan.");
        }
        this.add(pane);
        if (StoryTools.DEBUG) {
            System.out.println("Panel pridan.");
        }
    }

    private NewtCharPane getCharacter(EmohawkCharacter ec) {
        return this.chars.get(ec.id);
    }

    private NewtCharPane getCharacter(int id) {
        return this.chars.get(id);
    }

    protected void changeCharacter(int id, EmohawkCharacter ec) {
        NewtCharPane pane = this.getCharacter(id);
        if (pane == null) {
            return;
        }
        pane.changeCharacter();
        this.frame.getPropertiesPane().notifyCharacterChanged(ec);
    }

    protected void changeAction(ChangeStoryAction action) {
        NewtCharPane pane = this.getCharacter(action.getCharacter().id);
        if (pane == null) {
            return;
        }
        pane.changeAction(action);
        pane.validate();
        pane.repaint();
        this.frame.getPropertiesPane().notifyActionChanged(action.getCurrentAction());
    }

    protected synchronized void removeCharacter(EmohawkCharacter ec) {
        NewtCharPane pane = this.getCharacter(ec);
        if (pane == null) {
            return;
        }
        this.chars.remove(ec.id);
        this.remove(pane);
        this.frame.getPropertiesPane().notifyCharacterRemoved(ec);
    }

    @Override
    public void storyPlayChanged(boolean bPaused) {
        for (NewtCharPane p : this.chars.values()) {
            p.setEnabled(!bPaused);
            for (NewtActionElement a : p.getNewtActionsPane().getAnimationLayer().getActions().values()) {
                a.setEnabled(!bPaused);
            }
            for (NewtActionElement a : p.getNewtActionsPane().getMovementLayer().getActions().values()) {
                a.setEnabled(!bPaused);
            }
            for (NewtActionElement a : p.getNewtActionsPane().getRotationLayer().getActions().values()) {
                a.setEnabled(!bPaused);
            }
        }
    }

    private void initComponents() {
        this.setMaximumSize(new Dimension(20000, 20000));
        this.setLayout(new BoxLayout(this, 1));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CharacterChangesListener
    extends ElementListener<ChangeContainer>
    implements IUndoRedoListener {
        private CharacterChangesListener() {
        }

        public void elementChanged(ChangeContainer elem, boolean added) {
            if (added && elem.getClass().equals(ChangeCharacter.class) && elem.getChangeType() == ChangeType.CHANGE) {
                ChangeCharacter charChange = (ChangeCharacter)elem;
                NewtCharsPane.this.changeCharacter(charChange.getCharacter().id, charChange.getCharacter());
                NewtCharsPane.this.validate();
            } else if (added && elem.getClass().equals(ChangeActionParent.class)) {
                ChangeActionParent actionParent = (ChangeActionParent)elem;
                for (ChangeStoryAction action : actionParent.getChangesList()) {
                    if (action.getChangeType() != ChangeType.CHANGE) continue;
                    NewtCharsPane.this.changeAction(action);
                }
                NewtCharsPane.this.validate();
            }
        }

        @Override
        public void undoRedoPerformed(ChangeContainer change, boolean undo) {
            if (change.getClass().equals(ChangeCharacter.class) && change.getChangeType() == ChangeType.CHANGE) {
                ChangeCharacter changeChar = (ChangeCharacter)change;
                NewtCharsPane.this.changeCharacter(changeChar.getCharacter().id, changeChar.getCharacter());
                NewtCharsPane.this.validate();
            } else if (change.getClass().equals(ChangeActionParent.class)) {
                ChangeActionParent actionParent = (ChangeActionParent)change;
                for (ChangeStoryAction action : actionParent.getChangesList()) {
                    if (action.getChangeType() != ChangeType.CHANGE) continue;
                    NewtCharsPane.this.changeAction(action);
                }
                NewtCharsPane.this.validate();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CharactersListener
    extends ElementListener<EmohawkCharacter> {
        private CharactersListener() {
        }

        public void elementChanged(EmohawkCharacter elem, boolean added) {
            if (added) {
                NewtCharsPane.this.addCharacter(elem);
            } else {
                NewtCharsPane.this.removeCharacter(elem);
            }
            NewtCharsPane.this.validate();
            NewtCharsPane.this.repaint();
        }
    }
}

