/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.tools.IntTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.CharacterProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EBodyTexType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ECharacterType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ESkinTexType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class NewtCharacterProperties
extends JPanel {
    private final EmohawkCharacter character;
    private List<ECharacterType> characterTypes;
    private List<ESkinTexType> skinTexs;
    private List<EBodyTexType> bodyTexs;
    private ViewController controller;
    private JButton btnApplyChanges;
    private JButton btnPreview;
    private JButton btnResetFields;
    private JButton btnSnapAngle;
    private JComboBox cmbBodyTex;
    private JComboBox cmbSkinTex;
    private JPanel jPanel1;
    private JLabel lblBodyTexture;
    private JLabel lblCharName;
    private JLabel lblCharType;
    private JLabel lblLocationValueXY;
    private JLabel lblSkinTexture;
    private JLabel lblStartLocation;
    private JLabel lblStartRotation;
    private JTextField txtAngleH;
    private JTextField txtAngleV;
    private JTextField txtCharName;
    private JTextField txtCharType;
    private JTextField txtLocationZ;

    private void resetTextures(ECharacterType type) {
        this.skinTexs = new ArrayList<ESkinTexType>(ESkinTexType.getSkinTextures(type));
        this.bodyTexs = new ArrayList<EBodyTexType>(EBodyTexType.getBodyTextures(type));
        this.cmbBodyTex.setModel(new DefaultComboBoxModel<Object>(this.bodyTexs.toArray()));
        this.cmbSkinTex.setModel(new DefaultComboBoxModel<Object>(this.skinTexs.toArray()));
        if (this.character.getCharacterProperties().getCharacterClass() == type) {
            this.cmbBodyTex.setSelectedItem((Object)this.character.getCharacterProperties().getBodyTexture());
            this.cmbSkinTex.setSelectedItem((Object)this.character.getCharacterProperties().getSkinTexture());
        }
    }

    public EmohawkCharacter getCharacter() {
        return this.character;
    }

    public NewtCharacterProperties(ViewController controller, EmohawkCharacter character) {
        this.character = character;
        this.controller = controller;
        this.characterTypes = new ArrayList<ECharacterType>();
        this.characterTypes.addAll(ECharacterType.getCollection());
        this.initComponents();
        this.resetValues();
    }

    public void characterChanged(EmohawkCharacter ec) {
        if (this.character.id == ec.id) {
            this.resetValues();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.txtAngleH = new IntTextField();
        this.lblSkinTexture = new JLabel();
        this.lblLocationValueXY = new JLabel();
        this.lblCharType = new JLabel();
        this.cmbBodyTex = new JComboBox();
        this.txtCharName = new JTextField();
        this.txtCharType = new JTextField();
        this.lblCharName = new JLabel();
        this.txtAngleV = new IntTextField();
        this.lblBodyTexture = new JLabel();
        this.lblStartLocation = new JLabel();
        this.lblStartRotation = new JLabel();
        this.cmbSkinTex = new JComboBox();
        this.txtLocationZ = new IntTextField();
        this.btnApplyChanges = new JButton();
        this.btnSnapAngle = new JButton();
        this.btnResetFields = new JButton();
        this.btnPreview = new JButton();
        this.setBorder(BorderFactory.createTitledBorder(StorySettings.currentBundle.getString("CHARACTER EDITOR")));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.txtAngleH.setHorizontalAlignment(4);
        this.txtAngleH.setText("0");
        this.txtAngleH.setToolTipText(StorySettings.currentBundle.getString("ROTATION_YAW"));
        this.txtAngleH.setName("txtAngleH");
        this.jPanel1.add((Component)this.txtAngleH, new AbsoluteConstraints(100, 100, 45, -1));
        this.lblSkinTexture.setText(StorySettings.currentBundle.getString("SKIN TEX:"));
        this.lblSkinTexture.setName("lblSkinTexture");
        this.jPanel1.add((Component)this.lblSkinTexture, new AbsoluteConstraints(0, 40, -1, -1));
        this.lblLocationValueXY.setText("0,0,0");
        this.lblLocationValueXY.setName("lblLocationValueXY");
        this.jPanel1.add((Component)this.lblLocationValueXY, new AbsoluteConstraints(80, 80, 120, 20));
        this.lblCharType.setText(StorySettings.currentBundle.getString("CHAR TYPE:"));
        this.lblCharType.setName("lblCharType");
        this.jPanel1.add((Component)this.lblCharType, new AbsoluteConstraints(0, 20, -1, -1));
        this.cmbBodyTex.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbBodyTex.setName("cmbBodyTex");
        this.jPanel1.add((Component)this.cmbBodyTex, new AbsoluteConstraints(100, 60, 140, 20));
        this.txtCharName.setToolTipText(StorySettings.currentBundle.getString("CHAR_NAME_H"));
        this.txtCharName.setName("txtCharName");
        this.jPanel1.add((Component)this.txtCharName, new AbsoluteConstraints(100, 0, 140, 20));
        this.txtCharType.setEditable(false);
        this.txtCharType.setName("txtCharType");
        this.jPanel1.add((Component)this.txtCharType, new AbsoluteConstraints(100, 20, 140, 20));
        this.lblCharName.setText(StorySettings.currentBundle.getString("CHAR NAME:"));
        this.lblCharName.setName("lblCharName");
        this.jPanel1.add((Component)this.lblCharName, new AbsoluteConstraints(0, 0, -1, -1));
        this.txtAngleV.setHorizontalAlignment(4);
        this.txtAngleV.setText("0");
        this.txtAngleV.setToolTipText(StorySettings.currentBundle.getString("ROT_ANGLE_H"));
        this.txtAngleV.setName("txtAngleV");
        this.jPanel1.add((Component)this.txtAngleV, new AbsoluteConstraints(150, 100, 47, -1));
        this.lblBodyTexture.setText(StorySettings.currentBundle.getString("BODY TEX:"));
        this.lblBodyTexture.setName("lblBodyTexture");
        this.jPanel1.add((Component)this.lblBodyTexture, new AbsoluteConstraints(0, 60, -1, -1));
        this.lblStartLocation.setText(StorySettings.currentBundle.getString("START LOC:"));
        this.lblStartLocation.setName("lblStartLocation");
        this.jPanel1.add((Component)this.lblStartLocation, new AbsoluteConstraints(0, 80, -1, 20));
        this.lblStartRotation.setText(StorySettings.currentBundle.getString("START ROT:"));
        this.lblStartRotation.setName("lblStartRotation");
        this.jPanel1.add((Component)this.lblStartRotation, new AbsoluteConstraints(0, 100, -1, 20));
        this.cmbSkinTex.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbSkinTex.setName("cmbSkinTex");
        this.jPanel1.add((Component)this.cmbSkinTex, new AbsoluteConstraints(100, 40, 140, 20));
        this.txtLocationZ.setHorizontalAlignment(4);
        this.txtLocationZ.setText("0");
        this.txtLocationZ.setToolTipText(StorySettings.currentBundle.getString("ROT_ANGLE_H"));
        this.txtLocationZ.setName("txtLocationZ");
        this.jPanel1.add((Component)this.txtLocationZ, new AbsoluteConstraints(200, 80, 40, -1));
        this.btnApplyChanges.setText(StorySettings.currentBundle.getString("APPLY"));
        this.btnApplyChanges.setToolTipText(StorySettings.currentBundle.getString("USE_H"));
        this.btnApplyChanges.setName("btnApplyChanges");
        this.btnApplyChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtCharacterProperties.this.btnApplyChangesActionPerformed(evt);
            }
        });
        this.btnSnapAngle.setText(StorySettings.currentBundle.getString("ANGLE_SNAP"));
        this.btnSnapAngle.setToolTipText(StorySettings.currentBundle.getString("ANGLE_SNAP_TOOLTIP"));
        this.btnSnapAngle.setName("btnSnapAngle");
        this.btnSnapAngle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtCharacterProperties.this.btnSnapAngleActionPerformed(evt);
            }
        });
        this.btnResetFields.setText(StorySettings.currentBundle.getString("RESET"));
        this.btnResetFields.setToolTipText(StorySettings.currentBundle.getString("RESET_H"));
        this.btnResetFields.setName("btnResetFields");
        this.btnResetFields.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtCharacterProperties.this.btnResetFieldsActionPerformed(evt);
            }
        });
        this.btnPreview.setText(StorySettings.currentBundle.getString("PREVIEW"));
        this.btnPreview.setName("btnPreview");
        this.btnPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtCharacterProperties.this.btnPreviewActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.btnApplyChanges, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnResetFields, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPreview, -2, 76, -2)).addComponent(this.btnSnapAngle));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnApplyChanges).addComponent(this.btnResetFields).addComponent(this.btnPreview)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSnapAngle)));
    }

    public void resetValues() {
        Rotation startRot;
        this.txtCharType.setText(this.character.getCharacterProperties().getCharacterClass().toString());
        this.resetTextures(this.character.getCharacterProperties().getCharacterClass());
        this.txtCharName.setText(this.character.getName());
        Location startLoc = this.character.getCharacterProperties().getStartLocation();
        if (startLoc != null) {
            this.lblLocationValueXY.setText("x=" + Math.round(startLoc.x) + ", y=" + Math.round(startLoc.y) + ", z=");
            this.txtLocationZ.setText(String.valueOf(Math.round(startLoc.z)));
        }
        if ((startRot = this.character.getCharacterProperties().getStartRotation()) != null) {
            this.txtAngleH.setText(String.valueOf(StoryTools.unitsToAngle(startRot.yaw)));
            this.txtAngleV.setText(String.valueOf(StoryTools.unitsToAngle(startRot.pitch)));
        }
    }

    private void btnApplyChangesActionPerformed(ActionEvent evt) {
        CharacterProperties oldCP = new CharacterProperties(this.character.getCharacterProperties());
        CharacterProperties newCP = new CharacterProperties(oldCP);
        newCP.setName(this.txtCharName.getText());
        if (((IntTextField)this.txtAngleH).getValue() < -180) {
            this.txtAngleH.setText(String.valueOf(-180));
        } else if (((IntTextField)this.txtAngleH).getValue() > 180) {
            this.txtAngleH.setText(String.valueOf(180));
        }
        if (((IntTextField)this.txtAngleV).getValue() < -180) {
            this.txtAngleV.setText(String.valueOf(-180));
        } else if (((IntTextField)this.txtAngleV).getValue() > 180) {
            this.txtAngleV.setText(String.valueOf(180));
        }
        Location loc = this.character.getCharacterProperties().getStartLocation();
        loc.z = ((IntTextField)this.txtLocationZ).getValue();
        newCP.setStartRotation(new Rotation((double)StoryTools.angleToUTUnits(((IntTextField)this.txtAngleV).getValue()), (double)StoryTools.angleToUTUnits(((IntTextField)this.txtAngleH).getValue()), 0.0));
        newCP.setStartLocation(loc);
        newCP.setSkinTexture((ESkinTexType)((Object)this.cmbSkinTex.getSelectedItem()));
        newCP.setBodyTexture((EBodyTexType)((Object)this.cmbBodyTex.getSelectedItem()));
        ChangeCharacter change = new ChangeCharacter(ChangeType.CHANGE, this.character.id, this.character, oldCP, newCP);
        this.character.getModel().processChangeCharacter(change);
    }

    public void setEverythingDisable(boolean bEnabled) {
        this.btnApplyChanges.setEnabled(!bEnabled);
        this.btnResetFields.setEnabled(!bEnabled);
        this.cmbBodyTex.setEnabled(!bEnabled);
        this.cmbSkinTex.setEnabled(!bEnabled);
        this.lblBodyTexture.setEnabled(!bEnabled);
        this.lblCharName.setEnabled(!bEnabled);
        this.lblCharType.setEnabled(!bEnabled);
        this.lblLocationValueXY.setEnabled(!bEnabled);
        this.txtAngleH.setEnabled(!bEnabled);
        this.txtAngleV.setEnabled(!bEnabled);
        this.lblSkinTexture.setEnabled(!bEnabled);
        this.lblStartLocation.setEnabled(!bEnabled);
        this.lblStartRotation.setEnabled(!bEnabled);
        this.txtCharName.setEnabled(!bEnabled);
        this.btnPreview.setEnabled(!bEnabled);
        this.txtCharType.setEnabled(!bEnabled);
        this.txtLocationZ.setEnabled(!bEnabled);
    }

    private void btnResetFieldsActionPerformed(ActionEvent evt) {
        this.resetValues();
    }

    private void btnPreviewActionPerformed(ActionEvent evt) {
        if (!this.controller.isUnrealServerRunning()) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("REQUESTCONNECT"));
            return;
        }
        if (this.cmbBodyTex.getSelectedItem() == null || this.cmbSkinTex.getSelectedItem() == null) {
            return;
        }
        String clothes = Integer.valueOf(((EBodyTexType)((Object)this.cmbBodyTex.getSelectedItem())).getTextureID()).toString();
        String skin = Integer.valueOf(((ESkinTexType)((Object)this.cmbSkinTex.getSelectedItem())).getTextureID()).toString();
        this.controller.previewCharacter(this.character, clothes, skin);
    }

    private void btnSnapAngleActionPerformed(ActionEvent evt) {
        Rotation rotationSnap = this.controller.getUnrealStoryPlayer().getRotationSnapFromUnreal();
        this.txtAngleH.setText(String.valueOf(StoryTools.unitsToAngle(rotationSnap.yaw)));
        this.txtAngleV.setText(String.valueOf(StoryTools.unitsToAngle(rotationSnap.pitch)));
    }
}

