/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtCharActionsPane;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtCharacterProperties;
import cz.cuni.amis.pogamut.emonewt.gui.dialogs.NewtNewAnimationDialog;
import cz.cuni.amis.pogamut.emonewt.gui.dialogs.NewtNewMovementDialog;
import cz.cuni.amis.pogamut.emonewt.gui.dialogs.NewtNewRotationDialog;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.CharacterProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class NewtCharPane
extends JPanel {
    private JLabel charNameLabel;
    private NewtCharActionsPane newtActionsPane;
    private final EmohawkCharacter emoCharacter;
    private final EmoNewtFrame frame;
    private final ViewController controller;
    private int lastMousePressX = 0;
    private int lastMousePressY = 0;
    private MouseListener focusListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            if (!NewtCharPane.this.isEnabled()) {
                return;
            }
            NewtCharPane.this.lastMousePressX = e.getXOnScreen();
            NewtCharPane.this.lastMousePressY = e.getYOnScreen();
            NewtCharPane.this.controller.setFocusedObject(NewtCharPane.this.emoCharacter);
        }

        public void mouseClicked(MouseEvent e) {
            if (!NewtCharPane.this.isEnabled()) {
                return;
            }
            NewtCharPane.this.frame.getPropertiesPane().setPropertiesPane(new NewtCharacterProperties(NewtCharPane.this.controller, NewtCharPane.this.emoCharacter), null);
            NewtCharPane.this.controller.setFocusedObject(NewtCharPane.this.emoCharacter);
            if (NewtCharPane.this.controller.isSimulationRunning() || NewtCharPane.this.controller.isUnrealStoryRunning()) {
                NewtCharPane.this.frame.getPropertiesPane().setButtonsDisabled();
            }
        }
    };

    public NewtCharPane(EmoNewtFrame frame, ViewController controller, EmohawkCharacter ec) {
        this.emoCharacter = ec;
        this.frame = frame;
        this.controller = controller;
        this.charNameLabel = new JLabel();
        this.newtActionsPane = new NewtCharActionsPane(frame, controller, ec);
        this.setLayout(new BoxLayout(this, 1));
        this.charNameLabel.setText(ec.getName());
        this.charNameLabel.setBorder(BorderFactory.createEtchedBorder());
        this.charNameLabel.setName("charNameLabel");
        this.add(this.charNameLabel);
        this.newtActionsPane.setBorder(BorderFactory.createEtchedBorder());
        this.newtActionsPane.setName("newtActionsPane");
        this.add(this.newtActionsPane);
        JPopupMenu popupMenu = new JPopupMenu(ec.getName());
        popupMenu.add(new PopUpAddAnimation());
        popupMenu.add(new PopUpAddMovement());
        popupMenu.add(new PopUpAddRotation());
        popupMenu.add(new PopUpChangeCharacter());
        popupMenu.add(new PopUpDeleteCharacter());
        this.setComponentPopupMenu(popupMenu);
        this.addMouseListener(this.focusListener);
    }

    public void changeCharacter() {
        this.charNameLabel.setText(this.emoCharacter.getName());
    }

    public void changeAction(ChangeStoryAction action) {
        this.newtActionsPane.changeAction(action);
    }

    public NewtCharActionsPane getNewtActionsPane() {
        return this.newtActionsPane;
    }

    private class PopUpDeleteCharacter
    extends AbstractAction {
        public PopUpDeleteCharacter() {
            super(StorySettings.currentBundle.getString("DELETE CHARACTER"));
        }

        public void actionPerformed(ActionEvent e) {
            if (NewtCharPane.this.controller.isSimulationRunning() || NewtCharPane.this.controller.isUnrealStoryRunning()) {
                StoryTools.userNotificationDialog(NewtCharPane.this.frame, StorySettings.currentBundle.getString("REQUESTSTOPSTORY"));
                return;
            }
            EmohawkCharacter character = NewtCharPane.this.emoCharacter;
            int res = JOptionPane.showConfirmDialog(NewtCharPane.this, MessageFormat.format(StorySettings.currentBundle.getString("ASKDELETECHARACTER"), character.getName()), StorySettings.currentBundle.getString("ARE YOU SURE?"), 2);
            if (res == 0) {
                ChangeCharacter change = new ChangeCharacter(ChangeType.DELETE, character.id, character);
                character.getModel().processChangeCharacter(change);
            }
        }
    }

    private class PopUpChangeCharacter
    extends AbstractAction {
        public PopUpChangeCharacter() {
            super(StorySettings.currentBundle.getString("CHANGE CHARACTER NAME"));
        }

        public void actionPerformed(ActionEvent e) {
            if (NewtCharPane.this.controller.isSimulationRunning() || NewtCharPane.this.controller.isUnrealStoryRunning()) {
                StoryTools.userNotificationDialog(NewtCharPane.this.frame, StorySettings.currentBundle.getString("REQUESTSTOPSTORY"));
                return;
            }
            EmohawkCharacter character = NewtCharPane.this.emoCharacter;
            String s = JOptionPane.showInputDialog(NewtCharPane.this, StorySettings.currentBundle.getString("TYPE NEW CHARACTER NAME"), character.getCharacterProperties().getName());
            if (s != null && s.length() > 0) {
                CharacterProperties oldCP = new CharacterProperties(character.getCharacterProperties());
                CharacterProperties newCP = new CharacterProperties(oldCP);
                newCP.setName(s);
                ChangeCharacter change = new ChangeCharacter(ChangeType.CHANGE, character.id, character, oldCP, newCP);
                character.getModel().processChangeCharacter(change);
            }
        }
    }

    private class PopUpAddRotation
    extends AbstractAction {
        public PopUpAddRotation() {
            super(StorySettings.currentBundle.getString("ADD ROTATION"));
        }

        public void actionPerformed(ActionEvent e) {
            if (NewtCharPane.this.controller.isSimulationRunning() || NewtCharPane.this.controller.isUnrealStoryRunning()) {
                StoryTools.userNotificationDialog(NewtCharPane.this.frame, StorySettings.currentBundle.getString("REQUESTSTOPSTORY"));
                return;
            }
            EmohawkCharacter character = NewtCharPane.this.emoCharacter;
            NewtNewRotationDialog dial = new NewtNewRotationDialog(NewtCharPane.this.frame, true, character);
            dial.setLocation(NewtCharPane.this.lastMousePressX, NewtCharPane.this.lastMousePressY);
            dial.setVisible(true);
        }
    }

    private class PopUpAddMovement
    extends AbstractAction {
        public PopUpAddMovement() {
            super(StorySettings.currentBundle.getString("ADD MOVEMENT"));
        }

        public void actionPerformed(ActionEvent e) {
            if (NewtCharPane.this.controller.isSimulationRunning() || NewtCharPane.this.controller.isUnrealStoryRunning()) {
                StoryTools.userNotificationDialog(NewtCharPane.this.frame, StorySettings.currentBundle.getString("REQUESTSTOPSTORY"));
                return;
            }
            EmohawkCharacter character = NewtCharPane.this.emoCharacter;
            NewtNewMovementDialog dial = new NewtNewMovementDialog(NewtCharPane.this.frame, true, character);
            dial.setLocation(NewtCharPane.this.lastMousePressX, NewtCharPane.this.lastMousePressY);
            dial.setVisible(true);
        }
    }

    private class PopUpAddAnimation
    extends AbstractAction {
        public PopUpAddAnimation() {
            super(StorySettings.currentBundle.getString("ADD ANIMATION"));
        }

        public void actionPerformed(ActionEvent e) {
            if (NewtCharPane.this.controller.isSimulationRunning() || NewtCharPane.this.controller.isUnrealStoryRunning()) {
                StoryTools.userNotificationDialog(NewtCharPane.this.frame, StorySettings.currentBundle.getString("REQUESTSTOPSTORY"));
                return;
            }
            EmohawkCharacter character = NewtCharPane.this.emoCharacter;
            NewtNewAnimationDialog dial = new NewtNewAnimationDialog(NewtCharPane.this.frame, true, character);
            dial.setVisible(true);
        }
    }
}

