/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationInfo;
import cz.cuni.amis.pogamut.emonewt.gui.tools.NumericTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.openide.util.Exceptions;

public class NewtAnimationProperties
extends JPanel {
    private final ViewController controller;
    private final ActionAnimation animation;
    private List<AnimationInfo> animations;
    private JButton btnAddAsnew;
    private JButton btnAnimPreview;
    private JButton btnApplyChanges;
    private JButton btnLoopAnimPreview;
    private JButton btnResetFields;
    private JComboBox cmbDescription;
    private JPanel jPanel1;
    private JLabel lblAnimationName;
    private JLabel lblDescription;
    private JLabel lblDuration;
    private JLabel lblLoopCount;
    private JLabel lblOrder;
    private JLabel lblTime;
    private JSpinner spnLoopCount;
    private JSpinner spnOrder;
    private JTextField txtAnimName;
    private JTextField txtDuration;
    private JTextField txtTime;

    public NewtAnimationProperties(ViewController controller, ActionAnimation animation) {
        this.controller = controller;
        this.animation = animation;
        EmohawkCharacter character = animation.getOwner();
        this.animations = character.getModel().getAnimations(character);
        StoryTools storyTools = new StoryTools();
        Collections.sort(this.animations, storyTools.animationInfoDescriptionOrderComparator());
        this.initComponents();
        this.cmbDescription.setModel(new DefaultComboBoxModel(){
            Object[] strings;
            {
                this.strings = NewtAnimationProperties.this.animations.toArray();
            }

            public int getSize() {
                return NewtAnimationProperties.this.animations.size();
            }

            public Object getElementAt(int i) {
                return NewtAnimationProperties.this.animations.get(i);
            }
        });
        this.cmbDescription.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AnimationInfo newAnim = (AnimationInfo)e.getItem();
                    NewtAnimationProperties.this.txtAnimName.setText(newAnim.getAnimationId());
                    ((NumericTextField)NewtAnimationProperties.this.txtDuration).setValue(newAnim.getDurationInSeconds() * (double)((Integer)NewtAnimationProperties.this.spnLoopCount.getValue()).intValue());
                }
            }
        });
        this.spnLoopCount.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnimationInfo anim = (AnimationInfo)NewtAnimationProperties.this.cmbDescription.getSelectedItem();
                ((NumericTextField)NewtAnimationProperties.this.txtDuration).setValue(anim.getDurationInSeconds() * (double)((Integer)NewtAnimationProperties.this.spnLoopCount.getValue()).intValue());
            }
        });
        this.resetAnimation();
    }

    public void characterChanged(EmohawkCharacter ec) {
        if (ec != this.animation.getOwner()) {
            return;
        }
        this.cmbDescription.setModel(new DefaultComboBoxModel(){
            Object[] strings;
            {
                this.strings = NewtAnimationProperties.this.animations.toArray();
            }

            public int getSize() {
                return NewtAnimationProperties.this.animations.size();
            }

            public Object getElementAt(int i) {
                return NewtAnimationProperties.this.animations.get(i);
            }
        });
        this.resetAnimation();
    }

    public void actionChanged(StoryAction action) {
        if (action.getId() == this.animation.getId()) {
            this.resetAnimation();
        }
    }

    public StoryAction getStoryAction() {
        return this.animation;
    }

    public void resetAnimation() {
        AnimationInfo animationInfo = null;
        for (AnimationInfo animInfo : this.animations) {
            String animationId;
            String animInfoId = animInfo.getAnimationId();
            if (!animInfoId.equals(animationId = this.animation.getAnimationId())) continue;
            animationInfo = animInfo;
        }
        this.cmbDescription.setSelectedItem(animationInfo);
        this.txtAnimName.setText(this.animation.getAnimationId());
        ((NumericTextField)this.txtTime).setValue(this.animation.getTimeInSeconds());
        ((NumericTextField)this.txtDuration).setValue(this.animation.getDurationInSeconds());
        this.spnLoopCount.setValue(this.animation.getLoopCount());
        this.spnOrder.setValue(this.animation.getOrder());
        this.validate();
    }

    private void initComponents() {
        this.btnApplyChanges = new JButton();
        this.btnResetFields = new JButton();
        this.btnAnimPreview = new JButton();
        this.btnAddAsnew = new JButton();
        this.jPanel1 = new JPanel();
        this.spnOrder = new JSpinner();
        this.lblOrder = new JLabel();
        this.spnLoopCount = new JSpinner();
        this.lblLoopCount = new JLabel();
        this.lblDuration = new JLabel();
        this.txtDuration = new NumericTextField();
        this.txtTime = new NumericTextField();
        this.lblTime = new JLabel();
        this.lblDescription = new JLabel();
        this.cmbDescription = new JComboBox();
        this.txtAnimName = new JTextField();
        this.lblAnimationName = new JLabel();
        this.btnLoopAnimPreview = new JButton();
        this.setBorder(BorderFactory.createTitledBorder(StorySettings.currentBundle.getString("ANIMATION EDITOR")));
        this.setPreferredSize(new Dimension(267, 277));
        this.btnApplyChanges.setText(StorySettings.currentBundle.getString("APPLY"));
        this.btnApplyChanges.setToolTipText(StorySettings.currentBundle.getString("USE_H"));
        this.btnApplyChanges.setName("btnApplyChanges");
        this.btnApplyChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtAnimationProperties.this.btnApplyChangesActionPerformed(evt);
            }
        });
        this.btnResetFields.setText(StorySettings.currentBundle.getString("RESET"));
        this.btnResetFields.setToolTipText(StorySettings.currentBundle.getString("RESET_H"));
        this.btnResetFields.setName("btnResetFields");
        this.btnResetFields.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtAnimationProperties.this.btnResetFieldsActionPerformed(evt);
            }
        });
        this.btnAnimPreview.setText(StorySettings.currentBundle.getString("PREVIEW"));
        this.btnAnimPreview.setToolTipText(StorySettings.currentBundle.getString("PREVIEWHELP"));
        this.btnAnimPreview.setName("btnAnimPreview");
        this.btnAnimPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtAnimationProperties.this.btnAnimPreviewActionPerformed(evt);
            }
        });
        this.btnAddAsnew.setText(StorySettings.currentBundle.getString("ADDANIMASNEW"));
        this.btnAddAsnew.setToolTipText(StorySettings.currentBundle.getString("ADDASNEW_H"));
        this.btnAddAsnew.setName("btnAddAsnew");
        this.btnAddAsnew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtAnimationProperties.this.btnAddAsnewActionPerformed(evt);
            }
        });
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.spnOrder.setModel(new SpinnerNumberModel(1, 1, this.animation.getOwner().getAnimations().size(), 1));
        this.spnOrder.setToolTipText(StorySettings.currentBundle.getString("ORDERHELP"));
        this.spnOrder.setEditor(new JSpinner.NumberEditor(this.spnOrder, ""));
        this.spnOrder.setName("spnOrder");
        this.jPanel1.add((Component)this.spnOrder, new AbsoluteConstraints(103, 60, 50, 20));
        this.lblOrder.setText(StorySettings.currentBundle.getString("ORDER:"));
        this.lblOrder.setName("lblOrder");
        this.jPanel1.add((Component)this.lblOrder, new AbsoluteConstraints(0, 60, -1, -1));
        this.spnLoopCount.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.spnLoopCount.setToolTipText(StorySettings.currentBundle.getString("LOOPHELP"));
        this.spnLoopCount.setEditor(new JSpinner.NumberEditor(this.spnLoopCount, ""));
        this.spnLoopCount.setName("spnLoopCount");
        this.jPanel1.add((Component)this.spnLoopCount, new AbsoluteConstraints(103, 40, 50, 20));
        this.lblLoopCount.setText(StorySettings.currentBundle.getString("LOOP COUNT:"));
        this.lblLoopCount.setAlignmentY(0.0f);
        this.lblLoopCount.setName("lblLoopCount");
        this.jPanel1.add((Component)this.lblLoopCount, new AbsoluteConstraints(0, 40, -1, -1));
        this.lblDuration.setText(StorySettings.currentBundle.getString("DURATION:"));
        this.lblDuration.setName("lblDuration");
        this.jPanel1.add((Component)this.lblDuration, new AbsoluteConstraints(0, 80, -1, -1));
        this.txtDuration.setEditable(false);
        this.txtDuration.setHorizontalAlignment(4);
        this.txtDuration.setName("txtDuration");
        this.jPanel1.add((Component)this.txtDuration, new AbsoluteConstraints(100, 80, 142, 20));
        this.txtTime.setEditable(false);
        this.txtTime.setHorizontalAlignment(4);
        this.txtTime.setName("txtTime");
        this.jPanel1.add((Component)this.txtTime, new AbsoluteConstraints(100, 100, 142, -1));
        this.lblTime.setText(StorySettings.currentBundle.getString("TIME:"));
        this.lblTime.setName("lblTime");
        this.jPanel1.add((Component)this.lblTime, new AbsoluteConstraints(0, 100, -1, -1));
        this.lblDescription.setText(StorySettings.currentBundle.getString("DESCRIPTION:"));
        this.lblDescription.setName("lblDescription");
        this.jPanel1.add((Component)this.lblDescription, new AbsoluteConstraints(0, 20, -1, -1));
        this.cmbDescription.setToolTipText(StorySettings.currentBundle.getString("ANIMCHOOSERHELP"));
        this.cmbDescription.setName("cmbDescription");
        this.cmbDescription.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtAnimationProperties.this.cmbDescriptionActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.cmbDescription, new AbsoluteConstraints(102, 20, 150, 20));
        this.txtAnimName.setEditable(false);
        this.txtAnimName.setName("txtAnimName");
        this.jPanel1.add((Component)this.txtAnimName, new AbsoluteConstraints(102, 0, 150, 20));
        this.lblAnimationName.setText(StorySettings.currentBundle.getString("ANIM ID:"));
        this.lblAnimationName.setName("lblAnimationName");
        this.jPanel1.add((Component)this.lblAnimationName, new AbsoluteConstraints(0, 0, -1, -1));
        this.btnLoopAnimPreview.setText(StorySettings.currentBundle.getString("LOOPPREVIEW"));
        this.btnLoopAnimPreview.setToolTipText(StorySettings.currentBundle.getString("LOOPPREVIEWHELP"));
        this.btnLoopAnimPreview.setName("btnLoopAnimPreview");
        this.btnLoopAnimPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtAnimationProperties.this.btnLoopAnimPreviewActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.btnApplyChanges, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnResetFields, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAnimPreview, -2, 78, -2)).addGroup(layout.createSequentialGroup().addComponent(this.btnAddAsnew, -2, 156, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLoopAnimPreview, -2, 78, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnResetFields).addComponent(this.btnAnimPreview)).addComponent(this.btnApplyChanges)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnAddAsnew).addComponent(this.btnLoopAnimPreview)).addGap(67, 67, 67)));
    }

    private void btnApplyChangesActionPerformed(ActionEvent evt) {
        StoryActionProperties oldProp = this.animation.getActionProperties();
        StoryActionProperties newProp = new StoryActionProperties(this.animation.getActionProperties());
        newProp.setAnimationId(this.txtAnimName.getText());
        newProp.setLoopCount((Integer)this.spnLoopCount.getValue());
        try {
            newProp.setTimeFromSeconds(((NumericTextField)this.txtTime).getDoubleValue());
            newProp.setDurationFromSeconds(((NumericTextField)this.txtDuration).getDoubleValue());
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        newProp.setOrder((Integer)this.spnOrder.getValue());
        newProp.setDescription(this.cmbDescription.getSelectedItem().toString());
        ChangeStoryAction change = new ChangeStoryAction(ChangeType.CHANGE, this.animation.getOwner(), oldProp, newProp, this.animation);
        if (!this.animation.getOwner().getModel().processChangeStoryAction(change)) {
            this.resetAnimation();
        }
        this.resetAnimation();
    }

    private void btnResetFieldsActionPerformed(ActionEvent evt) {
        this.resetAnimation();
    }

    private void cmbDescriptionActionPerformed(ActionEvent evt) {
    }

    private void previewAnimation(boolean bLoop) {
        StoryActionProperties oldProp = this.animation.getActionProperties();
        StoryActionProperties newProp = new StoryActionProperties(this.animation.getActionProperties());
        newProp.setLoopCount((Integer)this.spnLoopCount.getValue());
        try {
            newProp.setDurationFromSeconds(((NumericTextField)this.txtDuration).getDoubleValue());
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        newProp.setOrder((Integer)this.spnOrder.getValue());
        ActionAnimation animPreview = new ActionAnimation(this.animation.getOwner(), (AnimationInfo)this.cmbDescription.getSelectedItem(), 0, newProp.getLoopCount(), newProp.getOrder());
        this.controller.previewAnimation(animPreview, bLoop);
    }

    private void btnAnimPreviewActionPerformed(ActionEvent evt) {
        this.previewAnimation(false);
    }

    private void btnAddAsnewActionPerformed(ActionEvent evt) {
        StoryActionProperties oldProp = this.animation.getActionProperties();
        StoryActionProperties newProp = new StoryActionProperties(this.animation.getActionProperties());
        newProp.setAnimationId(this.txtAnimName.getText());
        newProp.setLoopCount((Integer)this.spnLoopCount.getValue());
        try {
            newProp.setTimeFromSeconds(((NumericTextField)this.txtTime).getDoubleValue());
            newProp.setDurationFromSeconds(((NumericTextField)this.txtDuration).getDoubleValue());
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        newProp.setOrder((Integer)this.spnOrder.getValue() + 1);
        newProp.setDescription(this.cmbDescription.getSelectedItem().toString());
        if (this.cmbDescription.getSelectedItem() == null) {
            return;
        }
        ActionAnimation newAnim = new ActionAnimation(this.animation.getOwner(), (AnimationInfo)this.cmbDescription.getSelectedItem(), 0, newProp.getLoopCount(), newProp.getOrder());
        ChangeStoryAction change = new ChangeStoryAction(ChangeType.ADD, this.animation.getOwner(), newAnim.getActionProperties(), newAnim);
        if (!this.animation.getOwner().getModel().processChangeStoryAction(change)) {
            this.resetAnimation();
        }
        this.resetAnimation();
    }

    private void btnLoopAnimPreviewActionPerformed(ActionEvent evt) {
        this.previewAnimation(true);
    }

    public void setEverythingDisable(boolean bEnabled) {
        this.btnApplyChanges.setEnabled(!bEnabled);
        this.btnResetFields.setEnabled(!bEnabled);
        this.cmbDescription.setEnabled(!bEnabled);
        this.lblAnimationName.setEnabled(!bEnabled);
        this.lblDescription.setEnabled(!bEnabled);
        this.lblDuration.setEnabled(!bEnabled);
        this.lblLoopCount.setEnabled(!bEnabled);
        this.lblOrder.setEnabled(!bEnabled);
        this.lblTime.setEnabled(!bEnabled);
        this.spnLoopCount.setEnabled(!bEnabled);
        this.spnOrder.setEnabled(!bEnabled);
        this.txtAnimName.setEnabled(!bEnabled);
        this.txtDuration.setEnabled(!bEnabled);
        this.txtTime.setEnabled(!bEnabled);
        this.btnAnimPreview.setEnabled(!bEnabled);
        this.btnAddAsnew.setEnabled(!bEnabled);
    }
}

