/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtContainer;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewtActionElement<A extends StoryAction, C extends NewtContainer>
extends JPanel {
    protected final A storyAction;
    final C parent;
    private JLabel lblStoryActionDescription;
    public static final int ELEMENT_HEIGHT = 20;
    public final EmoNewtFrame frame;
    private int startX;
    private int startLocationX;
    private int myNewWidth;
    private boolean isBeingDragged = false;
    private boolean isBeingResized = false;
    private boolean isBeingResizedToLeft = false;
    private boolean shouldShiftEverythingOnRight = false;
    protected ViewController controller;
    public static final int RESIZE_TRESHOLD_MIN = 5;
    public static final int RESIZE_TRESHOLD_MAX = 18;
    private KeyAdapter myKeyAdapter = new KeyAdapter(){

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u007f') {
                if (NewtActionElement.this.controller.isSimulationRunning() || NewtActionElement.this.controller.isUnrealStoryRunning()) {
                    StoryTools.userNotificationDialog(NewtActionElement.this.frame, StorySettings.currentBundle.getString("REQUESTSTOPSTORY"));
                    return;
                }
                NewtActionElement.this.deleteAction();
            }
        }
    };
    private MouseListener clickListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            NewtActionElement.this.setPropertiesPane();
            NewtActionElement.this.controller.setFocusedObject(NewtActionElement.this.storyAction);
            if (NewtActionElement.this.controller.isSimulationRunning() || NewtActionElement.this.controller.isUnrealStoryRunning()) {
                NewtActionElement.this.frame.getPropertiesPane().setButtonsDisabled();
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!NewtActionElement.this.isEnabled()) {
                return;
            }
            ((NewtContainer)NewtActionElement.this.parent).actionClicked((NewtActionElement)NewtActionElement.this);
            NewtActionElement.this.setPropertiesPane();
            NewtActionElement.this.controller.setFocusedObject(NewtActionElement.this.storyAction);
            NewtActionElement.this.startX = e.getX();
            NewtActionElement.this.startLocationX = NewtActionElement.this.getLocation().x;
            int leftBorder = NewtActionElement.this.getLocation().x;
            int width = NewtActionElement.this.getWidth();
            int result = NewtActionElement.this.shouldBeResized(leftBorder, width, e.getX());
            if (result != 0) {
                NewtActionElement.this.isBeingResized = true;
                if (result == 1) {
                    NewtActionElement.this.isBeingResizedToLeft = true;
                }
            } else {
                NewtActionElement.this.isBeingDragged = true;
            }
            NewtActionElement.this.shouldShiftEverythingOnRight = false;
            if (!NewtActionElement.this.storyAction.getClass().equals(ActionAnimation.class)) {
                int shiftmask = 64;
                if ((e.getModifiersEx() & shiftmask) == shiftmask) {
                    NewtActionElement.this.shouldShiftEverythingOnRight = true;
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!NewtActionElement.this.isEnabled()) {
                return;
            }
            boolean bForce = false;
            int shiftmask = 64;
            if ((e.getModifiersEx() & shiftmask) == shiftmask) {
                bForce = true;
            }
            if (NewtActionElement.this.isBeingDragged) {
                if (NewtActionElement.this.shouldShiftEverythingOnRight && !bForce) {
                    NewtActionElement.this.actionChanged();
                } else {
                    NewtActionElement.this.confirmActionChangeByDragging(NewtActionElement.this.shouldShiftEverythingOnRight && bForce);
                }
            }
            NewtActionElement.this.isBeingDragged = false;
            if (NewtActionElement.this.isBeingResized) {
                if (NewtActionElement.this.shouldShiftEverythingOnRight && !bForce) {
                    NewtActionElement.this.actionChanged();
                } else {
                    NewtActionElement.this.confirmActionChangeByResizing(NewtActionElement.this.shouldShiftEverythingOnRight && bForce && !NewtActionElement.this.isBeingResizedToLeft);
                }
            }
            NewtActionElement.this.isBeingResized = false;
            NewtActionElement.this.isBeingResizedToLeft = false;
        }
    };

    public abstract void setPropertiesPane();

    private int shouldBeResized(int leftBorder, int width, int clickX) {
        int resizeTreshold = (int)Math.round((double)width * 0.05);
        resizeTreshold = Math.min(resizeTreshold, 18);
        if (clickX < (resizeTreshold = Math.max(resizeTreshold, 5))) {
            return 1;
        }
        if (clickX > width - resizeTreshold) {
            return 2;
        }
        return 0;
    }

    private void mySetCursor(Cursor CURSOR) {
        this.setCursor(CURSOR);
    }

    public void confirmActionChangeByDragging(boolean bForce) {
        if (this.startLocationX == this.getLocation().x) {
            return;
        }
        if (!this.frame.getModel().getSettings().isbAlwaysConfirmChanges() || StoryTools.userConfirmedDialog(this, ResourceBundle.getBundle("cz/cuni/amis/pogamut/emonewt/gui/resources/NewtStrings").getString("CONFIRM THE TIME CHANGE?"))) {
            EmohawkCharacter character = ((StoryAction)this.storyAction).getOwner();
            StoryActionProperties oldP = ((StoryAction)this.storyAction).getActionProperties();
            StoryActionProperties newP = new StoryActionProperties(oldP);
            newP.setTime(this.resizeSizeToTime(this.getLocation().x));
            ChangeStoryAction change = new ChangeStoryAction(ChangeType.CHANGE, character, oldP, newP, (StoryAction)this.storyAction);
            if (!character.getModel().processChangeStoryAction(change, bForce)) {
                this.actionChanged();
            }
        } else {
            this.actionChanged();
        }
        ((NewtContainer)this.parent).actionClicked((NewtActionElement)this);
    }

    public void confirmActionChangeByResizing(boolean bForce) {
        if (this.myNewWidth > 0 && (!this.frame.getModel().getSettings().isbAlwaysConfirmChanges() || StoryTools.userConfirmedDialog(this, ResourceBundle.getBundle("cz/cuni/amis/pogamut/emonewt/gui/resources/NewtStrings").getString("CONFIRM THE DURATION CHANGE?")))) {
            EmohawkCharacter character = ((StoryAction)this.storyAction).getOwner();
            StoryActionProperties oldP = ((StoryAction)this.storyAction).getActionProperties();
            StoryActionProperties newP = new StoryActionProperties(oldP);
            if (this.storyAction.getClass().equals(ActionAnimation.class)) {
                ActionAnimation anim = (ActionAnimation)this.storyAction;
                double baseDuration = anim.getDuration() / (long)oldP.getLoopCount();
                int newLoopCount = (int)Math.max(1L, Math.round((double)this.resizeSizeToTime(this.myNewWidth) / baseDuration));
                newP.setDuration(Math.round((double)newLoopCount * baseDuration));
                newP.setLoopCount(newLoopCount);
            } else {
                newP.setDuration(this.resizeSizeToTime(this.myNewWidth));
                if (this.isBeingResizedToLeft) {
                    newP.setTime(this.resizeSizeToTime(this.getLocation().x));
                }
            }
            ChangeStoryAction change = new ChangeStoryAction(ChangeType.CHANGE, character, oldP, newP, (StoryAction)this.storyAction);
            if (!character.getModel().processChangeStoryAction(change, bForce)) {
                this.actionChanged();
            } else {
                this.actionChanged();
            }
        } else {
            this.actionChanged();
        }
        ((NewtContainer)this.parent).actionClicked((NewtActionElement)this);
    }

    private int resizeSizeToTime(long position) {
        float scale = ((StoryAction)this.storyAction).getOwner().getModel().getScale();
        return Math.round((float)position * 1000.0f / scale);
    }

    private int resizeTimeToSize(long time) {
        float scale = ((StoryAction)this.storyAction).getOwner().getModel().getScale();
        return Math.round((float)time * scale / 1000.0f);
    }

    public void actionChanged() {
        if (StoryTools.DEBUG) {
            System.out.println(StorySettings.currentBundle.getString("ANIM VISUALIZATION IS UPDATED"));
        }
        this.setBounds(this.resizeTimeToSize(((StoryAction)this.storyAction).getTime()), 0, this.resizeTimeToSize(((StoryAction)this.storyAction).getDuration()), 20);
        this.lblStoryActionDescription.setText(((StoryAction)this.storyAction).getDescription());
    }

    public NewtActionElement(EmoNewtFrame frame, C pane, A action, ViewController controller) {
        this.storyAction = action;
        this.frame = frame;
        this.parent = pane;
        this.controller = controller;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEtchedBorder()));
        this.setBounds(this.resizeTimeToSize(((StoryAction)action).getTime()), 0, this.resizeTimeToSize(((StoryAction)action).getDuration()), 20);
        this.lblStoryActionDescription = new JLabel(((StoryAction)this.storyAction).getDescription(), 0);
        this.lblStoryActionDescription.setFont(new Font("SansSerif", 1, 10));
        this.add((Component)this.lblStoryActionDescription, "Center");
        JPopupMenu popupMenu = new JPopupMenu(StorySettings.currentBundle.getString("MENU TEST"));
        popupMenu.add(new PopUpDeleteAction());
        this.setComponentPopupMenu(popupMenu);
        this.addKeyListener(this.myKeyAdapter);
        this.addMouseListener(this.clickListener);
        this.addMouseMotionListener(new MouseAdapter(){

            public void mouseMoved(MouseEvent e) {
                NewtActionElement.this.requestFocusInWindow();
                if (NewtActionElement.this.shouldBeResized(NewtActionElement.this.getLocation().x, NewtActionElement.this.getWidth(), e.getX()) != 0) {
                    NewtActionElement.this.mySetCursor(new Cursor(11));
                } else {
                    NewtActionElement.this.mySetCursor(new Cursor(0));
                }
            }

            public void mouseDragged(MouseEvent e) {
                if (!NewtActionElement.this.isEnabled()) {
                    return;
                }
                if (NewtActionElement.this.isBeingDragged && (e.getModifiersEx() & 0x400) == 1024) {
                    Point newLocation = NewtActionElement.this.getLocation();
                    newLocation.x += e.getX() - NewtActionElement.this.startX;
                    if (NewtActionElement.this.isCorrectOperation(NewtActionElement.this.resizeSizeToTime(newLocation.x), (long)NewtActionElement.this.resizeSizeToTime(newLocation.x) + ((StoryAction)NewtActionElement.this.storyAction).getDuration())) {
                        NewtActionElement.this.setLocation(newLocation);
                    }
                }
                if (NewtActionElement.this.isBeingResized && (e.getModifiersEx() & 0x400) == 1024) {
                    if (NewtActionElement.this.isBeingResizedToLeft) {
                        NewtActionElement.this.myNewWidth = -e.getX() + NewtActionElement.this.startX + NewtActionElement.this.resizeTimeToSize(((StoryAction)NewtActionElement.this.storyAction).getDuration());
                    } else {
                        NewtActionElement.this.myNewWidth = e.getX() - NewtActionElement.this.startX + NewtActionElement.this.resizeTimeToSize(((StoryAction)NewtActionElement.this.storyAction).getDuration());
                    }
                    long endTime = 0L;
                    long startTime = 0L;
                    if (!NewtActionElement.this.isBeingResizedToLeft) {
                        startTime = NewtActionElement.this.resizeSizeToTime(NewtActionElement.this.getLocation().x);
                        endTime = (long)NewtActionElement.this.resizeSizeToTime(NewtActionElement.this.getLocation().x + e.getX() - NewtActionElement.this.startX) + ((StoryAction)NewtActionElement.this.storyAction).getDuration();
                    } else {
                        endTime = ((StoryAction)NewtActionElement.this.storyAction).getTime() + ((StoryAction)NewtActionElement.this.storyAction).getDuration();
                        startTime = endTime - ((StoryAction)NewtActionElement.this.storyAction).getDuration();
                    }
                    if (!NewtActionElement.this.isBeingResizedToLeft && NewtActionElement.this.isCorrectOperation(startTime, endTime)) {
                        NewtActionElement.this.setBounds(NewtActionElement.this.resizeTimeToSize(((StoryAction)NewtActionElement.this.storyAction).getTime()), 0, NewtActionElement.this.myNewWidth, 20);
                    } else if (NewtActionElement.this.isBeingResizedToLeft && NewtActionElement.this.isCorrectOperation(startTime, endTime)) {
                        NewtActionElement.this.setBounds(NewtActionElement.this.resizeTimeToSize(((StoryAction)NewtActionElement.this.storyAction).getTime()), 0, NewtActionElement.this.myNewWidth, 20);
                        Point newLocation = NewtActionElement.this.getLocation();
                        newLocation.x += e.getX() - NewtActionElement.this.startX;
                        NewtActionElement.this.startX = NewtActionElement.this.startX - e.getX();
                        NewtActionElement.this.setLocation(newLocation);
                    }
                }
            }
        });
    }

    private boolean isCorrectOperation(long leftCorner, long rightCorner) {
        ActionRotation prevRotation;
        if (leftCorner < 0L) {
            return false;
        }
        if (leftCorner >= rightCorner) {
            return false;
        }
        if (this.storyAction.getClass().equals(ActionMovement.class)) {
            ActionMovement nextMovement = this.getNextMovement();
            if (!this.shouldShiftEverythingOnRight && nextMovement != null && rightCorner > nextMovement.getTime()) {
                return false;
            }
            ActionMovement previousMovement = this.getPrevMovement();
            if (previousMovement != null && leftCorner < previousMovement.getTime() + previousMovement.getDuration()) {
                return false;
            }
        }
        return !this.storyAction.getClass().equals(ActionRotation.class) || (prevRotation = this.getPrevRotation()) == null || leftCorner >= prevRotation.getTime() + prevRotation.getDuration();
    }

    private ActionMovement getNextMovement() {
        return ((StoryAction)this.storyAction).getOwner().getNextMovement((ActionMovement)this.storyAction);
    }

    private ActionMovement getPrevMovement() {
        return ((StoryAction)this.storyAction).getOwner().getPreviousMovement((ActionMovement)this.storyAction);
    }

    private ActionRotation getPrevRotation() {
        return ((StoryAction)this.storyAction).getOwner().getPreviousRotation((ActionRotation)this.storyAction);
    }

    public void deleteAction() {
        EmohawkCharacter character = ((StoryAction)this.storyAction).getOwner();
        int result = JOptionPane.showConfirmDialog(this, StorySettings.currentBundle.getString("REALLY DELETE?"));
        if (result == 0) {
            ChangeStoryAction change = new ChangeStoryAction(ChangeType.DELETE, character, ((StoryAction)this.storyAction).getActionProperties(), (StoryAction)this.storyAction);
            character.getModel().processChangeStoryAction(change);
        }
    }

    private class PopUpDeleteAction
    extends AbstractAction {
        public PopUpDeleteAction() {
            super(StorySettings.currentBundle.getString("DELETE ACTION"));
        }

        public void actionPerformed(ActionEvent e) {
            if (NewtActionElement.this.controller.isSimulationRunning() || NewtActionElement.this.controller.isUnrealStoryRunning()) {
                StoryTools.userNotificationDialog(NewtActionElement.this.frame, StorySettings.currentBundle.getString("REQUESTSTOPSTORY"));
                return;
            }
            NewtActionElement.this.deleteAction();
        }
    }
}

