/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.widget;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.BirdviewScene;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.IDestroyableWidget;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ECharacterType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

abstract class WaypointWidget
extends Widget
implements Widget.Dependency,
IDestroyableWidget {
    protected static final Matrix3d identity = new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    protected EmohawkCharacter character;
    protected Location location;
    protected int r;
    protected Color widgetColor;
    protected ViewController controller;
    protected InstanceContent ic;
    private Lookup lookup;

    public WaypointWidget(Scene scene, EmohawkCharacter character, ViewController controller, Location location, int r, Color color) {
        super(scene);
        this.character = character;
        this.controller = controller;
        this.location = new Location(location.x, location.y, location.z);
        this.widgetColor = color;
        this.r = r;
        this.setForeground(this.widgetColor);
        this.setPreferredLocation(this.unreal2scene(location));
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        this.ic.add((Object)character);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    protected Matrix3d getU2SMatrix() {
        Matrix3d u2s = (Matrix3d)this.getScene().getLookup().lookup(Matrix3d.class);
        if (u2s == null) {
            u2s = identity;
        }
        return u2s;
    }

    protected Matrix3d getS2UMatrix() {
        Matrix3d s2u = new Matrix3d(this.getU2SMatrix());
        s2u.invert();
        return s2u;
    }

    protected Rectangle calculateClientArea() {
        return new Rectangle(-this.r - 1, -this.r - 1, 2 * this.r + 1, 2 * this.r + 1);
    }

    protected void paintWidget() {
        Graphics2D g = this.getGraphics();
        if (this.character.getCharacterProperties().getCharacterClass() != ECharacterType.CAMERA) {
            g.setColor(this.getForeground());
            g.fillOval(-this.r, -this.r, 2 * this.r, 2 * this.r);
        } else {
            g.setColor(this.getForeground());
            g.fillRect(-this.r, -this.r, 2 * this.r, 2 * this.r);
        }
    }

    protected Point getSceneLocation() {
        Matrix3d u2s = this.getU2SMatrix();
        Vector3d uloc = new Vector3d(this.location.x, this.location.y, 1.0);
        u2s.transform((Tuple3d)uloc);
        return new Point((int)uloc.x, (int)uloc.y);
    }

    protected Point unreal2scene(Location loc) {
        Matrix3d u2s = this.getU2SMatrix();
        Vector3d uloc = new Vector3d(loc.x, loc.y, loc.z);
        u2s.transform((Tuple3d)uloc);
        return new Point((int)uloc.x, (int)uloc.y);
    }

    protected Location scene2unreal(Point point) {
        Matrix3d s2u = this.getS2UMatrix();
        Vector3d sloc = new Vector3d((double)point.x, (double)point.y, 1.0);
        s2u.transform((Tuple3d)sloc);
        return new Location((Tuple3d)sloc);
    }

    public void revalidateDependency() {
        this.setPreferredLocation(this.getSceneLocation());
    }

    protected void setUnrealLocation(Location location) {
        this.location.x = location.x;
        this.location.y = location.y;
        this.location.z = location.z;
        this.setPreferredLocation(this.unreal2scene(location));
    }

    protected Location getUnrealLocation() {
        return new Location(this.location);
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        super.notifyStateChanged(previousState, state);
        if (previousState.isSelected() || state.isSelected()) {
            LayerWidget connectionLayer = ((BirdviewScene)this.getScene()).getConnectionsLayer();
            for (Widget connection : connectionLayer.getChildren()) {
                EmohawkCharacter connectionCharacter = (EmohawkCharacter)connection.getLookup().lookup(EmohawkCharacter.class);
                if (connectionCharacter == null || !connectionCharacter.equals(this.character)) continue;
                ObjectState connectionState = connection.getState().deriveHighlighted(state.isSelected());
                connection.setState(connectionState);
            }
        }
    }

    public abstract void destroy();
}

