/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.widget;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.action.AttachWaypointAction;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.BirdviewScene;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.IDestroyableWidget;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.WaypointWidget;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IUndoRedoListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeContainer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.CharacterProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ECharacterType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.utils.collections.ElementListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class StartWaypointWidget
extends WaypointWidget
implements IUndoRedoListener {
    private Color selectedColor = new Color(196, 32, 50);
    private DragWidget dragWidget;
    private ArcWidget arcWidget;
    private ElementListener<ChangeContainer> listener = new ElementListener<ChangeContainer>(){

        public void elementChanged(ChangeContainer elem, boolean added) {
            StartWaypointWidget.this.update();
            StartWaypointWidget.this.revalidate();
            StartWaypointWidget.this.getScene().validate();
        }
    };
    private SelectProvider selectProvider = new SelectProvider(){

        public boolean isAimingAllowed(Widget widget, Point point, boolean bln) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point point, boolean bln) {
            return true;
        }

        public void select(Widget widget, Point point, boolean bln) {
            StartWaypointWidget.this.controller.setFocusedObject(StartWaypointWidget.this.character);
        }
    };
    private final MoveProvider moveProvider = new MoveProvider(){

        private Location getULocation(Point spoint) {
            Matrix3d s2u = new Matrix3d(StartWaypointWidget.this.getU2SMatrix());
            s2u.invert();
            Vector3d sloc = new Vector3d((double)spoint.x, (double)spoint.y, 1.0);
            s2u.transform((Tuple3d)sloc);
            sloc.z = StartWaypointWidget.this.character.getCharacterProperties().getStartLocation().z;
            return new Location((Tuple3d)sloc);
        }

        public void movementStarted(Widget widget) {
            StartWaypointWidget.this.getScene().removeDependency((Widget.Dependency)StartWaypointWidget.this);
        }

        public void movementFinished(Widget widget) {
            StartWaypointWidget.this.getScene().addDependency((Widget.Dependency)StartWaypointWidget.this);
            CharacterProperties cp = StartWaypointWidget.this.character.getCharacterProperties();
            CharacterProperties charProp = new CharacterProperties(cp.getName(), new Location(this.getULocation(StartWaypointWidget.this.getPreferredLocation())), cp.getStartRotation(), cp.getCharacterClass(), cp.getBodyTexture(), cp.getSkinTexture());
            ChangeCharacter change = new ChangeCharacter(ChangeType.CHANGE, StartWaypointWidget.this.character.id, StartWaypointWidget.this.character, cp, charProp);
            StartWaypointWidget.this.character.getModel().processChangeCharacter(change);
        }

        public Point getOriginalLocation(Widget widget) {
            return widget.getPreferredLocation();
        }

        public void setNewLocation(Widget widget, Point location) {
            StartWaypointWidget.this.setPreferredLocation(location);
        }
    };
    private static Border squareBorder = new Border(){
        private Insets zeroInsets = new Insets(0, 0, 0, 0);
        private Stroke stroke = new BasicStroke(2.0f);

        public Insets getInsets() {
            return this.zeroInsets;
        }

        public void paint(Graphics2D g2, Rectangle rect) {
            g2.setStroke(this.stroke);
            g2.setColor(Color.BLACK);
            g2.drawRect(rect.x - 2, rect.y - 2, rect.width + 4, rect.height + 4);
        }

        public boolean isOpaque() {
            return false;
        }
    };
    private static Border circleBorder = new Border(){
        private Insets zeroInsets = new Insets(0, 0, 0, 0);
        private Stroke stroke = new BasicStroke(2.0f);

        public Insets getInsets() {
            return this.zeroInsets;
        }

        public void paint(Graphics2D g2, Rectangle rect) {
            g2.setStroke(this.stroke);
            g2.setColor(Color.BLACK);
            g2.drawOval(rect.x - 2, rect.y - 2, rect.width + 4, rect.height + 4);
        }

        public boolean isOpaque() {
            return false;
        }
    };

    private int rotation2angle(Rotation rotation) {
        return (int)(rotation.getYaw() * 180.0 / 32768.0);
    }

    protected void update() {
        this.dragWidget.setRotation(this.character.getCharacterProperties().getStartRotation());
        this.arcWidget.setRange(0, this.rotation2angle(this.character.getCharacterProperties().getStartRotation()));
        this.revalidate();
    }

    public void undoRedoPerformed(ChangeContainer changePosition, boolean undo) {
        this.update();
        this.revalidate();
        this.getScene().validate();
    }

    protected Point getSceneLocation() {
        Matrix3d u2s = this.getU2SMatrix();
        Location sl = this.character.getCharacterProperties().getStartLocation();
        Vector3d uloc = new Vector3d(sl.x, sl.y, 1.0);
        u2s.transform((Tuple3d)uloc);
        return new Point((int)uloc.x, (int)uloc.y);
    }

    StartWaypointWidget(BirdviewScene scene, EmohawkCharacter character, ViewController controller) {
        super((Scene)scene, character, controller, character.getCharacterProperties().getStartLocation(), 15, new Color(1, 76, 66));
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)this.selectProvider));
        this.getActions().addAction((WidgetAction)new AttachWaypointAction(scene.getConnectionsLayer()));
        this.getActions().addAction(ActionFactory.createMoveAction(null, (MoveProvider)this.moveProvider));
        scene.addDependency(this);
        scene.addObject(this.character, new Widget[]{this});
        System.err.println("Adding obj " + this.character.getName());
        scene.getStartpointsLayer().addChild((Widget)this);
        character.getModel().addUndoRedoListener(this);
        character.getModel().getChangeActions().addCollectionListener(this.listener);
        this.dragWidget = new DragWidget(scene, Color.WHITE, 6, this.r);
        this.dragWidget.setRotation(character.getCharacterProperties().getStartRotation());
        this.addChild(this.dragWidget);
        this.arcWidget = new ArcWidget(scene, this.r);
        this.arcWidget.setRange(0, this.rotation2angle(character.getCharacterProperties().getStartRotation()));
        this.addChild(this.arcWidget);
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        super.notifyStateChanged(previousState, state);
        if (state.isFocused()) {
            if (this.character.getCharacterProperties().getCharacterClass().equals((Object)ECharacterType.CAMERA)) {
                this.setBorder(squareBorder);
            } else {
                this.setBorder(circleBorder);
            }
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        Color color = this.widgetColor;
        if (state.isSelected()) {
            color = this.selectedColor;
        }
        this.setForeground(color);
        this.revalidate();
    }

    public void destroy() {
        this.character.getModel().removeUndoRedoListener(this);
        this.character.getModel().getChangeActions().removeCollectionListener(this.listener);
        ((BirdviewScene)this.getScene()).removeObject(this.character);
        System.err.println("Removing obj " + this.character.getName());
        this.getScene().removeDependency((Widget.Dependency)this);
        this.removeFromParent();
    }

    private final class DragWidget
    extends Widget
    implements IDestroyableWidget {
        private Color color;
        private int radius;
        private double rotationDistance;
        private MoveStrategy circlingStartegy;
        private MoveProvider moveProvider;

        public DragWidget(BirdviewScene scene, Color color, int widgetRadius, double rotationDistance) {
            super((Scene)scene);
            this.circlingStartegy = new MoveStrategy(){

                public Point locationSuggested(Widget widget, Point originalLocation, Point suggestedLocation) {
                    Vector2d vector = new Vector2d((double)suggestedLocation.x, (double)suggestedLocation.y);
                    vector.normalize();
                    vector.scale(DragWidget.this.rotationDistance);
                    return new Point((int)vector.x, (int)vector.y);
                }
            };
            this.moveProvider = new MoveProvider(){
                double angle;

                public void movementStarted(Widget widget) {
                    this.angle = StartWaypointWidget.this.character.getCharacterProperties().getStartRotation().yaw / 32768.0 * 180.0;
                }

                public void movementFinished(Widget widget) {
                    int utAngle = (int)(32768.0 * this.angle / 180.0);
                    CharacterProperties oldProp = StartWaypointWidget.this.character.getCharacterProperties();
                    CharacterProperties newProp = new CharacterProperties(oldProp);
                    Rotation newStartRotation = new Rotation(oldProp.getStartRotation());
                    newStartRotation.yaw = utAngle;
                    newProp.setStartRotation(newStartRotation);
                    ChangeCharacter change = new ChangeCharacter(ChangeType.CHANGE, StartWaypointWidget.this.character.id, StartWaypointWidget.this.character, oldProp, newProp);
                    boolean res = StartWaypointWidget.this.character.getModel().processChangeCharacter(change);
                    if (!res) {
                        Logger.getLogger("Birdview").warning("Unable to set char init rotation " + utAngle);
                    }
                }

                private double getAngle(Vector2d startVec, Vector2d endVec) {
                    int angleSize = (int)(startVec.angle(endVec) * 180.0 / Math.PI);
                    if (startVec.y * endVec.x - startVec.x * endVec.y > 0.0) {
                        angleSize = -angleSize;
                    }
                    return angleSize;
                }

                public Point getOriginalLocation(Widget widget) {
                    return widget.getPreferredLocation();
                }

                public void setNewLocation(Widget widget, Point point) {
                    widget.setPreferredLocation(point);
                    int startAngle = StartWaypointWidget.this.arcWidget.getStartAngle();
                    Vector2d startVec = new Vector2d(Math.cos((double)startAngle * Math.PI / 180.0), Math.sin((double)startAngle * Math.PI / 180.0));
                    Vector2d dragVec = new Vector2d((double)point.x, (double)point.y);
                    this.angle = this.getAngle(startVec, dragVec);
                    StartWaypointWidget.this.arcWidget.setRange(startAngle, (int)this.angle);
                    Object actRot = null;
                    if (actRot != null) {
                        // empty if block
                    }
                }
            };
            this.color = color;
            this.radius = widgetRadius;
            this.rotationDistance = rotationDistance;
            this.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)this.circlingStartegy, (MoveProvider)this.moveProvider));
        }

        protected Rectangle calculateClientArea() {
            return new Rectangle(-this.radius - 1, -this.radius - 1, 2 * this.radius + 1, 2 * this.radius + 1);
        }

        protected void paintWidget() {
            Graphics2D g = this.getGraphics();
            g.setColor(this.color);
            g.fillOval(-this.radius, -this.radius, 2 * this.radius, 2 * this.radius);
        }

        protected void setRotation(Rotation characterRotation) {
            characterRotation.pitch = 0.0;
            Location vector = characterRotation.toLocation();
            vector = vector.getNormalized().scale(this.rotationDistance);
            this.setPreferredLocation(new Point((int)vector.x, (int)vector.y));
        }

        public void destroy() {
            this.removeFromParent();
        }
    }

    private final class ArcWidget
    extends Widget
    implements IDestroyableWidget {
        private static final int ARC_WIDTH = 4;
        private int startAngle;
        private int angleSize;
        private int r;
        private final SelectProvider arcSelectProvider;

        private ArcWidget(BirdviewScene scene, int radius) {
            super((Scene)scene);
            this.arcSelectProvider = new SelectProvider(){

                public boolean isAimingAllowed(Widget widget, Point point, boolean bln) {
                    return true;
                }

                public boolean isSelectionAllowed(Widget widget, Point point, boolean bln) {
                    double distance = point.distance(0.0, 0.0);
                    if (distance < (double)(ArcWidget.this.r - 2) || distance > (double)(ArcWidget.this.r + 2)) {
                        return false;
                    }
                    Vector2d startVec = new Vector2d(Math.cos((double)ArcWidget.this.startAngle * Math.PI / 180.0), Math.sin((double)ArcWidget.this.startAngle * Math.PI / 180.0));
                    Vector2d pointVec = new Vector2d((double)point.x, (double)point.y);
                    int angle = (int)(startVec.angle(pointVec) * 180.0 / Math.PI);
                    if (startVec.y * pointVec.x - startVec.x * pointVec.y > 0.0) {
                        angle = -angle;
                    }
                    return angle < 0 ? angle > ArcWidget.this.angleSize : angle < ArcWidget.this.angleSize;
                }

                public void select(Widget widget, Point point, boolean bln) {
                    StartWaypointWidget.this.controller.setFocusedObject(StartWaypointWidget.this.character);
                }
            };
            this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)this.arcSelectProvider));
            this.r = radius;
        }

        protected Rectangle calculateClientArea() {
            return new Rectangle(-this.r, -this.r, 2 * this.r + 1, 2 * this.r + 1);
        }

        protected void paintWidget() {
            Graphics2D g = this.getGraphics();
            g.setStroke(new BasicStroke(5.0f));
            g.setColor(Color.WHITE);
            Rotation rot = StartWaypointWidget.this.character.getCharacterProperties().getStartRotation();
            rot.pitch = 0.0;
            Vector3d vector = new Vector3d((Tuple3d)rot.toLocation().asPoint3d());
            vector.scale((double)this.r);
            g.drawLine(0, 0, (int)vector.x, (int)vector.y);
        }

        public int getStartAngle() {
            return this.startAngle;
        }

        public int getAngleSize() {
            return this.angleSize;
        }

        public void setRange(int startAngle, int angleSize) {
            this.startAngle = startAngle;
            this.angleSize = angleSize;
            this.revalidate();
        }

        public void destroy() {
            this.removeFromParent();
        }
    }
}

