/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.widget;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.action.AttachWaypointAction;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.BirdviewScene;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.MoveConnection;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.WaypointWidget;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IUndoRedoListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeContainer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.utils.collections.ElementListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

class MoveWaypointWidget
extends WaypointWidget
implements Widget.Dependency,
IUndoRedoListener {
    protected ActionMovement move;
    protected MoveConnection connection;
    private ElementListener<ChangeContainer> listener = new ElementListener<ChangeContainer>(){

        public void elementChanged(ChangeContainer elem, boolean added) {
            MoveWaypointWidget.this.revalidate();
            MoveWaypointWidget.this.getScene().validate();
        }
    };
    private final SelectProvider selectProvider = new SelectProvider(){

        public boolean isAimingAllowed(Widget widget, Point point, boolean bln) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point point, boolean bln) {
            return true;
        }

        public void select(Widget widget, Point point, boolean bln) {
            MoveWaypointWidget.this.controller.setFocusedObject(MoveWaypointWidget.this.move);
        }
    };
    private final MoveProvider moveProvider = new MoveProvider(){

        public void movementStarted(Widget widget) {
            MoveWaypointWidget.this.getScene().removeDependency((Widget.Dependency)MoveWaypointWidget.this);
        }

        public void movementFinished(Widget widget) {
            MoveWaypointWidget.this.getScene().addDependency((Widget.Dependency)MoveWaypointWidget.this);
            Point spoint = widget.getPreferredLocation();
            Matrix3d s2u = new Matrix3d(MoveWaypointWidget.this.getU2SMatrix());
            s2u.invert();
            Vector3d sloc = new Vector3d((double)spoint.x, (double)spoint.y, 1.0);
            s2u.transform((Tuple3d)sloc);
            sloc.z = MoveWaypointWidget.this.move.getActionProperties().getEnd().z;
            StoryActionProperties oldProps = MoveWaypointWidget.this.move.getActionProperties();
            StoryActionProperties newProps = new StoryActionProperties(MoveWaypointWidget.this.move.getActionProperties());
            newProps.setEnd(new Location((Tuple3d)sloc));
            ChangeStoryAction csa = new ChangeStoryAction(ChangeType.CHANGE, MoveWaypointWidget.this.character, oldProps, newProps, MoveWaypointWidget.this.move);
            MoveWaypointWidget.this.character.getModel().processChangeStoryAction(csa);
        }

        public Point getOriginalLocation(Widget widget) {
            return widget.getPreferredLocation();
        }

        public void setNewLocation(Widget widget, Point location) {
            widget.setPreferredLocation(location);
        }
    };
    private static Border circleBorder = new Border(){
        private Insets zeroInsets = new Insets(0, 0, 0, 0);
        private Stroke stroke = new BasicStroke(2.0f);

        public Insets getInsets() {
            return this.zeroInsets;
        }

        public void paint(Graphics2D g2, Rectangle rect) {
            g2.setStroke(this.stroke);
            g2.setColor(Color.BLACK);
            g2.drawOval(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
        }

        public boolean isOpaque() {
            return false;
        }
    };

    public void undoRedoPerformed(ChangeContainer changePosition, boolean undo) {
        this.revalidate();
        this.getScene().validate();
    }

    MoveWaypointWidget(BirdviewScene scene, ViewController controller, Widget lastWidget, EmohawkCharacter character, ActionMovement move) {
        super((Scene)scene, character, controller, move.getEnd(), 10, Color.ORANGE);
        this.move = move;
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)this.selectProvider));
        this.getActions().addAction((WidgetAction)new AttachWaypointAction(scene.getConnectionsLayer()));
        this.getActions().addAction(ActionFactory.createMoveAction(null, (MoveProvider)this.moveProvider));
        scene.addDependency(this);
        scene.getWaypointsLayer().addChild((Widget)this);
        this.connection = new MoveConnection(scene, controller, move);
        this.connection.setSourceAnchor(AnchorFactory.createCircularAnchor((Widget)lastWidget, (int)(this.r + 1)));
        this.connection.setTargetAnchor(AnchorFactory.createCircularAnchor((Widget)this, (int)(this.r + 1)));
        scene.addObject(move, new Widget[]{this});
        this.ic.add((Object)move);
        character.getModel().getChangeActions().addCollectionListener(this.listener);
        character.getModel().addUndoRedoListener(this);
    }

    protected Point getSceneLocation() {
        Location end = this.move.getEnd();
        Vector3d uloc = new Vector3d(end.x, end.y, 1.0);
        this.getU2SMatrix().transform((Tuple3d)uloc);
        return new Point((int)uloc.x, (int)uloc.y);
    }

    public void reconnect(Widget widget) {
        this.connection.setSourceAnchor(AnchorFactory.createCenterAnchor((Widget)widget));
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        super.notifyStateChanged(previousState, state);
        this.connection.notifyStateChanged(previousState, state);
        Color color = this.widgetColor;
        if (state.isFocused()) {
            this.setBorder(circleBorder);
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        if (state.isSelected()) {
            color = this.widgetColor.brighter();
        }
        this.setForeground(color);
    }

    public void destroy() {
        this.character.getModel().getChangeActions().removeCollectionListener(this.listener);
        this.character.getModel().removeUndoRedoListener(this);
        this.connection.destroy();
        ((ObjectScene)this.getScene()).removeObject((Object)this.move);
        this.getScene().removeDependency((Widget.Dependency)this);
        this.removeFromParent();
    }
}

