/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.widget;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.BirdviewScene;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.CharacterInfoWidget;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.IDestroyableWidget;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.WaypointWidget;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IUndoRedoListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeContainer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.CharacterProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ObservableList;
import cz.cuni.amis.utils.collections.SimpleListener;
import java.awt.Color;
import java.awt.Point;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class CharacterWidget
extends WaypointWidget
implements StoryController.StoryControllerListener,
IDestroyableWidget {
    private CharacterInfoWidget infoWidget;
    private CharacterNameWidget nameWidget;
    private long time;
    private Widget targetPositionDependency;
    private Widget sourcePositionDependency;
    private Widget.Dependency positionDependencyListener = new Widget.Dependency(){

        public void revalidateDependency() {
            EmohawkCharacter depChar = (EmohawkCharacter)CharacterWidget.this.targetPositionDependency.getLookup().lookup(EmohawkCharacter.class);
            ActionMovement depMove = (ActionMovement)CharacterWidget.this.targetPositionDependency.getLookup().lookup(ActionMovement.class);
            assert (depChar != null);
            if (depMove == null) {
                CharacterWidget.this.setPreferredLocation(CharacterWidget.this.targetPositionDependency.getPreferredLocation());
                return;
            }
            double depTime = depMove.getTime();
            double depDuration = depMove.getDuration();
            double fraction = Math.min(1.0, ((double)CharacterWidget.this.time - depTime) / depDuration);
            Logger.getLogger("Birdview").fine("depMove is " + depMove + " fraction " + fraction);
            Location sourceLocation = CharacterWidget.this.sourcePositionDependency != null ? CharacterWidget.this.scene2unreal(CharacterWidget.this.sourcePositionDependency.getPreferredLocation()) : depMove.getStart();
            Location targetLocation = CharacterWidget.this.scene2unreal(CharacterWidget.this.targetPositionDependency.getPreferredLocation());
            Point tmpLoc = CharacterWidget.this.unreal2scene(Location.interpolate((Location)sourceLocation, (Location)targetLocation, (double)fraction));
            CharacterWidget.this.setPreferredLocation(tmpLoc);
        }
    };
    private final CollectionEventListener<ChangeContainer> changeActionsListener = new SimpleListener<ChangeContainer>(){

        protected void changed(Collection<ChangeContainer> collection, Collection<ChangeContainer> added, Collection<ChangeContainer> removed) {
            CharacterWidget.this.update(CharacterWidget.this.time);
        }
    };
    private final IUndoRedoListener undoRedoListener = new IUndoRedoListener(){

        public void undoRedoPerformed(ChangeContainer changePosition, boolean undo) {
            CharacterWidget.this.update(CharacterWidget.this.time);
        }
    };

    protected CharacterWidget(BirdviewScene scene, EmohawkCharacter character, ViewController controller, int r, long time) {
        super((Scene)scene, character, controller, character.getLocation(time), 10, Color.PINK);
        this.infoWidget = new CharacterInfoWidget(scene, character, controller, r, time);
        this.nameWidget = new CharacterNameWidget(scene, character, time);
        this.addChild(this.infoWidget);
        this.addChild(this.nameWidget);
        this.nameWidget.setPreferredLocation(new Point(-r, 2 * r));
        this.targetPositionDependency = this.findPositionDependency(time);
        assert (this.targetPositionDependency != null);
        this.targetPositionDependency.addDependency(this.positionDependencyListener);
        this.sourcePositionDependency = this.findSourcePositionDependency(time);
        if (this.sourcePositionDependency != null) {
            this.sourcePositionDependency.addDependency(this.positionDependencyListener);
        }
        scene.addDependency(this);
        character.getModel().addStoryControllerListener(this);
        character.getModel().addUndoRedoListener(this.undoRedoListener);
        character.getModel().getChangeActions().addCollectionListener(this.changeActionsListener);
        scene.getPlayerLayer().addChild((Widget)this);
    }

    protected void paintWidget() {
    }

    private void update(long time) {
        this.time = time;
        this.setUnrealLocation(this.character.getLocation(time));
        this.targetPositionDependency.removeDependency(this.positionDependencyListener);
        this.targetPositionDependency = this.findPositionDependency(time);
        this.targetPositionDependency.addDependency(this.positionDependencyListener);
        if (this.sourcePositionDependency != null) {
            this.sourcePositionDependency.removeDependency(this.positionDependencyListener);
        }
        this.sourcePositionDependency = this.findSourcePositionDependency(time);
        if (this.sourcePositionDependency != null) {
            this.sourcePositionDependency.addDependency(this.positionDependencyListener);
        }
        this.infoWidget.update(time);
        this.nameWidget.update(time);
        this.revalidate();
        this.getScene().validate();
    }

    public void currentTimeChanged(long oldCurrentTime, long newCurrentTime) {
        this.update(newCurrentTime);
    }

    private Widget findPositionDependency(long time) {
        ActionMovement am;
        BirdviewScene scene = (BirdviewScene)this.getScene();
        ObservableList<ActionMovement> moves = this.character.getMovements();
        if (time == 0L) {
            return scene.findWidget(this.character);
        }
        Object seeked = this.character;
        Iterator i$ = moves.iterator();
        while (i$.hasNext() && (am = (ActionMovement)i$.next()).getTime() <= time) {
            seeked = am;
        }
        Logger.getLogger("Birdview").fine("Dependency ActionMovement has index " + moves.indexOf(seeked));
        return scene.findWidget(seeked);
    }

    private Widget findSourcePositionDependency(long time) {
        BirdviewScene scene = (BirdviewScene)this.getScene();
        ObservableList<ActionMovement> moves = this.character.getMovements();
        ActionMovement move = this.character.getActionMovement(time);
        if (move == null) {
            return null;
        }
        if (moves.indexOf(move) == 0) {
            return scene.findWidget(this.character);
        }
        ActionMovement prev = move.getPreviousMovement();
        if (prev == null) {
            return null;
        }
        Widget w = scene.findWidget(prev);
        return w;
    }

    protected void setRotation(Rotation rotation) {
        this.infoWidget.setUnrealRotation(rotation);
    }

    public void destroy() {
        this.character.getModel().removeStoryControllerListener(this);
        this.character.getModel().removeUndoRedoListener(this.undoRedoListener);
        this.character.getModel().getChangeActions().removeCollectionListener(this.changeActionsListener);
        this.targetPositionDependency.removeDependency(this.positionDependencyListener);
        if (this.sourcePositionDependency != null) {
            this.sourcePositionDependency.removeDependency(this.positionDependencyListener);
        }
        this.getScene().removeDependency((Widget.Dependency)this);
        this.infoWidget.destroy();
        this.nameWidget.destroy();
    }

    private static class CharacterNameWidget
    extends Widget
    implements IDestroyableWidget {
        private final EmohawkCharacter character;
        private final LabelWidget nameWidget;
        private final LabelWidget animationWidget;
        private final TextFieldInplaceEditor characterNameEditor = new TextFieldInplaceEditor(){

            public boolean isEnabled(Widget widget) {
                return true;
            }

            public String getText(Widget widget) {
                return CharacterNameWidget.this.character.getName();
            }

            public void setText(Widget widget, String string) {
                CharacterProperties oldCP = new CharacterProperties(CharacterNameWidget.this.character.getCharacterProperties());
                CharacterProperties newCP = new CharacterProperties(oldCP);
                newCP.setName(string);
                ChangeCharacter change = new ChangeCharacter(ChangeType.CHANGE, ((CharacterNameWidget)CharacterNameWidget.this).character.id, CharacterNameWidget.this.character, oldCP, newCP);
                CharacterNameWidget.this.character.getModel().processChangeCharacter(change);
            }
        };

        protected void paintWidget() {
            if (!this.character.getModel().getSettings().isbMapDebug()) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
            super.paintWidget();
        }

        private CharacterNameWidget(BirdviewScene scene, EmohawkCharacter character, long time) {
            super((Scene)scene);
            this.character = character;
            this.setLayout(LayoutFactory.createVerticalFlowLayout());
            this.nameWidget = new LabelWidget((Scene)scene);
            this.animationWidget = new LabelWidget((Scene)scene);
            this.nameWidget.setAlignment(LabelWidget.Alignment.CENTER);
            this.animationWidget.setAlignment(LabelWidget.Alignment.CENTER);
            this.addChild((Widget)this.nameWidget);
            this.addChild((Widget)this.animationWidget);
            this.update(time);
            this.setBorder(BorderFactory.createRoundedBorder((int)10, (int)10, (int)3, (int)3, (Color)new Color(68, 123, 205), (Color)new Color(47, 86, 143)));
            this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)this.characterNameEditor));
        }

        public void update(long time) {
            if (!this.character.getModel().getSettings().isbMapDebug()) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
            this.nameWidget.setLabel(this.character.getName());
            ActionAnimation animation = this.character.getActionAnimation(time);
            if (animation != null) {
                this.animationWidget.setLabel(animation.getAnimationId());
            } else {
                this.animationWidget.setLabel("[NOT SET]");
            }
        }

        public void destroy() {
            this.removeFromParent();
        }
    }
}

