/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.widget;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.BirdviewScene;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.IDestroyableWidget;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.WaypointWidget;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ECharacterType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.logging.Logger;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class CharacterInfoWidget
extends WaypointWidget {
    public static final double ROTATE_SPEED = 10.0;
    public static final int MIN_ROTATION_DURATION = 1000;
    private static final Stroke stroke = new BasicStroke(2.0f);
    private Rotation characterRotation;
    private long time;
    private DragWidget dragWidget;
    private ArcWidget arcWidget;

    public CharacterInfoWidget(BirdviewScene scene, EmohawkCharacter character, ViewController controller, int r, long time) {
        super((Scene)scene, character, controller, new Location(), r, Color.DARK_GRAY);
        this.characterRotation = character.getCharacterProperties().getStartRotation();
        this.time = time;
        this.arcWidget = new ArcWidget(scene, r);
        this.arcWidget.setRange(this.rotation2angle(this.getRotationStart(time)), this.getRotationSize(time));
        this.addChild(this.arcWidget);
        Vector3d rotationVector = this.rotation2vector(this.characterRotation);
        rotationVector.normalize();
        rotationVector.scale((double)r);
        this.dragWidget = new DragWidget(scene, Color.BLACK, 4, r);
        this.dragWidget.setRotation(this.getRotationEnd(time));
        this.addChild(this.dragWidget);
    }

    protected void paintWidget() {
        Graphics2D g = this.getGraphics();
        g.setStroke(stroke);
        int circleR = this.r - 5;
        g.setColor(this.getForeground());
        if (this.character.getCharacterProperties().getCharacterClass().equals((Object)ECharacterType.CAMERA)) {
            g.drawRect(-circleR, -circleR, 2 * circleR, 2 * circleR);
        } else {
            g.drawOval(-circleR, -circleR, 2 * circleR, 2 * circleR);
        }
        g.setStroke(new BasicStroke(4.0f));
        g.setColor(Color.CYAN);
        Vector3d vector = this.rotation2vector(this.characterRotation);
        vector.scale((double)this.r);
        g.drawLine(0, 0, (int)vector.x, (int)vector.y);
    }

    private Vector3d rotation2vector(Rotation rot) {
        return new Vector3d((Tuple3d)rot.toLocation().asPoint3d());
    }

    protected void update(long time) {
        this.characterRotation = this.character.getRotation(time);
        this.characterRotation.pitch = 0.0;
        this.time = time;
        Rotation rotEnd = this.getRotationEnd(time);
        rotEnd.pitch = 0.0;
        this.dragWidget.setRotation(rotEnd);
        Rotation rotStart = this.getRotationStart(time);
        rotStart.pitch = 0.0;
        int rotSize = this.getRotationSize(time);
        this.arcWidget.setRange(this.rotation2angle(rotStart), rotSize);
        this.revalidate();
    }

    private int rotation2angle(Rotation rotation) {
        return (int)(rotation.getYaw() * 180.0 / 32768.0);
    }

    private Rotation getRotationStart(long time) {
        ActionRotation rotationAction = this.character.getActionRotation(time);
        return rotationAction == null ? this.character.getRotation(time) : rotationAction.getStartHorizontalAngle(time);
    }

    private Rotation getRotationEnd(long time) {
        ActionRotation rotationAction = this.character.getActionRotation(time);
        return rotationAction == null ? this.character.getRotation(time) : rotationAction.getEndHorizontalAngle(time);
    }

    private int getRotationSize(long time) {
        ActionRotation rotationAction = this.character.getActionRotation(time);
        if (rotationAction == null) {
            return 0;
        }
        int rotationSize = (int)((double)(180 * rotationAction.getRelativeHorizontalAngle()) / 32768.0);
        return rotationSize;
    }

    protected void setUnrealRotation(Rotation rotation) {
        rotation.pitch = 0.0;
        this.characterRotation = new Rotation(rotation);
        this.dragWidget.setRotation(rotation);
        this.arcWidget.setRange(this.rotation2angle(rotation), 0);
    }

    public void destroy() {
        this.dragWidget.destroy();
        this.arcWidget.destroy();
        this.removeFromParent();
        this.character = null;
    }

    private final class ArcWidget
    extends Widget
    implements IDestroyableWidget {
        private static final int ARC_WIDTH = 4;
        private int startAngle;
        private int angleSize;
        private int r;
        private final SelectProvider arcSelectProvider;

        private ArcWidget(BirdviewScene scene, int radius) {
            super((Scene)scene);
            this.arcSelectProvider = new SelectProvider(){

                public boolean isAimingAllowed(Widget widget, Point point, boolean bln) {
                    return true;
                }

                public boolean isSelectionAllowed(Widget widget, Point point, boolean bln) {
                    double distance = point.distance(0.0, 0.0);
                    if (distance < (double)(ArcWidget.this.r - 2) || distance > (double)(ArcWidget.this.r + 2)) {
                        return false;
                    }
                    Vector2d startVec = new Vector2d(Math.cos((double)ArcWidget.this.startAngle * Math.PI / 180.0), Math.sin((double)ArcWidget.this.startAngle * Math.PI / 180.0));
                    Vector2d pointVec = new Vector2d((double)point.x, (double)point.y);
                    int angle = (int)(startVec.angle(pointVec) * 180.0 / Math.PI);
                    if (startVec.y * pointVec.x - startVec.x * pointVec.y > 0.0) {
                        angle = -angle;
                    }
                    return angle < 0 ? angle > ArcWidget.this.angleSize : angle < ArcWidget.this.angleSize;
                }

                public void select(Widget widget, Point point, boolean bln) {
                    ActionRotation focusedRotation = CharacterInfoWidget.this.character.getActionRotation(CharacterInfoWidget.this.time);
                    if (focusedRotation != null) {
                        CharacterInfoWidget.this.controller.setFocusedObject(focusedRotation);
                    }
                }
            };
            this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)this.arcSelectProvider));
            this.r = radius;
        }

        protected Rectangle calculateClientArea() {
            return new Rectangle(-this.r, -this.r, 2 * this.r + 1, 2 * this.r + 1);
        }

        protected void paintWidget() {
            Graphics2D g = this.getGraphics();
            g.setColor(Color.WHITE);
            g.drawArc(-this.r, -this.r, 2 * this.r, 2 * this.r, -this.startAngle, -this.angleSize);
        }

        public int getStartAngle() {
            return this.startAngle;
        }

        public int getAngleSize() {
            return this.angleSize;
        }

        public void setRange(int startAngle, int angleSize) {
            this.startAngle = startAngle;
            this.angleSize = angleSize;
            this.revalidate();
        }

        public void destroy() {
            this.removeFromParent();
        }
    }

    private final class DragWidget
    extends Widget
    implements IDestroyableWidget {
        private Color color;
        private int radius;
        private double rotationDistance;
        private MoveStrategy circlingStartegy;
        private MoveProvider moveProvider;

        public DragWidget(BirdviewScene scene, Color color, int widgetRadius, double rotationDistance) {
            super((Scene)scene);
            this.circlingStartegy = new MoveStrategy(){

                public Point locationSuggested(Widget widget, Point originalLocation, Point suggestedLocation) {
                    Vector2d vector = new Vector2d((double)suggestedLocation.x, (double)suggestedLocation.y);
                    vector.normalize();
                    vector.scale(DragWidget.this.rotationDistance);
                    return new Point((int)vector.x, (int)vector.y);
                }
            };
            this.moveProvider = new MoveProvider(){
                double relativeAngle = 0.0;

                public void movementStarted(Widget widget) {
                    this.relativeAngle = 0.0;
                }

                public void movementFinished(Widget widget) {
                    ActionRotation rotation = CharacterInfoWidget.this.character.getActionRotation(CharacterInfoWidget.this.time);
                    if (rotation != null) {
                        if (!this.modifyRotation(rotation, this.relativeAngle)) {
                            Logger.getLogger("Birdview").warning("Unable to change rotation");
                        }
                    } else if (!this.addRotation(CharacterInfoWidget.this.time, this.relativeAngle)) {
                        Logger.getLogger("Birdview").warning("Unable to create rotation at " + CharacterInfoWidget.this.time + "ms, rotating by " + this.relativeAngle + " degrees.");
                    }
                }

                private boolean modifyRotation(ActionRotation rotation, double angle) {
                    int absUTAngle;
                    StoryActionProperties oldProp = rotation.getActionProperties();
                    StoryActionProperties newProp = new StoryActionProperties(rotation.getActionProperties());
                    int relativeUTAngle = (int)(32768.0 * angle / 180.0);
                    int startAbsUTAngle = (int)rotation.getStartHorizontalAngle((long)rotation.getTime()).yaw;
                    for (absUTAngle = startAbsUTAngle + relativeUTAngle; absUTAngle < Short.MIN_VALUE; absUTAngle += 65536) {
                    }
                    while (absUTAngle > Short.MAX_VALUE) {
                        absUTAngle -= 65536;
                    }
                    newProp.setAngleH(absUTAngle);
                    ChangeStoryAction change = new ChangeStoryAction(ChangeType.CHANGE, rotation.getOwner(), oldProp, newProp, rotation);
                    return rotation.getOwner().getModel().processChangeStoryAction(change);
                }

                private boolean addRotation(long time, double angle) {
                    int absUTAngle;
                    int duration = (int)Math.min((double)CharacterInfoWidget.this.character.getFreeRotationSpace(time), 1000.0 * Math.abs(angle) / 10.0);
                    duration = Math.max(duration, 1000);
                    int charStartUTYaw = (int)CharacterInfoWidget.this.character.getRotation((long)time).yaw;
                    int relativeUTAngle = (int)(32768.0 * angle / 180.0);
                    for (absUTAngle = charStartUTYaw + relativeUTAngle; absUTAngle < Short.MIN_VALUE; absUTAngle += 65536) {
                    }
                    while (absUTAngle > Short.MAX_VALUE) {
                        absUTAngle -= 65536;
                    }
                    ActionRotation newRotation = new ActionRotation(CharacterInfoWidget.this.character, time, duration, absUTAngle, "");
                    ChangeStoryAction change = new ChangeStoryAction(ChangeType.ADD, CharacterInfoWidget.this.character, newRotation.getActionProperties(), newRotation);
                    return CharacterInfoWidget.this.character.getModel().processChangeStoryAction(change);
                }

                private double getAngle(Vector2d startVec, Vector2d endVec) {
                    int angleSize = (int)(startVec.angle(endVec) * 180.0 / Math.PI);
                    if (startVec.y * endVec.x - startVec.x * endVec.y > 0.0) {
                        angleSize = -angleSize;
                    }
                    return angleSize;
                }

                public Point getOriginalLocation(Widget widget) {
                    return widget.getPreferredLocation();
                }

                public void setNewLocation(Widget widget, Point point) {
                    widget.setPreferredLocation(point);
                    int startAngle = CharacterInfoWidget.this.arcWidget.getStartAngle();
                    Vector2d startVec = new Vector2d(Math.cos((double)startAngle * Math.PI / 180.0), Math.sin((double)startAngle * Math.PI / 180.0));
                    Vector2d dragVec = new Vector2d((double)point.x, (double)point.y);
                    this.relativeAngle = this.getAngle(startVec, dragVec);
                    Logger.getLogger("DragWidget").info("startVec " + startVec + " dragVec " + dragVec + " angle " + this.relativeAngle);
                    CharacterInfoWidget.this.arcWidget.setRange(startAngle, (int)this.relativeAngle);
                    ActionRotation actRot = CharacterInfoWidget.this.character.getActionRotation(CharacterInfoWidget.this.time);
                    if (actRot != null) {
                        double fraction = (double)(CharacterInfoWidget.this.time - actRot.getTime()) / (double)actRot.getDuration();
                        double charAngle = (double)startAngle + fraction * this.relativeAngle;
                        ((CharacterInfoWidget)CharacterInfoWidget.this).characterRotation.yaw = 32768.0 * charAngle / 180.0;
                    }
                }
            };
            this.color = color;
            this.radius = widgetRadius;
            this.rotationDistance = rotationDistance;
            this.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)this.circlingStartegy, (MoveProvider)this.moveProvider));
        }

        protected Rectangle calculateClientArea() {
            return new Rectangle(-this.radius - 1, -this.radius - 1, 2 * this.radius + 1, 2 * this.radius + 1);
        }

        protected void paintWidget() {
            Graphics2D g = this.getGraphics();
            g.setColor(this.color);
            g.fillOval(-this.radius, -this.radius, 2 * this.radius, 2 * this.radius);
        }

        protected void setRotation(Rotation characterRotation) {
            Location vector = characterRotation.toLocation();
            vector = vector.getNormalized().scale(this.rotationDistance);
            this.setPreferredLocation(new Point((int)vector.x, (int)vector.y));
        }

        public void destroy() {
            this.removeFromParent();
        }
    }
}

