/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.widget;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emonewt.gui.AvatarState;
import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.action.DeleteFocusedCharacterAction;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.action.DeleteWaypointAction;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.action.MouseCenteredScaleAction;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.action.PanAction;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.BackgroundWidget;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.CharacterWidget;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.IDestroyableWidget;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.MoveWaypointWidget;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.StartWaypointWidget;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.WaypointWidget;
import cz.cuni.amis.pogamut.emonewt.gui.dialogs.NewtNewCharDialog;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryPlayerListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ElementListener;
import cz.cuni.amis.utils.collections.ObservableList;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.vecmath.GMatrix;
import javax.vecmath.GVector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class BirdviewScene
extends ObjectScene
implements StoryController.StoryControllerListener,
IDestroyableWidget {
    private final StoryController model;
    private final EmoNewtFrame frame;
    private final Matrix3d u2s;
    private final LayerWidget backgroundLayer;
    private final LayerWidget startpointsLayer;
    private final LayerWidget waypointsLayer;
    private final LayerWidget movesLayer;
    private final LayerWidget selectedLayer;
    private final LayerWidget charactersLayer;
    private final InstanceContent ic;
    private final Lookup lookup;
    private final ViewController controller;
    private int lastCursorX = 0;
    private int lastCursorY = 0;
    private final ViewController.ControllerSelectionListener selectionListener = new ViewController.ControllerSelectionListener(){

        @Override
        public void focusChanged(Object prevFocusedObject, Object focusedObject) {
            if (focusedObject instanceof EmohawkCharacter || focusedObject instanceof ActionMovement) {
                BirdviewScene.this.setFocusedObject(focusedObject);
            } else {
                BirdviewScene.this.setFocusedObject(null);
            }
        }

        @Override
        public void selectionChanged(Set<?> prevSelectedObjects, Set<?> selectedObjects) {
            HashSet selected = new HashSet();
            for (Object object : selectedObjects) {
                if (!(object instanceof ActionMovement) && !(object instanceof EmohawkCharacter)) continue;
                selected.add(object);
            }
            BirdviewScene.this.setSelectedObjects(selected);
        }
    };
    private final IStoryPlayerListener storyPlayerListener = new IStoryPlayerListener(){

        @Override
        public void storyPlayChanged(boolean storyIsRunning) {
            BirdviewScene.this.getWaypointsLayer().setEnabled(!storyIsRunning);
            BirdviewScene.this.getConnectionsLayer().setEnabled(!storyIsRunning);
            BirdviewScene.this.getPlayerLayer().setEnabled(!storyIsRunning);
            BirdviewScene.this.getStartpointsLayer().setEnabled(!storyIsRunning);
            if (storyIsRunning) {
                for (CharacterWidget characterWidget : BirdviewScene.this.characterWidgets.values()) {
                    characterWidget.setVisible(storyIsRunning);
                }
            }
        }

        @Override
        public void avatarsChanged(long time, Map<EmohawkCharacter, AvatarState> avatarStates) {
            for (Map.Entry<EmohawkCharacter, AvatarState> entry : avatarStates.entrySet()) {
                CharacterWidget characterWidget = (CharacterWidget)BirdviewScene.this.characterWidgets.get(entry.getKey());
                if (characterWidget == null) continue;
                AvatarState avatarState = entry.getValue();
                characterWidget.setVisible(true);
                characterWidget.setUnrealLocation(avatarState.getLocation());
                characterWidget.setRotation(avatarState.getRotation());
            }
            BirdviewScene.this.validate();
        }
    };
    private final CollectionEventListener<EmohawkCharacter> charactersListener = new ElementListener<EmohawkCharacter>(){

        public void elementChanged(EmohawkCharacter character, boolean added) {
            if (StoryTools.DEBUG) {
                System.out.println("characterListener " + character + " " + added);
            }
            if (added) {
                BirdviewScene.this.addCharacter(character);
            } else {
                BirdviewScene.this.removeCharacter(character);
            }
        }
    };
    public MouseAdapter myMouseAdapter = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            BirdviewScene.this.lastCursorX = e.getX();
            BirdviewScene.this.lastCursorY = e.getY();
        }
    };
    private PopupMenuProvider popupMenuProvider = new PopupMenuProvider(){
        JPopupMenu menu = new JPopupMenu();
        JMenuItem addCharacter = this.menu.add(new AbstractAction(StorySettings.currentBundle.getString("ADD CHARACTER")){

            public void actionPerformed(ActionEvent e) {
                NewtNewCharDialog dial = new NewtNewCharDialog(BirdviewScene.this.frame, true, BirdviewScene.this.model);
                Point viewPoint = new Point(BirdviewScene.this.lastCursorX, BirdviewScene.this.lastCursorY);
                Point scenePoint = BirdviewScene.this.convertViewToScene(viewPoint);
                Vector3d unrealStartLocation = new Vector3d((double)scenePoint.x, (double)scenePoint.y, 1.0);
                Matrix3d s2u = new Matrix3d(BirdviewScene.this.u2s);
                s2u.invert();
                s2u.transform((Tuple3d)unrealStartLocation);
                unrealStartLocation.z = StoryTools.getDefaultZ();
                dial.setInitialLocation(new Location((Tuple3d)unrealStartLocation));
                dial.setVisible(true);
            }
        });
        JMenuItem startSimulation = this.menu.add(new AbstractAction(StorySettings.currentBundle.getString("START_SIMULATION")){

            public void actionPerformed(ActionEvent e) {
                BirdviewScene.this.controller.startSimulation(BirdviewScene.this.model.getCurrentStoryTime(), BirdviewScene.this.model.getStoryEnd());
            }
        });
        JMenuItem stopSimulation = this.menu.add(new AbstractAction(StorySettings.currentBundle.getString("STOPSIMULATION")){

            public void actionPerformed(ActionEvent e) {
                BirdviewScene.this.controller.stopSimulation();
            }
        });
        JMenuItem startStory = this.menu.add(new AbstractAction(StorySettings.currentBundle.getString("START_PLAYING")){

            public void actionPerformed(ActionEvent e) {
                BirdviewScene.this.controller.startUnrealStory(BirdviewScene.this.model.getCurrentStoryTime(), BirdviewScene.this.model.getStoryEnd());
            }
        });
        JMenuItem stopStory = this.menu.add(new AbstractAction(StorySettings.currentBundle.getString("STOP_PLAYING")){

            public void actionPerformed(ActionEvent e) {
                BirdviewScene.this.controller.stopUnrealStory();
            }
        });
        {
            this.menu.add(this.addCharacter);
            this.menu.addSeparator();
            this.menu.add(this.startSimulation);
            this.menu.add(this.stopSimulation);
            this.menu.addSeparator();
            this.menu.add(this.startStory);
            this.menu.add(this.stopStory);
        }

        public JPopupMenu getPopupMenu(Widget widget, Point point) {
            boolean isSomethingRunning = BirdviewScene.this.controller.isSimulationRunning() || BirdviewScene.this.controller.isUnrealStoryRunning();
            this.addCharacter.setEnabled(!isSomethingRunning);
            this.startSimulation.setEnabled(!isSomethingRunning);
            this.stopSimulation.setEnabled(BirdviewScene.this.controller.isSimulationRunning());
            this.startStory.setEnabled(!isSomethingRunning);
            this.stopStory.setEnabled(BirdviewScene.this.controller.isUnrealStoryRunning());
            return this.menu;
        }
    };
    private CollectionEventListener<ActionMovement> moveListener = new CollectionEventListener<ActionMovement>(){

        private void addMovement(ActionMovement move) {
            Widget prevWidget;
            EmohawkCharacter character = move.getOwner();
            ObservableList<ActionMovement> allMoves = character.getMovements();
            int index = allMoves.indexOf(move);
            Widget widget = prevWidget = index == 0 ? this.findWidgetL(BirdviewScene.this.getStartpointsLayer().getChildren(), character) : this.findWidgetL(BirdviewScene.this.getWaypointsLayer().getChildren(), allMoves.get(index - 1));
            assert (prevWidget != null);
            MoveWaypointWidget newWidget = new MoveWaypointWidget(BirdviewScene.this, BirdviewScene.this.controller, prevWidget, character, move);
            if (index == allMoves.size() - 1) {
                BirdviewScene.this.controller.setFocusedObject(move);
                return;
            }
            Widget nextWidget = this.findWidgetL(BirdviewScene.this.getWaypointsLayer().getChildren(), allMoves.get(index + 1));
            assert (nextWidget instanceof MoveWaypointWidget);
            ((MoveWaypointWidget)nextWidget).reconnect(newWidget);
            BirdviewScene.this.controller.setFocusedObject(move);
        }

        private Widget findWidgetL(List<Widget> list, Object o) {
            for (Widget w : list) {
                Object m = w.getLookup().lookup(o.getClass());
                if (o != m) continue;
                return w;
            }
            return null;
        }

        private void removeMovement(ActionMovement move) {
            EmohawkCharacter character;
            ObservableList<ActionMovement> allMoves;
            int index;
            if (BirdviewScene.this.controller.getFocusedObject() == move) {
                BirdviewScene.this.controller.setFocusedObject(null);
            }
            Widget prevWidget = (index = (allMoves = (character = move.getOwner()).getMovements()).indexOf(move)) == 0 ? this.findWidgetL(BirdviewScene.this.getStartpointsLayer().getChildren(), character) : this.findWidgetL(BirdviewScene.this.getWaypointsLayer().getChildren(), allMoves.get(index - 1));
            Widget widget = this.findWidgetL(BirdviewScene.this.getWaypointsLayer().getChildren(), move);
            assert (widget != null && widget instanceof MoveWaypointWidget);
            ((MoveWaypointWidget)widget).destroy();
            if (index == allMoves.size() - 1) {
                return;
            }
            Widget nextWidget = this.findWidgetL(BirdviewScene.this.getWaypointsLayer().getChildren(), allMoves.get(index + 1));
            assert (nextWidget instanceof MoveWaypointWidget);
            ((MoveWaypointWidget)nextWidget).reconnect(prevWidget);
        }

        public void preAddEvent(Collection<ActionMovement> toBeAdded, Collection<ActionMovement> whereToAdd) {
        }

        public void postAddEvent(Collection<ActionMovement> alreadyAdded, Collection<ActionMovement> whereWereAdded) {
            for (ActionMovement am : alreadyAdded) {
                this.addMovement(am);
            }
        }

        public void preRemoveEvent(Collection<ActionMovement> toBeRemoved, Collection<ActionMovement> whereToRemove) {
            for (ActionMovement am : toBeRemoved) {
                this.removeMovement(am);
            }
        }

        public void postRemoveEvent(Collection<ActionMovement> alreadyAdded, Collection<ActionMovement> whereWereRemoved) {
        }
    };
    private final HashMap<EmohawkCharacter, CharacterWidget> characterWidgets = new HashMap();
    private final HashMap<EmohawkCharacter, StartWaypointWidget> startWidgets = new HashMap();

    public BirdviewScene(EmoNewtFrame frame, StoryController model, ViewController vc) {
        this.frame = frame;
        this.model = model;
        this.controller = vc;
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        this.u2s = new Matrix3d();
        this.u2s.setIdentity();
        this.u2s.setScale(0.05);
        this.ic.add((Object)this.u2s);
        this.ic.add((Object)vc);
        this.backgroundLayer = new LayerWidget((Scene)this);
        this.startpointsLayer = new LayerWidget((Scene)this);
        this.waypointsLayer = new LayerWidget((Scene)this);
        this.movesLayer = new LayerWidget((Scene)this);
        this.selectedLayer = new LayerWidget((Scene)this);
        this.charactersLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.backgroundLayer);
        this.addChild((Widget)this.startpointsLayer);
        this.addChild((Widget)this.waypointsLayer);
        this.addChild((Widget)this.movesLayer);
        this.addChild((Widget)this.selectedLayer);
        this.addChild((Widget)this.charactersLayer);
        this.setKeyEventProcessingType(EventProcessingType.ALL_WIDGETS);
        this.getActions().addAction((WidgetAction)new DeleteFocusedCharacterAction(this.controller));
        this.getActions().addAction((WidgetAction)new DeleteWaypointAction(this.controller));
        this.getActions().addAction((WidgetAction)new MouseCenteredScaleAction(1.2, 0.01, 0.5));
        this.getActions().addAction((WidgetAction)new PanAction());
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this.popupMenuProvider));
        for (EmohawkCharacter character : model.getStoryCharacters()) {
            this.addCharacter(character);
        }
        this.controller.addSWControllerListener(this.selectionListener);
        this.controller.addStoryPlayerListener(this.storyPlayerListener);
        model.addStoryControllerListener(this);
        model.getStoryCharacters().addCollectionListener(this.charactersListener);
    }

    public void addBackground(BufferedImage image, Vector2d[] u, Vector2d[] b) {
        GMatrix a = new GMatrix(6, 6, new double[]{b[0].x, b[0].y, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, b[0].x, b[0].y, 1.0, b[1].x, b[1].y, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, b[1].x, b[1].y, 1.0, b[2].x, b[2].y, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, b[2].x, b[2].y, 1.0});
        GVector x = new GVector(6);
        GVector right = new GVector(new double[]{u[0].x, u[0].y, u[1].x, u[1].y, u[2].x, u[2].y});
        a.invert();
        x.mul(a, right);
        Matrix3d b2u = new Matrix3d(x.getElement(0), x.getElement(1), x.getElement(2), x.getElement(3), x.getElement(4), x.getElement(5), 0.0, 0.0, 1.0);
        BackgroundWidget bw = new BackgroundWidget(this, image, b2u);
        this.addDependency(bw);
        this.backgroundLayer.addChild((Widget)bw);
    }

    public void addCharacter(EmohawkCharacter character) {
        assert (!this.isObject(character)) : "Character " + character.getName() + " is already in the scene.";
        character.getMovements().addCollectionListener(this.moveListener);
        assert (this.startWidgets.get(character) == null) : "There is already mapping for character " + character;
        StartWaypointWidget startWidget = new StartWaypointWidget(this, character, this.controller);
        this.startWidgets.put(character, startWidget);
        WaypointWidget lastWidget = startWidget;
        for (ActionMovement move : character.getMovements()) {
            lastWidget = new MoveWaypointWidget(this, this.controller, lastWidget, character, move);
        }
        assert (this.characterWidgets.get(character) == null) : "There is already a mapping for character " + character;
        this.characterWidgets.put(character, new CharacterWidget(this, character, this.controller, 25, 0L));
        this.validate();
    }

    public void removeCharacter(EmohawkCharacter character) {
        Widget[] waypointWidgets;
        assert (this.characterWidgets.get(character) != null);
        this.characterWidgets.remove(character).destroy();
        assert (this.startWidgets.get(character) != null);
        this.startWidgets.remove(character).destroy();
        character.getMovements().removeCollectionListener(this.moveListener);
        for (Widget widget : waypointWidgets = this.waypointsLayer.getChildren().toArray(new Widget[0])) {
            Lookup lkp = widget.getLookup();
            EmohawkCharacter widgetChar = (EmohawkCharacter)lkp.lookup(EmohawkCharacter.class);
            if (widgetChar != character) continue;
            ((IDestroyableWidget)widget).destroy();
        }
        this.validate();
    }

    public void setTransformation(Vector2d[] u, Vector2d[] s) {
        if (u.length < 3) {
            throw new IllegalArgumentException("u is too short: " + u.length);
        }
        if (s.length < 3) {
            throw new IllegalArgumentException("s is too short: " + s.length);
        }
        GMatrix a = new GMatrix(6, 6, new double[]{u[0].x, u[0].y, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, u[0].x, u[0].y, 1.0, u[1].x, u[1].y, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, u[1].x, u[1].y, 1.0, u[2].x, u[2].y, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, u[2].x, u[2].y, 1.0});
        GVector x = new GVector(6);
        GVector right = new GVector(new double[]{s[0].x, s[0].y, s[1].x, s[1].y, s[2].x, s[2].y});
        a.invert();
        x.mul(a, right);
        this.u2s.set(new Matrix3d(x.getElement(0), x.getElement(1), x.getElement(2), x.getElement(3), x.getElement(4), x.getElement(5), 0.0, 0.0, 1.0));
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void currentTimeChanged(long oldCurrentTime, long newCurrentTime) {
    }

    protected LayerWidget getWaypointsLayer() {
        return this.waypointsLayer;
    }

    protected LayerWidget getStartpointsLayer() {
        return this.startpointsLayer;
    }

    protected LayerWidget getConnectionsLayer() {
        return this.movesLayer;
    }

    protected LayerWidget getPlayerLayer() {
        return this.charactersLayer;
    }

    public void destroy() {
        this.model.removeStoryControllerListener(this);
        this.model.getStoryCharacters().removeCollectionListener(this.charactersListener);
        this.controller.removeSWControllerListener(this.selectionListener);
        this.controller.removeStoryPlayerListener(this.storyPlayerListener);
    }
}

