/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.widget;

import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.BirdviewScene;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class BackgroundWidget
extends ImageWidget
implements Widget.Dependency {
    private static final Matrix3d identity = new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    private Matrix3d b2u;

    BackgroundWidget(BirdviewScene scene, BufferedImage image, Matrix3d b2u) {
        super((Scene)scene, (Image)image);
        this.b2u = new Matrix3d(b2u);
    }

    private Matrix3d getU2SMatrix() {
        Matrix3d u2s = (Matrix3d)this.getScene().getLookup().lookup(Matrix3d.class);
        if (u2s == null) {
            u2s = identity;
        }
        return u2s;
    }

    private Rectangle computeBounds() {
        Vector3d tl = new Vector3d(0.0, 0.0, 1.0);
        Vector3d tr = new Vector3d((double)this.getImage().getWidth(null), 0.0, 1.0);
        Vector3d br = new Vector3d((double)this.getImage().getWidth(null), (double)this.getImage().getHeight(null), 1.0);
        Vector3d bl = new Vector3d(0.0, (double)this.getImage().getHeight(null), 1.0);
        this.b2u.transform((Tuple3d)tl);
        this.b2u.transform((Tuple3d)tr);
        this.b2u.transform((Tuple3d)br);
        this.b2u.transform((Tuple3d)bl);
        Matrix3d u2s = this.getU2SMatrix();
        Vector3d[] corners = new Vector3d[]{new Vector3d(), new Vector3d(), new Vector3d(), new Vector3d()};
        u2s.transform((Tuple3d)tl, (Tuple3d)corners[0]);
        u2s.transform((Tuple3d)tr, (Tuple3d)corners[1]);
        u2s.transform((Tuple3d)br, (Tuple3d)corners[2]);
        u2s.transform((Tuple3d)bl, (Tuple3d)corners[3]);
        double minx = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double miny = Double.MAX_VALUE;
        double maxy = Double.MIN_VALUE;
        for (int i = 0; i < 4; ++i) {
            if (corners[i].x < minx) {
                minx = corners[i].x;
            }
            if (corners[i].x > maxx) {
                maxx = corners[i].x;
            }
            if (corners[i].y < miny) {
                miny = corners[i].y;
            }
            if (!(corners[i].y > maxy)) continue;
            maxy = corners[i].y;
        }
        Rectangle r = new Rectangle((int)Math.ceil(minx), (int)Math.ceil(miny), (int)Math.floor(maxx - minx), (int)Math.floor(maxy - miny));
        return r;
    }

    protected Rectangle calculateClientArea() {
        Rectangle r = this.computeBounds();
        return r;
    }

    protected void paintWidget() {
        Graphics2D g = this.getGraphics();
        g.setColor(Color.RED);
        Matrix3d u2s = new Matrix3d(this.getU2SMatrix());
        Matrix3d b2s = new Matrix3d();
        b2s.mul(this.b2u, u2s);
        AffineTransform af = new AffineTransform(b2s.m00, b2s.m10, b2s.m01, b2s.m11, b2s.m02, b2s.m12);
        g.drawImage(this.getImage(), af, null);
    }

    public void revalidateDependency() {
        this.revalidate();
    }
}

