/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.action;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.Point;
import java.util.logging.Logger;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class SplitMoveAction
extends WidgetAction.Adapter {
    public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() != 1 || event.getClickCount() != 2) {
            return WidgetAction.State.REJECTED;
        }
        ActionMovement move = (ActionMovement)widget.getLookup().lookup(ActionMovement.class);
        if (move == null) {
            Logger.getLogger("Birdview").warning("ActionMovement not found in lookup.");
            return WidgetAction.State.REJECTED;
        }
        Logger.getLogger("Birdview").fine("ActionMovement has been found.");
        ConnectionWidget moveWidget = (ConnectionWidget)widget;
        Anchor sourceAnchor = moveWidget.getSourceAnchor();
        Anchor targetAnchor = moveWidget.getTargetAnchor();
        double source2point = this.getAnchorDistance(sourceAnchor, event.getPoint());
        double target2point = this.getAnchorDistance(targetAnchor, event.getPoint());
        double source2target = this.getAnchorDistance(sourceAnchor, targetAnchor);
        double factor = source2point / source2target;
        long interDuration = (long)((double)move.getDuration() * factor);
        Location sourceLocation = move.getStart();
        Location targetLocation = move.getEnd();
        Location interLocation = Location.interpolate((Location)sourceLocation, (Location)targetLocation, (double)factor);
        long newStart = move.getTime() + interDuration;
        long newDuration = move.getDuration() - interDuration;
        Logger.getLogger("Birdview").fine("ActionMovement shortened, now starts  from " + move.getTime() + " for " + interDuration + "(was " + move.getDuration() + ")");
        boolean ret = this.changeMovement(move, interLocation, interDuration);
        if (!ret) {
            Logger.getLogger("Birdview").severe("Unable to change ActionMovement.");
            return WidgetAction.State.REJECTED;
        }
        Logger.getLogger("Birdview").fine("New ActionMovement from " + newStart + " for " + newDuration);
        ret = this.addMovement(move.getOwner(), targetLocation, newStart, newDuration);
        if (!ret) {
            Logger.getLogger("Birdview").severe("Unable to add new ActionMovement.");
            return WidgetAction.State.REJECTED;
        }
        return WidgetAction.State.CONSUMED;
    }

    private boolean addMovement(EmohawkCharacter character, Location location, long start, long duration) {
        ActionMovement newMove = new ActionMovement(character, start, duration, location, "");
        ChangeStoryAction change = new ChangeStoryAction(ChangeType.ADD, character, newMove.getActionProperties(), newMove);
        return character.getModel().processChangeStoryAction(change);
    }

    private boolean changeMovement(ActionMovement move, Location newLoc, long duration) {
        StoryActionProperties oldProp = move.getActionProperties();
        StoryActionProperties newProp = new StoryActionProperties(move.getActionProperties());
        newProp.setEnd(newLoc);
        newProp.setDuration(duration);
        ChangeStoryAction csa = new ChangeStoryAction(ChangeType.CHANGE, move.getOwner(), oldProp, newProp, move);
        return move.getOwner().getModel().processChangeStoryAction(csa);
    }

    private double getAnchorDistance(Anchor anchor, Point point) {
        return anchor.getRelatedSceneLocation().distance(point);
    }

    private double getAnchorDistance(Anchor source, Anchor target) {
        Point sourcePoint = source.getRelatedSceneLocation();
        Point targetPoint = target.getRelatedSceneLocation();
        return sourcePoint.distance(targetPoint);
    }
}

