/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.action;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class PanAction
extends WidgetAction.LockedAdapter {
    private boolean locked = false;
    private Scene scene;
    private Point lastLocation;

    protected boolean isLocked() {
        return this.locked;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        if (event.getButton() == 1) {
            this.locked = true;
            this.scene = widget.getScene();
            this.lastLocation = this.scene.convertSceneToView(widget.convertLocalToScene(event.getPoint()));
            SwingUtilities.convertPointToScreen(this.lastLocation, this.scene.getView());
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (!this.isLocked()) {
            return WidgetAction.State.REJECTED;
        }
        JComponent view = this.scene.getView();
        Point viewLocation = this.scene.convertSceneToView(widget.convertLocalToScene(event.getPoint()));
        SwingUtilities.convertPointToScreen(viewLocation, this.scene.getView());
        Rectangle rectangle = view.getVisibleRect();
        rectangle.x += this.lastLocation.x - viewLocation.x;
        rectangle.y += this.lastLocation.y - viewLocation.y;
        view.scrollRectToVisible(rectangle);
        this.lastLocation = viewLocation;
        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (!this.isLocked()) {
            return WidgetAction.State.REJECTED;
        }
        this.scene = null;
        this.lastLocation = null;
        this.locked = false;
        return WidgetAction.State.CONSUMED;
    }
}

