/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.action;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.vecmath.Matrix3d;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class MouseCenteredScaleAction
extends WidgetAction.Adapter {
    protected static final Matrix3d identity = new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    protected double zoomFactor;
    protected double minZoom = Double.MIN_VALUE;
    protected double maxZoom = Double.MAX_VALUE;

    public MouseCenteredScaleAction(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public MouseCenteredScaleAction(double zoomFactor, double minZoom, double maxZoom) {
        this.zoomFactor = zoomFactor;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
    }

    public void setMinZoom(double minZoom) {
        this.minZoom = minZoom;
    }

    public void setMaxZoom(double maxZoom) {
        this.maxZoom = maxZoom;
    }

    private Matrix3d getU2SMatrix(Scene scene) {
        Matrix3d u2s = (Matrix3d)scene.getLookup().lookup(Matrix3d.class);
        if (u2s == null) {
            u2s = identity;
        }
        return u2s;
    }

    private double getZoom(Matrix3d matrix) {
        return 0.0;
    }

    public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent wme) {
        int zoomDirection = 0;
        if (wme.isControlDown() && wme.getButton() == 1) {
            zoomDirection = 1;
        } else if (wme.isShiftDown() && wme.getButton() == 1) {
            zoomDirection = -1;
        } else {
            return WidgetAction.State.CHAIN_ONLY;
        }
        Scene scene = widget.getScene();
        Matrix3d u2s = this.getU2SMatrix(scene);
        Matrix3d s2u = new Matrix3d(u2s);
        s2u.invert();
        double zoom = Math.pow(this.zoomFactor, zoomDirection);
        JComponent view = scene.getView();
        if (view != null) {
            Rectangle viewBounds = view.getVisibleRect();
            Point mouseLocation = scene.convertSceneToView(wme.getPoint());
            double newZoom = u2s.getScale() * zoom;
            if (newZoom > this.maxZoom) {
                newZoom = this.maxZoom;
            }
            if (newZoom < this.minZoom) {
                newZoom = this.minZoom;
            }
            zoom = newZoom / u2s.getScale();
            u2s.setScale(newZoom);
            scene.revalidate();
            scene.validate();
            Point mouseDisplacement = new Point((int)(zoom * (double)wme.getPoint().x), (int)(zoom * (double)wme.getPoint().y));
            Point newMouseInView = scene.convertSceneToView(mouseDisplacement);
            Rectangle r1 = new Rectangle(newMouseInView.x - (mouseLocation.x - viewBounds.x), newMouseInView.y - (mouseLocation.y - viewBounds.y), viewBounds.width, viewBounds.height);
            view.scrollRectToVisible(r1);
        } else {
            u2s.setScale(zoom);
            scene.revalidate();
        }
        return WidgetAction.State.CONSUMED;
    }

    public WidgetAction.State mouseWheelMoved(Widget widget, WidgetAction.WidgetMouseWheelEvent event) {
        Scene scene = widget.getScene();
        Matrix3d u2s = this.getU2SMatrix(scene);
        Matrix3d s2u = new Matrix3d(u2s);
        s2u.invert();
        double zoom = Math.pow(this.zoomFactor, -event.getWheelRotation());
        JComponent view = scene.getView();
        if (view != null) {
            Rectangle viewBounds = view.getVisibleRect();
            Point mouseLocation = scene.convertSceneToView(event.getPoint());
            double newZoom = u2s.getScale() * zoom;
            if (newZoom > this.maxZoom) {
                newZoom = this.maxZoom;
            }
            if (newZoom < this.minZoom) {
                newZoom = this.minZoom;
            }
            zoom = newZoom / u2s.getScale();
            u2s.setScale(newZoom);
            scene.revalidate();
            scene.validate();
            Point mouseDisplacement = new Point((int)(zoom * (double)event.getPoint().x), (int)(zoom * (double)event.getPoint().y));
            Point newMouseInView = scene.convertSceneToView(mouseDisplacement);
            Rectangle r1 = new Rectangle(newMouseInView.x - (mouseLocation.x - viewBounds.x), newMouseInView.y - (mouseLocation.y - viewBounds.y), viewBounds.width, viewBounds.height);
            view.scrollRectToVisible(r1);
        } else {
            u2s.setScale(zoom);
            scene.revalidate();
        }
        return WidgetAction.State.CONSUMED;
    }
}

