/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.action;

import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;

public class DeleteWaypointAction
extends WidgetAction.Adapter {
    private ViewController controller;

    public DeleteWaypointAction(ViewController controller) {
        this.controller = controller;
    }

    public WidgetAction.State keyTyped(Widget widget, WidgetAction.WidgetKeyEvent event) {
        if (event.getKeyChar() != '\u007f') {
            return WidgetAction.State.REJECTED;
        }
        if (StoryTools.DEBUG) {
            System.out.println("DeleteWaypointWidget 001");
        }
        ObjectScene scene = (ObjectScene)widget.getScene();
        Set<Object> selectedObjects = this.controller.getSelectedObjects();
        LinkedList<ActionMovement> actionsToDelete = new LinkedList<ActionMovement>();
        for (Object queriedObject : selectedObjects) {
            if (!(queriedObject instanceof ActionMovement)) continue;
            actionsToDelete.add((ActionMovement)queriedObject);
        }
        if (actionsToDelete.isEmpty()) {
            return WidgetAction.State.REJECTED;
        }
        int res = JOptionPane.showConfirmDialog(scene.getView(), MessageFormat.format(StorySettings.currentBundle.getString("REALLY DELETE?"), actionsToDelete.size()), StorySettings.currentBundle.getString("DELETE ACTION"), 0);
        if (res != 0) {
            return WidgetAction.State.CONSUMED;
        }
        for (ActionMovement am : actionsToDelete) {
            long duration;
            EmohawkCharacter character = am.getOwner();
            ActionMovement nextMovement = am.getNextMovement();
            long time = am.getTime();
            ChangeStoryAction change = new ChangeStoryAction(ChangeType.DELETE, character, am.getActionProperties(), am);
            boolean success = character.getModel().processChangeStoryAction(change);
            if (!success) {
                Logger.getLogger("Birdview").warning("Unable to delete action " + am);
            } else {
                Logger.getLogger("Birdview").fine("Action " + am + " deleted.");
            }
            if (nextMovement == null || (success = this.changeMovementTime(nextMovement, time, duration = nextMovement.getEndTime() - time))) continue;
            Logger.getLogger("Birdview").warning("Failed to change action " + nextMovement + " to start " + time + " duration " + duration);
        }
        return WidgetAction.State.CONSUMED;
    }

    private boolean changeMovementTime(ActionMovement move, long start, long duration) {
        StoryActionProperties oldProp = move.getActionProperties();
        StoryActionProperties newProp = new StoryActionProperties(move.getActionProperties());
        newProp.setTime(start);
        newProp.setDuration(duration);
        ChangeStoryAction csa = new ChangeStoryAction(ChangeType.CHANGE, move.getOwner(), oldProp, newProp, move);
        return move.getOwner().getModel().processChangeStoryAction(csa);
    }
}

