/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.birdview.action;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.utils.collections.ObservableList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.logging.Logger;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class AttachWaypointAction
extends WidgetAction.LockedAdapter {
    private static final Matrix3d identity = new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    private static final AnchorShape circleShape = new AnchorShape(){
        private final int r = 10;
        private final Color color = Color.ORANGE;

        public boolean isLineOriented() {
            return false;
        }

        public int getRadius() {
            return 10;
        }

        public double getCutDistance() {
            return 0.0;
        }

        public void paint(Graphics2D g, boolean source) {
            g.setColor(this.color);
            g.fillOval(-10, -10, 20, 20);
        }
    };
    private static final Stroke stroke = new BasicStroke(3.0f, 1, 1);
    private final LayerWidget layer;
    private ConnectionWidget connection;
    private Widget startingWidget;
    private Point sourceLocation;
    private Point targetLocation;
    private double speed = 0.2;

    public AttachWaypointAction(LayerWidget layer) {
        this.layer = layer;
    }

    protected boolean isLocked() {
        return this.startingWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        if (!this.isLastWaypoint(widget)) {
            return WidgetAction.State.REJECTED;
        }
        if (event.getButton() == 3 && event.getClickCount() == 1) {
            this.startingWidget = widget;
            this.sourceLocation = widget.getLocation();
            this.targetLocation = null;
            this.connection = new ConnectionWidget(widget.getScene());
            this.connection.setStroke(stroke);
            this.connection.setTargetAnchorShape(circleShape);
            this.connection.setSourceAnchor(AnchorFactory.createCenterAnchor((Widget)widget));
            this.layer.addChild((Widget)this.connection);
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (!this.isLocked()) {
            return WidgetAction.State.REJECTED;
        }
        this.targetLocation = widget.convertLocalToScene(event.getPoint());
        this.connection.setTargetAnchor(AnchorFactory.createFixedAnchor((Point)this.targetLocation));
        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (!this.isLocked()) {
            return WidgetAction.State.REJECTED;
        }
        if (this.targetLocation != null) {
            EmohawkCharacter character = (EmohawkCharacter)widget.getLookup().lookup(EmohawkCharacter.class);
            assert (character != null) : "No character in widget lookup.";
            Matrix3d s2u = this.getS2UMatrix(widget.getScene());
            Vector3d unrealLoc = new Vector3d((double)this.targetLocation.x, (double)this.targetLocation.y, 1.0);
            s2u.transform((Tuple3d)unrealLoc);
            int movesSize = character.getMovements().size();
            unrealLoc.z = movesSize == 0 ? character.getCharacterProperties().getStartLocation().z : ((ActionMovement)character.getMovements().get((int)(movesSize - 1))).getEnd().z;
            Location location = new Location((Tuple3d)unrealLoc);
            long time = this.getStartTime(character);
            long duration = this.getDuration(s2u, this.sourceLocation, this.targetLocation);
            boolean ret = this.addMovement(character, location, time, duration);
            if (!ret) {
                Logger.getLogger("Birdview").warning("Unable to attach move: " + location + ", time " + time + ", duration" + duration);
            } else {
                Logger.getLogger("Birdview").info("Attached move: " + location + ", time " + time + ", duration" + duration);
            }
        }
        this.layer.removeChild((Widget)this.connection);
        this.startingWidget = null;
        this.sourceLocation = null;
        this.targetLocation = null;
        this.connection = null;
        return WidgetAction.State.CONSUMED;
    }

    private boolean isLastWaypoint(Widget widget) {
        EmohawkCharacter character = (EmohawkCharacter)widget.getLookup().lookup(EmohawkCharacter.class);
        ActionMovement move = (ActionMovement)widget.getLookup().lookup(ActionMovement.class);
        assert (character != null) : "No emohawk character in lookup";
        ObservableList<ActionMovement> moves = character.getMovements();
        return moves.isEmpty() || moves.indexOf(move) + 1 == moves.size();
    }

    private long getDuration(Matrix3d s2u, Point sourceLocation, Point targetLocation) {
        Vector3d sourceUnrealLoc = new Vector3d((double)sourceLocation.x, (double)sourceLocation.y, 1.0);
        s2u.transform((Tuple3d)sourceUnrealLoc);
        Vector3d targetUnrealLoc = new Vector3d((double)targetLocation.x, (double)targetLocation.y, 1.0);
        s2u.transform((Tuple3d)targetUnrealLoc);
        Vector3d source2target = new Vector3d();
        source2target.sub((Tuple3d)targetUnrealLoc, (Tuple3d)sourceUnrealLoc);
        double unrealDistance = source2target.length();
        return (long)Math.ceil(unrealDistance / this.speed);
    }

    private long getStartTime(EmohawkCharacter character) {
        ObservableList<ActionMovement> moves = character.getMovements();
        int size = moves.size();
        if (size == 0) {
            return 0L;
        }
        return ((ActionMovement)moves.get(size - 1)).getEndTime();
    }

    protected Matrix3d getS2UMatrix(Scene scene) {
        Matrix3d u2s = (Matrix3d)scene.getLookup().lookup(Matrix3d.class);
        if (u2s == null) {
            u2s = identity;
        }
        Matrix3d s2u = new Matrix3d(u2s);
        s2u.invert();
        return s2u;
    }

    private boolean addMovement(EmohawkCharacter character, Location location, long start, long duration) {
        ActionMovement newMove = new ActionMovement(character, start, duration, location, "");
        ChangeStoryAction change = new ChangeStoryAction(ChangeType.ADD, character, newMove.getActionProperties(), newMove);
        return character.getModel().processChangeStoryAction(change);
    }
}

