/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui;

import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.SimulationStoryPlayer;
import cz.cuni.amis.pogamut.emonewt.gui.UnrealStoryPlayer;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtAnimationProperties;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtCharacterProperties;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtMovementProperties;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtRotationProperties;
import cz.cuni.amis.pogamut.emonewt.gui.tools.UCCUE2Wrapper;
import cz.cuni.amis.pogamut.emonewt.gui.tools.UE2Wrapper;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryPlayerListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IUndoRedoListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeContainer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.utils.collections.ElementListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewController {
    private final StoryController model;
    private final EmoNewtFrame view;
    private Object focusedObject;
    private HashSet<Object> selectedObjects = new HashSet();
    private Set<Object> selectedObjectsUm = Collections.unmodifiableSet(this.selectedObjects);
    private HashSet<ControllerSelectionListener> selectionListeners = new HashSet();
    private HashSet<IStoryPlayerListener> playerListeners = new HashSet();
    private SimulationStoryPlayer dummyStoryPlayer;
    private UnrealStoryPlayer unrealStoryPlayer;
    private final ElementListener<ChangeContainer> unfocusOnDeleteListener = new ElementListener<ChangeContainer>(){

        public void elementChanged(ChangeContainer elem, boolean added) {
            if (added) {
                ViewController.this.unfocusOnDelete(elem, false);
            }
        }
    };
    private final IUndoRedoListener unfocusOnUndoRedoListener = new IUndoRedoListener(){

        public void undoRedoPerformed(ChangeContainer changePosition, boolean undo) {
            ViewController.this.unfocusOnDelete(changePosition, undo);
        }
    };
    private ControllerSelectionListener selectionListener = new ControllerSelectionListener(){

        @Override
        public void focusChanged(Object prevFocusedObject, Object focusedObject) {
            if (focusedObject instanceof EmohawkCharacter) {
                ViewController.this.view.getPropertiesPane().setPropertiesPane(new NewtCharacterProperties(ViewController.this, (EmohawkCharacter)focusedObject), null);
            } else if (focusedObject instanceof StoryAction) {
                JPanel actionPane;
                StoryAction action = (StoryAction)focusedObject;
                if (action instanceof ActionAnimation) {
                    actionPane = new NewtAnimationProperties(ViewController.this, (ActionAnimation)action);
                } else if (action instanceof ActionMovement) {
                    actionPane = new NewtMovementProperties((ActionMovement)action);
                } else if (action instanceof ActionRotation) {
                    actionPane = new NewtRotationProperties(ViewController.this.view, (ActionRotation)action);
                } else {
                    throw new IllegalArgumentException("Illegal action class " + action);
                }
                ViewController.this.view.getPropertiesPane().setPropertiesPane(new NewtCharacterProperties(ViewController.this, action.getOwner()), actionPane);
            }
        }

        @Override
        public void selectionChanged(Set<?> prevSelectedObjects, Set<?> selectedObject) {
        }
    };
    private UE2Wrapper ue2Wrapper = new UE2Wrapper();
    private UCCUE2Wrapper uccWrapper;

    private void unfocusOnDelete(ChangeContainer elem, boolean undo) {
        boolean removeAction;
        boolean bl = undo ? elem.getChangeType() == ChangeType.ADD : (removeAction = elem.getChangeType() == ChangeType.DELETE);
        if (removeAction) {
            ChangeStoryAction storyChange;
            if (elem instanceof ChangeCharacter) {
                ChangeCharacter charChange = (ChangeCharacter)elem;
                if (charChange.getCharacter().equals(this.focusedObject)) {
                    this.setFocusedObject(null);
                }
            } else if (elem instanceof ChangeStoryAction && (storyChange = (ChangeStoryAction)elem).getCurrentAction().equals(this.focusedObject)) {
                this.setFocusedObject(null);
            }
        }
    }

    public ViewController(StoryController model, EmoNewtFrame frame) {
        this.view = frame;
        this.model = model;
        this.dummyStoryPlayer = new SimulationStoryPlayer(model, this, 100);
        this.unrealStoryPlayer = new UnrealStoryPlayer(model, this, 100);
        model.getChangeActions().addCollectionListener(this.unfocusOnDeleteListener);
        model.addUndoRedoListener(this.unfocusOnUndoRedoListener);
        this.addSWControllerListener(this.selectionListener);
    }

    public UnrealStoryPlayer getUnrealStoryPlayer() {
        return this.unrealStoryPlayer;
    }

    public final void modifySelection(Object suggestedObject, boolean add) {
        if (add) {
            if (this.getSelectedObjects().contains(suggestedObject)) {
                return;
            }
            HashSet<Object> objects = new HashSet<Object>(this.getSelectedObjects());
            objects.add(suggestedObject);
            this.setSelectedObjects(objects);
        } else {
            if (!this.getSelectedObjects().contains(suggestedObject)) {
                return;
            }
            HashSet<Object> objects = new HashSet<Object>(this.getSelectedObjects());
            objects.remove(suggestedObject);
            this.setSelectedObjects(objects);
        }
    }

    public final void setSelectedObjects(Set<?> suggestedObjects) {
        Set<Object> prevSelectedObjectsUm = Collections.unmodifiableSet(new HashSet<Object>(this.selectedObjects));
        Iterator<Object> it = this.selectedObjects.iterator();
        while (it.hasNext()) {
            if (suggestedObjects.contains(it.next())) continue;
            it.remove();
        }
        for (Object object : suggestedObjects) {
            if (this.selectedObjects.contains(object)) continue;
            this.selectedObjects.add(object);
        }
        for (ControllerSelectionListener listener : this.getListeners()) {
            listener.selectionChanged(prevSelectedObjectsUm, this.selectedObjectsUm);
        }
    }

    public final Set<Object> getSelectedObjects() {
        return this.selectedObjectsUm;
    }

    public final Object getFocusedObject() {
        return this.focusedObject;
    }

    public void setFocusedObject(Object focusedObject) {
        boolean equal;
        boolean bl = focusedObject != null ? focusedObject.equals(this.focusedObject) : (equal = this.focusedObject == null);
        if (equal) {
            return;
        }
        Object oldFocusedObject = this.focusedObject;
        this.focusedObject = focusedObject;
        for (ControllerSelectionListener listener : this.getListeners()) {
            listener.focusChanged(oldFocusedObject, focusedObject);
        }
        if (focusedObject != null) {
            this.setSelectedObjects(Collections.singleton(focusedObject));
        } else {
            this.setSelectedObjects(Collections.EMPTY_SET);
        }
    }

    public UE2Wrapper getUnrealEngine() {
        return this.ue2Wrapper;
    }

    public UCCUE2Wrapper startUnrealServer() {
        if (this.uccWrapper == null) {
            this.uccWrapper = this.createUnrealServer();
        }
        return this.uccWrapper;
    }

    public void stopUnrealServer() {
        if (this.uccWrapper != null) {
            this.uccWrapper.stop();
        }
    }

    public boolean isUnrealServerRunning() {
        return this.uccWrapper != null;
    }

    private final UCCUE2Wrapper createUnrealServer() {
        UCCUE2Wrapper.UCCWrapperConf conf = new UCCUE2Wrapper.UCCWrapperConf();
        conf.setGameBotsPack("GBEmohawk");
        conf.setGameType("StoryEmohawkScenario");
        conf.setMapName("EmohawkVille_Runtime_04");
        conf.setLogger(Logger.getLogger("UCC"));
        conf.setStartOnUnusedPort(false);
        return new UCCUE2Wrapper(conf);
    }

    public boolean startSimulation(long startTime, long endTime) {
        if (this.dummyStoryPlayer.isRunning() || this.unrealStoryPlayer.isRunning()) {
            return false;
        }
        this.dummyStoryPlayer.setEndTime(endTime);
        this.dummyStoryPlayer.setStartTime(startTime);
        return this.dummyStoryPlayer.start();
    }

    public boolean isSimulationRunning() {
        return this.dummyStoryPlayer.isRunning();
    }

    public boolean stopSimulation() {
        return this.dummyStoryPlayer.stop();
    }

    public boolean startUnrealStory(long startTime, long endTime) {
        if (this.dummyStoryPlayer.isRunning() || this.unrealStoryPlayer.isRunning()) {
            return false;
        }
        this.unrealStoryPlayer.setEndTime(endTime);
        this.unrealStoryPlayer.setStartTime(startTime);
        return this.unrealStoryPlayer.start();
    }

    public boolean isUnrealStoryRunning() {
        return this.unrealStoryPlayer.isRunning();
    }

    public boolean stopUnrealStory() {
        return this.unrealStoryPlayer.stop();
    }

    public boolean previewAnimation(ActionAnimation animPreview, boolean bLoop) {
        return this.unrealStoryPlayer.previewAnimation(animPreview, bLoop);
    }

    public boolean previewCharacter(EmohawkCharacter character, String clothes, String skin) {
        return this.unrealStoryPlayer.previewCharacter(character, clothes, skin);
    }

    public final void addSWControllerListener(ControllerSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public final void removeSWControllerListener(ControllerSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected IStoryPlayerListener[] getPlayerListeners() {
        return this.playerListeners.toArray(new IStoryPlayerListener[this.playerListeners.size()]);
    }

    public void addStoryPlayerListener(IStoryPlayerListener listener) {
        this.playerListeners.add(listener);
    }

    public void removeStoryPlayerListener(IStoryPlayerListener listener) {
        this.playerListeners.remove(listener);
    }

    private ControllerSelectionListener[] getListeners() {
        return this.selectionListeners.toArray(new ControllerSelectionListener[this.selectionListeners.size()]);
    }

    public boolean deleteCharacter(EmohawkCharacter character) {
        ChangeCharacter deleteCharacter = new ChangeCharacter(ChangeType.DELETE, character.id, character);
        return this.model.processChangeCharacter(deleteCharacter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ControllerSelectionListener {
        public void focusChanged(Object var1, Object var2);

        public void selectionChanged(Set<?> var1, Set<?> var2);
    }
}

