/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.AbstractStoryPlayer;
import cz.cuni.amis.pogamut.emonewt.gui.AvatarState;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryPlayerListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryPlayer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ECharacterType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkLivingCharacter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UnrealStoryPlayer
extends AbstractStoryPlayer {
    private final StoryPlayer unrealPlayer;
    private final HashMap<EmohawkCharacter, AvatarState> avatarStates = new HashMap();
    private final Map<EmohawkCharacter, AvatarState> avatarStatesUm = Collections.unmodifiableMap(this.avatarStates);

    UnrealStoryPlayer(StoryController model, ViewController controller, int interval) {
        super(model, controller, interval);
        this.unrealPlayer = new StoryPlayer(model);
    }

    protected boolean previewAnimation(ActionAnimation animationPreview, boolean bLoop) {
        this.unrealPlayer.animationPreview(animationPreview, bLoop);
        return true;
    }

    public StoryPlayer getUnrealPlayer() {
        return this.unrealPlayer;
    }

    protected boolean previewCharacter(EmohawkCharacter character, String clothes, String skin) {
        this.unrealPlayer.characterPreview(character, clothes, skin);
        return true;
    }

    protected boolean preStartUp() {
        this.unrealPlayer.startPlaying(this.start);
        return true;
    }

    protected boolean postStartUp() {
        return true;
    }

    public void tick(long storyTime) {
        IStoryPlayerListener[] playerListeners = this.controller.getPlayerListeners();
        this.updateAvatarStates();
        this.model.setCurrentTime(storyTime);
        for (IStoryPlayerListener listener : playerListeners) {
            listener.avatarsChanged(storyTime, this.avatarStatesUm);
        }
    }

    private void updateAvatarStates() {
        for (EmohawkCharacter character : this.model.getStoryCharacters()) {
            if (character.getCharacterProperties().getCharacterClass().equals((Object)ECharacterType.CAMERA)) continue;
            EmohawkLivingCharacter avatar = character.getAvatar();
            if (avatar == null) {
                this.avatarStates.remove(character);
                continue;
            }
            AvatarState avatarState = this.avatarStates.get(character);
            if (avatarState == null) {
                avatarState = new AvatarState();
            }
            avatarState.animationID = avatar.getLastAnimationID();
            avatarState.location = new Location(avatar.getBot().getLocation());
            avatarState.rotation = new Rotation(avatar.getBot().getRotation());
            this.avatarStates.put(character, avatarState);
        }
    }

    protected boolean preShutDown() {
        return true;
    }

    protected boolean postShutDown() {
        if (this.unrealPlayer.isStoryPlaying()) {
            this.unrealPlayer.stopPlaying();
        }
        return true;
    }

    public Rotation getRotationSnapFromUnreal() {
        if (this.unrealPlayer.getControlServer() != null) {
            return this.unrealPlayer.getControlServer().getRotationSnapFromUnreal();
        }
        return new Rotation();
    }

    public void startControlServer() {
        this.unrealPlayer.startControlServer();
    }
}

