/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui;

import cz.cuni.amis.pogamut.emonewt.gui.AvatarState;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.birdview.widget.BirdviewScene;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtCharsPane;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtPropertiesPane;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtScaleSlider;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtSlider;
import cz.cuni.amis.pogamut.emonewt.gui.dialogs.NewtAboutDialog;
import cz.cuni.amis.pogamut.emonewt.gui.dialogs.NewtHelp;
import cz.cuni.amis.pogamut.emonewt.gui.dialogs.NewtNewCharDialog;
import cz.cuni.amis.pogamut.emonewt.gui.dialogs.NewtRecordingSettingsDialog;
import cz.cuni.amis.pogamut.emonewt.gui.dialogs.NewtSettingsDialog;
import cz.cuni.amis.pogamut.emonewt.gui.tools.ExtensionFileFilter;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.gui.tools.UE2Wrapper;
import cz.cuni.amis.pogamut.emonewt.storycontrol.ICharacterNumberChangeListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IScaleChangeListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryLenghtChangeListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryPlayerListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.vecmath.Vector2d;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmoNewtFrame
extends JFrame
implements IStoryPlayerListener,
IScaleChangeListener,
IStoryLenghtChangeListener,
ICharacterNumberChangeListener {
    private NewtCharsPane newtCharsPane;
    private NewtPropertiesPane propertiesPane;
    private StoryController model;
    private String currentSavingFile = null;
    private File currentSaveLoadDir = null;
    private NewtSlider timeSlider = null;
    private NewtScaleSlider scaleSlider = null;
    private JPanel middlePane;
    private JPanel innerPane;
    private JScrollPane timeInfoScrollPane;
    private ViewController controller;
    private NewtHelp helpPane;
    private boolean isVideoBeingCaptured = false;
    private int userInfoLogMessagesCount = 0;
    private JButton btnAddCharacter;
    private JButton btnPlay;
    private JButton btnPlayFromStart;
    private JButton btnRecStart;
    private JButton btnRecStop;
    private JButton btnSimulate;
    private JButton btnSpectate;
    private JButton btnStop;
    private JButton btnStopSimulation;
    private JCheckBox chbAutomaticRecording;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JSplitPane jSplitPane2;
    private JLabel lblIsRecording;
    private JMenuBar mMainMenu;
    private JMenuItem mfExit;
    private JMenuItem mfLoad;
    private JMenuItem mfNewStory;
    private JMenuItem mfSave;
    private JMenuItem mfSaveAs;
    private JMenu mmAbout;
    private JMenu mmEdit;
    private JMenu mmFile;
    private JMenu mmHelp;
    private JMenu mmPlaying;
    private JMenu mmRedo;
    private JMenu mmSettings;
    private JMenu mmUndo;
    private JMenuItem mpPause;
    private JMenuItem mpPlay;
    private JMenuItem mpPlayFromStart;
    private JMenuItem mpStartSim;
    private JMenuItem mpStop;
    private JMenuItem mpStopSim;
    private JMenuItem msRecSettingsItem;
    private JMenuItem msSettingsItem;
    private JScrollPane newtBirdviewPane;
    private JPanel paneProperties;
    private JPanel pnlRightPane;
    private JPanel timeInfoPanel;
    private JTextPane txtUserInfoLog;
    private JMenuItem undoItem;

    public void setCurrentSavingFile(String currentSavingFile) {
        this.currentSavingFile = currentSavingFile;
    }

    public ViewController getController() {
        return this.controller;
    }

    public NewtPropertiesPane getPropertiesPane() {
        return this.propertiesPane;
    }

    public EmoNewtFrame(StoryController model) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InstantiationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.model = model;
        this.controller = new ViewController(model, this);
        this.initComponents();
        this.propertiesPane = (NewtPropertiesPane)this.paneProperties;
        this.newtCharsPane = new NewtCharsPane(this, model, this.controller);
        this.middlePane = new JPanel(null);
        int innerHeight = 400;
        int innerWidth = 400;
        innerWidth = this.fillInWidthOfTheWindow(innerWidth);
        innerHeight = this.fillInHeightOfTheWindow(innerHeight);
        this.middlePane.setPreferredSize(new Dimension(innerWidth, innerHeight));
        this.innerPane = new JPanel();
        this.innerPane.setLayout(new BorderLayout());
        this.innerPane.setSize(innerWidth, innerHeight);
        this.timeSlider = new NewtSlider(model, this.controller);
        this.innerPane.add((Component)this.timeSlider, "First");
        this.innerPane.add((Component)this.newtCharsPane, "Center");
        this.middlePane.add(this.innerPane);
        this.timeInfoScrollPane = new JScrollPane();
        this.timeInfoScrollPane.setHorizontalScrollBarPolicy(30);
        this.timeInfoScrollPane.setVerticalScrollBarPolicy(20);
        this.timeInfoScrollPane.setViewportView(this.middlePane);
        this.timeInfoPanel.add((Component)this.timeInfoScrollPane, "Center");
        this.scaleSlider = new NewtScaleSlider(model, this.controller, -100, 100, 0);
        this.timeInfoPanel.add((Component)this.scaleSlider, "East");
        final BirdviewScene scene = new BirdviewScene(this, model, this.controller);
        try {
            scene.addBackground(ImageIO.read(new File("images/birdseye_preview.jpg")), new Vector2d[]{new Vector2d(5500.0, -1334.0), new Vector2d(6211.0, 8136.0), new Vector2d(-8729.0, 522.0)}, new Vector2d[]{new Vector2d(360.0, 779.0), new Vector2d(41.0, 798.0), new Vector2d(294.0, 303.0)});
        }
        catch (IOException ex) {
            Logger.getLogger(EmoNewtFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.newtBirdviewPane.setViewportView(scene.createView());
        scene.getView().addMouseListener(scene.myMouseAdapter);
        scene.getView().addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                scene.getView().requestFocusInWindow();
            }

            public void mouseMoved(MouseEvent e) {
                scene.getView().requestFocusInWindow();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EmoNewtFrame.this.handleWindowClosing();
            }
        });
        this.controller.addStoryPlayerListener(this);
        model.addScaleListener(this);
        model.addStoryLengthChangedListener(this);
        model.addCharacterNumberChangeListener(this);
        this.btnPlay.setIcon(new ImageIcon("images/play.jpg"));
        this.btnStop.setIcon(new ImageIcon("images/stop.jpg"));
        this.btnPlayFromStart.setIcon(new ImageIcon("images/replay.jpg"));
        this.btnRecStart.setIcon(new ImageIcon("images/recScreen.jpg"));
        this.btnRecStop.setIcon(new ImageIcon("images/recScreenStop.jpg"));
        this.btnSimulate.setIcon(new ImageIcon("images/simPlay.jpg"));
        this.btnStopSimulation.setIcon(new ImageIcon("images/simStop.jpg"));
        this.mpPlay.setEnabled(true);
        this.mpPlayFromStart.setEnabled(true);
        this.mpStop.setEnabled(false);
        this.mpPause.setEnabled(false);
        this.mpStartSim.setEnabled(true);
        this.mpStopSim.setEnabled(false);
        this.startUnrealServer();
        this.controller.getUnrealStoryPlayer().startControlServer();
    }

    private void startUnrealServer() {
        File file;
        boolean bAskForPath = false;
        String ue2path = "";
        if (StorySettings.ue2path != null) {
            ue2path = new String(StorySettings.ue2path);
        }
        if (!ue2path.isEmpty()) {
            file = new File(ue2path + "/System/UE2Runtime.exe");
            if (!file.exists()) {
                bAskForPath = true;
            }
        } else {
            bAskForPath = true;
        }
        if (bAskForPath) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("SELECT_UE2_DIRECTORY_AT_START"));
            String runtimePath = "";
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(2);
            if (this.currentSaveLoadDir == null) {
                this.currentSaveLoadDir = new File(".");
            }
            chooser.setCurrentDirectory(this.currentSaveLoadDir);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    StorySettings.ue2path = runtimePath = chooser.getSelectedFile().getCanonicalPath();
                    StoryTools.saveSettings(".\\config\\settings.xml", this.model.getSettings().getStorySettingsSave());
                    if (StoryTools.DEBUG) {
                        System.out.println(runtimePath);
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (StorySettings.ue2path != null && !(file = new File(StorySettings.ue2path + "/System/UE2Runtime.exe")).exists()) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("SELECT_UE2_DIRECTORY_WRONG_PATH"));
            this.setVisible(false);
            this.dispose();
        }
        this.controller.startUnrealServer();
    }

    public void handleWindowClosing() {
        if (this.model.getSettings().isbAskSaveStoryOnClose()) {
            int result = JOptionPane.showConfirmDialog(this, StorySettings.currentBundle.getString("DO YOU WANT TO SAVE THE STORY BEFORE CLOSING?"));
            if (result == 0) {
                this.save();
            } else if (result == 2) {
                return;
            }
        }
        if (this.controller.isSimulationRunning()) {
            this.controller.stopSimulation();
        }
        if (this.controller.isUnrealStoryRunning()) {
            this.controller.stopUnrealStory();
        }
        this.model.resetModel();
        if (this.controller.getUnrealStoryPlayer().getUnrealPlayer().getControlServer() != null) {
            this.controller.getUnrealStoryPlayer().getUnrealPlayer().getControlServer().stop();
        }
        if (this.isVideoBeingCaptured) {
            this.recStopRecording();
        }
        EmoNewtFrame.killRunningProcess("UE2Runtime.exe", false);
        if (this.controller.isUnrealServerRunning()) {
            this.controller.stopUnrealServer();
        }
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    public StoryController getModel() {
        return this.model;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.pnlRightPane = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.paneProperties = new NewtPropertiesPane(this, this.controller);
        this.jScrollPane1 = new JScrollPane();
        this.txtUserInfoLog = new JTextPane();
        this.jPanel4 = new JPanel();
        this.lblIsRecording = new JLabel();
        this.btnStopSimulation = new JButton();
        this.btnStop = new JButton();
        this.btnPlay = new JButton();
        this.btnPlayFromStart = new JButton();
        this.chbAutomaticRecording = new JCheckBox();
        this.btnSimulate = new JButton();
        this.btnRecStart = new JButton();
        this.btnRecStop = new JButton();
        this.btnAddCharacter = new JButton();
        this.btnSpectate = new JButton();
        this.jSplitPane2 = new JSplitPane();
        this.newtBirdviewPane = new JScrollPane();
        this.timeInfoPanel = new JPanel();
        this.mMainMenu = new JMenuBar();
        this.mmFile = new JMenu();
        this.mfNewStory = new JMenuItem();
        this.mfLoad = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.mfSave = new JMenuItem();
        this.mfSaveAs = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.mfExit = new JMenuItem();
        this.mmEdit = new JMenu();
        this.undoItem = new JMenuItem();
        JMenuItem redoItem = new JMenuItem();
        this.mmPlaying = new JMenu();
        this.mpPlayFromStart = new JMenuItem();
        this.mpPlay = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.mpPause = new JMenuItem();
        this.mpStop = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.mpStartSim = new JMenuItem();
        this.mpStopSim = new JMenuItem();
        this.mmSettings = new JMenu();
        this.msSettingsItem = new JMenuItem();
        this.msRecSettingsItem = new JMenuItem();
        this.mmHelp = new JMenu();
        this.mmAbout = new JMenu();
        this.mmUndo = new JMenu();
        this.mmRedo = new JMenu();
        this.jPanel1.setName("jPanel1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.jPanel2.setName("jPanel2");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(0);
        this.setTitle(StorySettings.currentBundle.getString("EMOHAWKSTORYWORLD"));
        this.setCursor(new Cursor(0));
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setPreferredSize(new Dimension(800, 600));
        this.pnlRightPane.setBorder(BorderFactory.createEtchedBorder());
        this.pnlRightPane.setMaximumSize(new Dimension(400, 650));
        this.pnlRightPane.setMinimumSize(new Dimension(400, 650));
        this.pnlRightPane.setName("pnlRightPane");
        this.pnlRightPane.setPreferredSize(new Dimension(400, 600));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setName("jScrollPane2");
        this.paneProperties.setBorder(BorderFactory.createEtchedBorder());
        this.paneProperties.setMaximumSize(new Dimension(20000, 20000));
        this.paneProperties.setMinimumSize(new Dimension(0, 450));
        this.paneProperties.setName("paneProperties");
        this.paneProperties.setLayout(new BoxLayout(this.paneProperties, 1));
        this.jScrollPane2.setViewportView(this.paneProperties);
        this.jScrollPane1.setMaximumSize(new Dimension(50, 50));
        this.jScrollPane1.setName("jScrollPane1");
        this.txtUserInfoLog.setEditable(false);
        this.txtUserInfoLog.setText(StorySettings.currentBundle.getString("USER_LOG_DEFAULT_TEXT"));
        this.txtUserInfoLog.setMaximumSize(new Dimension(300, 100));
        this.txtUserInfoLog.setName("txtUserInfoLog");
        this.jScrollPane1.setViewportView(this.txtUserInfoLog);
        this.jPanel4.setName("jPanel4");
        this.jPanel4.setPreferredSize(new Dimension(277, 408));
        this.jPanel4.setLayout((LayoutManager)new AbsoluteLayout());
        this.lblIsRecording.setText(StorySettings.currentBundle.getString("REC_IS_RECORDING_OFF"));
        this.lblIsRecording.setToolTipText(StorySettings.currentBundle.getString("REC_IS_RECORDING_TOOLTIP"));
        this.lblIsRecording.setName("lblIsRecording");
        this.jPanel4.add((Component)this.lblIsRecording, new AbsoluteConstraints(150, 100, 98, 20));
        this.btnStopSimulation.setToolTipText(StorySettings.currentBundle.getString("STOPSIMULATION_H"));
        this.btnStopSimulation.setName("btnStopSimulation");
        this.btnStopSimulation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.btnStopSimulationActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.btnStopSimulation, new AbsoluteConstraints(70, 50, 50, 40));
        this.btnStop.setText("");
        this.btnStop.setToolTipText(StorySettings.currentBundle.getString("STOPHELP"));
        this.btnStop.setName("btnStop");
        this.btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.btnStopActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.btnStop, new AbsoluteConstraints(130, 0, 50, 40));
        this.btnPlay.setText("");
        this.btnPlay.setToolTipText(StorySettings.currentBundle.getString("PLAYHELP"));
        this.btnPlay.setName("btnPlay");
        this.btnPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.btnPlayActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.btnPlay, new AbsoluteConstraints(70, 0, 50, 40));
        this.btnPlayFromStart.setText("");
        this.btnPlayFromStart.setToolTipText(StorySettings.currentBundle.getString("PLAYFROMSTART_H"));
        this.btnPlayFromStart.setName("btnPlayFromStart");
        this.btnPlayFromStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.btnPlayFromStartActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.btnPlayFromStart, new AbsoluteConstraints(10, 0, 50, 40));
        this.chbAutomaticRecording.setText(StorySettings.currentBundle.getString("REC_AUTOMATIC_RECORDING"));
        this.chbAutomaticRecording.setToolTipText(StorySettings.currentBundle.getString("REC_AUTOMATIC_RECORDING_TOOLTIP"));
        this.chbAutomaticRecording.setName("chbAutomaticRecording");
        this.jPanel4.add((Component)this.chbAutomaticRecording, new AbsoluteConstraints(130, 120, -1, 20));
        this.btnSimulate.setToolTipText(StorySettings.currentBundle.getString("SIMULATION_H"));
        this.btnSimulate.setName("btnSimulate");
        this.btnSimulate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.btnSimulateActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.btnSimulate, new AbsoluteConstraints(10, 50, 50, 40));
        this.btnRecStart.setText("");
        this.btnRecStart.setToolTipText(StorySettings.currentBundle.getString("REC_RECORD_BUTTON_HELP"));
        this.btnRecStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.btnRecStartActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.btnRecStart, new AbsoluteConstraints(130, 50, 50, 40));
        this.btnRecStop.setText("");
        this.btnRecStop.setToolTipText(StorySettings.currentBundle.getString("STOPHELP"));
        this.btnRecStop.setName("btnRecStop");
        this.btnRecStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.btnRecStopActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.btnRecStop, new AbsoluteConstraints(190, 50, 50, 40));
        this.btnAddCharacter.setText(StorySettings.currentBundle.getString("ADD CHARACTER"));
        this.btnAddCharacter.setToolTipText(StorySettings.currentBundle.getString("ADDCHARACTER_H"));
        this.btnAddCharacter.setName("btnAddCharacter");
        this.btnAddCharacter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.btnAddCharacterActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.btnAddCharacter, new AbsoluteConstraints(10, 100, -1, 30));
        this.btnSpectate.setText(StorySettings.currentBundle.getString("SPECTATE"));
        this.btnSpectate.setToolTipText(StorySettings.currentBundle.getString("SPECTATE_H"));
        this.btnSpectate.setName("btnSpectate");
        this.btnSpectate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.btnSpectateActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.btnSpectate, new AbsoluteConstraints(190, 0, 80, 40));
        GroupLayout pnlRightPaneLayout = new GroupLayout(this.pnlRightPane);
        this.pnlRightPane.setLayout(pnlRightPaneLayout);
        pnlRightPaneLayout.setHorizontalGroup(pnlRightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 277, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 277, Short.MAX_VALUE));
        pnlRightPaneLayout.setVerticalGroup(pnlRightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRightPaneLayout.createSequentialGroup().addComponent(this.jPanel4, -2, 148, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 511, Short.MAX_VALUE)));
        this.jSplitPane2.setDividerLocation(150);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.8);
        this.jSplitPane2.setName("jSplitPane2");
        this.newtBirdviewPane.setName("newtBirdviewPane");
        this.jSplitPane2.setTopComponent(this.newtBirdviewPane);
        this.timeInfoPanel.setName("timeInfoPanel");
        this.timeInfoPanel.setLayout(new BorderLayout());
        this.jSplitPane2.setRightComponent(this.timeInfoPanel);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jSplitPane2, -1, 390, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlRightPane, -2, 281, -2)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.pnlRightPane, -1, 768, Short.MAX_VALUE).addGap(13, 13, 13)));
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.mMainMenu.setName("mMainMenu");
        ApplicationActionMap actionMap = Application.getInstance().getContext().getActionMap(EmoNewtFrame.class, this);
        this.mmFile.setAction(actionMap.get("save"));
        this.mmFile.setText(StorySettings.currentBundle.getString("FILE"));
        this.mmFile.setName("mmFile");
        this.mfNewStory.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.mfNewStory.setText(StorySettings.currentBundle.getString("NEW STORY"));
        this.mfNewStory.setToolTipText(StorySettings.currentBundle.getString("NEWSTORYHELP"));
        this.mfNewStory.setName("mfNewStory");
        this.mfNewStory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mfNewStoryActionPerformed(evt);
            }
        });
        this.mmFile.add(this.mfNewStory);
        this.mfLoad.setAction(actionMap.get("load"));
        this.mfLoad.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.mfLoad.setText(StorySettings.currentBundle.getString("LOAD"));
        this.mfLoad.setToolTipText(StorySettings.currentBundle.getString("LOADHELP"));
        this.mfLoad.setName("mfLoad");
        this.mfLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mfLoadActionPerformed(evt);
            }
        });
        this.mmFile.add(this.mfLoad);
        this.jSeparator1.setName("jSeparator1");
        this.mmFile.add(this.jSeparator1);
        this.mfSave.setAction(actionMap.get("save"));
        this.mfSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mfSave.setText(StorySettings.currentBundle.getString("SAVE"));
        this.mfSave.setToolTipText(StorySettings.currentBundle.getString("SAVEHELP"));
        this.mfSave.setName("mfSave");
        this.mfSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mfSaveActionPerformed(evt);
            }
        });
        this.mmFile.add(this.mfSave);
        this.mfSaveAs.setAction(actionMap.get("saveAs"));
        this.mfSaveAs.setText(StorySettings.currentBundle.getString("SAVE AS"));
        this.mfSaveAs.setToolTipText(StorySettings.currentBundle.getString("SAVEHELP"));
        this.mfSaveAs.setName("mfSaveAs");
        this.mfSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mfSaveAsActionPerformed(evt);
            }
        });
        this.mmFile.add(this.mfSaveAs);
        this.jSeparator2.setName("jSeparator2");
        this.mmFile.add(this.jSeparator2);
        this.mfExit.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.mfExit.setText(StorySettings.currentBundle.getString("EXIT"));
        this.mfExit.setName("mfExit");
        this.mfExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mfExitActionPerformed(evt);
            }
        });
        this.mmFile.add(this.mfExit);
        this.mMainMenu.add(this.mmFile);
        this.mmEdit.setText(StorySettings.currentBundle.getString("EDIT"));
        this.mmEdit.setName("mmEdit");
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoItem.setText(StorySettings.currentBundle.getString("UNDO"));
        this.undoItem.setName("undoItem");
        this.undoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.undoItemActionPerformed(evt);
            }
        });
        this.mmEdit.add(this.undoItem);
        redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        redoItem.setText(StorySettings.currentBundle.getString("REDO"));
        redoItem.setName("redoItem");
        redoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.redoItemActionPerformed(evt);
            }
        });
        this.mmEdit.add(redoItem);
        this.mMainMenu.add(this.mmEdit);
        this.mmPlaying.setName("mmPlaying");
        this.mmPlaying.setText(StorySettings.currentBundle.getString("MPLAYING"));
        this.mpPlayFromStart.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.mpPlayFromStart.setText(StorySettings.currentBundle.getString("PLAYFROMSTART"));
        this.mpPlayFromStart.setName("mpPlayFromStart");
        this.mpPlayFromStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mpPlayFromStartActionPerformed(evt);
            }
        });
        this.mmPlaying.add(this.mpPlayFromStart);
        this.mpPlay.setText(StorySettings.currentBundle.getString("PLAY"));
        this.mpPlay.setName("mpPlay");
        this.mpPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mpPlayActionPerformed(evt);
            }
        });
        this.mmPlaying.add(this.mpPlay);
        this.jSeparator4.setName("jSeparator4");
        this.mmPlaying.add(this.jSeparator4);
        this.mpPause.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        this.mpPause.setText(StorySettings.currentBundle.getString("PAUSE"));
        this.mpPause.setName("mpPause");
        this.mpPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mpPauseActionPerformed(evt);
            }
        });
        this.mmPlaying.add(this.mpPause);
        this.mpStop.setAccelerator(KeyStroke.getKeyStroke(86, 8));
        this.mpStop.setText(StorySettings.currentBundle.getString("STOP_PLAYING"));
        this.mpStop.setName("mpStop");
        this.mpStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mpStopActionPerformed(evt);
            }
        });
        this.mmPlaying.add(this.mpStop);
        this.jSeparator3.setName("jSeparator3");
        this.mmPlaying.add(this.jSeparator3);
        this.mpStartSim.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        this.mpStartSim.setText(StorySettings.currentBundle.getString("START_SIMULATION"));
        this.mpStartSim.setName("mpStartSim");
        this.mpStartSim.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mpStartSimActionPerformed(evt);
            }
        });
        this.mmPlaying.add(this.mpStartSim);
        this.mpStopSim.setAccelerator(KeyStroke.getKeyStroke(77, 8));
        this.mpStopSim.setText(StorySettings.currentBundle.getString("STOPSIMULATION"));
        this.mpStopSim.setName("mpStopSim");
        this.mpStopSim.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.mpStopSimActionPerformed(evt);
            }
        });
        this.mmPlaying.add(this.mpStopSim);
        this.mMainMenu.add(this.mmPlaying);
        this.mmSettings.setText(StorySettings.currentBundle.getString("SETTINGS"));
        this.mmSettings.setActionCommand("");
        this.mmSettings.setName("mmSettings");
        this.msSettingsItem.setText(StorySettings.currentBundle.getString("REC_MENU_SETTINGS"));
        this.msSettingsItem.setActionCommand("<user code>");
        this.msSettingsItem.setName("msSettingsItem");
        this.msSettingsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.msSettingsItemActionPerformed(evt);
            }
        });
        this.mmSettings.add(this.msSettingsItem);
        this.msRecSettingsItem.setText(StorySettings.currentBundle.getString("REC_MENU_RECORD_SETTINGS"));
        this.msRecSettingsItem.setActionCommand("<user code>");
        this.msRecSettingsItem.setName("msRecSettingsItem");
        this.msRecSettingsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmoNewtFrame.this.msRecSettingsItemActionPerformed(evt);
            }
        });
        this.mmSettings.add(this.msRecSettingsItem);
        this.mMainMenu.add(this.mmSettings);
        this.mmHelp.setText(StorySettings.currentBundle.getString("HELP"));
        this.mmHelp.setName("mmHelp");
        this.mmHelp.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EmoNewtFrame.this.mmHelpMouseClicked(evt);
            }
        });
        this.mMainMenu.add(this.mmHelp);
        this.mmAbout.setText(StorySettings.currentBundle.getString("ABOUT"));
        this.mmAbout.setName("mmAbout");
        this.mmAbout.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EmoNewtFrame.this.mmAboutMouseClicked(evt);
            }
        });
        this.mMainMenu.add(this.mmAbout);
        this.mmUndo.setText(StorySettings.currentBundle.getString("UNDO"));
        this.mmUndo.setName("mmUndo");
        this.mmUndo.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EmoNewtFrame.this.mmUndoMouseClicked(evt);
            }
        });
        this.mMainMenu.add(this.mmUndo);
        this.mmRedo.setText(StorySettings.currentBundle.getString("REDO"));
        this.mmRedo.setName("mmRedo");
        this.mmRedo.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EmoNewtFrame.this.mmRedoMouseClicked(evt);
            }
        });
        this.mMainMenu.add(this.mmRedo);
        this.setJMenuBar(this.mMainMenu);
        this.pack();
    }

    private void btnPlayActionPerformed(ActionEvent evt) {
        if (this.controller.isUnrealStoryRunning()) {
            this.controller.stopUnrealStory();
            if (this.isVideoBeingCaptured) {
                this.recStopRecording();
            }
        } else {
            if (!this.controller.getUnrealEngine().isRunning()) {
                StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("START_PLAYING_AND_UNREAL_NOT_ON"));
            }
            long storyTime = this.model.getCurrentStoryTime();
            this.controller.startUnrealStory(storyTime, this.model.getStoryEnd());
            if (this.chbAutomaticRecording.isSelected()) {
                this.recStartRecording();
            }
        }
    }

    private void btnStopActionPerformed(ActionEvent evt) {
        if (this.controller.isUnrealStoryRunning()) {
            this.model.setCurrentTime(0L);
            this.validate();
            this.controller.stopUnrealStory();
        }
        if (this.isVideoBeingCaptured) {
            this.recStopRecording();
        }
    }

    private void mfSaveAsActionPerformed(ActionEvent evt) {
        this.saveAs();
    }

    private void mfSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void mfLoadActionPerformed(ActionEvent evt) {
        this.load();
        if (this.controller != null && this.controller.getUnrealStoryPlayer() != null && this.controller.getUnrealStoryPlayer().getUnrealPlayer() != null && this.controller.getUnrealStoryPlayer().getUnrealPlayer().getControlServer() != null) {
            this.controller.getUnrealStoryPlayer().getUnrealPlayer().getControlServer().clearCamera();
        }
    }

    private void mfExitActionPerformed(ActionEvent evt) {
        this.handleWindowClosing();
    }

    private void mmAboutMouseClicked(MouseEvent evt) {
        NewtAboutDialog dial = new NewtAboutDialog(this, true, this.model);
        dial.setLocation(this.getWidth() / 4, this.getHeight() / 4);
        dial.setVisible(true);
    }

    private void mfNewStoryActionPerformed(ActionEvent evt) {
        int result = StoryTools.userYesNoCancelDialog(this, StorySettings.currentBundle.getString("ASK SAVE"));
        if (result == 2) {
            return;
        }
        if (result == 0) {
            this.save();
        }
        this.setCurrentSavingFile(null);
        this.model.resetModel();
        if (this.controller != null && this.controller.getUnrealStoryPlayer() != null && this.controller.getUnrealStoryPlayer().getUnrealPlayer() != null && this.controller.getUnrealStoryPlayer().getUnrealPlayer().getControlServer() != null) {
            this.controller.getUnrealStoryPlayer().getUnrealPlayer().getControlServer().clearCamera();
        }
    }

    private void btnSpectateActionPerformed(ActionEvent evt) {
        if (!this.controller.isUnrealServerRunning()) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("REQUESTCONNECT"));
            return;
        }
        try {
            UE2Wrapper ue2 = this.controller.getUnrealEngine();
            if (!ue2.isRunning()) {
                ue2.startUnrealRuntime("localhost");
            } else {
                EmoNewtFrame.killRunningProcess("UE2Runtime.exe", false);
                ue2.destroySpectate();
                ue2.startUnrealRuntime("localhost");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void btnSimulateActionPerformed(ActionEvent evt) {
        this.controller.startSimulation(this.model.getCurrentStoryTime(), this.model.getStoryEnd());
    }

    private void btnStopSimulationActionPerformed(ActionEvent evt) {
        if (this.controller.isSimulationRunning()) {
            this.controller.stopSimulation();
        }
    }

    private void btnAddCharacterActionPerformed(ActionEvent evt) {
        NewtNewCharDialog dial = new NewtNewCharDialog(this, true, this.getModel());
        dial.setVisible(true);
    }

    private void btnPlayFromStartActionPerformed(ActionEvent evt) {
        if (!this.controller.getUnrealEngine().isRunning()) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("START_PLAYING_AND_UNREAL_NOT_ON"));
        }
        this.model.setCurrentTime(0L);
        this.model.setCurrentTime(-2000L);
        if (this.chbAutomaticRecording.isSelected()) {
            this.recStartRecording();
        }
        this.controller.startUnrealStory(this.model.getCurrentStoryTime(), this.model.getStoryEnd());
    }

    private void undoItemActionPerformed(ActionEvent evt) {
        this.model.undo();
    }

    private void redoItemActionPerformed(ActionEvent evt) {
        this.model.redo();
    }

    private void mpPlayFromStartActionPerformed(ActionEvent evt) {
        this.btnPlayFromStartActionPerformed(evt);
    }

    private void mpPlayActionPerformed(ActionEvent evt) {
        this.btnPlayActionPerformed(evt);
    }

    private void mpPauseActionPerformed(ActionEvent evt) {
        this.btnPlayActionPerformed(evt);
    }

    private void mpStopActionPerformed(ActionEvent evt) {
        this.btnStopActionPerformed(evt);
    }

    private void mpStartSimActionPerformed(ActionEvent evt) {
        this.controller.startSimulation(this.model.getCurrentStoryTime(), this.model.getStoryEnd());
    }

    private void mpStopSimActionPerformed(ActionEvent evt) {
        this.controller.stopSimulation();
    }

    private void mmHelpMouseClicked(MouseEvent evt) {
        if (this.helpPane == null) {
            this.helpPane = new NewtHelp(this);
        }
        this.helpPane.setVisible(true);
    }

    private String[] prepareCScontrolArguments() {
        String[] args = new String[]{".\\Recording\\CScontrol\\CScontrol.exe", this.model.getSettings().getbDrawRecordingAreaRectangle() ? "--drawRectangle" : "--noDrawRectangle", this.model.getSettings().isbAutoSaveRecToCStudioDir() ? "--autoSave" : "--noAutoSave", "--timeLapse", String.valueOf(this.model.getSettings().getbRecordingFrameTimeLapse()), "--quality", String.valueOf(this.model.getSettings().getbRecordingQuality()), StoryTools.DEBUG ? "--debugMode" : "", this.model.getSettings().getbPerformUThack() ? "--UThack" : "--noUThack", this.model.getSettings().getbUseXVIDCodec() ? "--xvidActive" : ""};
        return args;
    }

    private void recStartRecording() {
        this.isVideoBeingCaptured = this.isRecorderProcessRunning();
        if (this.isVideoBeingCaptured) {
            this.showTextInUserLog(StorySettings.currentBundle.getString("REC_ALREADY_RECORDING_ERR"));
            if (StoryTools.DEBUG) {
                System.out.println("Video is already being recorded - stop previous recording before starting new.");
            }
            return;
        }
        String[] args = this.prepareCScontrolArguments();
        if (this.runCommandWithVerbose(args) == 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isVideoBeingCaptured = this.isRecorderProcessRunning();
            if (this.isVideoBeingCaptured) {
                this.showTextInUserLog(StorySettings.currentBundle.getString("REC_RECORDER_PROCESS_FOUND"));
            } else {
                this.showTextInUserLog(StorySettings.currentBundle.getString("REC_RECORDER_PROCESS_NOT_FOUND"));
            }
        }
        this.updateIsRecordingLabel();
    }

    private void recStopRecording() {
        boolean wasRunningBefore = this.isVideoBeingCaptured = this.isRecorderProcessRunning();
        if (StoryTools.DEBUG) {
            if (this.isVideoBeingCaptured) {
                this.showTextInUserLog(StorySettings.currentBundle.getString("REC_RECORDER_PROCESS_FOUND"));
            } else {
                this.showTextInUserLog(StorySettings.currentBundle.getString("REC_RECORDER_PROCESS_NOT_FOUND"));
            }
        }
        String[] args = new String[4];
        args[0] = ".\\Recording\\CScontrol\\CScontrol.exe";
        args[1] = "--onlyStopRecord";
        args[2] = this.model.getSettings().getbPerformUThack() ? "--UThack" : "--noUThack";
        String string = args[3] = StoryTools.DEBUG ? "--debugMode" : "";
        if (this.runCommandWithVerbose(args) == 0) {
            this.isVideoBeingCaptured = this.isRecorderProcessRunning();
            if (StoryTools.DEBUG) {
                if (this.isVideoBeingCaptured) {
                    this.showTextInUserLog(StorySettings.currentBundle.getString("REC_RECORDER_PROCESS_FOUND"));
                    this.showTextInUserLog(StorySettings.currentBundle.getString("REC_MANUAL_CLOSE_REQUIRED"));
                } else {
                    this.showTextInUserLog(StorySettings.currentBundle.getString("REC_RECORDER_PROCESS_NOT_FOUND"));
                }
            }
            if (wasRunningBefore) {
                if (this.isVideoBeingCaptured) {
                    this.showTextInUserLog(StorySettings.currentBundle.getString("REC_RECORDER_PROCESS_FOUND"));
                    this.showTextInUserLog(StorySettings.currentBundle.getString("REC_MANUAL_CLOSE_REQUIRED"));
                } else {
                    this.showTextInUserLog(StorySettings.currentBundle.getString("REC_STOP_SUCCEEDED"));
                }
            }
            this.updateIsRecordingLabel();
        }
    }

    private void updateIsRecordingLabel() {
        if (this.isVideoBeingCaptured) {
            this.lblIsRecording.setText(StorySettings.currentBundle.getString("REC_IS_RECORDING"));
        } else {
            this.lblIsRecording.setText(StorySettings.currentBundle.getString("REC_IS_RECORDING_OFF"));
        }
    }

    private void btnRecStartActionPerformed(ActionEvent evt) {
        if (StoryTools.DEBUG) {
            System.out.println("Start CScontrol button invoked.");
            this.showTextInUserLog("Start CScontrol button invoked.");
        }
        this.recStartRecording();
    }

    private void btnRecStopActionPerformed(ActionEvent evt) {
        if (StoryTools.DEBUG) {
            System.out.println("Stop recording in CScontrol button invoked!");
            this.showTextInUserLog("Stop recording in CScontrol button invoked!");
        }
        this.recStopRecording();
    }

    private void msSettingsItemActionPerformed(ActionEvent evt) {
        NewtSettingsDialog dial = new NewtSettingsDialog(this, true, this.model);
        dial.setLocation(this.getWidth() / 4, this.getHeight() / 4);
        dial.setVisible(true);
    }

    private void msRecSettingsItemActionPerformed(ActionEvent evt) {
        NewtRecordingSettingsDialog dial = new NewtRecordingSettingsDialog(this, true, this.model);
        dial.setLocation(this.getWidth() / 4, this.getHeight() / 4);
        dial.setVisible(true);
    }

    private void mmUndoMouseClicked(MouseEvent evt) {
        this.model.undo();
    }

    private void mmRedoMouseClicked(MouseEvent evt) {
        this.model.redo();
    }

    public int runCommandWithVerbose(String[] commandWithArgs) {
        String s = null;
        Process p = null;
        boolean firstIteration = true;
        if (StoryTools.DEBUG) {
            System.out.print("\n Starting command : ");
        }
        for (int i = 0; i < commandWithArgs.length; ++i) {
            if (!StoryTools.DEBUG) continue;
            System.out.print("  " + commandWithArgs[i]);
        }
        if (StoryTools.DEBUG) {
            System.out.println("");
        }
        try {
            p = Runtime.getRuntime().exec(commandWithArgs);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((s = stdInput.readLine()) != null) {
                if (firstIteration) {
                    if (StoryTools.DEBUG) {
                        System.out.println("Standard output of the command:\n");
                    }
                    firstIteration = false;
                }
                System.out.println(s);
                this.showTextInUserLog(s);
            }
            firstIteration = true;
            while ((s = stdError.readLine()) != null) {
                if (firstIteration) {
                    if (StoryTools.DEBUG) {
                        System.out.println("Error output of the command:\n");
                    }
                    firstIteration = false;
                }
                System.out.println(s);
                this.showTextInUserLog("Error: " + s);
            }
        }
        catch (IOException e) {
            System.out.println("Exception occured when running: " + commandWithArgs[0] + " \n Additional info: ");
            this.showTextInUserLog("Exception occured when running: " + commandWithArgs[0] + " \n Additional info: ");
            e.printStackTrace();
            return 1;
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                StoryController model = new StoryController();
                EmoNewtFrame frame = new EmoNewtFrame(model);
                ViewController controller = new ViewController(model, frame);
                frame.setVisible(true);
            }
        });
    }

    public void saveAs() {
        JFileChooser chooser = new JFileChooser();
        if (this.currentSaveLoadDir == null) {
            this.currentSaveLoadDir = new File(".");
        }
        chooser.setCurrentDirectory(this.currentSaveLoadDir);
        ExtensionFileFilter filter = new ExtensionFileFilter("emo", new String[]{"emo"});
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        this.currentSaveLoadDir = chooser.getCurrentDirectory();
        if (returnVal == 0) {
            try {
                this.currentSavingFile = chooser.getSelectedFile().getCanonicalPath();
                if (!filter.acceptFileString(this.currentSavingFile)) {
                    this.currentSavingFile = this.currentSavingFile + ".emo";
                }
                if (new File(this.currentSavingFile).exists() && !StoryTools.userConfirmedDialog(this, StorySettings.currentBundle.getString("OVERWRITE EXISTING FILE?"))) {
                    this.saveAs();
                    return;
                }
                this.model.save(this.currentSavingFile);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, StorySettings.currentBundle.getString("ERROR SAVING TO FILE"));
            }
        }
    }

    public void load() {
        if (!this.model.getChangeActions().isEmpty()) {
            int result = JOptionPane.showConfirmDialog(this, StorySettings.currentBundle.getString("ASKSAVELOADING"));
            if (result == 0) {
                this.save();
            } else if (result == 2) {
                return;
            }
        }
        JFileChooser chooser = new JFileChooser();
        if (this.currentSaveLoadDir == null) {
            this.currentSaveLoadDir = new File(".");
        }
        chooser.setCurrentDirectory(this.currentSaveLoadDir);
        ExtensionFileFilter filter = new ExtensionFileFilter("emo", new String[]{"emo"});
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        this.currentSaveLoadDir = chooser.getCurrentDirectory();
        if (returnVal == 0) {
            try {
                this.currentSavingFile = chooser.getSelectedFile().getCanonicalPath();
                this.model.load(this.currentSavingFile);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(null, StorySettings.currentBundle.getString("FILE NOT FOUND"));
            }
            catch (ClassNotFoundException ex) {
                JOptionPane.showMessageDialog(null, StorySettings.currentBundle.getString("INCORRECT FILE TYPE"));
            }
            catch (IOException e) {
                System.out.println(e.toString());
                JOptionPane.showMessageDialog(null, StorySettings.currentBundle.getString("CANNOT READ THE FILE"));
            }
        }
    }

    public void save() {
        if (this.currentSavingFile == null) {
            this.saveAs();
        } else {
            try {
                File currentFile = new File(this.currentSavingFile);
                if (!StoryTools.userConfirmedDialog(this, StorySettings.currentBundle.getString("OVERWRITE") + " " + currentFile.getName() + "?")) {
                    this.saveAs();
                    return;
                }
                this.model.save(this.currentSavingFile);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, StorySettings.currentBundle.getString("ERROR SAVING TO FILE"));
            }
        }
    }

    public void setButtonsDisable(boolean bEnabled) {
        this.btnStopSimulation.setEnabled(!bEnabled);
        this.mmFile.setEnabled(!bEnabled);
        this.mmEdit.setEnabled(!bEnabled);
        this.mmSettings.setEnabled(!bEnabled);
        this.mmRedo.setEnabled(!bEnabled);
        this.mmUndo.setEnabled(!bEnabled);
        this.btnPlayFromStart.setEnabled(!bEnabled);
        this.btnSimulate.setEnabled(!bEnabled);
        this.btnAddCharacter.setEnabled(!bEnabled);
    }

    public void setButtonsDisableSimulation(boolean bEnabled) {
        this.btnStopSimulation.setEnabled(!bEnabled);
        this.mmFile.setEnabled(!bEnabled);
        this.mmEdit.setEnabled(!bEnabled);
        this.mmSettings.setEnabled(!bEnabled);
        this.mmRedo.setEnabled(!bEnabled);
        this.mmUndo.setEnabled(!bEnabled);
        this.btnPlayFromStart.setEnabled(!bEnabled);
        this.btnPlay.setEnabled(!bEnabled);
        this.btnStop.setEnabled(!bEnabled);
        this.btnSimulate.setEnabled(!bEnabled);
        this.btnAddCharacter.setEnabled(!bEnabled);
    }

    @Override
    public void storyPlayChanged(boolean bPaused) {
        if (this.controller.isUnrealStoryRunning()) {
            this.btnPlay.setIcon(new ImageIcon("images/pause.jpg"));
            this.setButtonsDisable(bPaused);
            this.mpPlay.setEnabled(false);
            this.mpPlayFromStart.setEnabled(false);
            this.mpStop.setEnabled(true);
            this.mpPause.setEnabled(true);
            this.mpStartSim.setEnabled(false);
            this.mpStopSim.setEnabled(false);
        } else if (this.controller.isSimulationRunning()) {
            this.setButtonsDisableSimulation(bPaused);
            this.btnStopSimulation.setEnabled(true);
            this.mpPlay.setEnabled(false);
            this.mpPlayFromStart.setEnabled(false);
            this.mpStop.setEnabled(false);
            this.mpPause.setEnabled(false);
            this.mpStartSim.setEnabled(false);
            this.mpStopSim.setEnabled(true);
        } else {
            this.setButtonsDisableSimulation(bPaused);
            this.btnPlay.setIcon(new ImageIcon("images/play.jpg"));
            this.mpPlay.setEnabled(true);
            this.mpPlayFromStart.setEnabled(true);
            this.mpStop.setEnabled(false);
            this.mpPause.setEnabled(false);
            this.mpStartSim.setEnabled(true);
            this.mpStopSim.setEnabled(false);
            if (this.isVideoBeingCaptured) {
                this.recStopRecording();
            }
        }
        this.validate();
    }

    private int fillInWidthOfTheWindow(int originalWidth) {
        if (this.getModel() != null) {
            int innerWidth = this.getModel().getSettings().getWidthOfTheWindows();
            System.out.println("Width: " + innerWidth);
            return innerWidth;
        }
        return originalWidth;
    }

    private int fillInHeightOfTheWindow(int originalHeight) {
        if (this.getModel() != null) {
            int numberOfCharacters = this.getModel().getStoryCharacters().size();
            if (StoryTools.DEBUG) {
                System.out.println("Number of chars: " + numberOfCharacters);
            }
            int innerHeight = numberOfCharacters * 130 + 20;
            if (numberOfCharacters == 0) {
                innerHeight = 50;
            }
            if (StoryTools.DEBUG) {
                System.out.println("Height: " + innerHeight);
            }
            return innerHeight;
        }
        return originalHeight;
    }

    private void recountSizeOfTimeWindow() {
        int innerHeight = 400;
        int innerWidth = 400;
        innerWidth = this.fillInWidthOfTheWindow(innerWidth);
        innerHeight = this.fillInHeightOfTheWindow(innerHeight);
        this.middlePane.setPreferredSize(new Dimension(innerWidth, innerHeight));
        this.innerPane.setSize(innerWidth, innerHeight);
        this.newtCharsPane.redrawAllElements();
    }

    @Override
    public void scaleChanged(float oldScale, float newScale) {
        Rectangle visibleRectangle = this.innerPane.getVisibleRect();
        Point levyHorni = new Point(this.timeInfoScrollPane.getViewport().getViewPosition());
        levyHorni.x += visibleRectangle.width / 2;
        int cas = Math.round((float)levyHorni.x * 1000.0f / oldScale);
        levyHorni.x = Math.round((float)cas * newScale / 1000.0f);
        levyHorni.x -= visibleRectangle.width / 2;
        this.recountSizeOfTimeWindow();
        this.timeInfoScrollPane.getViewport().setViewPosition(levyHorni);
        this.validateAndRepaint();
    }

    private void validateAndRepaint() {
        this.timeInfoScrollPane.validate();
        this.timeInfoScrollPane.repaint();
        this.middlePane.validate();
        this.middlePane.repaint();
        this.innerPane.validate();
        this.innerPane.repaint();
    }

    @Override
    public void storyLengthChanged(long oldLength, long newLength) {
        this.recountSizeOfTimeWindow();
    }

    @Override
    public void avatarsChanged(long time, Map<EmohawkCharacter, AvatarState> avataStates) {
    }

    @Override
    public void characterNumberChanged() {
        if (StoryTools.DEBUG) {
            System.out.println("Listener for character number change.");
        }
        for (EmohawkCharacter ec : this.model.getStoryCharacters()) {
            if (!StoryTools.DEBUG) continue;
            System.out.println("    " + ec.getName());
        }
        this.recountSizeOfTimeWindow();
        this.validateAndRepaint();
    }

    private void showTextInUserLog(String text) {
        ++this.userInfoLogMessagesCount;
        this.txtUserInfoLog.setText(this.txtUserInfoLog.getText() + "\n[" + String.valueOf(this.userInfoLogMessagesCount) + "] " + text);
    }

    public static boolean killRunningProcess(String processExecutableName, boolean forceProcessKill) {
        String outputLine = null;
        String outputFull = "";
        Process p = null;
        if (!EmoNewtFrame.isProcessRunning(processExecutableName)) {
            if (StoryTools.DEBUG) {
                System.out.println(" No running process: " + processExecutableName + " found! ");
            }
            return false;
        }
        try {
            p = Runtime.getRuntime().exec(".\\Recording\\TaskkillEN\\taskkillEN.exe /T " + (forceProcessKill ? "/F" : "") + " /FI \"imagename eq " + processExecutableName + "\"");
            p.waitFor();
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            return false;
        }
        catch (InterruptedException ex) {
            System.out.println(ex.toString());
            return false;
        }
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            while ((outputLine = stdInput.readLine()) != null) {
                outputFull = outputFull.concat(outputLine);
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
        if (StoryTools.DEBUG) {
            System.out.println("\n killRunningProcess " + processExecutableName + " invoked.\n Output from taskkill.exe is: " + outputFull);
        }
        if (!outputFull.matches("^SUCCESS.*")) {
            return false;
        }
        return !EmoNewtFrame.isProcessRunning(processExecutableName);
    }

    private static boolean isProcessRunning(String processExecutableName) {
        String outputLine = null;
        String outputFull = "";
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(".\\Recording\\TasklistEN\\tasklistEN.exe /FO CSV /NH /FI \"imagename eq " + processExecutableName + "\"");
            p.waitFor();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            try {
                while ((outputLine = stdInput.readLine()) != null) {
                    outputFull = outputFull.concat(outputLine);
                }
            }
            catch (IOException ex) {
                System.out.println(ex.toString());
            }
            if (StoryTools.DEBUG) {
                System.out.println("\n isProcessRunning " + processExecutableName + " invoked.\n Output from tasklist.exe is: " + outputFull);
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
        catch (InterruptedException ex) {
            System.out.println(ex.toString());
        }
        return outputFull.matches("^\"" + processExecutableName + "\",.*");
    }

    private boolean isRecorderProcessRunning() {
        return EmoNewtFrame.isProcessRunning("Recorder.exe");
    }
}

