/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui;

import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryPlayerListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.Timer;

public abstract class AbstractStoryPlayer
implements ActionListener {
    protected final StoryController model;
    protected final ViewController controller;
    private Timer timer;
    protected long start;
    protected long end;
    protected int interval;
    private long simulationStartedTime = -1L;

    public void actionPerformed(ActionEvent e) {
        long elapsedTime;
        long storyTime;
        if (this.simulationStartedTime == -1L) {
            this.simulationStartedTime = Calendar.getInstance().getTimeInMillis();
        }
        if ((storyTime = (elapsedTime = Calendar.getInstance().getTimeInMillis() - this.simulationStartedTime) + this.start) >= this.end) {
            this.stop();
            return;
        }
        this.tick(storyTime);
    }

    public ViewController getController() {
        return this.controller;
    }

    protected abstract boolean preStartUp();

    protected abstract boolean postStartUp();

    protected abstract void tick(long var1);

    protected abstract boolean preShutDown();

    protected abstract boolean postShutDown();

    protected abstract boolean previewAnimation(ActionAnimation var1, boolean var2);

    public AbstractStoryPlayer(StoryController model, ViewController controller, int interval) {
        this.model = model;
        this.controller = controller;
        this.start = 0L;
        this.end = model.getStoryEnd();
        this.interval = interval;
    }

    public void setStartTime(long start) {
        this.start = start;
    }

    public void setEndTime(long end) {
        assert (end <= this.model.getStoryLength() && end > this.start);
        this.end = end;
    }

    public void setInterval(int interval) {
        assert (interval > 0);
        this.interval = interval;
    }

    public boolean start() {
        assert (this.timer == null);
        if (!this.preStartUp()) {
            return false;
        }
        this.simulationStartedTime = -1L;
        this.timer = new Timer(this.interval, this);
        this.timer.setInitialDelay(0);
        this.timer.start();
        for (IStoryPlayerListener listener : this.controller.getPlayerListeners()) {
            listener.storyPlayChanged(true);
        }
        if (!this.postStartUp()) {
            this.stop();
            return false;
        }
        return true;
    }

    public boolean isRunning() {
        return this.timer != null ? this.timer.isRunning() : false;
    }

    public boolean stop() {
        if (this.timer == null) {
            return false;
        }
        this.preShutDown();
        this.timer.stop();
        this.timer = null;
        for (IStoryPlayerListener listener : this.controller.getPlayerListeners()) {
            listener.storyPlayChanged(false);
        }
        return this.postShutDown();
    }
}

