/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.iterators;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CircularListIterator<E>
implements ListIterator<E> {
    protected boolean passedEnd = false;
    protected boolean passedBeginning = false;
    protected boolean moved = false;
    private int index = 0;
    private List<E> toIterateOver;
    private ListIterator<E> iterator;

    public CircularListIterator(List<E> toIterateOver) {
        if (toIterateOver == null) {
            throw new NullPointerException("List<E> to be iterated over cannot be null.");
        }
        this.toIterateOver = toIterateOver;
        this.iterator = toIterateOver.listIterator();
    }

    public CircularListIterator(List<E> toIterateOver, int index) {
        if (toIterateOver == null) {
            throw new IllegalArgumentException("List<E> to be iterated over cannot be null.");
        }
        if (index < 0 && index > toIterateOver.size()) {
            throw new IllegalArgumentException("Index parameter cannot be outside toIterateOver parameter.");
        }
        this.toIterateOver = toIterateOver;
        this.iterator = toIterateOver.listIterator(index);
        this.index = index;
    }

    public CircularListIterator(CircularListIterator<E> source) {
        this.passedEnd = source.passedEnd;
        this.passedBeginning = source.passedBeginning;
        this.index = source.index;
        this.toIterateOver = source.toIterateOver;
        int currentIndex = source.currentIndex();
        this.iterator = this.toIterateOver.listIterator(currentIndex == -1 ? this.toIterateOver.size() - 1 : currentIndex);
    }

    @Override
    public boolean hasNext() {
        return this.toIterateOver.size() > 0;
    }

    @Override
    public E next() {
        if (this.currentIndex() == this.toIterateOver.size()) {
            this.restartIteratorBeginning();
        }
        E value = this.iterator.next();
        if (this.currentIndex() == this.index && this.moved) {
            this.passedEnd = true;
        }
        this.moved = true;
        return value;
    }

    @Override
    public void remove() {
        this.iterator.remove();
        if (this.currentIndex() == this.index) {
            this.passedEnd = true;
        }
        if (this.currentIndex() == this.toIterateOver.size()) {
            this.restartIteratorBeginning();
        }
    }

    public boolean hasPassedEnd() {
        if (this.passedEnd) {
            this.passedEnd = false;
            return this.passedEnd;
        }
        return false;
    }

    public boolean hasPassedBeginning() {
        if (this.passedBeginning) {
            this.passedBeginning = false;
            return this.passedBeginning;
        }
        return false;
    }

    protected Iterable<E> getIterable() {
        return this.toIterateOver;
    }

    protected Iterator<E> getIterator() {
        return this.iterator;
    }

    protected void restartIteratorBeginning() {
        this.iterator = this.toIterateOver.listIterator();
    }

    protected void restartIteratorEnd() {
        this.iterator = this.toIterateOver.listIterator(this.toIterateOver.size());
    }

    @Override
    public void add(E e) {
        this.iterator.add(e);
    }

    @Override
    public boolean hasPrevious() {
        return this.hasNext();
    }

    @Override
    public int nextIndex() {
        return this.iterator.nextIndex() % this.toIterateOver.size();
    }

    @Override
    public E previous() {
        if (this.currentIndex() == 0) {
            this.restartIteratorEnd();
        }
        E value = this.iterator.previous();
        if (this.currentIndex() == this.index && this.moved) {
            this.passedBeginning = true;
        }
        this.moved = true;
        return value;
    }

    @Override
    public int previousIndex() {
        int previous = this.iterator.previousIndex();
        return previous == -1 ? this.toIterateOver.size() - 1 : previous;
    }

    @Override
    public void set(E e) {
        this.iterator.set(e);
    }

    public int currentIndex() {
        int next = this.nextIndex() - 1;
        return next == this.toIterateOver.size() ? 0 : this.nextIndex() - 1;
    }

    public CircularListIterator<E> previousIter() {
        this.previous();
        return this;
    }

    public CircularListIterator<E> nextIter() {
        this.next();
        return this;
    }
}

