/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.astar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

public class AStarResult<NODE> {
    public HashMap<NODE, NODE> previousNode = new HashMap();
    public Collection<NODE> openList;
    public Collection<NODE> closeList = new HashSet<NODE>();
    public HashMap<NODE, Integer> pathCost = new HashMap();
    public HashMap<NODE, Integer> estimatedCost = new HashMap();
    public long interations = 0L;
    public NODE startNode = null;
    public NODE goalNode = null;
    public boolean success = false;
    private List<NODE> path = null;

    public NODE getPreviousNode(NODE node) {
        if (this.previousNode.containsKey(node)) {
            return this.previousNode.get(node);
        }
        return null;
    }

    public void putPreviousNode(NODE node, NODE previous) {
        this.previousNode.put(node, previous);
    }

    public int getCostToNode(NODE node) {
        if (this.pathCost.containsKey(node)) {
            return this.pathCost.get(node);
        }
        return -1;
    }

    public void putCostToNode(NODE node, Integer cost) {
        this.pathCost.put(node, cost);
    }

    public int getEstimatedCostToNode(NODE node) {
        if (this.estimatedCost.containsKey(node)) {
            return this.estimatedCost.get(node);
        }
        return -1;
    }

    public void putEstimatedCostToNode(NODE node, Integer cost) {
        this.estimatedCost.put(node, cost);
    }

    public List<NODE> getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (!this.success) {
            return null;
        }
        Stack<NODE> tempPath = new Stack<NODE>();
        tempPath.push(this.goalNode);
        NODE node = this.goalNode;
        while (node != this.startNode) {
            if ((node = this.getPreviousNode(node)) == null) {
                return null;
            }
            tempPath.push(node);
        }
        this.path = new ArrayList<NODE>();
        while (!tempPath.empty()) {
            this.path.add(tempPath.pop());
        }
        return this.path;
    }

    public int getDistanceToGoal() {
        if (!this.success) {
            return -1;
        }
        return this.pathCost.get(this.goalNode);
    }
}

