/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.util.concurrent.TimeUnit;

public class Heatup {
    private long heatupMillis;
    private long lastUsedMillis;

    public Heatup(long cooldownMillis) {
        this(cooldownMillis, TimeUnit.MILLISECONDS);
    }

    public Heatup(long cooldownTime, TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                this.heatupMillis = cooldownTime * 24L * 60L * 60L * 1000L;
                break;
            }
            case HOURS: {
                this.heatupMillis = cooldownTime * 60L * 60L * 1000L;
                break;
            }
            case MICROSECONDS: {
                throw new UnsupportedOperationException("Unsupported: MICROSECONDS.");
            }
            case MILLISECONDS: {
                this.heatupMillis = cooldownTime;
                break;
            }
            case MINUTES: {
                this.heatupMillis = cooldownTime * 60L * 1000L;
                break;
            }
            case NANOSECONDS: {
                throw new UnsupportedOperationException("Unsupported: NANOSECONDS.");
            }
            case SECONDS: {
                this.heatupMillis = cooldownTime * 1000L;
            }
        }
    }

    public boolean isHot() {
        return System.currentTimeMillis() - this.lastUsedMillis < this.heatupMillis;
    }

    public void heat() {
        this.lastUsedMillis = System.currentTimeMillis();
    }

    public long getRemainingTime() {
        if (!this.isHot()) {
            return 0L;
        }
        return this.heatupMillis - (System.currentTimeMillis() - this.lastUsedMillis);
    }

    public void clear() {
        this.lastUsedMillis = 0L;
    }

    public boolean isCool() {
        return !this.isHot();
    }
}

