/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogEnvelope;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestAgents {
    public static NetworkLoggingAgent createNewAgent() {
        AgentId agentId = new AgentId();
        AgentLogger agentLogger = new AgentLogger(agentId);
        agentLogger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus(agentLogger);
        return new NetworkLoggingAgent(agentId, bus, agentLogger);
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        agent1 = TestAgents.createNewAgent();
        agent2 = TestAgents.createNewAgent();
        agent3 = TestAgents.createNewAgent();
        agent4 = TestAgents.createNewAgent();
        agent1.start();
        agent2.start();
        agent3.start();
        agent4.start();
        agent1Id = agent1.getComponentId();
        agent2Id = agent2.getComponentId();
        agent3Id = agent3.getComponentId();
        agent4Id = agent4.getComponentId();
        a1logged = true;
        a2logged = true;
        a3logged = true;
        a4logged = true;
        try {
            cl1 = new Socket(InetAddress.getByName("localhost"), 12345);
            new ObjectOutputStream(cl1.getOutputStream()).writeObject(agent1Id);
            cl2 = new Socket(InetAddress.getByName("localhost"), 12345);
            new ObjectOutputStream(cl2.getOutputStream()).writeObject(agent2Id);
            cl3 = new Socket(InetAddress.getByName("localhost"), 12345);
            new ObjectOutputStream(cl3.getOutputStream()).writeObject(agent3Id);
            cl4 = new Socket(InetAddress.getByName("localhost"), 12345);
            new ObjectOutputStream(cl4.getOutputStream()).writeObject(agent4Id);
            i = false;
            try {
                block8: while (true) {
                    if (a1logged) {
                        for (NetworkLogEnvelope envelope : (LinkedBlockingQueue)new ObjectInputStream(cl1.getInputStream()).readObject()) {
                            System.out.println("client 1's log: " + envelope.toString());
                        }
                    }
                    if (a2logged) {
                        for (NetworkLogEnvelope envelope : (LinkedBlockingQueue)new ObjectInputStream(cl2.getInputStream()).readObject()) {
                            System.out.println("client 2's log: " + envelope.toString());
                        }
                    }
                    if (a3logged) {
                        for (NetworkLogEnvelope envelope : (LinkedBlockingQueue)new ObjectInputStream(cl3.getInputStream()).readObject()) {
                            System.out.println("client 3's log: " + envelope.toString());
                        }
                    }
                    if (!a4logged) continue;
                    i$ = ((LinkedBlockingQueue)new ObjectInputStream(cl4.getInputStream()).readObject()).iterator();
                    while (true) {
                        if (i$.hasNext()) ** break;
                        continue block8;
                        envelope = (NetworkLogEnvelope)i$.next();
                        System.out.println("client 4's log: " + envelope.toString());
                    }
                    break;
                }
            }
            catch (StreamCorruptedException e) {
                System.out.println(e.toString());
            }
            catch (ClassNotFoundException e) {
                System.out.println(e.toString());
            }
            System.out.println("logging finished");
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(TestAgents.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TestAgents.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        agent1.kill();
        Pogamut.getPlatform().close();
    }

    public static class NetworkLoggingAgent
    extends AbstractAgent {
        public IAgentLogic myLogic = new IAgentLogic(){

            @Override
            public long getLogicInitializeTime() {
                return 1000L;
            }

            @Override
            public long getLogicShutdownTime() {
                return 1000L;
            }

            @Override
            public void logic() {
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").finest("I'm alive! FINEST" + this.toString());
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").finer("I'm alive! FINER");
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").fine("I'm alive! FINE");
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").info("I'm alive! INFO");
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").warning("I'm alive! WARNING");
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").severe("I'm alive! SEVERE");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            public void logicInitialize(LogicModule logicModule) {
            }

            @Override
            public void logicShutdown() {
            }
        };
        LogicModule logic;

        public NetworkLoggingAgent(IAgentId agentId, IComponentBus eventBus, IAgentLogger logger) {
            super(agentId, eventBus, logger);
            logger.addDefaultNetworkHandler();
            this.logic = new LogicModule<NetworkLoggingAgent>(this, this.myLogic);
        }
    }
}

