/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.impl;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.java.ReflectionObjectFolder;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.component.event.AgentEvents;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.jmx.AgentJMXComponents;
import cz.cuni.amis.pogamut.base.agent.jmx.IJMXEnabled;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentState;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateFailing;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateInstantiated;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStatePaused;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStatePausing;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateResumed;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateResuming;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStarted;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStartedPaused;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStarting;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStartingPaused;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStopped;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStopping;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateGoingDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateGoingUp;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailing;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateInstantiated;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStatePaused;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.IFatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IPausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IResetEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantPauseException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantResumeException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStopException;
import cz.cuni.amis.pogamut.base.utils.jmx.FolderToIJMXEnabledAdapter;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.collections.HashSetClass;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.IFlag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import cz.cuni.amis.utils.token.IToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractAgent
implements IAgent {
    public static final String INTROSPECTION_ROOT_NAME = "root";
    private IAgentLogger logger = null;
    protected LogCategory log = null;
    private Flag<IAgentState> agentState = new Flag<AgentStateInstantiated>(new AgentStateInstantiated("Just created."));
    private AgentJMXComponents jmx = null;
    private Object jmxMutex = new Object();
    private IComponentBus eventBus;
    private Folder folder = null;
    protected AgentEvents events;
    private IAgentId agentId;
    private Map<IToken, IComponent> runningComponents = new HashMap<IToken, IComponent>();
    private HashSetClass stopDependencyClass = new HashSetClass();
    private Set<IToken> stopDependencyToken = new HashSet<IToken>();
    private IComponentEventListener<IStartedEvent> startedEventListener = new IComponentEventListener<IStartedEvent>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(IStartedEvent event) {
            if (event.getSource() == null) {
                return;
            }
            if (event.getSource() == AbstractAgent.this) {
                return;
            }
            Map map = AbstractAgent.this.runningComponents;
            synchronized (map) {
                IComponent component = (IComponent)AbstractAgent.this.runningComponents.get(event.getSource().getComponentId());
                if (component == null) {
                    if (AbstractAgent.this.log.isLoggable(Level.FINE)) {
                        AbstractAgent.this.log.fine("Component " + event.getSource() + " started.");
                    }
                    AbstractAgent.this.componentStarted(event);
                } else if (component == event.getSource()) {
                    if (AbstractAgent.this.log.isLoggable(Level.WARNING)) {
                        AbstractAgent.this.log.warning("Component " + event.getSource() + " has started more than once.");
                    }
                } else {
                    throw new AgentException("Component id clash, two instances of components have the same component id = " + event.getSource().getComponentId(), (Object)this);
                }
            }
        }
    };
    private IComponentEventListener<IPausedEvent> pausedEventListener = new IComponentEventListener<IPausedEvent>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(IPausedEvent event) {
            if (event.getSource() == null) {
                return;
            }
            if (event.getSource() == AbstractAgent.this) {
                return;
            }
            Map map = AbstractAgent.this.runningComponents;
            synchronized (map) {
                IComponent component = (IComponent)AbstractAgent.this.runningComponents.get(event.getSource().getComponentId());
                if (component == null) {
                    if (AbstractAgent.this.log.isLoggable(Level.FINE)) {
                        AbstractAgent.this.log.fine("Component " + event.getSource() + " started.");
                    }
                    AbstractAgent.this.componentStarted(event);
                } else if (component != event.getSource()) {
                    throw new AgentException("Component id clash, two instances of components have the same component id = " + event.getSource().getComponentId(), (Object)this);
                }
            }
        }
    };
    private IComponentEventListener<IStoppingEvent> stoppingEventListener = new IComponentEventListener<IStoppingEvent>(){

        @Override
        public void notify(IStoppingEvent event) {
            AbstractAgent.this.componentStopping(event);
        }
    };
    private IComponentEventListener<IStoppedEvent> stoppedEventListener = new IComponentEventListener<IStoppedEvent>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(IStoppedEvent event) {
            Map map = AbstractAgent.this.runningComponents;
            synchronized (map) {
                IComponent component = (IComponent)AbstractAgent.this.runningComponents.get(event.getSource().getComponentId());
                if (component == null) {
                    if (AbstractAgent.this.log.isLoggable(Level.WARNING)) {
                        AbstractAgent.this.log.warning("Component " + event.getSource() + " stopped, but it has never reported that it started.");
                    }
                } else if (component == event.getSource()) {
                    if (AbstractAgent.this.log.isLoggable(Level.WARNING)) {
                        AbstractAgent.this.log.warning("Component " + event.getSource() + " has stopped.");
                    }
                    AbstractAgent.this.componentStopped(event);
                } else {
                    throw new AgentException("Component id clash, two instances of components have the same component id = " + event.getSource().getComponentId(), (Object)this);
                }
            }
        }
    };
    private IComponentEventListener<IFatalErrorEvent> fatalErrorEventListener = new IComponentEventListener<IFatalErrorEvent>(){

        @Override
        public void notify(IFatalErrorEvent event) {
            if (AbstractAgent.this.log.isLoggable(Level.SEVERE)) {
                AbstractAgent.this.log.severe("Fatal error sensed: " + event);
            }
            AbstractAgent.this.componentFatalError(event);
        }
    };
    private IComponentEventListener<IResetEvent> resetEventListener = new IComponentEventListener<IResetEvent>(){

        @Override
        public void notify(IResetEvent event) {
            AbstractAgent.this.resetEvent(event);
        }
    };
    private boolean startMethodCalled = false;
    private boolean stopMethodCalled = false;
    private boolean killMethodCalled = false;
    private boolean pauseMethodCalled = false;
    private boolean resumeMethodCalled = false;

    public AbstractAgent(IAgentId agentId, IComponentBus eventBus, IAgentLogger logger) {
        this.logger = logger;
        NullCheck.check(this.logger, "logger");
        this.agentId = agentId;
        NullCheck.check(this.agentId, "agentId");
        this.eventBus = eventBus;
        NullCheck.check(this.eventBus, "eventBus");
        this.log = this.logger.getCategory(this);
        NullCheck.check(this.log, "logger.getCategory()");
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Initializing " + this.getClass().getSimpleName() + ", id: " + this.agentId.getToken());
        }
        this.events = new AgentEvents(this.eventBus, this, (Logger)this.log);
        this.eventBus.addEventListener(IStartedEvent.class, this.startedEventListener);
        this.eventBus.addEventListener(IPausedEvent.class, this.pausedEventListener);
        this.eventBus.addEventListener(IStoppingEvent.class, this.stoppingEventListener);
        this.eventBus.addEventListener(IStoppedEvent.class, this.stoppedEventListener);
        this.eventBus.addEventListener(IFatalErrorEvent.class, this.fatalErrorEventListener);
        this.eventBus.addEventListener(IResetEvent.class, this.resetEventListener);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AbstractAgent)) {
            return false;
        }
        AbstractAgent otherAgent = (AbstractAgent)other;
        return this.agentId.equals(otherAgent.getComponentId());
    }

    public int hashCode() {
        return this.agentId.hashCode();
    }

    @Override
    public IAgentLogger getLogger() {
        return this.logger;
    }

    @Override
    public ImmutableFlag<IAgentState> getState() {
        return this.agentState.getImmutable();
    }

    public boolean inState(Class<?> ... states) {
        Class<?> agentState = this.getState().getFlag().getClass();
        for (Class<?> state : states) {
            if (!state.isAssignableFrom(agentState)) continue;
            return true;
        }
        return false;
    }

    public boolean notInState(Class<?> ... states) {
        Class<?> agentState = this.getState().getFlag().getClass();
        for (Class<?> state : states) {
            if (!state.isAssignableFrom(agentState)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IComponentBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public String getName() {
        return this.agentId.getName().getFlag();
    }

    @Override
    public IAgentId getComponentId() {
        return this.agentId;
    }

    public LogCategory getLog() {
        return this.log;
    }

    private void startFailedTest() {
        if (this.inState(IAgentStateFailed.class)) {
            throw new ComponentCantStartException("Agent has been killed during initialization.", (Logger)this.log, (IComponent)this);
        }
    }

    @Override
    public final synchronized void start() throws ComponentCantStartException {
        if (this.startMethodCalled) {
            return;
        }
        if (this.inState(IAgentStateGoingUp.class, IAgentStateUp.class)) {
            return;
        }
        if (this.notInState(IAgentStateDown.class)) {
            throw new ComponentCantStartException("Agent can't start, it is in wrong state (" + this.getState().getFlag() + ") stop() or kill() agent before start()ing.", (Logger)this.log, (IComponent)this);
        }
        this.startMethodCalled = true;
        try {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Starting agent " + this.getComponentId().getToken());
            }
            if (this.jmx != null) {
                this.getJMX().registerJMX();
            }
            if (!this.eventBus.isRunning()) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Event bus is not running, resetting.");
                }
                this.eventBus.reset();
                if (!this.eventBus.isRunning()) {
                    throw new ComponentCantStartException("Event bus reset()ed but it's still not running.", (Logger)this.log, (IComponent)this);
                }
            }
            this.setState(new AgentStateStarting("Sending 'starting' event."));
            this.startFailedTest();
            this.events.startingTransactional();
            this.startFailedTest();
            this.setState(new AgentStateStarting("Calling startAgent()."));
            this.startFailedTest();
            this.startAgent();
            this.startFailedTest();
            this.setState(new AgentStateStarting("Sending 'started' event."));
            this.startFailedTest();
            this.events.startedTransactional();
            this.startFailedTest();
            this.setState(new AgentStateStarted("Agent has started."));
            this.startFailedTest();
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.runningComponents.size() + " component" + (this.runningComponents.size() > 1 ? "s" : "") + " has started along with the agent.");
            }
        }
        catch (Exception e) {
            if (!this.inState(IAgentStateFailed.class) && !this.events.fatalError("Can't start the agent", e)) {
                this.componentFatalError(new FatalErrorEvent<AbstractAgent>(this, "agent's fatal error not propagated"));
            }
            if (e instanceof ComponentCantStartException) {
                throw (ComponentCantStartException)e;
            }
            throw new ComponentCantStartException("Can't start: " + e.getMessage(), (Throwable)e, (Logger)this.log, this);
        }
        finally {
            this.startMethodCalled = false;
        }
    }

    @Override
    public final synchronized void startPaused() throws ComponentCantStartException {
        if (this.startMethodCalled) {
            return;
        }
        if (this.inState(IAgentStateGoingUp.class, IAgentStateUp.class)) {
            return;
        }
        if (this.notInState(IAgentStateDown.class)) {
            throw new ComponentCantStartException("Agent can't start, it is in wrong state (" + this.getState().getFlag() + ") stop() or kill() agent before start()ing.", (Logger)this.log, (IComponent)this);
        }
        this.startMethodCalled = true;
        try {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Starting-paused agent " + this.getComponentId().getToken());
            }
            if (this.jmx != null) {
                this.getJMX().registerJMX();
            }
            if (!this.eventBus.isRunning()) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Event bus is not running, resetting.");
                }
                this.eventBus.reset();
                if (!this.eventBus.isRunning()) {
                    throw new ComponentCantStartException("Event bus reset()ed but it's still not running.", (Logger)this.log, (IComponent)this);
                }
            }
            this.setState(new AgentStateStartingPaused("Sending 'starting-paused' event."));
            this.startFailedTest();
            this.events.startingPausedTransactional();
            this.startFailedTest();
            this.setState(new AgentStateStartingPaused("Calling startPausedAgent()."));
            this.startFailedTest();
            this.startPausedAgent();
            this.startFailedTest();
            this.setState(new AgentStateStartingPaused("Sending 'paused' event."));
            this.startFailedTest();
            this.events.pausedTransactional();
            this.startFailedTest();
            this.setState(new AgentStateStartedPaused("Agent has started into paused state."));
            this.startFailedTest();
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.runningComponents.size() + " component" + (this.runningComponents.size() > 1 ? "s" : "") + " has started along with the agent.");
            }
        }
        catch (Exception e) {
            if (!this.inState(IAgentStateFailed.class) && !this.events.fatalError("Can't start-paused the agent", e)) {
                this.componentFatalError(new FatalErrorEvent<AbstractAgent>(this, "agent's fatal error not propagated"));
            }
            if (e instanceof ComponentCantStartException) {
                throw (ComponentCantStartException)e;
            }
            throw new ComponentCantStartException("Can't start-paused: " + e.getMessage(), (Throwable)e, (Logger)this.log, this);
        }
        finally {
            this.startMethodCalled = false;
        }
    }

    @Override
    public final synchronized void stop() throws ComponentCantStopException {
        if (this.stopMethodCalled) {
            return;
        }
        if (this.inState(IAgentStateGoingDown.class, IAgentStateDown.class, IAgentStateInstantiated.class)) {
            return;
        }
        if (this.inState(IAgentStateGoingUp.class)) {
            throw new ComponentCantStopException("stop() requested during initialization, kill() the agent.", (Logger)this.log, (Object)this);
        }
        if (this.notInState(IAgentStateUp.class)) {
            throw new ComponentCantStopException("Agent can't stop, it is in wrong state (" + this.getState().getFlag() + "), call start() first.", (Logger)this.log, (Object)this);
        }
        this.stopMethodCalled = true;
        try {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Stopping agent " + this.getComponentId().getToken());
            }
            this.setState(new AgentStateStopping("stop() requested, sending 'stopping' event"));
            this.events.stoppingTransactional();
            this.setState(new AgentStateStopping("Calling stopAgent()."));
            this.stopAgent();
            if (this.runningComponents.size() > 1) {
                StringBuffer sb = new StringBuffer();
                boolean first = true;
                for (IComponent component : this.runningComponents.values()) {
                    if (component == this) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(component.getComponentId().getToken());
                    sb.append(":");
                    sb.append(component);
                }
                ComponentCantStopException e = new ComponentCantStopException("Not all components has stopped along with the agent - components that did not send stopped event (id:toString): " + sb.toString(), (Logger)this.log, (Object)this);
                if (!this.events.fatalError(e)) {
                    this.componentFatalError(new FatalErrorEvent<AbstractAgent>(this, "agent's fatal error not propagated"));
                }
                throw e;
            }
            this.setState(new AgentStateStopping("Sending 'stopped' event."));
            this.events.stoppedTransactional();
            this.setState(new AgentStateStopped("Agent stopped."));
            if (this.jmx != null) {
                this.getJMX().unregisterJMX();
            }
            this.getLogger().removeDefaultNetworkHandler();
        }
        catch (Exception e) {
            if (!this.events.fatalError("Can't stop the agent.", e)) {
                this.componentFatalError(new FatalErrorEvent<AbstractAgent>(this, "agent's fatal error not propagated"));
            }
            if (e instanceof ComponentCantStopException) {
                throw (ComponentCantStopException)e;
            }
            throw new ComponentCantStopException("Can't stop.", (Throwable)e, this.log, this);
        }
        finally {
            this.stopMethodCalled = false;
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void kill() {
        if (this.killMethodCalled) {
            return;
        }
        this.killMethodCalled = true;
        try {
            if (this.inState(IAgentStateFailing.class, IAgentStateFailed.class)) {
                return;
            }
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe("Killing agent " + this.getComponentId().getToken());
            }
            try {
                this.setState(new AgentStateFailing("kill() requested, sending fatal error event."));
            }
            finally {
                try {
                    this.events.fatalError("agent kill() requested");
                }
                finally {
                    try {
                        this.setState(new AgentStateFailing("Calling killAgent()."));
                    }
                    finally {
                        try {
                            this.innerKillAgent();
                        }
                        finally {
                            try {
                                this.setState(new AgentStateFailed("Agent killed."));
                            }
                            finally {
                                if (this.jmx != null) {
                                    this.getJMX().unregisterJMX();
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof PogamutException) {
                ((PogamutException)e).logExceptionOnce(this.log);
            } else if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ExceptionToString.process(e));
            }
        }
        finally {
            this.killMethodCalled = false;
            System.gc();
        }
    }

    @Override
    public final synchronized void pause() throws ComponentCantPauseException {
        if (this.pauseMethodCalled) {
            return;
        }
        if (this.inState(IAgentStatePaused.class)) {
            return;
        }
        if (this.notInState(IAgentStateRunning.class)) {
            throw new ComponentCantPauseException("Agent can't pause, it is not in the running state but " + this.getState().getFlag() + ".", (Logger)this.log, (Object)this);
        }
        this.pauseMethodCalled = true;
        try {
            this.setState(new AgentStatePausing("Sending 'pausing' event."));
            this.events.pausingTransactional();
            this.setState(new AgentStatePausing("Calling pauseAgent()."));
            this.pauseAgent();
            this.setState(new AgentStatePausing("Sending 'paused' event."));
            this.events.pausedTransactional();
            this.setState(new AgentStatePaused("Agent paused."));
        }
        catch (Exception e) {
            if (!this.events.fatalError("Can't pause the agent", e)) {
                this.componentFatalError(new FatalErrorEvent<AbstractAgent>(this, "agent's fatal error not propagated"));
            }
            if (e instanceof ComponentCantPauseException) {
                throw (ComponentCantPauseException)e;
            }
            throw new ComponentCantPauseException("Can't pause.", (Throwable)e, this.log, this);
        }
        finally {
            this.pauseMethodCalled = false;
        }
    }

    @Override
    public final synchronized void resume() throws ComponentCantResumeException {
        if (this.resumeMethodCalled) {
            return;
        }
        if (this.inState(IAgentStateRunning.class)) {
            return;
        }
        if (this.notInState(IAgentStatePaused.class)) {
            throw new ComponentCantResumeException("Agent can't resume, it is not in the paused state but " + this.getState().getFlag() + ".", (Logger)this.log, (Object)this);
        }
        this.resumeMethodCalled = true;
        try {
            this.setState(new AgentStateResuming("resume() requested, sending 'resuming' event."));
            this.events.resumingTransactional();
            this.setState(new AgentStateResuming("Calling resumeAgent()."));
            this.resumeAgent();
            this.setState(new AgentStateResuming("Sending 'resumed' event."));
            this.events.resumedTransactional();
            this.setState(new AgentStateResumed("Agent resumed."));
        }
        catch (Exception e) {
            if (!this.events.fatalError("Can't resume the agent.", e)) {
                this.componentFatalError(new FatalErrorEvent<AbstractAgent>(this, "agent's fatal error not propagated"));
            }
            if (e instanceof ComponentCantResumeException) {
                throw (ComponentCantResumeException)e;
            }
            throw new ComponentCantResumeException("Can't resume.", (Throwable)e, this.log, this);
        }
        finally {
            this.resumeMethodCalled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AgentJMXComponents getJMX() {
        if (this.jmx == null) {
            Object object = this.jmxMutex;
            synchronized (object) {
                if (this.jmx == null) {
                    this.jmx = this.createAgentJMX();
                    this.addJMXComponents();
                }
            }
        }
        return this.jmx;
    }

    public IAgentState awaitState(final Class awaitAgentState) throws AgentException {
        IAgentState state = this.getState().getFlag();
        if (awaitAgentState.isAssignableFrom(state.getClass())) {
            return state;
        }
        state = (IAgentState)((Object)new WaitForFlagChange<7>((IFlag<7>)this.agentState, new WaitForFlagChange.IAccept<IAgentState>(){

            @Override
            public boolean accept(IAgentState flagValue) {
                return awaitAgentState.isAssignableFrom(flagValue.getClass()) || flagValue instanceof IAgentStateDown;
            }
        }).await());
        if (awaitAgentState.isAssignableFrom(state.getClass())) {
            return state;
        }
        if (state instanceof IAgentStateDown) {
            return null;
        }
        throw new PogamutException("Agent is in unexpected state, not IAgentStateUp nor IAgentStateDown but " + state + ".", (Logger)this.log, (Object)this);
    }

    public IAgentState awaitState(final Class awaitAgentState, long timeoutMillis) throws AgentException {
        IAgentState state = this.getState().getFlag();
        if (awaitAgentState.isAssignableFrom(state.getClass())) {
            return state;
        }
        state = (IAgentState)((Object)new WaitForFlagChange<8>((IFlag<8>)this.agentState, new WaitForFlagChange.IAccept<IAgentState>(){

            @Override
            public boolean accept(IAgentState flagValue) {
                return awaitAgentState.isAssignableFrom(flagValue.getClass()) || flagValue instanceof IAgentStateDown;
            }
        }).await(timeoutMillis, TimeUnit.MILLISECONDS));
        if (state == null) {
            return null;
        }
        if (awaitAgentState.isAssignableFrom(state.getClass())) {
            return state;
        }
        if (state instanceof IAgentStateDown) {
            return null;
        }
        throw new PogamutException("Agent is in unexpected state, not IAgentStateUp nor IAgentStateDown but " + state + ".", (Logger)this.log, (Object)this);
    }

    @Override
    public final Folder getIntrospection() {
        if (this.folder == null) {
            this.folder = this.createIntrospection();
        }
        return this.folder;
    }

    protected Folder createIntrospection() {
        return new ReflectionObjectFolder(INTROSPECTION_ROOT_NAME, (Object)this);
    }

    protected void startAgent() {
    }

    protected void startPausedAgent() {
    }

    protected void stopAgent() {
    }

    protected void killAgent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerKillAgent() {
        try {
            this.runningComponents.clear();
        }
        finally {
            this.killAgent();
        }
    }

    protected void pauseAgent() {
    }

    protected void resumeAgent() {
    }

    protected void resetAgent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void componentStarted(IStartedEvent event) {
        Object object = this.runningComponents;
        synchronized (object) {
            if (this.runningComponents.containsKey(event.getSource().getComponentId())) {
                return;
            }
            this.runningComponents.put(event.getSource().getComponentId(), (IComponent)event.getSource());
        }
        if (event.getSource() instanceof IJMXEnabled) {
            object = this.getJMX();
            synchronized (object) {
                this.jmx.addComponent((IJMXEnabled)event.getSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void componentStarted(IPausedEvent event) {
        Object object = this.runningComponents;
        synchronized (object) {
            if (this.runningComponents.containsKey(event.getSource().getComponentId())) {
                return;
            }
            this.runningComponents.put(event.getSource().getComponentId(), (IComponent)event.getSource());
        }
        if (event.getSource() instanceof IJMXEnabled) {
            object = this.getJMX();
            synchronized (object) {
                this.jmx.addComponent((IJMXEnabled)event.getSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void componentStopping(IStoppingEvent event) {
        if (this.stopMethodCalled) {
            return;
        }
        HashSetClass hashSetClass = this.stopDependencyToken;
        synchronized (hashSetClass) {
            if (this.stopDependencyToken.contains(event.getSource().getComponentId())) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Component " + event.getSource().getComponentId().getToken() + " that the agent depends on is stopping, stopping agent as well.");
                }
                this.stop();
                return;
            }
        }
        hashSetClass = this.stopDependencyClass;
        synchronized (hashSetClass) {
            Class dependency = this.stopDependencyClass.containsClass(event.getSource().getClass());
            if (dependency != null) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Component of class " + dependency.getSimpleName() + " (id: " + event.getSource().getComponentId().getToken() + ") that tghe agent depends on is stopping, stopping agent as well.");
                }
                this.stop();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void componentStopped(IStoppedEvent event) {
        Map<IToken, IComponent> map = this.runningComponents;
        synchronized (map) {
            this.runningComponents.remove(event.getSource().getComponentId());
            if (this.runningComponents.size() == 0) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("All agent's components has stopped. Stopping agent as well.");
                }
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentFatalError(IFatalErrorEvent event) {
        try {
            this.setState(new AgentStateFailing(event.getMessage() + ", calling killAgent()."));
        }
        finally {
            try {
                this.innerKillAgent();
            }
            finally {
                this.setState(new AgentStateFailed(event.getMessage()));
            }
        }
    }

    protected void resetEvent(IResetEvent event) {
        this.resetAgent();
    }

    protected AgentJMXComponents createAgentJMX() {
        return new AgentJMXComponents<AbstractAgent>(this);
    }

    protected void addDependency(IComponent component) {
        NullCheck.check(component, "component");
        this.addDependency(component.getComponentId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDependency(Class componentClass) {
        NullCheck.check(componentClass, "componentClass");
        HashSetClass hashSetClass = this.stopDependencyClass;
        synchronized (hashSetClass) {
            this.stopDependencyClass.add(componentClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDependency(IToken componentId) {
        NullCheck.check(componentId, "componentId");
        Set<IToken> set = this.stopDependencyToken;
        synchronized (set) {
            this.stopDependencyToken.add(componentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(AgentState state) {
        Flag<IAgentState> flag = this.agentState;
        synchronized (flag) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Agent state is going to be switched to: " + state.toString());
            }
            this.agentState.setFlag(state);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Agent state switched to: " + state.toString());
            }
        }
    }

    protected void addJMXComponents() {
        this.jmx.addComponent(this.logger);
        this.jmx.addComponent(new FolderToIJMXEnabledAdapter(this.getIntrospection()));
    }

    public String toString() {
        if (this == null) {
            return "AbstractAgent[constructing]";
        }
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

