/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.fsm;

import cz.cuni.amis.fsm.FSM;
import cz.cuni.amis.fsm.IFSMState;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSMDotPrinter {
    public static void print(FSM fsm, OutputStream out, String graphName) {
        PrintStream pout = new PrintStream(out);
        pout.println("digraph " + graphName + " {");
        pout.println(" node [shape=Mrecord fillcolor=lightblue style=filled]");
        Iterator i$ = fsm.getStates().iterator();
        while (i$.hasNext()) {
            FSM.StateWrapper state;
            FSM.StateWrapper wrapper = state = i$.next();
            String fromStr = wrapper.getWrappedState().getClass().getSimpleName();
            Iterator i$2 = wrapper.getTransitions().entrySet().iterator();
            while (i$2.hasNext()) {
                Map.Entry transEntryObj;
                Map.Entry transEntry = transEntryObj = i$2.next();
                String symbolStr = transEntry.getKey().getSimpleName();
                FSM.StateWrapper target = transEntry.getValue().getTarget();
                String toStr = target != null ? target.getWrappedState().getClass().getSimpleName() : fromStr;
                pout.println(fromStr + " -> " + toStr + " [label=\"" + symbolStr + "\"];");
            }
        }
        pout.println("}");
    }

    public static void print(Class<IFSMState> initialStateClass, OutputStream out, String graphName) {
        Logger log = Logger.getAnonymousLogger();
        FSM fsm = new FSM(null, initialStateClass, log);
        FSMDotPrinter.print(fsm, out, graphName);
    }

    protected static void printUsage() {
        System.out.println("java cz.cuni.amis.fsm.FSMDotPrinter INIT_STATE [GRAPH_NAME] [FILE]");
        System.out.println();
        System.out.println("Prints a Graphviz dot file showing the FSM.");
        System.out.println();
        System.out.println("INIT_STATE   fully qualified name of the initial state of the FSM");
        System.out.println("GRAPH_NAME   name used for the graphviz graph");
        System.out.println("FILE         output file");
        System.out.println();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length == 0) {
            FSMDotPrinter.printUsage();
            System.exit(-3);
        }
        String className = args[0];
        String graphName = args.length == 1 ? "DefaultGraph" : args[1];
        try {
            Class<IFSMState> stateClass = Class.forName(className);
            if (IFSMState.class.isAssignableFrom(stateClass)) {
                OutputStream out = args.length >= 2 ? new FileOutputStream(args[2]) : System.out;
                FSMDotPrinter.print(stateClass, out, graphName);
                out.close();
                out.close();
                System.exit(0);
            } else {
                System.err.println("The specified class doesn't implement the IFSMState interface, hence it couldn't be used as initial state of the FSM.");
                System.exit(-1);
            }
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Class " + className + " not found. It probably isn't on the classpath.");
            ex.printStackTrace();
            System.exit(-2);
        }
    }
}

