

// generated by yylex.xsl from Core/src/cz/cuni/pogamut/gbmessages/xmlresources/MessageObjectsList.xml, called from ant script build.xml
// file was further processed by JFlex to create class Yylex (yylex.java)

package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import java.io.Reader;

// imports from MessageObjectsList.xml/gbmessages/settings/jflexsettings/javaimport
import java.util.*;
import javax.vecmath.*;
import cz.cuni.amis.pogamut.base.communication.translator.*;
import cz.cuni.amis.pogamut.base.communication.parser.*;
import cz.cuni.amis.pogamut.base.communication.parser.exception.*;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.*;
import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.base.communication.worldview.*;
import cz.cuni.amis.pogamut.base.communication.worldview.event.*;
import cz.cuni.amis.pogamut.base.communication.worldview.object.*;
import cz.cuni.amis.pogamut.base3d.worldview.object.*;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.*;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.parser.*;
import cz.cuni.amis.pogamut.ut2004.communication.messages.*;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Category;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.*;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.*;
import java.lang.reflect.Method;
import cz.cuni.amis.utils.exception.*;



// beggining of the yylex definition
%%

// declare result class Yylex as public
%public

// return type of the yylex() method should be Object
%type InfoMessage

%implements IUT2004Yylex

// default return value should be null
%eofval{
throw new ParserEOFException(this);
%eofval}

// following block is containing code that will be added to the generated lexical parser yylex.java
%{
	
 	public static final String DELIMITERS_STANDARD = " {}";
 	public static final String DELIMITERS_EXTENDED = " {},";

	/** Map for list of String, Double */
	protected Map<Integer, Double> mapIntIDDouble = null;

	/** Map for list of String, Double */
	protected Map<Integer, Double> mapIntDouble = null;
	
	/** parser reference, this parser will be used for translation of UnrealID to IntID */
	protected UnrealIdTranslator translator = null;
	
	/** object that is used to translate type of the message to the */ 
	protected ItemTranslator itemTranslator = null;
	
	/** observer for the yylex for reporting exceptions */	
	protected IYylexObserver observer = null;
	
	/** time in the UT2004 */	
	protected double ut2004Time = 0;
	
	public Yylex(){
	}
	
	public void setReader(Reader reader) {
		yyreset(reader);
	}
	
	public void close() throws java.io.IOException {
		yyclose();
	}
	
	public void setItemTranslator(ItemTranslator translator) {
		this.itemTranslator = translator;
	}
	
	public void setObserver(IYylexObserver observer) {
		this.observer = observer;
	}
	
	/**
	 * Set parser translating UnrealID to IntID.
	 * This function should be called after constructor, I dont know how to define constructor, so this will do.
	 */
	public void setTranslator(UnrealIdTranslator translator) {
		this.translator = translator;
	}
	
	public void setTime(IWorldObject obj, double time) {
		try {
			Method m = obj.getClass().getDeclaredMethod("setTime", new Class[]{double.class});
			m.setAccessible(true);
			m.invoke(obj, ut2004Time);
		} catch (Exception e) {
			exceptionOccured(e, "can't set Time to message " + obj.getClass());
		}
	}
	
	/**
	 * Logs the exception if observer present, or print it to System.out.
	 * <BR><BR>
	 * Does not throw the exception...
	 * <BR><BR>
	 * If exception 'e' is null, only info message is written to logs.
	 * @param e
	 * @param info	 
	 */
	protected void exceptionOccured(Exception e, String info) {
		IYylexObserver currentObserver = this.observer;
		if (currentObserver != null) {			
			currentObserver.exception(e, info != null ? info : "--empty info--");
		} else {
			System.out.println("Yylex exception: " + info);
			if (e != null) e.printStackTrace(); 
		}
	} 
	
	/**
	 * Send the warning to observer or prints it to the console.
	 */
	protected void warning(String info) {
		IYylexObserver currentObserver = this.observer;
		if (currentObserver != null) {			
			currentObserver.warning(info != null ? info : "--empty warning--");
		} else {
			System.out.println("Yylex warning: " + info);			 
		}
	}
	
	/**
	 * Returns 'num'-th token from 'text' using 'delimiters'.
	 * <BR><BR>
	 * Use only IFF you're getting only one token from 'text'.
	 * @param text
	 * @param delimiters
	 * @return String token
	 */ 
	protected String getToken(String text, String delimiters, int num) {
		StringTokenizer st = new StringTokenizer(text, delimiters);
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		try {
			return st.nextToken();
		} catch (Exception e) {
			exceptionOccured(e, "Can't get " + num + "-th token from text '"+text+"' using delimiters '"+delimiters+"'.");
			return null;
		}
	}
	
	/**
	 * Returns 'num'-th token from 'text' using DELIMITERS_STANDARD.
	 * <BR><BR>
	 * Use only IFF you're getting only one token from 'text'.
	 * @param text
	 * @return String token
	 */ 
	protected String getToken(String text, int num) {
		return getToken(text, DELIMITERS_STANDARD, num);		
	}

	/**
	 * Return an integer from num token in txt.
	 * <BR><BR>
	 * Integer token is expected to be 'second token' in the 'txt' using delimiters " {}".
	 * 
	 * @param  txt  text of parameter
	 * @return Integer from given token.
	 */
	protected int intValue( String txt  ) {
		try {
        	return Integer.parseInt(getToken(txt, 1));
        } catch (NullPointerException e) {
        	warning("Can't get int token from text '"+txt+"'.");
        	return -1;
        } catch (NumberFormatException e) {
        	exceptionOccured(e, "Wrong int number format in '"+txt+".");
        	return -1; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get int token from text '"+txt+"'.");
        	return -1;
        }
	}

	
	/**
	 * Return a double from num token in txt.
	 * <BR><BR>
	 * Num token is expected to be 'second token' in the 'txt' using delimiters " {}".	 
	 * 
	 * @param  txt  text of parameter
	 * @return Double from given token.
	 */
	protected double doubleValue(String txt) {
		try {
        	return Double.parseDouble(getToken(txt, 1));
        } catch (NullPointerException e) {
        	warning("Can't get double token from text '"+txt+"'.");
        	return -1;
        } catch (NumberFormatException e) {
        	exceptionOccured(e, "Wrong double number format in '"+txt+".");
        	return -1; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get double token from text '"+txt+"'.");
        	return -1;
        }
	}
	
	/**
	 * Return a float from num token in txt.
	 * <BR><BR>
	 * Num token is expected to be 'second token' in the 'txt' using delimiters " {}".	 
	 * 
	 * @param  txt  text of parameter
	 * @return Float from given token.
	 */
	protected float floatValue(String txt) {
		try {
        	return Float.parseFloat(getToken(txt, 1));
        } catch (NullPointerException e) {
        	warning("Can't get float token from text '"+txt+"'.");
        	return -1;
        } catch (NumberFormatException e) {
        	exceptionOccured(e, "Wrong float number format in '"+txt+".");
        	return -1; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get float token from text '"+txt+"'.");
        	return -1;
        }
	}
	
        /**
	 * Return a triple (double[]{x,y,z})
	 * starting from num token(tokens are separated by space) in 'txt'
	 * 
	 * @param  txt  text of parameter
	 * @return Array of three doubles from given token.
	 */
	protected double[] getTriple( String txt ) {
		StringTokenizer st = new StringTokenizer(txt, DELIMITERS_EXTENDED);
		
		int num = 1;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		// now we should have an token with integer
		try {
			double t1,t2,t3;
			t1 = new Double(st.nextToken()).doubleValue();
			t2 = new Double(st.nextToken()).doubleValue();
			t3 = new Double(st.nextToken()).doubleValue();
        	return new double[]{t1,t2,t3};
        } catch (NumberFormatException e) {
        	exceptionOccured(e, "Wrong double number format in '"+txt+".");
        	return null; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get triple from text '"+txt+"'.");
        	return null;
        }
	}
	
	/**
	 * Return a Location instance starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @return Location from given token.
	 */
	protected Location locationValue(String txt) {
		double[] triple = getTriple(txt);
		try {
			return new Location(triple[0], triple[1], triple[2]);
		} catch (NullPointerException e) {
			warning("Can't get Location from text '"+txt+"'.");
			return new Location();
		} catch (Exception e) {
			exceptionOccured(e, "Can't get Location from text '"+txt+"'.");
			return null;
		}
	}
	
	/**
     * Return an ItemType instance.
     * 
     * @param  txt  text of parameter
     * @return ItemType from given token.
     */
    protected ItemType itemTypeValue(String txt) {
        return ItemType.getItemType(getToken(txt, 1));
    }
    
    protected ItemDescriptor itemDescriptorValue(ItemType type) {
    	return itemTranslator.getDescriptor(type);
    }
    
    /**
     * Return a Category of the item.
     * @param  txt  text of parameter
     * @return ItemType.Category from given token.
     */ 
    protected ItemType.Category categoryValue(String txt) {
    	try {
    		return ItemType.Category.valueOf(getToken(txt, 1).toUpperCase());
    	} catch (IllegalArgumentException e) {
    		return ItemType.Category.OTHER;
    	}
    }
	
	/**
	 * Return a Velocity instance starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @return Velocity from given token.
	 */
	protected Velocity velocityValue(String txt) {
		double[] triple = getTriple(txt);
		try {
			return new Velocity(triple[0], triple[1], triple[2]);
		} catch (NullPointerException e) {
			warning("Can't get Velocity from text '"+txt+"'.");
			return new Velocity();
		} catch (Exception e) {
			exceptionOccured(e, "Can't get Velocity from text '"+txt+"'.");
			return null;
		}
	}

	/**
	 * Return a Rotation instance starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @return Rotation from given token.
	 */
	protected Rotation rotationValue(String txt) {
		double[] triple = getTriple(txt);
		try {
			return new Rotation(triple[0], triple[1], triple[2]);
		} catch (NullPointerException e) {
			warning("Can't get Rotation from text '"+txt+"'.");
			return new Rotation();
		} catch (Exception e) {
			exceptionOccured(e, "Can't get Rotation from text '"+txt+"'.");
			return null;
		}
	}
	
	/**
	 * Return a Point3d instance starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @return Point3d from given token.
	 */
	protected Point3d point3dValue(String txt) {
		double[] triple = getTriple(txt);
		try {
			return new Point3d(triple[0], triple[1], triple[2]);
		} catch (NullPointerException e) {
			warning("Can't get Point3d from text '"+txt+"'.");
        	return new Point3d(0,0,0);
		} catch (Exception e) {
        	exceptionOccured(e, "Can't get Point3d from text '"+txt+"'.");
        	return null;
        }
	}
	
	/**
	 * Return a Vector3d instance starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @return Vector3d from given token.
	 */
	protected Vector3d vector3dValue(String txt) {
		double[] triple = getTriple(txt);
		try {
			return new Vector3d(triple[0], triple[1], triple[2]);
		} catch (NullPointerException e) {
			warning("Can't get Vector3d from text '"+txt+"'.");
        	return new Vector3d(0,0,0);
		} catch (Exception e) {
        	exceptionOccured(e, "Can't get Vector3d from text '"+txt+"'.");
        	return null;
        }
	}
	
	/**
	 * Returns string for parsed token.
	 *	 
	 * @param  txt  text of parameter
	 * @return String from given token.
	 */
	protected String stringValue( String txt ) {
		try {
        	int index = txt.indexOf(" ");
			if (index == -1) {
				warning("Can't get string token from text '" + txt + "'.");
				return "";
			}
			String string = txt.substring(index+1, txt.length()-1);
        	if (string != null) {
				return string;        	        		
        	} else {
        		warning("Can't get string token from text '"+txt+"'.");
        		return "";
        	}
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get string token from text '"+txt+"'.");
        	return "";
        }
	}
	
	/**
	 * Returns UnrealId for parsed token.
	 *	 
	 * @param  txt  text of parameter
	 * @return StringId from given token.
	 */
	protected UnrealId stringIdValue( String txt ) {
		return unrealIdValue(txt);				
	}
	
	/**
	 * Return a boolean from boolean token in txt.
	 * <BR><BR>
	 * Boolean token is expected to be 'second token' in the 'txt' using delimiters " {}".	 
	 * 
	 * @param  txt  text of parameter
	 * @return Boolean from given token.
	 */
	protected boolean booleanValue(String txt) {
		try {
        	String token = getToken(txt, 1);
        	if (token.equals("True")) return true;
        	else return false;
        } catch (NullPointerException e) {
        	warning("Can't get boolean token from text '"+txt+"'.");
        	return false; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get boolean token from text '"+txt+"'.");
        	return false;
        }
	}
	
	/**
	 * Return an UnrealId instance from identificator token in txt.
	 * <BR><BR>
	 * Boolean token is expected to be 'second token' in the 'txt' using delimiters " {}".	 
	 * 
	 * @param  txt  text of parameter
	 * @return UnrealId from given token.
	 */
	protected UnrealId unrealIdValue(String txt) {
		try {
        	String token = getToken(txt, 1);
        	if (token == null) {
        		warning("Can't get UnrealId token from text '"+txt+"'.");
        		return null;
        	}
        	return translator.getId(token);
        } catch (NullPointerException e) {
        	warning("Can't get UnrealId token from text '"+txt+"' (translator not set?).");
        	return null; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get UnrealId token from text '"+txt+"'.");
        	return null;
        }
	}
		
    // this is stack with static size, so it can overflow... theoreticly... No.
    private int[] stack = new int[10];
    private int stack_pos = 0;
  
 	// actual object that is being parsed 
    protected Object actObj;
  
    /**
     * Change state to state and push original state to stack, so parser can return in state_return
     */
    private void state_go(int state)
    {
  	    stack[stack_pos++] = yystate();
  	    yybegin(state);
    }
  
    /**
     * Return to previous state.
     */
    private void state_return()
    {
  	    yybegin(stack[--stack_pos]);
    }
%} 

%line
%char
%state DUMMY, MSG_AIN, MSG_ADG, MSG_ALIVE, MSG_ANIMATIONBOTID, MSG_CHANGEANIM, MSG_ANIMPORT, MSG_ANIMATIONSTOPPED, MSG_ATR, MSG_BEG, MSG_BOM, MSG_DAM, MSG_DIE, MSG_BMP, MSG_CWP, MSG_COMBO, MSG_CONFCH, MSG_DLGCMD, MSG_DFAIL, MSG_DOK, MSG_DOM, MSG_END, MSG_ENTERED, MSG_USED, MSG_FAL, MSG_FTR, MSG_FLG, MSG_NFO, MSG_PAUSED, MSG_RESUMED, MSG_VMS, MSG_EHS, MSG_SHS, MSG_HRN, MSG_HRP, MSG_HELLO_BOT, MSG_HELLO_CONTROL_SERVER, MSG_HELLO_OBSERVER, MSG_PRJ, MSG_INITED, MSG_INV, MSG_ITC, MSG_EITC, MSG_SITC, MSG_EINV, MSG_SINV, MSG_IPK, MSG_JUMP, MSG_KEYEVENT, MSG_LAND, MSG_LOCKED, MSG_LOSTCHILD, MSG_LIN, MSG_MAPCHANGE, MSG_FIN, MSG_IMAP, MSG_EMAP, MSG_SMAP, MSG_MOV, MSG_EMOV, MSG_SMOV, MSG_MUT, MSG_EMUT, MSG_SMUT, MSG_MYINV, MSG_EMYINV, MSG_SMYINV, MSG_NAV, MSG_ENAV, MSG_SNAV, MSG_INGP, MSG_ENGP, MSG_SNGP, MSG_SEL, MSG_PASSWDOK, MSG_PASSWDWRONG, MSG_PASSWORD, MSG_IPTH, MSG_EPTH, MSG_SPTH, MSG_PLR, MSG_HIT, MSG_PLI, MSG_JOIN, MSG_KIL, MSG_LEFT, MSG_EPLR, MSG_SPLR, MSG_PLS, MSG_PONG, MSG_RCH, MSG_RECEND, MSG_RECSTART, MSG_SLF, MSG_SHOOT, MSG_STOPSHOOT, MSG_SPW, MSG_TEAMCHANGE, MSG_VMT, MSG_TES, MSG_THROWN, MSG_TRC, MSG_TRG, MSG_VEH, MSG_VCH, MSG_WAL, MSG_WUP, MSG_ZCB
%full
%standalone

ALPHA=[A-Za-z]
ALPHA_NUMERIC={ALPHA}|{DIGIT}
SEP=[_\-.]
ALPHA_NUMERIC_SEP = {ALPHA}|{DIGIT}|{SEP}
UNREALID={ALPHA_NUMERIC_SEP}+

DIGIT=[0-9]
NONNEWLINE_WHITE_SPACE_CHAR=[\ \t\b\012]
NEWLINE=\r|\n|\r\n
WHITE_SPACE_CHAR=[\n\r\ \t\b\012]
UINT = {DIGIT}+

FLit1    = {DIGIT}+ \. {DIGIT}* 
FLit2    = \. {DIGIT}+ 
FLit3    = {DIGIT}+

INT = \-? {UINT}
FLOAT    = \-?({FLit1}|{FLit2}|{FLit3})
DOUBLE   = \-?({FLit1}|{FLit2}|{FLit3})
STRING=[^}]* 
STRINGID=[^}]+
ITEMTYPE = [^}]+
CATEGORY = [^}]+
POINT3D = {FLOAT} \, {FLOAT} \, {FLOAT}
VECTOR3D = {FLOAT} \, {FLOAT} \, {FLOAT}
LOCATION = {FLOAT} \, {FLOAT} \, {FLOAT}
VELOCITY = {FLOAT} \, {FLOAT} \, {FLOAT}
ROTATION = {FLOAT} \, {FLOAT} \, {FLOAT}
BOOLEAN = "True" | "False" | "true" | "false" | "Falso" | "falso"
SPACE= " "

%% 

<YYINITIAL> {


  "AIN" {
  	actObj = new AddInventoryMsg();
  	state_go(MSG_AIN);
  }

  "ADG" {
  	actObj = new AdrenalineGained();
  	state_go(MSG_ADG);
  }

  "ALIVE" {
  	actObj = new AliveMessage();
  	state_go(MSG_ALIVE);
  }

  "ANIMATIONBOTID" {
  	actObj = new AnimationBotID();
  	state_go(MSG_ANIMATIONBOTID);
  }

  "CHANGEANIM" {
  	actObj = new AnimationChange();
  	state_go(MSG_CHANGEANIM);
  }

  "ANIMPORT" {
  	actObj = new AnimationPort();
  	state_go(MSG_ANIMPORT);
  }

  "ANIMATIONSTOPPED" {
  	actObj = new AnimationStop();
  	state_go(MSG_ANIMATIONSTOPPED);
  }

  "ATR" {
  	actObj = new AutoTraceRay();
  	state_go(MSG_ATR);
  }

  "BEG" {
  	actObj = new BeginMessage();
  	state_go(MSG_BEG);
  }

  "BOM" {
  	actObj = new BombInfo();
  	state_go(MSG_BOM);
  }

  "DAM" {
  	actObj = new BotDamaged();
  	state_go(MSG_DAM);
  }

  "DIE" {
  	actObj = new BotKilled();
  	state_go(MSG_DIE);
  }

  "BMP" {
  	actObj = new Bumped();
  	state_go(MSG_BMP);
  }

  "CWP" {
  	actObj = new ChangedWeapon();
  	state_go(MSG_CWP);
  }

  "COMBO" {
  	actObj = new ComboStarted();
  	state_go(MSG_COMBO);
  }

  "CONFCH" {
  	actObj = new ConfigChange();
  	state_go(MSG_CONFCH);
  }

  "DLGCMD" {
  	actObj = new DialogCommand();
  	state_go(MSG_DLGCMD);
  }

  "DFAIL" {
  	actObj = new DialogFailed();
  	state_go(MSG_DFAIL);
  }

  "DOK" {
  	actObj = new DialogOk();
  	state_go(MSG_DOK);
  }

  "DOM" {
  	actObj = new DominationPoint();
  	state_go(MSG_DOM);
  }

  "END" {
  	actObj = new EndMessage();
  	state_go(MSG_END);
  }

  "ENTERED" {
  	actObj = new EnteredVehicle();
  	state_go(MSG_ENTERED);
  }

  "USED" {
  	actObj = new FactoryUsed();
  	state_go(MSG_USED);
  }

  "FAL" {
  	actObj = new FallEdge();
  	state_go(MSG_FAL);
  }

  "FTR" {
  	actObj = new FastTraceResponse();
  	state_go(MSG_FTR);
  }

  "FLG" {
  	actObj = new FlagInfo();
  	state_go(MSG_FLG);
  }

  "NFO" {
  	actObj = new GameInfo();
  	state_go(MSG_NFO);
  }

  "PAUSED" {
  	actObj = new GamePaused();
  	state_go(MSG_PAUSED);
  }

  "RESUMED" {
  	actObj = new GameResumed();
  	state_go(MSG_RESUMED);
  }

  "VMS" {
  	actObj = new GlobalChat();
  	state_go(MSG_VMS);
  }

  "EHS" {
  	actObj = new HandShakeEnd();
  	state_go(MSG_EHS);
  }

  "SHS" {
  	actObj = new HandShakeStart();
  	state_go(MSG_SHS);
  }

  "HRN" {
  	actObj = new HearNoise();
  	state_go(MSG_HRN);
  }

  "HRP" {
  	actObj = new HearPickup();
  	state_go(MSG_HRP);
  }

  "HELLO_BOT" {
  	actObj = new HelloBotHandshake();
  	state_go(MSG_HELLO_BOT);
  }

  "HELLO_CONTROL_SERVER" {
  	actObj = new HelloControlServerHandshake();
  	state_go(MSG_HELLO_CONTROL_SERVER);
  }

  "HELLO_OBSERVER" {
  	actObj = new HelloObserverHandshake();
  	state_go(MSG_HELLO_OBSERVER);
  }

  "PRJ" {
  	actObj = new IncomingProjectile();
  	state_go(MSG_PRJ);
  }

  "INITED" {
  	actObj = new InitedMessage();
  	state_go(MSG_INITED);
  }

  "INV" {
  	actObj = new Item();
  	state_go(MSG_INV);
  }

  "ITC" {
  	actObj = new ItemCategory();
  	state_go(MSG_ITC);
  }

  "EITC" {
  	actObj = new ItemCategoryEnd();
  	state_go(MSG_EITC);
  }

  "SITC" {
  	actObj = new ItemCategoryStart();
  	state_go(MSG_SITC);
  }

  "EINV" {
  	actObj = new ItemListEnd();
  	state_go(MSG_EINV);
  }

  "SINV" {
  	actObj = new ItemListStart();
  	state_go(MSG_SINV);
  }

  "IPK" {
  	actObj = new ItemPickedUp();
  	state_go(MSG_IPK);
  }

  "JUMP" {
  	actObj = new JumpPerformed();
  	state_go(MSG_JUMP);
  }

  "KEYEVENT" {
  	actObj = new KeyEvent();
  	state_go(MSG_KEYEVENT);
  }

  "LAND" {
  	actObj = new Landed();
  	state_go(MSG_LAND);
  }

  "LOCKED" {
  	actObj = new LockedVehicle();
  	state_go(MSG_LOCKED);
  }

  "LOSTCHILD" {
  	actObj = new LostChild();
  	state_go(MSG_LOSTCHILD);
  }

  "LIN" {
  	actObj = new LostInventory();
  	state_go(MSG_LIN);
  }

  "MAPCHANGE" {
  	actObj = new MapChange();
  	state_go(MSG_MAPCHANGE);
  }

  "FIN" {
  	actObj = new MapFinished();
  	state_go(MSG_FIN);
  }

  "IMAP" {
  	actObj = new MapList();
  	state_go(MSG_IMAP);
  }

  "EMAP" {
  	actObj = new MapListEnd();
  	state_go(MSG_EMAP);
  }

  "SMAP" {
  	actObj = new MapListStart();
  	state_go(MSG_SMAP);
  }

  "MOV" {
  	actObj = new Mover();
  	state_go(MSG_MOV);
  }

  "EMOV" {
  	actObj = new MoverListEnd();
  	state_go(MSG_EMOV);
  }

  "SMOV" {
  	actObj = new MoverListStart();
  	state_go(MSG_SMOV);
  }

  "MUT" {
  	actObj = new Mutator();
  	state_go(MSG_MUT);
  }

  "EMUT" {
  	actObj = new MutatorListEnd();
  	state_go(MSG_EMUT);
  }

  "SMUT" {
  	actObj = new MutatorListStart();
  	state_go(MSG_SMUT);
  }

  "MYINV" {
  	actObj = new MyInventory();
  	state_go(MSG_MYINV);
  }

  "EMYINV" {
  	actObj = new MyInventoryEnd();
  	state_go(MSG_EMYINV);
  }

  "SMYINV" {
  	actObj = new MyInventoryStart();
  	state_go(MSG_SMYINV);
  }

  "NAV" {
  	actObj = new NavPoint();
  	state_go(MSG_NAV);
  }

  "ENAV" {
  	actObj = new NavPointListEnd();
  	state_go(MSG_ENAV);
  }

  "SNAV" {
  	actObj = new NavPointListStart();
  	state_go(MSG_SNAV);
  }

  "INGP" {
  	actObj = new NavPointNeighbourLink();
  	state_go(MSG_INGP);
  }

  "ENGP" {
  	actObj = new NavPointNeighbourLinkEnd();
  	state_go(MSG_ENGP);
  }

  "SNGP" {
  	actObj = new NavPointNeighbourLinkStart();
  	state_go(MSG_SNGP);
  }

  "SEL" {
  	actObj = new ObjectSelected();
  	state_go(MSG_SEL);
  }

  "PASSWDOK" {
  	actObj = new PasswdOk();
  	state_go(MSG_PASSWDOK);
  }

  "PASSWDWRONG" {
  	actObj = new PasswdWrong();
  	state_go(MSG_PASSWDWRONG);
  }

  "PASSWORD" {
  	actObj = new Password();
  	state_go(MSG_PASSWORD);
  }

  "IPTH" {
  	actObj = new PathList();
  	state_go(MSG_IPTH);
  }

  "EPTH" {
  	actObj = new PathListEnd();
  	state_go(MSG_EPTH);
  }

  "SPTH" {
  	actObj = new PathListStart();
  	state_go(MSG_SPTH);
  }

  "PLR" {
  	actObj = new Player();
  	state_go(MSG_PLR);
  }

  "HIT" {
  	actObj = new PlayerDamaged();
  	state_go(MSG_HIT);
  }

  "PLI" {
  	actObj = new PlayerInput();
  	state_go(MSG_PLI);
  }

  "JOIN" {
  	actObj = new PlayerJoinsGame();
  	state_go(MSG_JOIN);
  }

  "KIL" {
  	actObj = new PlayerKilled();
  	state_go(MSG_KIL);
  }

  "LEFT" {
  	actObj = new PlayerLeft();
  	state_go(MSG_LEFT);
  }

  "EPLR" {
  	actObj = new PlayerListEnd();
  	state_go(MSG_EPLR);
  }

  "SPLR" {
  	actObj = new PlayerListStart();
  	state_go(MSG_SPLR);
  }

  "PLS" {
  	actObj = new PlayerScore();
  	state_go(MSG_PLS);
  }

  "PONG" {
  	actObj = new Pong();
  	state_go(MSG_PONG);
  }

  "RCH" {
  	actObj = new Reachable();
  	state_go(MSG_RCH);
  }

  "RECEND" {
  	actObj = new RecordingEnded();
  	state_go(MSG_RECEND);
  }

  "RECSTART" {
  	actObj = new RecordingStarted();
  	state_go(MSG_RECSTART);
  }

  "SLF" {
  	actObj = new Self();
  	state_go(MSG_SLF);
  }

  "SHOOT" {
  	actObj = new ShootingStarted();
  	state_go(MSG_SHOOT);
  }

  "STOPSHOOT" {
  	actObj = new ShootingStopped();
  	state_go(MSG_STOPSHOOT);
  }

  "SPW" {
  	actObj = new Spawn();
  	state_go(MSG_SPW);
  }

  "TEAMCHANGE" {
  	actObj = new TeamChanged();
  	state_go(MSG_TEAMCHANGE);
  }

  "VMT" {
  	actObj = new TeamChat();
  	state_go(MSG_VMT);
  }

  "TES" {
  	actObj = new TeamScore();
  	state_go(MSG_TES);
  }

  "THROWN" {
  	actObj = new Thrown();
  	state_go(MSG_THROWN);
  }

  "TRC" {
  	actObj = new TraceResponse();
  	state_go(MSG_TRC);
  }

  "TRG" {
  	actObj = new Trigger();
  	state_go(MSG_TRG);
  }

  "VEH" {
  	actObj = new Vehicle();
  	state_go(MSG_VEH);
  }

  "VCH" {
  	actObj = new VolumeChanged();
  	state_go(MSG_VCH);
  }

  "WAL" {
  	actObj = new WallCollision();
  	state_go(MSG_WAL);
  }

  "WUP" {
  	actObj = new WeaponUpdate();
  	state_go(MSG_WUP);
  }

  "ZCB" {
  	actObj = new ZoneChangedBot();
  	state_go(MSG_ZCB);
  }


}



<MSG_AIN> {
  	
			"{Id " {UNREALID} "}" {
				((AddInventoryMsg)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Type " {STRING} "}" {
				((AddInventoryMsg)actObj).Type = stringValue(yytext());
				
			}
		
			"{PickupType " {ITEMTYPE} "}" {
				((AddInventoryMsg)actObj).PickupType = itemTypeValue(yytext());
				
					((AddInventoryMsg)actObj).Descriptor = itemDescriptorValue(((AddInventoryMsg)actObj).PickupType);
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_AIN unprocessed: " + yytext());
		}
  	}
}

<MSG_ADG> {
  	
			"{Amount " {INT} "}" {
				((AdrenalineGained)actObj).Amount = intValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ADG unprocessed: " + yytext());
		}
  	}
}

<MSG_ALIVE> {
  	
			"{Time " {DOUBLE} "}" {
				((AliveMessage)actObj).Time = doubleValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ALIVE unprocessed: " + yytext());
		}
  	}
}

<MSG_ANIMATIONBOTID> {
  	
			"{id " {INT} "}" {
				((AnimationBotID)actObj).id = intValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ANIMATIONBOTID unprocessed: " + yytext());
		}
  	}
}

<MSG_CHANGEANIM> {
  	
			"{Name " {STRING} "}" {
				((AnimationChange)actObj).Name = stringValue(yytext());
				
			}
		
			"{AnimStart " {BOOLEAN} "}" {
				((AnimationChange)actObj).AnimStart = booleanValue(yytext());
				
			}
		
			"{AnimEnd " {BOOLEAN} "}" {
				((AnimationChange)actObj).AnimEnd = booleanValue(yytext());
				
			}
		
			"{Time " {DOUBLE} "}" {
				((AnimationChange)actObj).Time = doubleValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_CHANGEANIM unprocessed: " + yytext());
		}
  	}
}

<MSG_ANIMPORT> {
  	
			"{Port " {INT} "}" {
				((AnimationPort)actObj).Port = intValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ANIMPORT unprocessed: " + yytext());
		}
  	}
}

<MSG_ANIMATIONSTOPPED> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ANIMATIONSTOPPED unprocessed: " + yytext());
		}
  	}
}

<MSG_ATR> {
  	
			"{Id " {UNREALID} "}" {
				((AutoTraceRay)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{From " {LOCATION} "}" {
				((AutoTraceRay)actObj).From = locationValue(yytext());
				
			}
		
			"{To " {LOCATION} "}" {
				((AutoTraceRay)actObj).To = locationValue(yytext());
				
			}
		
			"{FastTrace " {BOOLEAN} "}" {
				((AutoTraceRay)actObj).FastTrace = booleanValue(yytext());
				
			}
		
			"{FloorCorrection " {BOOLEAN} "}" {
				((AutoTraceRay)actObj).FloorCorrection = booleanValue(yytext());
				
			}
		
			"{Result " {BOOLEAN} "}" {
				((AutoTraceRay)actObj).Result = booleanValue(yytext());
				
			}
		
			"{HitNormal " {VECTOR3D} "}" {
				((AutoTraceRay)actObj).HitNormal = vector3dValue(yytext());
				
			}
		
			"{HitLocation " {LOCATION} "}" {
				((AutoTraceRay)actObj).HitLocation = locationValue(yytext());
				
			}
		
			"{TraceActors " {BOOLEAN} "}" {
				((AutoTraceRay)actObj).TraceActors = booleanValue(yytext());
				
			}
		
			"{HitId " {UNREALID} "}" {
				((AutoTraceRay)actObj).HitId = unrealIdValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ATR unprocessed: " + yytext());
		}
  	}
}

<MSG_BEG> {
  	
			"{Time " {DOUBLE} "}" {
				((BeginMessage)actObj).Time = doubleValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_BEG unprocessed: " + yytext());
		}
  	}
}

<MSG_BOM> {
  	
			"{Id " {UNREALID} "}" {
				((BombInfo)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((BombInfo)actObj).Location = locationValue(yytext());
				
			}
		
			"{Holder " {UNREALID} "}" {
				((BombInfo)actObj).Holder = unrealIdValue(yytext());
				
			}
		
			"{HolderTeam " {INT} "}" {
				((BombInfo)actObj).HolderTeam = intValue(yytext());
				
			}
		
			"{Reachable " {BOOLEAN} "}" {
				((BombInfo)actObj).Reachable = booleanValue(yytext());
				
			}
		
			"{Visible " {BOOLEAN} "}" {
				((BombInfo)actObj).Visible = booleanValue(yytext());
				
			}
		
			"{State " {STRING} "}" {
				((BombInfo)actObj).State = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_BOM unprocessed: " + yytext());
		}
  	}
}

<MSG_DAM> {
  	
			"{Damage " {INT} "}" {
				((BotDamaged)actObj).Damage = intValue(yytext());
				
			}
		
			"{DamageType " {STRING} "}" {
				((BotDamaged)actObj).DamageType = stringValue(yytext());
				
			}
		
			"{WeaponName " {STRING} "}" {
				((BotDamaged)actObj).WeaponName = stringValue(yytext());
				
			}
		
			"{Flaming " {BOOLEAN} "}" {
				((BotDamaged)actObj).Flaming = booleanValue(yytext());
				
			}
		
			"{CausedByWorld " {BOOLEAN} "}" {
				((BotDamaged)actObj).CausedByWorld = booleanValue(yytext());
				
			}
		
			"{DirectDamage " {BOOLEAN} "}" {
				((BotDamaged)actObj).DirectDamage = booleanValue(yytext());
				
			}
		
			"{BulletHit " {BOOLEAN} "}" {
				((BotDamaged)actObj).BulletHit = booleanValue(yytext());
				
			}
		
			"{VehicleHit " {BOOLEAN} "}" {
				((BotDamaged)actObj).VehicleHit = booleanValue(yytext());
				
			}
		
			"{Instigator " {UNREALID} "}" {
				((BotDamaged)actObj).Instigator = unrealIdValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_DAM unprocessed: " + yytext());
		}
  	}
}

<MSG_DIE> {
  	
			"{Killer " {UNREALID} "}" {
				((BotKilled)actObj).Killer = unrealIdValue(yytext());
				
			}
		
			"{DamageType " {STRING} "}" {
				((BotKilled)actObj).DamageType = stringValue(yytext());
				
			}
		
			"{DeathString " {STRING} "}" {
				((BotKilled)actObj).DeathString = stringValue(yytext());
				
			}
		
			"{WeaponName " {STRING} "}" {
				((BotKilled)actObj).WeaponName = stringValue(yytext());
				
			}
		
			"{Flaming " {BOOLEAN} "}" {
				((BotKilled)actObj).Flaming = booleanValue(yytext());
				
			}
		
			"{CausedByWorld " {BOOLEAN} "}" {
				((BotKilled)actObj).CausedByWorld = booleanValue(yytext());
				
			}
		
			"{DirectDamage " {BOOLEAN} "}" {
				((BotKilled)actObj).DirectDamage = booleanValue(yytext());
				
			}
		
			"{BulletHit " {BOOLEAN} "}" {
				((BotKilled)actObj).BulletHit = booleanValue(yytext());
				
			}
		
			"{VehicleHit " {BOOLEAN} "}" {
				((BotKilled)actObj).VehicleHit = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_DIE unprocessed: " + yytext());
		}
  	}
}

<MSG_BMP> {
  	
			"{Id " {UNREALID} "}" {
				((Bumped)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((Bumped)actObj).Location = locationValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_BMP unprocessed: " + yytext());
		}
  	}
}

<MSG_CWP> {
  	
			"{Id " {STRING} "}" {
				((ChangedWeapon)actObj).Id = stringValue(yytext());
				
			}
		
			"{PrimaryAmmo " {INT} "}" {
				((ChangedWeapon)actObj).PrimaryAmmo = intValue(yytext());
				
			}
		
			"{SecondaryAmmo " {INT} "}" {
				((ChangedWeapon)actObj).SecondaryAmmo = intValue(yytext());
				
			}
		
			"{Type " {STRING} "}" {
				((ChangedWeapon)actObj).Type = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_CWP unprocessed: " + yytext());
		}
  	}
}

<MSG_COMBO> {
  	
			"{Type " {STRING} "}" {
				((ComboStarted)actObj).Type = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_COMBO unprocessed: " + yytext());
		}
  	}
}

<MSG_CONFCH> {
  	
			"{Id " {UNREALID} "}" {
				((ConfigChange)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{BotId " {UNREALID} "}" {
				((ConfigChange)actObj).BotId = unrealIdValue(yytext());
				
			}
		
			"{ManualSpawn " {BOOLEAN} "}" {
				((ConfigChange)actObj).ManualSpawn = booleanValue(yytext());
				
			}
		
			"{AutoTrace " {BOOLEAN} "}" {
				((ConfigChange)actObj).AutoTrace = booleanValue(yytext());
				
			}
		
			"{Name " {STRING} "}" {
				((ConfigChange)actObj).Name = stringValue(yytext());
				
			}
		
			"{SpeedMultiplier " {DOUBLE} "}" {
				((ConfigChange)actObj).SpeedMultiplier = doubleValue(yytext());
				
			}
		
			"{RotationRate " {ROTATION} "}" {
				((ConfigChange)actObj).RotationRate = rotationValue(yytext());
				
			}
		
			"{Invulnerable " {BOOLEAN} "}" {
				((ConfigChange)actObj).Invulnerable = booleanValue(yytext());
				
			}
		
			"{VisionTime " {DOUBLE} "}" {
				((ConfigChange)actObj).VisionTime = doubleValue(yytext());
				
			}
		
			"{ShowDebug " {BOOLEAN} "}" {
				((ConfigChange)actObj).ShowDebug = booleanValue(yytext());
				
			}
		
			"{ShowFocalPoint " {BOOLEAN} "}" {
				((ConfigChange)actObj).ShowFocalPoint = booleanValue(yytext());
				
			}
		
			"{DrawTraceLines " {BOOLEAN} "}" {
				((ConfigChange)actObj).DrawTraceLines = booleanValue(yytext());
				
			}
		
			"{SynchronousOff " {BOOLEAN} "}" {
				((ConfigChange)actObj).SynchronousOff = booleanValue(yytext());
				
			}
		
			"{AutoPickupOff " {BOOLEAN} "}" {
				((ConfigChange)actObj).AutoPickupOff = booleanValue(yytext());
				
			}
		
			"{Action " {STRING} "}" {
				((ConfigChange)actObj).Action = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_CONFCH unprocessed: " + yytext());
		}
  	}
}

<MSG_DLGCMD> {
  	
			"{Id " {STRING} "}" {
				((DialogCommand)actObj).Id = stringValue(yytext());
				
			}
		
			"{SourceId " {STRING} "}" {
				((DialogCommand)actObj).SourceId = stringValue(yytext());
				
			}
		
			"{Command " {STRING} "}" {
				((DialogCommand)actObj).Command = stringValue(yytext());
				
			}
		
			"{Data " {STRING} "}" {
				((DialogCommand)actObj).Data = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_DLGCMD unprocessed: " + yytext());
		}
  	}
}

<MSG_DFAIL> {
  	
			"{Id " {STRING} "}" {
				((DialogFailed)actObj).Id = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_DFAIL unprocessed: " + yytext());
		}
  	}
}

<MSG_DOK> {
  	
			"{Id " {STRING} "}" {
				((DialogOk)actObj).Id = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_DOK unprocessed: " + yytext());
		}
  	}
}

<MSG_DOM> {
  	
			"{Id " {UNREALID} "}" {
				((DominationPoint)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((DominationPoint)actObj).Location = locationValue(yytext());
				
			}
		
			"{Visible " {BOOLEAN} "}" {
				((DominationPoint)actObj).Visible = booleanValue(yytext());
				
			}
		
			"{Reachable " {BOOLEAN} "}" {
				((DominationPoint)actObj).Reachable = booleanValue(yytext());
				
			}
		
			"{Item " {UNREALID} "}" {
				((DominationPoint)actObj).Item = unrealIdValue(yytext());
				
			}
		
			"{Flag " {STRING} "}" {
				((DominationPoint)actObj).Flag = stringValue(yytext());
				
			}
		
			"{Rotation " {ROTATION} "}" {
				((DominationPoint)actObj).Rotation = rotationValue(yytext());
				
			}
		
			"{RoamingSpot " {BOOLEAN} "}" {
				((DominationPoint)actObj).RoamingSpot = booleanValue(yytext());
				
			}
		
			"{SnipingSpot " {BOOLEAN} "}" {
				((DominationPoint)actObj).SnipingSpot = booleanValue(yytext());
				
			}
		
			"{PreferedWeapon " {STRING} "}" {
				((DominationPoint)actObj).PreferedWeapon = stringValue(yytext());
				
			}
		
			"{Controller " {INT} "}" {
				((DominationPoint)actObj).Controller = intValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_DOM unprocessed: " + yytext());
		}
  	}
}

<MSG_END> {
  	
			"{Time " {DOUBLE} "}" {
				((EndMessage)actObj).Time = doubleValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_END unprocessed: " + yytext());
		}
  	}
}

<MSG_ENTERED> {
  	
			"{Id " {UNREALID} "}" {
				((EnteredVehicle)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Type " {STRING} "}" {
				((EnteredVehicle)actObj).Type = stringValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((EnteredVehicle)actObj).Location = locationValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ENTERED unprocessed: " + yytext());
		}
  	}
}

<MSG_USED> {
  	
			"{Success " {BOOLEAN} "}" {
				((FactoryUsed)actObj).Success = booleanValue(yytext());
				
			}
		
			"{Reason " {STRING} "}" {
				((FactoryUsed)actObj).Reason = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_USED unprocessed: " + yytext());
		}
  	}
}

<MSG_FAL> {
  	
			"{Fell " {BOOLEAN} "}" {
				((FallEdge)actObj).Fell = booleanValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((FallEdge)actObj).Location = locationValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_FAL unprocessed: " + yytext());
		}
  	}
}

<MSG_FTR> {
  	
			"{Id " {STRING} "}" {
				((FastTraceResponse)actObj).Id = stringValue(yytext());
				
			}
		
			"{From " {LOCATION} "}" {
				((FastTraceResponse)actObj).From = locationValue(yytext());
				
			}
		
			"{To " {LOCATION} "}" {
				((FastTraceResponse)actObj).To = locationValue(yytext());
				
			}
		
			"{Result " {BOOLEAN} "}" {
				((FastTraceResponse)actObj).Result = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_FTR unprocessed: " + yytext());
		}
  	}
}

<MSG_FLG> {
  	
			"{Id " {UNREALID} "}" {
				((FlagInfo)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((FlagInfo)actObj).Location = locationValue(yytext());
				
			}
		
			"{Holder " {UNREALID} "}" {
				((FlagInfo)actObj).Holder = unrealIdValue(yytext());
				
			}
		
			"{Team " {INT} "}" {
				((FlagInfo)actObj).Team = intValue(yytext());
				
			}
		
			"{Reachable " {BOOLEAN} "}" {
				((FlagInfo)actObj).Reachable = booleanValue(yytext());
				
			}
		
			"{Visible " {BOOLEAN} "}" {
				((FlagInfo)actObj).Visible = booleanValue(yytext());
				
			}
		
			"{State " {STRING} "}" {
				((FlagInfo)actObj).State = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_FLG unprocessed: " + yytext());
		}
  	}
}

<MSG_NFO> {
  	
			"{Gametype " {STRING} "}" {
				((GameInfo)actObj).Gametype = stringValue(yytext());
				
			}
		
			"{Level " {STRING} "}" {
				((GameInfo)actObj).Level = stringValue(yytext());
				
			}
		
			"{WeaponStay " {BOOLEAN} "}" {
				((GameInfo)actObj).WeaponStay = booleanValue(yytext());
				
			}
		
			"{TimeLimit " {DOUBLE} "}" {
				((GameInfo)actObj).TimeLimit = doubleValue(yytext());
				
			}
		
			"{FragLimit " {INT} "}" {
				((GameInfo)actObj).FragLimit = intValue(yytext());
				
			}
		
			"{GoalTeamScore " {DOUBLE} "}" {
				((GameInfo)actObj).GoalTeamScore = doubleValue(yytext());
				
			}
		
			"{MaxTeams " {INT} "}" {
				((GameInfo)actObj).MaxTeams = intValue(yytext());
				
			}
		
			"{MaxTeamSize " {INT} "}" {
				((GameInfo)actObj).MaxTeamSize = intValue(yytext());
				
			}
		
			"{RedBaseLocation " {LOCATION} "}" {
				((GameInfo)actObj).RedBaseLocation = locationValue(yytext());
				
			}
		
			"{BlueBaseLocation " {LOCATION} "}" {
				((GameInfo)actObj).BlueBaseLocation = locationValue(yytext());
				
			}
		
			"{FirstDomPointLocation " {LOCATION} "}" {
				((GameInfo)actObj).FirstDomPointLocation = locationValue(yytext());
				
			}
		
			"{SecondDomPointLocation " {LOCATION} "}" {
				((GameInfo)actObj).SecondDomPointLocation = locationValue(yytext());
				
			}
		
			"{GamePaused " {BOOLEAN} "}" {
				((GameInfo)actObj).GamePaused = booleanValue(yytext());
				
			}
		
			"{BotsPaused " {BOOLEAN} "}" {
				((GameInfo)actObj).BotsPaused = booleanValue(yytext());
				
			}
		
			"{FactoryLocation " {LOCATION} "}" {
				((GameInfo)actObj).FactoryLocation = locationValue(yytext());
				
			}
		
			"{FactoryRadius " {DOUBLE} "}" {
				((GameInfo)actObj).FactoryRadius = doubleValue(yytext());
				
			}
		
			"{DisperserLocation " {LOCATION} "}" {
				((GameInfo)actObj).DisperserLocation = locationValue(yytext());
				
			}
		
			"{DisperserRadius " {DOUBLE} "}" {
				((GameInfo)actObj).DisperserRadius = doubleValue(yytext());
				
			}
		
			"{FactoryAdrenalineCount " {DOUBLE} "}" {
				((GameInfo)actObj).FactoryAdrenalineCount = doubleValue(yytext());
				
			}
		
			"{FactorySpawnType " {STRING} "}" {
				((GameInfo)actObj).FactorySpawnType = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_NFO unprocessed: " + yytext());
		}
  	}
}

<MSG_PAUSED> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_PAUSED unprocessed: " + yytext());
		}
  	}
}

<MSG_RESUMED> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_RESUMED unprocessed: " + yytext());
		}
  	}
}

<MSG_VMS> {
  	
			"{Id " {UNREALID} "}" {
				((GlobalChat)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Name " {STRING} "}" {
				((GlobalChat)actObj).Name = stringValue(yytext());
				
			}
		
			"{Text " {STRING} "}" {
				((GlobalChat)actObj).Text = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_VMS unprocessed: " + yytext());
		}
  	}
}

<MSG_EHS> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_EHS unprocessed: " + yytext());
		}
  	}
}

<MSG_SHS> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SHS unprocessed: " + yytext());
		}
  	}
}

<MSG_HRN> {
  	
			"{Source " {UNREALID} "}" {
				((HearNoise)actObj).Source = unrealIdValue(yytext());
				
			}
		
			"{Type " {STRING} "}" {
				((HearNoise)actObj).Type = stringValue(yytext());
				
			}
		
			"{Rotation " {ROTATION} "}" {
				((HearNoise)actObj).Rotation = rotationValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_HRN unprocessed: " + yytext());
		}
  	}
}

<MSG_HRP> {
  	
			"{Source " {UNREALID} "}" {
				((HearPickup)actObj).Source = unrealIdValue(yytext());
				
			}
		
			"{Type " {STRING} "}" {
				((HearPickup)actObj).Type = stringValue(yytext());
				
			}
		
			"{Rotation " {ROTATION} "}" {
				((HearPickup)actObj).Rotation = rotationValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_HRP unprocessed: " + yytext());
		}
  	}
}

<MSG_HELLO_BOT> {
  	
			"{ServerFull " {BOOLEAN} "}" {
				((HelloBotHandshake)actObj).ServerFull = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_HELLO_BOT unprocessed: " + yytext());
		}
  	}
}

<MSG_HELLO_CONTROL_SERVER> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_HELLO_CONTROL_SERVER unprocessed: " + yytext());
		}
  	}
}

<MSG_HELLO_OBSERVER> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_HELLO_OBSERVER unprocessed: " + yytext());
		}
  	}
}

<MSG_PRJ> {
  	
			"{Id " {UNREALID} "}" {
				((IncomingProjectile)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Time " {DOUBLE} "}" {
				((IncomingProjectile)actObj).Time = doubleValue(yytext());
				
			}
		
			"{Direction " {VECTOR3D} "}" {
				((IncomingProjectile)actObj).Direction = vector3dValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((IncomingProjectile)actObj).Location = locationValue(yytext());
				
			}
		
			"{Velocity " {VELOCITY} "}" {
				((IncomingProjectile)actObj).Velocity = velocityValue(yytext());
				
			}
		
			"{Speed " {DOUBLE} "}" {
				((IncomingProjectile)actObj).Speed = doubleValue(yytext());
				
			}
		
			"{Origin " {LOCATION} "}" {
				((IncomingProjectile)actObj).Origin = locationValue(yytext());
				
			}
		
			"{DamageRadius " {DOUBLE} "}" {
				((IncomingProjectile)actObj).DamageRadius = doubleValue(yytext());
				
			}
		
			"{Type " {STRING} "}" {
				((IncomingProjectile)actObj).Type = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_PRJ unprocessed: " + yytext());
		}
  	}
}

<MSG_INITED> {
  	
			"{BotId " {UNREALID} "}" {
				((InitedMessage)actObj).BotId = unrealIdValue(yytext());
				
			}
		
			"{HealthStart " {INT} "}" {
				((InitedMessage)actObj).HealthStart = intValue(yytext());
				
			}
		
			"{HealthFull " {INT} "}" {
				((InitedMessage)actObj).HealthFull = intValue(yytext());
				
			}
		
			"{HealthMax " {INT} "}" {
				((InitedMessage)actObj).HealthMax = intValue(yytext());
				
			}
		
			"{AdrenalineStart " {DOUBLE} "}" {
				((InitedMessage)actObj).AdrenalineStart = doubleValue(yytext());
				
			}
		
			"{AdrenalineMax " {DOUBLE} "}" {
				((InitedMessage)actObj).AdrenalineMax = doubleValue(yytext());
				
			}
		
			"{ShieldStrengthStart " {INT} "}" {
				((InitedMessage)actObj).ShieldStrengthStart = intValue(yytext());
				
			}
		
			"{ShieldStrengthMax " {INT} "}" {
				((InitedMessage)actObj).ShieldStrengthMax = intValue(yytext());
				
			}
		
			"{MaxMultiJump " {INT} "}" {
				((InitedMessage)actObj).MaxMultiJump = intValue(yytext());
				
			}
		
			"{DamageScaling " {DOUBLE} "}" {
				((InitedMessage)actObj).DamageScaling = doubleValue(yytext());
				
			}
		
			"{GroundSpeed " {DOUBLE} "}" {
				((InitedMessage)actObj).GroundSpeed = doubleValue(yytext());
				
			}
		
			"{WaterSpeed " {DOUBLE} "}" {
				((InitedMessage)actObj).WaterSpeed = doubleValue(yytext());
				
			}
		
			"{AirSpeed " {DOUBLE} "}" {
				((InitedMessage)actObj).AirSpeed = doubleValue(yytext());
				
			}
		
			"{LadderSpeed " {DOUBLE} "}" {
				((InitedMessage)actObj).LadderSpeed = doubleValue(yytext());
				
			}
		
			"{AccelRate " {DOUBLE} "}" {
				((InitedMessage)actObj).AccelRate = doubleValue(yytext());
				
			}
		
			"{JumpZ " {DOUBLE} "}" {
				((InitedMessage)actObj).JumpZ = doubleValue(yytext());
				
			}
		
			"{MultiJumpBoost " {DOUBLE} "}" {
				((InitedMessage)actObj).MultiJumpBoost = doubleValue(yytext());
				
			}
		
			"{MaxFallSpeed " {DOUBLE} "}" {
				((InitedMessage)actObj).MaxFallSpeed = doubleValue(yytext());
				
			}
		
			"{DodgeSpeedFactor " {DOUBLE} "}" {
				((InitedMessage)actObj).DodgeSpeedFactor = doubleValue(yytext());
				
			}
		
			"{DodgeSpeedZ " {DOUBLE} "}" {
				((InitedMessage)actObj).DodgeSpeedZ = doubleValue(yytext());
				
			}
		
			"{AirControl " {DOUBLE} "}" {
				((InitedMessage)actObj).AirControl = doubleValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_INITED unprocessed: " + yytext());
		}
  	}
}

<MSG_INV> {
  	
			"{Id " {UNREALID} "}" {
				((Item)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{NavPointId " {UNREALID} "}" {
				((Item)actObj).NavPointId = unrealIdValue(yytext());
				
			}
		
			"{Visible " {BOOLEAN} "}" {
				((Item)actObj).Visible = booleanValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((Item)actObj).Location = locationValue(yytext());
				
			}
		
			"{Reachable " {BOOLEAN} "}" {
				((Item)actObj).Reachable = booleanValue(yytext());
				
			}
		
			"{Amount " {INT} "}" {
				((Item)actObj).Amount = intValue(yytext());
				
			}
		
			"{Type " {ITEMTYPE} "}" {
				((Item)actObj).Type = itemTypeValue(yytext());
				
					((Item)actObj).Descriptor = itemDescriptorValue(((Item)actObj).Type);
				
			}
		
			"{Dropped " {BOOLEAN} "}" {
				((Item)actObj).Dropped = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_INV unprocessed: " + yytext());
		}
  	}
}

<MSG_ITC> {
  	
			"{InventoryType " {STRING} "}" {
				((ItemCategory)actObj).InventoryType = stringValue(yytext());
				
			}
		
			"{PickupType " {ITEMTYPE} "}" {
				((ItemCategory)actObj).PickupType = itemTypeValue(yytext());
				
			}
		
			"{ItemCategory " {CATEGORY} "}" {
				((ItemCategory)actObj).ItemCategory = categoryValue(yytext());
				
			}
		
			"{Melee " {BOOLEAN} "}" {
				((ItemCategory)actObj).Melee = booleanValue(yytext());
				
			}
		
			"{Sniping " {BOOLEAN} "}" {
				((ItemCategory)actObj).Sniping = booleanValue(yytext());
				
			}
		
			"{UsesAltAmmo " {BOOLEAN} "}" {
				((ItemCategory)actObj).UsesAltAmmo = booleanValue(yytext());
				
			}
		
			"{PriFireModeType " {STRING} "}" {
				((ItemCategory)actObj).PriFireModeType = stringValue(yytext());
				
			}
		
			"{PriSplashDamage " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriSplashDamage = booleanValue(yytext());
				
			}
		
			"{PriSplashJump " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriSplashJump = booleanValue(yytext());
				
			}
		
			"{PriRecomSplashDamage " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriRecomSplashDamage = booleanValue(yytext());
				
			}
		
			"{PriTossed " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriTossed = booleanValue(yytext());
				
			}
		
			"{PriLeadTarget " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriLeadTarget = booleanValue(yytext());
				
			}
		
			"{PriInstantHit " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriInstantHit = booleanValue(yytext());
				
			}
		
			"{PriFireOnRelease " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriFireOnRelease = booleanValue(yytext());
				
			}
		
			"{PriWaitForRelease " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriWaitForRelease = booleanValue(yytext());
				
			}
		
			"{PriModeExclusive " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriModeExclusive = booleanValue(yytext());
				
			}
		
			"{PriFireRate " {DOUBLE} "}" {
				((ItemCategory)actObj).PriFireRate = doubleValue(yytext());
				
			}
		
			"{PriBotRefireRate " {DOUBLE} "}" {
				((ItemCategory)actObj).PriBotRefireRate = doubleValue(yytext());
				
			}
		
			"{PriAmmoPerFire " {INT} "}" {
				((ItemCategory)actObj).PriAmmoPerFire = intValue(yytext());
				
			}
		
			"{PriAmmoClipSize " {INT} "}" {
				((ItemCategory)actObj).PriAmmoClipSize = intValue(yytext());
				
			}
		
			"{PriAimError " {DOUBLE} "}" {
				((ItemCategory)actObj).PriAimError = doubleValue(yytext());
				
			}
		
			"{PriSpread " {DOUBLE} "}" {
				((ItemCategory)actObj).PriSpread = doubleValue(yytext());
				
			}
		
			"{PriSpreadStyle " {INT} "}" {
				((ItemCategory)actObj).PriSpreadStyle = intValue(yytext());
				
			}
		
			"{PriFireCount " {INT} "}" {
				((ItemCategory)actObj).PriFireCount = intValue(yytext());
				
			}
		
			"{PriDamageAtten " {DOUBLE} "}" {
				((ItemCategory)actObj).PriDamageAtten = doubleValue(yytext());
				
			}
		
			"{PriAmmoType " {STRING} "}" {
				((ItemCategory)actObj).PriAmmoType = stringValue(yytext());
				
			}
		
			"{PriInitialAmount " {INT} "}" {
				((ItemCategory)actObj).PriInitialAmount = intValue(yytext());
				
			}
		
			"{PriMaxAmount " {INT} "}" {
				((ItemCategory)actObj).PriMaxAmount = intValue(yytext());
				
			}
		
			"{PriMaxRange " {DOUBLE} "}" {
				((ItemCategory)actObj).PriMaxRange = doubleValue(yytext());
				
			}
		
			"{PriDamageType " {STRING} "}" {
				((ItemCategory)actObj).PriDamageType = stringValue(yytext());
				
			}
		
			"{PriArmorStops " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriArmorStops = booleanValue(yytext());
				
			}
		
			"{PriAlwaysGibs " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriAlwaysGibs = booleanValue(yytext());
				
			}
		
			"{PriSpecial " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriSpecial = booleanValue(yytext());
				
			}
		
			"{PriDetonatesGoop " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriDetonatesGoop = booleanValue(yytext());
				
			}
		
			"{PriSuperWeapon " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriSuperWeapon = booleanValue(yytext());
				
			}
		
			"{PriExtraMomZ " {BOOLEAN} "}" {
				((ItemCategory)actObj).PriExtraMomZ = booleanValue(yytext());
				
			}
		
			"{PriProjType " {STRING} "}" {
				((ItemCategory)actObj).PriProjType = stringValue(yytext());
				
			}
		
			"{PriDamage " {DOUBLE} "}" {
				((ItemCategory)actObj).PriDamage = doubleValue(yytext());
				
			}
		
			"{PriDamageMax " {DOUBLE} "}" {
				((ItemCategory)actObj).PriDamageMax = doubleValue(yytext());
				
			}
		
			"{PriDamageMin " {DOUBLE} "}" {
				((ItemCategory)actObj).PriDamageMin = doubleValue(yytext());
				
			}
		
			"{PriSpeed " {DOUBLE} "}" {
				((ItemCategory)actObj).PriSpeed = doubleValue(yytext());
				
			}
		
			"{PriMaxSpeed " {DOUBLE} "}" {
				((ItemCategory)actObj).PriMaxSpeed = doubleValue(yytext());
				
			}
		
			"{PriLifeSpan " {DOUBLE} "}" {
				((ItemCategory)actObj).PriLifeSpan = doubleValue(yytext());
				
			}
		
			"{PriDamageRadius " {DOUBLE} "}" {
				((ItemCategory)actObj).PriDamageRadius = doubleValue(yytext());
				
			}
		
			"{PriTossZ " {DOUBLE} "}" {
				((ItemCategory)actObj).PriTossZ = doubleValue(yytext());
				
			}
		
			"{PriMaxEffectDistance " {DOUBLE} "}" {
				((ItemCategory)actObj).PriMaxEffectDistance = doubleValue(yytext());
				
			}
		
			"{SecFireModeType " {STRING} "}" {
				((ItemCategory)actObj).SecFireModeType = stringValue(yytext());
				
			}
		
			"{SecSplashDamage " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecSplashDamage = booleanValue(yytext());
				
			}
		
			"{SecSplashJump " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecSplashJump = booleanValue(yytext());
				
			}
		
			"{SecRecomSplashDamage " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecRecomSplashDamage = booleanValue(yytext());
				
			}
		
			"{SecTossed " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecTossed = booleanValue(yytext());
				
			}
		
			"{SecLeadTarget " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecLeadTarget = booleanValue(yytext());
				
			}
		
			"{SecInstantHit " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecInstantHit = booleanValue(yytext());
				
			}
		
			"{SecFireOnRelease " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecFireOnRelease = booleanValue(yytext());
				
			}
		
			"{SecWaitForRelease " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecWaitForRelease = booleanValue(yytext());
				
			}
		
			"{SecModeExclusive " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecModeExclusive = booleanValue(yytext());
				
			}
		
			"{SecFireRate " {DOUBLE} "}" {
				((ItemCategory)actObj).SecFireRate = doubleValue(yytext());
				
			}
		
			"{SecBotRefireRate " {DOUBLE} "}" {
				((ItemCategory)actObj).SecBotRefireRate = doubleValue(yytext());
				
			}
		
			"{SecAmmoPerFire " {INT} "}" {
				((ItemCategory)actObj).SecAmmoPerFire = intValue(yytext());
				
			}
		
			"{SecAmmoClipSize " {INT} "}" {
				((ItemCategory)actObj).SecAmmoClipSize = intValue(yytext());
				
			}
		
			"{SecAimError " {DOUBLE} "}" {
				((ItemCategory)actObj).SecAimError = doubleValue(yytext());
				
			}
		
			"{SecSpread " {DOUBLE} "}" {
				((ItemCategory)actObj).SecSpread = doubleValue(yytext());
				
			}
		
			"{SecSpreadStyle " {INT} "}" {
				((ItemCategory)actObj).SecSpreadStyle = intValue(yytext());
				
			}
		
			"{SecFireCount " {INT} "}" {
				((ItemCategory)actObj).SecFireCount = intValue(yytext());
				
			}
		
			"{SecDamageAtten " {DOUBLE} "}" {
				((ItemCategory)actObj).SecDamageAtten = doubleValue(yytext());
				
			}
		
			"{SecAmmoType " {STRING} "}" {
				((ItemCategory)actObj).SecAmmoType = stringValue(yytext());
				
			}
		
			"{SecInitialAmount " {INT} "}" {
				((ItemCategory)actObj).SecInitialAmount = intValue(yytext());
				
			}
		
			"{SecMaxAmount " {INT} "}" {
				((ItemCategory)actObj).SecMaxAmount = intValue(yytext());
				
			}
		
			"{SecMaxRange " {DOUBLE} "}" {
				((ItemCategory)actObj).SecMaxRange = doubleValue(yytext());
				
			}
		
			"{SecDamageType " {STRING} "}" {
				((ItemCategory)actObj).SecDamageType = stringValue(yytext());
				
			}
		
			"{SecArmorStops " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecArmorStops = booleanValue(yytext());
				
			}
		
			"{SecAlwaysGibs " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecAlwaysGibs = booleanValue(yytext());
				
			}
		
			"{SecSpecial " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecSpecial = booleanValue(yytext());
				
			}
		
			"{SecDetonatesGoop " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecDetonatesGoop = booleanValue(yytext());
				
			}
		
			"{SecSuperWeapon " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecSuperWeapon = booleanValue(yytext());
				
			}
		
			"{SecExtraMomZ " {BOOLEAN} "}" {
				((ItemCategory)actObj).SecExtraMomZ = booleanValue(yytext());
				
			}
		
			"{SecProjType " {STRING} "}" {
				((ItemCategory)actObj).SecProjType = stringValue(yytext());
				
			}
		
			"{SecDamage " {DOUBLE} "}" {
				((ItemCategory)actObj).SecDamage = doubleValue(yytext());
				
			}
		
			"{SecDamageMax " {DOUBLE} "}" {
				((ItemCategory)actObj).SecDamageMax = doubleValue(yytext());
				
			}
		
			"{SecDamageMin " {DOUBLE} "}" {
				((ItemCategory)actObj).SecDamageMin = doubleValue(yytext());
				
			}
		
			"{SecSpeed " {DOUBLE} "}" {
				((ItemCategory)actObj).SecSpeed = doubleValue(yytext());
				
			}
		
			"{SecMaxSpeed " {DOUBLE} "}" {
				((ItemCategory)actObj).SecMaxSpeed = doubleValue(yytext());
				
			}
		
			"{SecLifeSpan " {DOUBLE} "}" {
				((ItemCategory)actObj).SecLifeSpan = doubleValue(yytext());
				
			}
		
			"{SecDamageRadius " {DOUBLE} "}" {
				((ItemCategory)actObj).SecDamageRadius = doubleValue(yytext());
				
			}
		
			"{SecTossZ " {DOUBLE} "}" {
				((ItemCategory)actObj).SecTossZ = doubleValue(yytext());
				
			}
		
			"{SecMaxEffectDistance " {DOUBLE} "}" {
				((ItemCategory)actObj).SecMaxEffectDistance = doubleValue(yytext());
				
			}
		
			"{Amount " {INT} "}" {
				((ItemCategory)actObj).Amount = intValue(yytext());
				
			}
		
			"{SuperHeal " {BOOLEAN} "}" {
				((ItemCategory)actObj).SuperHeal = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ITC unprocessed: " + yytext());
		}
  	}
}

<MSG_EITC> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_EITC unprocessed: " + yytext());
		}
  	}
}

<MSG_SITC> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SITC unprocessed: " + yytext());
		}
  	}
}

<MSG_EINV> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_EINV unprocessed: " + yytext());
		}
  	}
}

<MSG_SINV> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SINV unprocessed: " + yytext());
		}
  	}
}

<MSG_IPK> {
  	
			"{Id " {UNREALID} "}" {
				((ItemPickedUp)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{InventoryId " {UNREALID} "}" {
				((ItemPickedUp)actObj).InventoryId = unrealIdValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((ItemPickedUp)actObj).Location = locationValue(yytext());
				
			}
		
			"{Amount " {INT} "}" {
				((ItemPickedUp)actObj).Amount = intValue(yytext());
				
			}
		
			"{AmountSec " {INT} "}" {
				((ItemPickedUp)actObj).AmountSec = intValue(yytext());
				
			}
		
			"{Type " {ITEMTYPE} "}" {
				((ItemPickedUp)actObj).Type = itemTypeValue(yytext());
				
					((ItemPickedUp)actObj).Descriptor = itemDescriptorValue(((ItemPickedUp)actObj).Type);
				
			}
		
			"{Dropped " {BOOLEAN} "}" {
				((ItemPickedUp)actObj).Dropped = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_IPK unprocessed: " + yytext());
		}
  	}
}

<MSG_JUMP> {
  	
			"{DoubleJump " {BOOLEAN} "}" {
				((JumpPerformed)actObj).DoubleJump = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_JUMP unprocessed: " + yytext());
		}
  	}
}

<MSG_KEYEVENT> {
  	
			"{Player " {STRING} "}" {
				((KeyEvent)actObj).Player = stringValue(yytext());
				
			}
		
			"{Action " {STRING} "}" {
				((KeyEvent)actObj).Action = stringValue(yytext());
				
			}
		
			"{Key " {STRING} "}" {
				((KeyEvent)actObj).Key = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_KEYEVENT unprocessed: " + yytext());
		}
  	}
}

<MSG_LAND> {
  	
			"{HitNormal " {VECTOR3D} "}" {
				((Landed)actObj).HitNormal = vector3dValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_LAND unprocessed: " + yytext());
		}
  	}
}

<MSG_LOCKED> {
  	
			"{Id " {UNREALID} "}" {
				((LockedVehicle)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Type " {STRING} "}" {
				((LockedVehicle)actObj).Type = stringValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((LockedVehicle)actObj).Location = locationValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_LOCKED unprocessed: " + yytext());
		}
  	}
}

<MSG_LOSTCHILD> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_LOSTCHILD unprocessed: " + yytext());
		}
  	}
}

<MSG_LIN> {
  	
			"{Id " {STRING} "}" {
				((LostInventory)actObj).Id = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_LIN unprocessed: " + yytext());
		}
  	}
}

<MSG_MAPCHANGE> {
  	
			"{MapName " {STRING} "}" {
				((MapChange)actObj).MapName = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_MAPCHANGE unprocessed: " + yytext());
		}
  	}
}

<MSG_FIN> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_FIN unprocessed: " + yytext());
		}
  	}
}

<MSG_IMAP> {
  	
			"{Name " {STRING} "}" {
				((MapList)actObj).Name = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_IMAP unprocessed: " + yytext());
		}
  	}
}

<MSG_EMAP> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_EMAP unprocessed: " + yytext());
		}
  	}
}

<MSG_SMAP> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SMAP unprocessed: " + yytext());
		}
  	}
}

<MSG_MOV> {
  	
			"{Id " {UNREALID} "}" {
				((Mover)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((Mover)actObj).Location = locationValue(yytext());
				
			}
		
			"{Visible " {BOOLEAN} "}" {
				((Mover)actObj).Visible = booleanValue(yytext());
				
			}
		
			"{Reachable " {BOOLEAN} "}" {
				((Mover)actObj).Reachable = booleanValue(yytext());
				
			}
		
			"{DamageTrig " {BOOLEAN} "}" {
				((Mover)actObj).DamageTrig = booleanValue(yytext());
				
			}
		
			"{Type " {STRING} "}" {
				((Mover)actObj).Type = stringValue(yytext());
				
			}
		
			"{IsMoving " {BOOLEAN} "}" {
				((Mover)actObj).IsMoving = booleanValue(yytext());
				
			}
		
			"{Velocity " {VELOCITY} "}" {
				((Mover)actObj).Velocity = velocityValue(yytext());
				
			}
		
			"{MoveTime " {DOUBLE} "}" {
				((Mover)actObj).MoveTime = doubleValue(yytext());
				
			}
		
			"{OpenTime " {DOUBLE} "}" {
				((Mover)actObj).OpenTime = doubleValue(yytext());
				
			}
		
			"{BasePos " {LOCATION} "}" {
				((Mover)actObj).BasePos = locationValue(yytext());
				
			}
		
			"{BaseRot " {LOCATION} "}" {
				((Mover)actObj).BaseRot = locationValue(yytext());
				
			}
		
			"{DelayTime " {DOUBLE} "}" {
				((Mover)actObj).DelayTime = doubleValue(yytext());
				
			}
		
			"{State " {STRING} "}" {
				((Mover)actObj).State = stringValue(yytext());
				
			}
		
			"{NavPointMarker " {UNREALID} "}" {
				((Mover)actObj).NavPointMarker = unrealIdValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_MOV unprocessed: " + yytext());
		}
  	}
}

<MSG_EMOV> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_EMOV unprocessed: " + yytext());
		}
  	}
}

<MSG_SMOV> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SMOV unprocessed: " + yytext());
		}
  	}
}

<MSG_MUT> {
  	
			"{Id " {UNREALID} "}" {
				((Mutator)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Name " {STRING} "}" {
				((Mutator)actObj).Name = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_MUT unprocessed: " + yytext());
		}
  	}
}

<MSG_EMUT> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_EMUT unprocessed: " + yytext());
		}
  	}
}

<MSG_SMUT> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SMUT unprocessed: " + yytext());
		}
  	}
}

<MSG_MYINV> {
  	
			"{Id " {UNREALID} "}" {
				((MyInventory)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{CurrentAmmo " {INT} "}" {
				((MyInventory)actObj).CurrentAmmo = intValue(yytext());
				
			}
		
			"{CurrentAltAmmo " {INT} "}" {
				((MyInventory)actObj).CurrentAltAmmo = intValue(yytext());
				
			}
		
			"{Amount " {INT} "}" {
				((MyInventory)actObj).Amount = intValue(yytext());
				
			}
		
			"{Type " {ITEMTYPE} "}" {
				((MyInventory)actObj).Type = itemTypeValue(yytext());
				
					((MyInventory)actObj).Descriptor = itemDescriptorValue(((MyInventory)actObj).Type);
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_MYINV unprocessed: " + yytext());
		}
  	}
}

<MSG_EMYINV> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_EMYINV unprocessed: " + yytext());
		}
  	}
}

<MSG_SMYINV> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SMYINV unprocessed: " + yytext());
		}
  	}
}

<MSG_NAV> {
  	
			"{Id " {UNREALID} "}" {
				((NavPoint)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((NavPoint)actObj).Location = locationValue(yytext());
				
			}
		
			"{Velocity " {VELOCITY} "}" {
				((NavPoint)actObj).Velocity = velocityValue(yytext());
				
			}
		
			"{Visible " {BOOLEAN} "}" {
				((NavPoint)actObj).Visible = booleanValue(yytext());
				
			}
		
			"{Reachable " {BOOLEAN} "}" {
				((NavPoint)actObj).Reachable = booleanValue(yytext());
				
			}
		
			"{Item " {UNREALID} "}" {
				((NavPoint)actObj).Item = unrealIdValue(yytext());
				
			}
		
			"{ItemClass " {ITEMTYPE} "}" {
				((NavPoint)actObj).ItemClass = itemTypeValue(yytext());
				
			}
		
			"{ItemSpawned " {BOOLEAN} "}" {
				((NavPoint)actObj).ItemSpawned = booleanValue(yytext());
				
			}
		
			"{DoorOpened " {BOOLEAN} "}" {
				((NavPoint)actObj).DoorOpened = booleanValue(yytext());
				
			}
		
			"{Mover " {UNREALID} "}" {
				((NavPoint)actObj).Mover = unrealIdValue(yytext());
				
			}
		
			"{LiftOffset " {VECTOR3D} "}" {
				((NavPoint)actObj).LiftOffset = vector3dValue(yytext());
				
			}
		
			"{LiftJumpExit " {BOOLEAN} "}" {
				((NavPoint)actObj).LiftJumpExit = booleanValue(yytext());
				
			}
		
			"{NoDoubleJump " {BOOLEAN} "}" {
				((NavPoint)actObj).NoDoubleJump = booleanValue(yytext());
				
			}
		
			"{InvSpot " {BOOLEAN} "}" {
				((NavPoint)actObj).InvSpot = booleanValue(yytext());
				
			}
		
			"{PlayerStart " {BOOLEAN} "}" {
				((NavPoint)actObj).PlayerStart = booleanValue(yytext());
				
			}
		
			"{TeamNumber " {INT} "}" {
				((NavPoint)actObj).TeamNumber = intValue(yytext());
				
			}
		
			"{Door " {BOOLEAN} "}" {
				((NavPoint)actObj).Door = booleanValue(yytext());
				
			}
		
			"{LiftCenter " {BOOLEAN} "}" {
				((NavPoint)actObj).LiftCenter = booleanValue(yytext());
				
			}
		
			"{LiftExit " {BOOLEAN} "}" {
				((NavPoint)actObj).LiftExit = booleanValue(yytext());
				
			}
		
			"{AIMarker " {BOOLEAN} "}" {
				((NavPoint)actObj).AIMarker = booleanValue(yytext());
				
			}
		
			"{JumpSpot " {BOOLEAN} "}" {
				((NavPoint)actObj).JumpSpot = booleanValue(yytext());
				
			}
		
			"{JumpDest " {BOOLEAN} "}" {
				((NavPoint)actObj).JumpDest = booleanValue(yytext());
				
			}
		
			"{Teleporter " {BOOLEAN} "}" {
				((NavPoint)actObj).Teleporter = booleanValue(yytext());
				
			}
		
			"{Rotation " {ROTATION} "}" {
				((NavPoint)actObj).Rotation = rotationValue(yytext());
				
			}
		
			"{RoamingSpot " {BOOLEAN} "}" {
				((NavPoint)actObj).RoamingSpot = booleanValue(yytext());
				
			}
		
			"{SnipingSpot " {BOOLEAN} "}" {
				((NavPoint)actObj).SnipingSpot = booleanValue(yytext());
				
			}
		
			"{PreferedWeapon " {STRING} "}" {
				((NavPoint)actObj).PreferedWeapon = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_NAV unprocessed: " + yytext());
		}
  	}
}

<MSG_ENAV> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ENAV unprocessed: " + yytext());
		}
  	}
}

<MSG_SNAV> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SNAV unprocessed: " + yytext());
		}
  	}
}

<MSG_INGP> {
  	
			"{Id " {UNREALID} "}" {
				((NavPointNeighbourLink)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Flags " {INT} "}" {
				((NavPointNeighbourLink)actObj).Flags = intValue(yytext());
				
			}
		
			"{CollisionR " {INT} "}" {
				((NavPointNeighbourLink)actObj).CollisionR = intValue(yytext());
				
			}
		
			"{CollisionH " {INT} "}" {
				((NavPointNeighbourLink)actObj).CollisionH = intValue(yytext());
				
			}
		
			"{TranslocZOffset " {DOUBLE} "}" {
				((NavPointNeighbourLink)actObj).TranslocZOffset = doubleValue(yytext());
				
			}
		
			"{TranslocTargetTag " {STRING} "}" {
				((NavPointNeighbourLink)actObj).TranslocTargetTag = stringValue(yytext());
				
			}
		
			"{OnlyTranslocator " {BOOLEAN} "}" {
				((NavPointNeighbourLink)actObj).OnlyTranslocator = booleanValue(yytext());
				
			}
		
			"{ForceDoubleJump " {BOOLEAN} "}" {
				((NavPointNeighbourLink)actObj).ForceDoubleJump = booleanValue(yytext());
				
			}
		
			"{NeededJump " {VECTOR3D} "}" {
				((NavPointNeighbourLink)actObj).NeededJump = vector3dValue(yytext());
				
			}
		
			"{NeverImpactJump " {BOOLEAN} "}" {
				((NavPointNeighbourLink)actObj).NeverImpactJump = booleanValue(yytext());
				
			}
		
			"{NoLowGrav " {BOOLEAN} "}" {
				((NavPointNeighbourLink)actObj).NoLowGrav = booleanValue(yytext());
				
			}
		
			"{CalculatedGravityZ " {DOUBLE} "}" {
				((NavPointNeighbourLink)actObj).CalculatedGravityZ = doubleValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_INGP unprocessed: " + yytext());
		}
  	}
}

<MSG_ENGP> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ENGP unprocessed: " + yytext());
		}
  	}
}

<MSG_SNGP> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SNGP unprocessed: " + yytext());
		}
  	}
}

<MSG_SEL> {
  	
			"{PlayerId " {UNREALID} "}" {
				((ObjectSelected)actObj).PlayerId = unrealIdValue(yytext());
				
			}
		
			"{PlayerName " {STRING} "}" {
				((ObjectSelected)actObj).PlayerName = stringValue(yytext());
				
			}
		
			"{ObjectId " {UNREALID} "}" {
				((ObjectSelected)actObj).ObjectId = unrealIdValue(yytext());
				
			}
		
			"{ObjectLocation " {LOCATION} "}" {
				((ObjectSelected)actObj).ObjectLocation = locationValue(yytext());
				
			}
		
			"{ObjectHitLocation " {LOCATION} "}" {
				((ObjectSelected)actObj).ObjectHitLocation = locationValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SEL unprocessed: " + yytext());
		}
  	}
}

<MSG_PASSWDOK> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_PASSWDOK unprocessed: " + yytext());
		}
  	}
}

<MSG_PASSWDWRONG> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_PASSWDWRONG unprocessed: " + yytext());
		}
  	}
}

<MSG_PASSWORD> {
  	
			"{BlockedByIp " {STRING} "}" {
				((Password)actObj).BlockedByIp = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_PASSWORD unprocessed: " + yytext());
		}
  	}
}

<MSG_IPTH> {
  	
			"{RouteId " {UNREALID} "}" {
				((PathList)actObj).RouteId = unrealIdValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((PathList)actObj).Location = locationValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_IPTH unprocessed: " + yytext());
		}
  	}
}

<MSG_EPTH> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_EPTH unprocessed: " + yytext());
		}
  	}
}

<MSG_SPTH> {
  	
			"{MessageId " {STRING} "}" {
				((PathListStart)actObj).MessageId = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SPTH unprocessed: " + yytext());
		}
  	}
}

<MSG_PLR> {
  	
			"{Id " {UNREALID} "}" {
				((Player)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Jmx " {STRING} "}" {
				((Player)actObj).Jmx = stringValue(yytext());
				
			}
		
			"{Name " {STRING} "}" {
				((Player)actObj).Name = stringValue(yytext());
				
			}
		
			"{Action " {STRING} "}" {
				((Player)actObj).Action = stringValue(yytext());
				
			}
		
			"{Visible " {BOOLEAN} "}" {
				((Player)actObj).Visible = booleanValue(yytext());
				
			}
		
			"{Rotation " {ROTATION} "}" {
				((Player)actObj).Rotation = rotationValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((Player)actObj).Location = locationValue(yytext());
				
			}
		
			"{Velocity " {VELOCITY} "}" {
				((Player)actObj).Velocity = velocityValue(yytext());
				
			}
		
			"{Team " {INT} "}" {
				((Player)actObj).Team = intValue(yytext());
				
			}
		
			"{Weapon " {STRING} "}" {
				((Player)actObj).Weapon = stringValue(yytext());
				
			}
		
			"{Reachable " {BOOLEAN} "}" {
				((Player)actObj).Reachable = booleanValue(yytext());
				
			}
		
			"{Firing " {INT} "}" {
				((Player)actObj).Firing = intValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_PLR unprocessed: " + yytext());
		}
  	}
}

<MSG_HIT> {
  	
			"{Id " {UNREALID} "}" {
				((PlayerDamaged)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Damage " {INT} "}" {
				((PlayerDamaged)actObj).Damage = intValue(yytext());
				
			}
		
			"{DamageType " {STRING} "}" {
				((PlayerDamaged)actObj).DamageType = stringValue(yytext());
				
			}
		
			"{WeaponName " {STRING} "}" {
				((PlayerDamaged)actObj).WeaponName = stringValue(yytext());
				
			}
		
			"{Flaming " {BOOLEAN} "}" {
				((PlayerDamaged)actObj).Flaming = booleanValue(yytext());
				
			}
		
			"{DirectDamage " {BOOLEAN} "}" {
				((PlayerDamaged)actObj).DirectDamage = booleanValue(yytext());
				
			}
		
			"{BulletHit " {BOOLEAN} "}" {
				((PlayerDamaged)actObj).BulletHit = booleanValue(yytext());
				
			}
		
			"{VehicleHit " {BOOLEAN} "}" {
				((PlayerDamaged)actObj).VehicleHit = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_HIT unprocessed: " + yytext());
		}
  	}
}

<MSG_PLI> {
  	
			"{Id " {UNREALID} "}" {
				((PlayerInput)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{DialogId " {STRING} "}" {
				((PlayerInput)actObj).DialogId = stringValue(yytext());
				
			}
		
			"{Key " {INT} "}" {
				((PlayerInput)actObj).Key = intValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_PLI unprocessed: " + yytext());
		}
  	}
}

<MSG_JOIN> {
  	
			"{Id " {UNREALID} "}" {
				((PlayerJoinsGame)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Name " {STRING} "}" {
				((PlayerJoinsGame)actObj).Name = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_JOIN unprocessed: " + yytext());
		}
  	}
}

<MSG_KIL> {
  	
			"{Id " {UNREALID} "}" {
				((PlayerKilled)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Killer " {UNREALID} "}" {
				((PlayerKilled)actObj).Killer = unrealIdValue(yytext());
				
			}
		
			"{KilledPawn " {STRING} "}" {
				((PlayerKilled)actObj).KilledPawn = stringValue(yytext());
				
			}
		
			"{DamageType " {STRING} "}" {
				((PlayerKilled)actObj).DamageType = stringValue(yytext());
				
			}
		
			"{DeathString " {STRING} "}" {
				((PlayerKilled)actObj).DeathString = stringValue(yytext());
				
			}
		
			"{WeaponName " {STRING} "}" {
				((PlayerKilled)actObj).WeaponName = stringValue(yytext());
				
			}
		
			"{Flaming " {BOOLEAN} "}" {
				((PlayerKilled)actObj).Flaming = booleanValue(yytext());
				
			}
		
			"{CausedByWorld " {BOOLEAN} "}" {
				((PlayerKilled)actObj).CausedByWorld = booleanValue(yytext());
				
			}
		
			"{DirectDamage " {BOOLEAN} "}" {
				((PlayerKilled)actObj).DirectDamage = booleanValue(yytext());
				
			}
		
			"{BulletHit " {BOOLEAN} "}" {
				((PlayerKilled)actObj).BulletHit = booleanValue(yytext());
				
			}
		
			"{VehicleHit " {BOOLEAN} "}" {
				((PlayerKilled)actObj).VehicleHit = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_KIL unprocessed: " + yytext());
		}
  	}
}

<MSG_LEFT> {
  	
			"{Id " {UNREALID} "}" {
				((PlayerLeft)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Name " {STRING} "}" {
				((PlayerLeft)actObj).Name = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_LEFT unprocessed: " + yytext());
		}
  	}
}

<MSG_EPLR> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_EPLR unprocessed: " + yytext());
		}
  	}
}

<MSG_SPLR> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SPLR unprocessed: " + yytext());
		}
  	}
}

<MSG_PLS> {
  	
			"{Id " {UNREALID} "}" {
				((PlayerScore)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Score " {INT} "}" {
				((PlayerScore)actObj).Score = intValue(yytext());
				
			}
		
			"{Deaths " {INT} "}" {
				((PlayerScore)actObj).Deaths = intValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_PLS unprocessed: " + yytext());
		}
  	}
}

<MSG_PONG> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_PONG unprocessed: " + yytext());
		}
  	}
}

<MSG_RCH> {
  	
			"{Id " {STRING} "}" {
				((Reachable)actObj).Id = stringValue(yytext());
				
			}
		
			"{Reachable " {BOOLEAN} "}" {
				((Reachable)actObj).Reachable = booleanValue(yytext());
				
			}
		
			"{From " {LOCATION} "}" {
				((Reachable)actObj).From = locationValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_RCH unprocessed: " + yytext());
		}
  	}
}

<MSG_RECEND> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_RECEND unprocessed: " + yytext());
		}
  	}
}

<MSG_RECSTART> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_RECSTART unprocessed: " + yytext());
		}
  	}
}

<MSG_SLF> {
  	
			"{Id " {UNREALID} "}" {
				((Self)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Name " {STRING} "}" {
				((Self)actObj).Name = stringValue(yytext());
				
			}
		
			"{Vehicle " {BOOLEAN} "}" {
				((Self)actObj).Vehicle = booleanValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((Self)actObj).Location = locationValue(yytext());
				
			}
		
			"{Velocity " {VELOCITY} "}" {
				((Self)actObj).Velocity = velocityValue(yytext());
				
			}
		
			"{Rotation " {ROTATION} "}" {
				((Self)actObj).Rotation = rotationValue(yytext());
				
			}
		
			"{Team " {INT} "}" {
				((Self)actObj).Team = intValue(yytext());
				
			}
		
			"{Weapon " {UNREALID} "}" {
				((Self)actObj).Weapon = unrealIdValue(yytext());
				
			}
		
			"{Shooting " {BOOLEAN} "}" {
				((Self)actObj).Shooting = booleanValue(yytext());
				
			}
		
			"{Health " {INT} "}" {
				((Self)actObj).Health = intValue(yytext());
				
			}
		
			"{PrimaryAmmo " {INT} "}" {
				((Self)actObj).PrimaryAmmo = intValue(yytext());
				
			}
		
			"{SecondaryAmmo " {INT} "}" {
				((Self)actObj).SecondaryAmmo = intValue(yytext());
				
			}
		
			"{Adrenaline " {INT} "}" {
				((Self)actObj).Adrenaline = intValue(yytext());
				
			}
		
			"{Armor " {INT} "}" {
				((Self)actObj).Armor = intValue(yytext());
				
			}
		
			"{SmallArmor " {INT} "}" {
				((Self)actObj).SmallArmor = intValue(yytext());
				
			}
		
			"{AltFiring " {BOOLEAN} "}" {
				((Self)actObj).AltFiring = booleanValue(yytext());
				
			}
		
			"{Crouched " {BOOLEAN} "}" {
				((Self)actObj).Crouched = booleanValue(yytext());
				
			}
		
			"{Walking " {BOOLEAN} "}" {
				((Self)actObj).Walking = booleanValue(yytext());
				
			}
		
			"{FloorLocation " {LOCATION} "}" {
				((Self)actObj).FloorLocation = locationValue(yytext());
				
			}
		
			"{FloorNormal " {LOCATION} "}" {
				((Self)actObj).FloorNormal = locationValue(yytext());
				
			}
		
			"{Combo " {STRING} "}" {
				((Self)actObj).Combo = stringValue(yytext());
				
			}
		
			"{UDamageTime " {DOUBLE} "}" {
				((Self)actObj).UDamageTime = doubleValue(yytext());
				
			}
		
			"{Action " {STRING} "}" {
				((Self)actObj).Action = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SLF unprocessed: " + yytext());
		}
  	}
}

<MSG_SHOOT> {
  	
			"{Alt " {BOOLEAN} "}" {
				((ShootingStarted)actObj).Alt = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SHOOT unprocessed: " + yytext());
		}
  	}
}

<MSG_STOPSHOOT> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_STOPSHOOT unprocessed: " + yytext());
		}
  	}
}

<MSG_SPW> {
  	
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_SPW unprocessed: " + yytext());
		}
  	}
}

<MSG_TEAMCHANGE> {
  	
			"{Success " {BOOLEAN} "}" {
				((TeamChanged)actObj).Success = booleanValue(yytext());
				
			}
		
			"{DesiredTeam " {INT} "}" {
				((TeamChanged)actObj).DesiredTeam = intValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_TEAMCHANGE unprocessed: " + yytext());
		}
  	}
}

<MSG_VMT> {
  	
			"{Id " {UNREALID} "}" {
				((TeamChat)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Name " {STRING} "}" {
				((TeamChat)actObj).Name = stringValue(yytext());
				
			}
		
			"{Text " {STRING} "}" {
				((TeamChat)actObj).Text = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_VMT unprocessed: " + yytext());
		}
  	}
}

<MSG_TES> {
  	
			"{Id " {UNREALID} "}" {
				((TeamScore)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Team " {INT} "}" {
				((TeamScore)actObj).Team = intValue(yytext());
				
			}
		
			"{Score " {INT} "}" {
				((TeamScore)actObj).Score = intValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_TES unprocessed: " + yytext());
		}
  	}
}

<MSG_THROWN> {
  	
			"{Id " {UNREALID} "}" {
				((Thrown)actObj).Id = unrealIdValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_THROWN unprocessed: " + yytext());
		}
  	}
}

<MSG_TRC> {
  	
			"{Id " {STRING} "}" {
				((TraceResponse)actObj).Id = stringValue(yytext());
				
			}
		
			"{From " {LOCATION} "}" {
				((TraceResponse)actObj).From = locationValue(yytext());
				
			}
		
			"{To " {LOCATION} "}" {
				((TraceResponse)actObj).To = locationValue(yytext());
				
			}
		
			"{Result " {BOOLEAN} "}" {
				((TraceResponse)actObj).Result = booleanValue(yytext());
				
			}
		
			"{HitNormal " {VECTOR3D} "}" {
				((TraceResponse)actObj).HitNormal = vector3dValue(yytext());
				
			}
		
			"{HitLocation " {VECTOR3D} "}" {
				((TraceResponse)actObj).HitLocation = vector3dValue(yytext());
				
			}
		
			"{HitID " {UNREALID} "}" {
				((TraceResponse)actObj).HitID = unrealIdValue(yytext());
				
			}
		
			"{TraceActors " {BOOLEAN} "}" {
				((TraceResponse)actObj).TraceActors = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_TRC unprocessed: " + yytext());
		}
  	}
}

<MSG_TRG> {
  	
			"{Actor " {STRING} "}" {
				((Trigger)actObj).Actor = stringValue(yytext());
				
			}
		
			"{EventInstigator " {UNREALID} "}" {
				((Trigger)actObj).EventInstigator = unrealIdValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_TRG unprocessed: " + yytext());
		}
  	}
}

<MSG_VEH> {
  	
			"{Id " {UNREALID} "}" {
				((Vehicle)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{Rotation " {ROTATION} "}" {
				((Vehicle)actObj).Rotation = rotationValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((Vehicle)actObj).Location = locationValue(yytext());
				
			}
		
			"{Velocity " {VELOCITY} "}" {
				((Vehicle)actObj).Velocity = velocityValue(yytext());
				
			}
		
			"{Visible " {BOOLEAN} "}" {
				((Vehicle)actObj).Visible = booleanValue(yytext());
				
			}
		
			"{Team " {INT} "}" {
				((Vehicle)actObj).Team = intValue(yytext());
				
			}
		
			"{Health " {INT} "}" {
				((Vehicle)actObj).Health = intValue(yytext());
				
			}
		
			"{Armor " {INT} "}" {
				((Vehicle)actObj).Armor = intValue(yytext());
				
			}
		
			"{Driver " {UNREALID} "}" {
				((Vehicle)actObj).Driver = unrealIdValue(yytext());
				
			}
		
			"{TeamLocked " {BOOLEAN} "}" {
				((Vehicle)actObj).TeamLocked = booleanValue(yytext());
				
			}
		
			"{Type " {STRING} "}" {
				((Vehicle)actObj).Type = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_VEH unprocessed: " + yytext());
		}
  	}
}

<MSG_VCH> {
  	
			"{Id " {STRING} "}" {
				((VolumeChanged)actObj).Id = stringValue(yytext());
				
			}
		
			"{ZoneVelocity " {VELOCITY} "}" {
				((VolumeChanged)actObj).ZoneVelocity = velocityValue(yytext());
				
			}
		
			"{ZoneGravity " {VELOCITY} "}" {
				((VolumeChanged)actObj).ZoneGravity = velocityValue(yytext());
				
			}
		
			"{GroundFriction " {DOUBLE} "}" {
				((VolumeChanged)actObj).GroundFriction = doubleValue(yytext());
				
			}
		
			"{FluidFriction " {DOUBLE} "}" {
				((VolumeChanged)actObj).FluidFriction = doubleValue(yytext());
				
			}
		
			"{TerminalVelocity " {DOUBLE} "}" {
				((VolumeChanged)actObj).TerminalVelocity = doubleValue(yytext());
				
			}
		
			"{WaterVolume " {BOOLEAN} "}" {
				((VolumeChanged)actObj).WaterVolume = booleanValue(yytext());
				
			}
		
			"{PainCausing " {BOOLEAN} "}" {
				((VolumeChanged)actObj).PainCausing = booleanValue(yytext());
				
			}
		
			"{Destructive " {BOOLEAN} "}" {
				((VolumeChanged)actObj).Destructive = booleanValue(yytext());
				
			}
		
			"{DamagePerSec " {DOUBLE} "}" {
				((VolumeChanged)actObj).DamagePerSec = doubleValue(yytext());
				
			}
		
			"{DamageType " {STRING} "}" {
				((VolumeChanged)actObj).DamageType = stringValue(yytext());
				
			}
		
			"{NoInventory " {BOOLEAN} "}" {
				((VolumeChanged)actObj).NoInventory = booleanValue(yytext());
				
			}
		
			"{MoveProjectiles " {BOOLEAN} "}" {
				((VolumeChanged)actObj).MoveProjectiles = booleanValue(yytext());
				
			}
		
			"{NeutralZone " {BOOLEAN} "}" {
				((VolumeChanged)actObj).NeutralZone = booleanValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_VCH unprocessed: " + yytext());
		}
  	}
}

<MSG_WAL> {
  	
			"{Id " {STRING} "}" {
				((WallCollision)actObj).Id = stringValue(yytext());
				
			}
		
			"{Normal " {VECTOR3D} "}" {
				((WallCollision)actObj).Normal = vector3dValue(yytext());
				
			}
		
			"{Location " {LOCATION} "}" {
				((WallCollision)actObj).Location = locationValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_WAL unprocessed: " + yytext());
		}
  	}
}

<MSG_WUP> {
  	
			"{Id " {UNREALID} "}" {
				((WeaponUpdate)actObj).Id = unrealIdValue(yytext());
				
			}
		
			"{PrimaryAmmo " {INT} "}" {
				((WeaponUpdate)actObj).PrimaryAmmo = intValue(yytext());
				
			}
		
			"{SecondaryAmmo " {INT} "}" {
				((WeaponUpdate)actObj).SecondaryAmmo = intValue(yytext());
				
			}
		
			"{InventoryType " {STRING} "}" {
				((WeaponUpdate)actObj).InventoryType = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_WUP unprocessed: " + yytext());
		}
  	}
}

<MSG_ZCB> {
  	
			"{Id " {STRING} "}" {
				((ZoneChangedBot)actObj).Id = stringValue(yytext());
				
			}
		
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_ZCB unprocessed: " + yytext());
		}
  	}
}




<DUMMY> {
	. {
		warning("Dummy state, should not reach here: " + yytext());
	}
}

{WHITE_SPACE_CHAR} { }

{NEWLINE} { 
		// reset scanning
		stack_pos = 0;
 		yybegin(YYINITIAL);
 		if (actObj != null)
 		{ 			
 			InfoMessage obj = (InfoMessage) actObj;
 			
 			if (obj instanceof BeginMessage) {
                ut2004Time = ((BeginMessage)obj).getTime();
            } else
            if (obj instanceof AliveMessage) {
                ut2004Time = ((AliveMessage)obj).getTime();
            } else
 			if (obj instanceof IWorldObject) {
 				setTime((IWorldObject)obj, ut2004Time);
 			}
 			
 			actObj = null;
 			return obj;
 		}
}


. {
  warning("Illegal character: <" + yytext() + "> + currentstate "+ yystate());  
}


