<?xml version="1.0" encoding="UTF-8"?>

<!--
    Document   : MessageTransformer.xslt.xml
    Created on : 17. březen 2008, 10:53
    Author     : ik, Jimmy
    Description:
        Transforms the MessageObjectsList.xml file fo set of Java wrappers for
        the GB messages.
-->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="2.0">
    <xsl:output method="text" indent="yes"/>

<!--
	INCLUDES
 -->
 	<xsl:include href="Interfaces.xslt" />
  <!--<xsl:include href="../../../../../../tools/docbook-xsl-1.73.2/xhtml/docbook.xsl"/>!-->
  <!--<xsl:include href="../../../../../../tools/docbook-xsl2-snapshot/base/html/html.xsl"/>!-->

<!--
	CONFIGURATION
 -->
    <!-- target directory for java files. !-->
    <xsl:variable name="commandsJavaDir">../gbcommands/</xsl:variable>
    <xsl:variable name="infoJavaDir">../gbinfomessages/</xsl:variable>

<!--
	SUBROUTINES (i.e., templates that are called as methods) 
 -->
 
 	<!--
 		Makes some string to begin with upper-case character
 		CONTEXT: /all/ 
 	 -->
    <xsl:template name="uppercaseFirst">
        <xsl:param name="str"/>
        <xsl:param name="strLen" select="string-length($str)"/>
        <xsl:variable name="firstLetter" select="substring($str,1,1)"/>
        <xsl:variable name="restString" select="substring($str,2,$strLen)"/>
        <xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>
        <xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
        <xsl:variable name="translate" select="translate($firstLetter,$lower,$upper)"/>
        <xsl:value-of select="concat($translate,$restString)"/>
    </xsl:template>
 
 
 	<!--
 		Used to write a notice at the beginning of the file that the file is auto-generated. 
 	 -->
 	<xsl:template name="header">
	 	/**
         IMPORTANT !!!

         DO NOT EDIT THIS FILE. IT IS GENERATED FROM approriate xml file in <xsl:choose>
                      <xsl:when test="@command">xmlresources/gbcommands</xsl:when>
                      <xsl:when test="@message">xmlresources/gbinfomessages</xsl:when>
                      <xsl:otherwise>!ERROR!</xsl:otherwise>
                  </xsl:choose> BY
         THE JavaClassesGenerator.xslt. MODIFY THAT FILE INSTEAD OF THIS ONE.
         
         Use Ant task process-gb-messages after that to generate .java files again.
         
         IMPORTANT END !!!
        */
 	</xsl:template>
 	
 	<!--
 		Used to create 'import' declaration at the beginning of the .java class file. 
 	 -->
 	<xsl:template name="javaimport">
        <xsl:param name="package"/>
        <xsl:text>import </xsl:text>
                <xsl:value-of select="$package"/>;
    </xsl:template>
 	
 	<!--
 		Used to create all 'import' declarations at the beginning of the .java class file.
 		CONTEXT: /all/  
 	 -->
 	<xsl:template name="fillImports">
		<xsl:for-each select="/messages/settings/javasettings/javaimport">
		    <xsl:call-template name="javaimport">
		        <xsl:with-param name="package" select="@import"/>
		    </xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="extra/code/java/javaimport">
		    <xsl:call-template name="javaimport">
		        <xsl:with-param name="package" select="@import"/>
		    </xsl:call-template>
		</xsl:for-each>
    </xsl:template>
 	
 	<!--
 		Used to create type name of the message property
 		CONTEXT: messageobject/property 
 	 -->
 	<xsl:template name="typeMessage">
 		<xsl:value-of select="@type" />        
 	</xsl:template>
 	
 	<!--
 		Used to create type name of the command property
 		CONTEXT: commandobject/property 
 	 -->
 	<xsl:template name="typeCommand">
 		<xsl:choose>
            <xsl:when test="@type = 'boolean'">Boolean</xsl:when>
        	<xsl:when test="@type = 'int'">Integer</xsl:when>
        	<xsl:when test="@type = 'float'">Float</xsl:when>
        	<xsl:when test="@type = 'double'">Double</xsl:when>
        	<xsl:otherwise>
        		<xsl:value-of select="@type"/>
        	</xsl:otherwise>
       	</xsl:choose>
 	</xsl:template>
 	
 	<!-- 
 		Generates constructor(s) for the message class.
 		CONTEXT: messageobject
 	-->
    <xsl:template name="constructorCreatorMessage">
		/**
		  Creates new instance of the message <xsl:value-of select="@name"/>.
		  <xsl:apply-templates select="documentation"/>
		  <p>Corresponding GameBots message for is
		  <code><xsl:value-of select="@message"/></code>.</p>
		
		  <xsl:for-each select="property">
		      @param <xsl:value-of select="@name"/><xsl:text> </xsl:text><xsl:apply-templates select="documentation"/>
		  </xsl:for-each>
		*/
		public <xsl:value-of select="@name"/>(
            	<xsl:for-each select="property">
            		<xsl:call-template name="typeMessage" />
   	         		
               		<xsl:text> </xsl:text>
               		<xsl:value-of select="@name"/>
                   		<xsl:if test="position() != last()">
					<xsl:text>,  </xsl:text>
				</xsl:if>
               </xsl:for-each>
		) {
			<xsl:for-each select="property">
				this.<xsl:value-of select="@name"/> = <xsl:value-of select="@name"/>;
               </xsl:for-each>
		}
		
		<xsl:if test="not(count(property) = 0)">
			/**
	         * Used by Yylex to create empty message then to fill it's protected fields (Yylex is in the same package).
	         */
		    public <xsl:value-of select="@name"/>() {
		    }
	    </xsl:if>
	    
    </xsl:template>
 	
 	<!-- 
 		Generates constructor(s) for the command class.
 		CONTEXT: commandobject
 	-->
    <xsl:template name="constructorCreatorCommand">
		/**
		  Creates new instance of command <xsl:value-of select="@name"/>.
		  <xsl:apply-templates select="documentation"/>
		  <p>Corresponding GameBots message for this command is
		  <code><xsl:value-of select="@command"/></code>.</p>
		
		  <xsl:for-each select="property">
		      @param <xsl:value-of select="@name"/><xsl:text> </xsl:text><xsl:apply-templates select="documentation"/>
		  </xsl:for-each>
		  */
		public <xsl:value-of select="@name"/>(
            	<xsl:for-each select="property">
            		<xsl:call-template name="typeCommand" />
   	         		
               		<xsl:text> </xsl:text>
               		<xsl:value-of select="@name"/>
                   		<xsl:if test="position() != last()">
					<xsl:text>,  </xsl:text>
				</xsl:if>
               </xsl:for-each>
		) {
			<xsl:for-each select="property">
				this.<xsl:value-of select="@name"/> = <xsl:value-of select="@name"/>;
               </xsl:for-each>
		}

		<xsl:if test="not(count(property) = 0)">
			/**
			Creates new instance of command <xsl:value-of select="@name"/>.
			<xsl:apply-templates select="documentation"/>
			<p>Corresponding GameBots message for this command is
			<code><xsl:value-of select="@command"/></code>.</p>
			<xsl:text><![CDATA[<p></p>]]></xsl:text>
			<b>WARNING:</b> this is empty-command constructor, you have to use setters to fill it up!
		    */
		    public <xsl:value-of select="@name"/>() {
		    }
		</xsl:if>	
    </xsl:template>
 	
 	<!-- 
 		Used to create Cloning constructor. 		
 		CONTEXT: messageobject | commandobject 
 	 -->
 	<xsl:template name="cloningConstructor">
		/**
		 * Cloning constructor.
		 */
		public <xsl:value-of select="@name"/>(<xsl:value-of select="@name"/> original) {
		   <xsl:for-each select="property">
		        this.<xsl:value-of select="@name"/>=original.<xsl:value-of select="@name"/>;
		   </xsl:for-each>
		}
 	</xsl:template>
 	
 	<!--
 		Outputs toString() method. 		
 		CONTEXT: messageobject | commandobject 
 	 -->
 	<xsl:template name="toString">
 	    public String toString() {
            return
            <xsl:choose>
				<xsl:when test="@message">
	           		super.toString() + " | " +
	           		<xsl:for-each select="property">
	              		<xsl:if test="not(@jflex)">
	              			"<xsl:value-of select="@name"/> = " +
	              			String.valueOf(<xsl:value-of select="@name"/>) + " | " +
	           			</xsl:if>
					</xsl:for-each> "";
           		</xsl:when>
				<xsl:when test="@command">
               		toMessage();
               	</xsl:when>
           </xsl:choose>
        }
 	</xsl:template>
 	
 	<!--
 		Outputs message as HTML snippet.		
 		CONTEXT: messageobject | commandobject 
 	 -->
 	<xsl:template name="toHtmlString">
 		public String toHtmlString() {
			return super.toString() +
            <xsl:for-each select="property">
            "<![CDATA[<b>]]><xsl:value-of select="@name"/><![CDATA[</b>]]> : " +
            String.valueOf(<xsl:value-of select="@name"/>) +
            " <![CDATA[<br/>]]> " +
            </xsl:for-each> "";
		}
 	</xsl:template>
 	
 	<!-- 
 		Generates prototype string with the message.
 		CONTEXT: messageobject | commandobject
 	-->
    <xsl:template name="prototypeCreator">
    	/** Example how the message looks like - used during parser tests. */
    	public static final String PROTOTYPE =
    		"<xsl:value-of select="@message"/><xsl:for-each select="property"><xsl:if test="not(@jflex)"><xsl:text> {</xsl:text><xsl:value-of select="@name"/><xsl:text> </xsl:text><xsl:choose>
  				<xsl:when test="@type = 'Boolean'">False</xsl:when>
  				<xsl:when test="@type = 'boolean'">False</xsl:when>
  				<xsl:when test="@type = 'Integer'">0</xsl:when>
  				<xsl:when test="@type = 'int'">0</xsl:when>
  				<xsl:when test="@type = 'Float'">0</xsl:when>
  				<xsl:when test="@type = 'float'">0</xsl:when>
  				<xsl:when test="@type = 'Double'">0</xsl:when>
  				<xsl:when test="@type = 'double'">0</xsl:when>
  				<xsl:when test="@type = 'Point3d'">0,0,0</xsl:when>
  				<xsl:when test="@type = 'Vector3d'">0,0,0</xsl:when>
  				<xsl:when test="@type = 'Location'">0,0,0</xsl:when>
  				<xsl:when test="@type = 'Velocity'">0,0,0</xsl:when>
  				<xsl:when test="@type = 'Rotation'">0,0,0</xsl:when>
  				<xsl:when test="@type = 'UnrealId'">unreal_id</xsl:when>
  				<xsl:when test="@type = 'ItemType'">xWeapons.FlakCannonPickup</xsl:when>
  				<xsl:when test="@type = 'String'">text</xsl:when>
  				<xsl:otherwise>null</xsl:otherwise>
  			</xsl:choose><xsl:text>}</xsl:text></xsl:if></xsl:for-each>";
    </xsl:template>

<!--
	MAIN SUBROUTINE FOR THE 'messageobject' 
 -->  
 	<xsl:template name="messageobject">
 		<!-- template parameters -->
    	<xsl:param name="filename"/>
    	<!-- template variables -->
    	<xsl:variable name="interfaces"></xsl:variable>
		<!-- result document where the .java class is going to be output into -->
        <xsl:result-document href="{$filename}" method="text" indent="yes">
            
        <xsl:call-template name="header"/>
            
        package <xsl:value-of select="/messages/settings/javasettings/javapackageinfomessages/@package"/>;

        <xsl:call-template name="fillImports"/>
        <!-- Apply the Docbook to HTML transformation. !-->
        /**
	    <xsl:apply-templates select="documentation"/>
        <p>Corresponding GameBots message is  <code><xsl:value-of select="@message"/></code>.</p>
        */
        <xsl:for-each select="annotation">
			@<xsl:value-of select="@name"/>
        </xsl:for-each>
        <xsl:if test="@type = 'Synchronous'">
          	@SyncMessage
        </xsl:if>
        public class <xsl:value-of select="@name"/>
            <!--TODO polish the interfaces -->
            <xsl:choose>
                <xsl:when test="@type = 'Event'">
                    extends GBEvent
                </xsl:when>
                <xsl:when test="@type = 'ObjectUpdate'">
                    extends GBObjectUpdate
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="@extends"/>
                </xsl:otherwise>
            </xsl:choose>

           <!-- list of interfaces, some from the implements tag, some determined by
           the message type. !-->
           <xsl:variable name="interfaces2">
	           <xsl:choose>
		            <xsl:when test="@type='Event' or @type='Batch'">
		            	<xsl:call-template name="addInterfaces">
			            		<xsl:with-param name="interfaces" select="$interfaces"/>
			            		<xsl:with-param name="interfacesToAdd" select="'IWorldEvent, IWorldChangeEvent'"/>
			            </xsl:call-template>
		            </xsl:when>
		            <xsl:when test="@type='ObjectUpdate'">
		            	<xsl:call-template name="addInterfaces">
		            		<xsl:with-param name="interfaces" select="$interfaces"/>
		            		<xsl:with-param name="interfacesToAdd" select="'IGBWorldObjectEvent, IWorldObject'"/>
			            </xsl:call-template>
		            </xsl:when>
		            <xsl:otherwise>
		            	<xsl:value-of select="$interfaces"/>
		            </xsl:otherwise>
		        </xsl:choose>
	    	</xsl:variable>
	        <xsl:variable name="interfaces3">
	        	<xsl:call-template name="addInterfaces">
	        		<xsl:with-param name="interfaces" select="$interfaces2"/>
	        		<xsl:with-param name="interfacesToAdd" select="./implements/@interfaces"/>
	        	</xsl:call-template>
	        </xsl:variable>
			<xsl:choose>
            	<xsl:when test="normalize-space($interfaces3) = ''">
            	</xsl:when>
            	<xsl:otherwise>
	            	implements <xsl:value-of select="$interfaces3"/>
    	        </xsl:otherwise>
        	</xsl:choose>
            {            
            
            <xsl:call-template name="constructorCreatorMessage" />
            
            <xsl:call-template name="prototypeCreator"/>
            
            <xsl:apply-templates select="property"/>
            
            /////// Extra Java code BEGIN

            	/////// Additional code from xslt BEGIN
            		<xsl:if test="@type = 'ObjectUpdate'">
            		<!-- Now we have to check whether we have all informations
            		     IWorldObject interface requires (Id, lastSeenTime),
            		     if not -> add them manually
            	    -->
            			<xsl:choose>
            				<xsl:when test="./property[@name='Id']">
            				</xsl:when>
            				<xsl:otherwise>
            					public static final UnrealId <xsl:value-of select="@name"/>Id = UnrealId.get("<xsl:value-of select="@name"/>Id");

            					public UnrealId getId() {
            						return <xsl:value-of select="@name"/>Id;
            					}
            				</xsl:otherwise>
            			</xsl:choose>

       					<xsl:choose>
       						<xsl:when test="./property[@name='Time']">
       							protected void setTime(double time) {
       								this.Time = time;
       							}

       							public double getLastSeenTime() {
       								return Time;
       							}
       						</xsl:when>
       						<xsl:otherwise>
       							protected double Time = 0;

       							protected double getTime() {
       								return Time;
       							}

       							protected void setTime(double time) {
       								this.Time = time;
       							}

       							public double getLastSeenTime() {
       								return Time;
       							}
       						</xsl:otherwise>
       					</xsl:choose>

       					public boolean equals(Object obj) {
	                        if (!(obj instanceof <xsl:value-of select="@name"/>)) return false;
	                        <xsl:value-of select="@name"/> cast = (<xsl:value-of select="@name"/>)obj;
	                        if (this.getId() != null) return this.getId().equals(cast.getId());
	                        else return cast.getId() == null;
	                    }

	                    public int hashCode() {
	                        if (getId() != null) return getId().hashCode();
	                        return 0;
	                    }

            		</xsl:if>


            	/////// Additional code from xslt END

	            /////// Extra Java from XML BEGIN
            		<xsl:value-of select="extra/code/java"/>
            	/////// Extra Java from XML END

            /////// Extra Java code END

            <!-- CUSTOM CODE !-->

            /**
              * Cloning constructor.
              */
             public <xsl:value-of select="@name"/>(<xsl:value-of select="@name"/> original) {
                 <xsl:for-each select="property">
                     this.<xsl:value-of select="@name"/>=original.<xsl:value-of select="@name"/>;
                 </xsl:for-each>
             }
             
            <xsl:choose>
	    		<xsl:when test="@type = 'ObjectUpdate'">
	    		<xsl:if test="./property[@name='Visible']">

	    		     /**
	    		      * Used to drop Visible flag from the object.
	    		      */
	    		     public static class ObjectDisappeared implements IGBWorldObjectDisappeared {

	    		         private IWorldObject orig;

	    		         public ObjectDisappeared(IWorldObject orig) {
	    		             this.orig = orig;
	    		         }

	    		         public WorldObjectId getId() {
	    		             return orig.getId();
	    		         }

                         public IWorldObjectUpdateResult update(IWorldObject obj) {
                            if (obj == null) {
                                throw new PogamutException("not meant to create new object, probably wanted to update non-existing object of id: " + getId(), this);
                            }
                            if (!(obj instanceof <xsl:value-of select="@name"/>)) {
                                throw new PogamutException("can't update object of class " + obj.getClass() + ", meant to update <xsl:value-of select="@name"/>", this);
                            }
                            orig = obj;
                            <xsl:value-of select="@name"/> toUpdate = (<xsl:value-of select="@name"/>)obj;
                            if (toUpdate.Visible) {
								toUpdate.Visible = false;
								return new IWorldObjectUpdateResult.WorldObjectUpdateResult(cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult.Result.UPDATED, toUpdate);
							} else {
								return new IWorldObjectUpdateResult.WorldObjectUpdateResult(cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult.Result.SAME, toUpdate);
							}
                         }

                         public IWorldObject getObject() {
                            return orig;
                         }

                         public String toString() {
                            return "ObjectDisappeared[" + orig.getClass().getSimpleName() + " " + orig.getId().getStringId() + "]";
                         }

	    		     }

	    		     /**
	    		      * Used to create event that drops the Visible flag of the item.
	    		      */
	    		     public <xsl:value-of select="@name"/>(<xsl:value-of select="@name"/> Original, boolean Visible) {
	    		         this(Original);
	    		         this.Visible = Visible;
	    		     }

	    		     public IGBWorldObjectDisappeared createDisappearEvent() {
	    		         return new ObjectDisappeared(this);
	    		     }
	    		</xsl:if>

	    		/**
	    		 * Here we save the original object for which this object is an update.
	    		 */
	    		private IWorldObject orig = null;

	            public IWorldObjectUpdateResult update(IWorldObject obj) {
		            if(obj == null) {
		               orig = this;
		               return new IWorldObjectUpdateResult.WorldObjectUpdateResult(cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult.Result.CREATED, this);
		            }
		            orig = obj;
		            // typecast
		            <xsl:value-of select="@name"/><xsl:text> </xsl:text> o = (<xsl:value-of select="@name"/>)obj;

		            boolean updated = false;

		            <xsl:for-each select="property[@volatile]">
		            	<xsl:choose>
		    				<xsl:when test="@type = 'Boolean'">
		    					if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'boolean'">
		    					if (o.<xsl:value-of select="@name"/> != <xsl:value-of select="@name"/>) {
		    					    o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'Integer'">
		    					if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'int'">
		    					if (o.<xsl:value-of select="@name"/> != <xsl:value-of select="@name"/>) {
		    					    o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'Float'">
		    					if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'float'">
		    					if (o.<xsl:value-of select="@name"/> != <xsl:value-of select="@name"/>) {
		    					    o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'Double'">
		    					if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'double'">
		    					if (o.<xsl:value-of select="@name"/> != <xsl:value-of select="@name"/>) {
		    					    o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'Point3d'">
		    					if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'Vector3d'">
		    					if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'Location'">
                                if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
                            </xsl:when>
                            <xsl:when test="@type = 'Velocity'">
                                if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
                            </xsl:when>
                            <xsl:when test="@type = 'Rotation'">
                                if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
                            </xsl:when>
                            <xsl:when test="@type = 'Color'">
                                if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
                            </xsl:when>
                            <xsl:when test="@type = 'Point2D'">
                                if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
                            </xsl:when>
                            <xsl:when test="@type = 'Dimension2D'">
                                if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
                            </xsl:when>
		    				<xsl:when test="@type = 'UnrealId'">
		    					if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'String'">
		    					if (!SafeEquals.equals(o.<xsl:value-of select="@name"/>, <xsl:value-of select="@name"/>)) {
		    						o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		    						updated = true;
		    					}
		    				</xsl:when>
		    				<xsl:otherwise> unsupported type <xsl:value-of select="@type"/> </xsl:otherwise>
	    				</xsl:choose>
		            </xsl:for-each>

		            <!--  If it is ObjectUpdate && we don't have property Time,
		            	  (that means the property Time is added by this XSLT),
		            	  put into update additional property Time
		             -->
		            <xsl:if test="@type = 'ObjectUpdate'">
		            	<xsl:choose>
							<xsl:when test="./property[@name='Time']">
							</xsl:when>
							<xsl:otherwise>
								o.Time = Time;
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>

		            if (updated) {
		                return new IWorldObjectUpdateResult.WorldObjectUpdateResult(cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult.Result.UPDATED, o);
		            } else {
		            	return new IWorldObjectUpdateResult.WorldObjectUpdateResult(cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult.Result.SAME, o);
		            }
		        }

	            /**
	             * Returns original object (if method update() has already been called, for bot-programmer that is always true
	             * as the original object is updated and then the event is propagated).
	             */
		        public IWorldObject getObject() {
		            if (orig == null) return this;
		            return orig;
		        }
	        </xsl:when>
        </xsl:choose>

		<!-- toString method -->
		<xsl:call-template name="toString"/>
            
		<!-- toHtmlString method -->
		<xsl:call-template name="toHtmlString"/>
        }

        </xsl:result-document>
    </xsl:template>
    
 <!--
	MAIN SUBROUTINE FOR THE 'commandobject' 
 -->  
 	<xsl:template name="commandobject">
 		<!-- template parameters -->
    	<xsl:param name="filename"/>
		<!-- result document where the .java class is going to be output into -->
        <xsl:result-document href="{$filename}" method="text" indent="yes">
            
        <xsl:call-template name="header"/>
            
        package <xsl:value-of select="/messages/settings/javasettings/javapackagecommands/@package"/>;

            <xsl:call-template name="fillImports"/>
            <!-- Apply the Docbook to HTML transformation. !-->
            /**
              <xsl:apply-templates select="documentation"/>

              <p>
                 Corresponding GameBots command is <code><xsl:value-of select="@command"/></code>.
              </p>
             */
            <xsl:for-each select="annotation">
            	@<xsl:value-of select="@name"/>
            </xsl:for-each>
            <xsl:if test="@type = 'Synchronous'">
            	@SyncMessage
            </xsl:if>
            public class
            <xsl:value-of select="@name"/>
            
            <xsl:apply-templates select="@extends" />

            <xsl:if test="./implements/@interfaces">
	           	implements <xsl:value-of select="./implements/@interfaces"/>
	        </xsl:if>

            {
            <xsl:call-template name="constructorCreatorCommand"/>
            
            /////// Properties BEGIN
            <xsl:apply-templates select="property"/>
            /////// Properties END

            /////// Extra Java code BEGIN

  	            /////// Extra Java from XML BEGIN
            		<xsl:value-of select="extra/code/java"/>
            	/////// Extra Java from XML END
            	
            	<xsl:call-template name="cloningConstructor"/>
            	
            /////// Extra Java code END

			<xsl:call-template name="toString" />
			
			<xsl:call-template name="toHtmlString" />

             <!-- To GB string. Used for sending the command. !-->
             <xsl:if test="@command">
             	 public String toMessage() {
              		StringBuffer buf = new StringBuffer();
              		buf.append("<xsl:value-of select="@command"/>");
              		<xsl:for-each select="property">
	              		<xsl:choose>
		    				<xsl:when test="@type = 'Point3d'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " +
		    							<xsl:value-of select="@name"/>.getX() + "," +
		    							<xsl:value-of select="@name"/>.getY() + "," +
		    							<xsl:value-of select="@name"/>.getZ() + "}");
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'Vector3d'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " +
		    							<xsl:value-of select="@name"/>.getX() + "," +
		    							<xsl:value-of select="@name"/>.getY() + "," +
		    							<xsl:value-of select="@name"/>.getZ() + "}");
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'Location'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " +
                                        <xsl:value-of select="@name"/>.getX() + "," +
                                        <xsl:value-of select="@name"/>.getY() + "," +
                                        <xsl:value-of select="@name"/>.getZ() + "}");
                                }
                            </xsl:when>
                            <xsl:when test="@type = 'Velocity'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " +
                                        <xsl:value-of select="@name"/>.getX() + "," +
                                        <xsl:value-of select="@name"/>.getY() + "," +
                                        <xsl:value-of select="@name"/>.getZ() + "}");
                                }
                            </xsl:when>
                            <xsl:when test="@type = 'Rotation'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " +
                                        <xsl:value-of select="@name"/>.getPitch() + "," +
                                        <xsl:value-of select="@name"/>.getYaw() + "," +
                                        <xsl:value-of select="@name"/>.getRoll() + "}");
                                }
                            </xsl:when>
                            <xsl:when test="@type = 'Color'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " +
                                        <xsl:value-of select="@name"/>.getRed() + "," +
                                        <xsl:value-of select="@name"/>.getGreen() + "," +
                                        <xsl:value-of select="@name"/>.getBlue() + "," +
                                        <xsl:value-of select="@name"/>.getAlpha() + "}");
                                }
                            </xsl:when>
                            <xsl:when test="@type = 'Point2D'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " +
                                        <xsl:value-of select="@name"/>.getX() + "," +
                                        <xsl:value-of select="@name"/>.getY() + "}");
                                }
                            </xsl:when>
                            <xsl:when test="@type = 'Dimension2D'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " +
                                        <xsl:value-of select="@name"/>.getWidth() + "," +
                                        <xsl:value-of select="@name"/>.getHeight() + "}");
                                }
                            </xsl:when>
		    				<xsl:when test="@type = 'UnrealId'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/>.getStringId() + "}");
		    					}
		    				</xsl:when>
		    				<xsl:otherwise>
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/> + "}");
		    					}
		    				</xsl:otherwise>
	    				</xsl:choose>
              		</xsl:for-each>
            		return buf.toString();
            }
        </xsl:if>
        }

        </xsl:result-document>
    </xsl:template>

<!-- 
	MAIN PROGRAM
 -->

    <!-- 
    	Template translating message/command objects to java files.
    	  context: /all/ 
    !-->
    <xsl:template match="//messageobject|//commandobject">
    	<xsl:choose>
    		<xsl:when test="local-name() = 'messageobject'">
    			<xsl:call-template name="messageobject">
    				<xsl:with-param name="filename" select="concat($infoJavaDir, @name,'.java')" />
    			</xsl:call-template>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:call-template name="commandobject">
    				<xsl:with-param name="filename" select="concat($commandsJavaDir, @name,'.java')" />
    			</xsl:call-template>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>    
    
<!-- ADDITIONAL TEMPLATES THAT ARE RECALLED WITH apply-templates -->
    
    <xsl:template match="@extends"> extends
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="messageobject/property">    	
        /**
        <xsl:apply-templates select="documentation"/> 
        */
        protected
        <xsl:text> </xsl:text>
        <xsl:call-template name="typeMessage" />        
        <xsl:text> </xsl:text>
        <xsl:value-of select="@name"/> =
       	<xsl:choose>
       		<xsl:when test="@default">
       			<xsl:value-of select="@default"/>
       		</xsl:when>
       		<xsl:otherwise>
        		<xsl:choose>
					<xsl:when test="@type = 'boolean'">false</xsl:when>
					<xsl:when test="@type = 'int'">0</xsl:when>
					<xsl:when test="@type = 'float'">0</xsl:when>
					<xsl:when test="@type = 'double'">0</xsl:when>
					<xsl:otherwise>null</xsl:otherwise>
				</xsl:choose>
        	</xsl:otherwise>
		</xsl:choose>;

        <!-- Getter !-->
        /**
        <xsl:apply-templates select="documentation"/> 
        */
        public
        <xsl:call-template name="typeMessage" />
        <xsl:choose>
            <xsl:when test="@type='boolean'">
                <xsl:text> is</xsl:text>
            </xsl:when>
            <xsl:when test="@type='Boolean'">
                <xsl:text> is</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text> get</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="uppercaseFirst">
            <xsl:with-param name="str" select="@name"/>
        </xsl:call-template>() {
            return
        <xsl:text> </xsl:text>
        <xsl:value-of select="@name"/>;
        }
    </xsl:template>
    
    <xsl:template match="commandobject/property">    	
        /**
        <xsl:apply-templates select="documentation"/> 
        */
        protected
        <xsl:text> </xsl:text>
        <xsl:call-template name="typeCommand" />        
        <xsl:text> </xsl:text>
        <xsl:value-of select="@name"/> =
       	<xsl:choose>
       		<xsl:when test="@default">
       			<xsl:value-of select="@default"/>
       		</xsl:when>
       		<xsl:otherwise>
        		null
        	</xsl:otherwise>
		</xsl:choose>;

        <!-- Getter !-->
        /**
        <xsl:apply-templates select="documentation"/> 
        */
        public
        <xsl:call-template name="typeCommand" />
        <xsl:choose>
            <xsl:when test="@type='boolean'">
                <xsl:text> is</xsl:text>
            </xsl:when>
            <xsl:when test="@type='Boolean'">
                <xsl:text> is</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text> get</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="uppercaseFirst">
            <xsl:with-param name="str" select="@name"/>
        </xsl:call-template>() {
            return
        <xsl:text> </xsl:text>
        <xsl:value-of select="@name"/>;
        }
        <!-- Setter !-->

        <xsl:if test="../@command">
        /**
        <xsl:apply-templates select="documentation"/>
        */
        public <xsl:value-of select="../@name"/>
        <xsl:text> set</xsl:text>
        <xsl:call-template name="uppercaseFirst">
            <xsl:with-param name="str" select="@name"/>
        </xsl:call-template>(
        	<xsl:call-template name="typeCommand" />
        	<xsl:text> </xsl:text>
        	<xsl:value-of select="@name"/>
        ) {
			this.<xsl:value-of select="@name"/> = <xsl:value-of select="@name"/>;
			return this;
		}
       </xsl:if>
    </xsl:template>

    <!-- Docbook to HTML transformations. !-->
    <xsl:template match="para">
        <![CDATA[<p>]]>
            <xsl:apply-templates select="."/>
        <![CDATA[</p>]]>
    </xsl:template>

     <xsl:template match="itemizedlist">
        <![CDATA[<ul>]]>
            <xsl:apply-templates select="."/>
        <![CDATA[</ul>]]>
    </xsl:template>

    <xsl:template match="listitem">
         <![CDATA[<li>]]>
            <xsl:apply-templates select="."/>
        <![CDATA[</li>]]>
    </xsl:template>

     <xsl:template match="simplelist">
         <![CDATA[<ul>]]><xsl:apply-templates/><![CDATA[</ul>]]>
    </xsl:template>

        <xsl:template match="member">
     <![CDATA[<li>]]><xsl:apply-templates/><![CDATA[</li>]]>
    </xsl:template>

<!-- 
	UTILITY PROGRAM
	  - outputs separate files that contains prototypes of all InfoMessage(s)
 --> 
 	<xsl:template match="/">
    	<xsl:result-document href="{concat($infoJavaDir, 'InfoMessages.java')}" method="text" indent="yes">
    		/**
         	IMPORTANT !!!

         	DO NOT EDIT THIS FILE. IT IS GENERATED FROM 
         	THE JavaClassesGenerator.xslt. MODIFY THAT FILE INSTEAD OF THIS ONE.
         
         	Use Ant task process-gb-messages after that to generate this file again.
         
         	IMPORTANT END !!!
        	*/
    	
    		package <xsl:value-of select="/messages/settings/javasettings/javapackageinfomessages/@package"/>;

            <xsl:call-template name="fillImports"/>

            /**
             * Serves for the purpose of testing the parser. Warning - first item in PROTOTYPES is null!
             */
            public class InfoMessages {
            	public static final String[] PROTOTYPES =
            		new String[]{
            			null // dummy
            			<xsl:for-each select="//messageobject">

            				<xsl:text>,</xsl:text>
            				<xsl:value-of select="@name"/><xsl:text>.PROTOTYPE</xsl:text>
            			</xsl:for-each>
            		};

            	/** Serves to initialize map */
            	private static final Map<![CDATA[<]]>String,Class<![CDATA[<]]>? extends InfoMessage>> prototypeMap =
            		new HashMap<![CDATA[<]]>String,Class<![CDATA[<]]>? extends InfoMessage>>();

            	/** Unmodifiable map message.PROTOTYPE -> message.class */
           		public static final Map<![CDATA[<]]>String,Class<![CDATA[<]]>? extends InfoMessage>> PROTOTYPE_MAP;

            	static {
            		<xsl:for-each select="//messageobject">
            			prototypeMap.put(<xsl:value-of select="@name"/>.PROTOTYPE, <xsl:value-of select="@name"/>.class);
           			</xsl:for-each>
					PROTOTYPE_MAP = Collections.unmodifiableMap(prototypeMap);
            	}
            }

            <xsl:apply-templates/>

    	</xsl:result-document>
    </xsl:template>
    
</xsl:stylesheet>




