<?xml version="1.0" encoding="UTF-8"?>

<!--
    Document   : yylex.xsl
    Created on : 14. duben 2008, 11:15
    Author     : student
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  version="2.0">
      
<xsl:output method="text"/>

<xsl:template name="firstLetter">
	
	<xsl:param name="toconvert" />
	<xsl:param name="conversion" />
	<xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>
    <xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>

	<xsl:choose>
		<xsl:when test="$conversion='upper'">
			<xsl:variable name="first" select="translate(substring($toconvert,1,1),$lower,$upper)" />
			<xsl:variable name="rest" select="substring($toconvert, 2, string-length($toconvert))" />
			<xsl:value-of select="concat($first, $rest)"/>
		</xsl:when>
		<xsl:when test="$conversion='lower'">
			<xsl:variable name="first" select="translate(substring($toconvert,1,1),$upper,$lower)" />
			<xsl:variable name="rest" select="substring($toconvert, 2, string-length($toconvert))" />
			<xsl:value-of select="concat($first, $rest)"/>
		</xsl:when>		
		<xsl:otherwise>
			<xsl:value-of select="concat($conversion, $toconvert)" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
    
<xsl:template match="/">
<![CDATA[
// generated by yylex.xsl from Core/src/cz/cuni/pogamut/gbmessages/xmlresources/MessageObjectsList.xml, called from ant script build.xml
// file was further processed by JFlex to create class Yylex (yylex.java)
]]>
package <xsl:value-of select="/messages/settings/jflexsettings/jflexpackage/@package"/>;

import java.io.Reader;

// imports from MessageObjectsList.xml/gbmessages/settings/jflexsettings/javaimport
<xsl:for-each select="/messages/settings/jflexsettings/javaimport">
<xsl:text>import </xsl:text><xsl:value-of select="@import"/><xsl:text>;
</xsl:text>
</xsl:for-each>

<![CDATA[
// beggining of the yylex definition
%%

// declare result class Yylex as public
%public

// return type of the yylex() method should be Object
%type InfoMessage

%implements IUT2004Yylex

// default return value should be null
%eofval{
throw new ParserEOFException(this);
%eofval}

// following block is containing code that will be added to the generated lexical parser yylex.java
%{
	
 	public static final String DELIMITERS_STANDARD = " {}";
 	public static final String DELIMITERS_EXTENDED = " {},";

	/** Map for list of String, Double */
	protected Map<Integer, Double> mapIntIDDouble = null;

	/** Map for list of String, Double */
	protected Map<Integer, Double> mapIntDouble = null;
	
	/** parser reference, this parser will be used for translation of UnrealID to IntID */
	protected UnrealIdTranslator translator = null;
	
	/** object that is used to translate type of the message to the */ 
	protected ItemTranslator itemTranslator = null;
	
	/** observer for the yylex for reporting exceptions */	
	protected IYylexObserver observer = null;
	
	/** time in the UT2004 */	
	protected double ut2004Time = 0;
	
	public Yylex(){
	}
	
	public void setReader(Reader reader) {
		yyreset(reader);
	}
	
	public void close() throws java.io.IOException {
		yyclose();
	}
	
	public void setItemTranslator(ItemTranslator translator) {
		this.itemTranslator = translator;
	}
	
	public void setObserver(IYylexObserver observer) {
		this.observer = observer;
	}
	
	/**
	 * Set parser translating UnrealID to IntID.
	 * This function should be called after constructor, I dont know how to define constructor, so this will do.
	 */
	public void setTranslator(UnrealIdTranslator translator) {
		this.translator = translator;
	}
	
	public void setTime(IWorldObject obj, double time) {
		try {
			Method m = obj.getClass().getDeclaredMethod("setTime", new Class[]{double.class});
			m.setAccessible(true);
			m.invoke(obj, ut2004Time);
		} catch (Exception e) {
			exceptionOccured(e, "can't set Time to message " + obj.getClass());
		}
	}
	
	/**
	 * Logs the exception if observer present, or print it to System.out.
	 * <BR><BR>
	 * Does not throw the exception...
	 * <BR><BR>
	 * If exception 'e' is null, only info message is written to logs.
	 * @param e
	 * @param info	 
	 */
	protected void exceptionOccured(Exception e, String info) {
		IYylexObserver currentObserver = this.observer;
		if (currentObserver != null) {			
			currentObserver.exception(e, info != null ? info : "--empty info--");
		} else {
			System.out.println("Yylex exception: " + info);
			if (e != null) e.printStackTrace(); 
		}
	} 
	
	/**
	 * Send the warning to observer or prints it to the console.
	 */
	protected void warning(String info) {
		IYylexObserver currentObserver = this.observer;
		if (currentObserver != null) {			
			currentObserver.warning(info != null ? info : "--empty warning--");
		} else {
			System.out.println("Yylex warning: " + info);			 
		}
	}
	
	/**
	 * Returns 'num'-th token from 'text' using 'delimiters'.
	 * <BR><BR>
	 * Use only IFF you're getting only one token from 'text'.
	 * @param text
	 * @param delimiters
	 * @return String token
	 */ 
	protected String getToken(String text, String delimiters, int num) {
		StringTokenizer st = new StringTokenizer(text, delimiters);
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		try {
			return st.nextToken();
		} catch (Exception e) {
			exceptionOccured(e, "Can't get " + num + "-th token from text '"+text+"' using delimiters '"+delimiters+"'.");
			return null;
		}
	}
	
	/**
	 * Returns 'num'-th token from 'text' using DELIMITERS_STANDARD.
	 * <BR><BR>
	 * Use only IFF you're getting only one token from 'text'.
	 * @param text
	 * @return String token
	 */ 
	protected String getToken(String text, int num) {
		return getToken(text, DELIMITERS_STANDARD, num);		
	}

	/**
	 * Return an integer from num token in txt.
	 * <BR><BR>
	 * Integer token is expected to be 'second token' in the 'txt' using delimiters " {}".
	 * 
	 * @param  txt  text of parameter
	 * @return Integer from given token.
	 */
	protected int intValue( String txt  ) {
		try {
        	return Integer.parseInt(getToken(txt, 1));
        } catch (NullPointerException e) {
        	warning("Can't get int token from text '"+txt+"'.");
        	return -1;
        } catch (NumberFormatException e) {
        	exceptionOccured(e, "Wrong int number format in '"+txt+".");
        	return -1; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get int token from text '"+txt+"'.");
        	return -1;
        }
	}

	
	/**
	 * Return a double from num token in txt.
	 * <BR><BR>
	 * Num token is expected to be 'second token' in the 'txt' using delimiters " {}".	 
	 * 
	 * @param  txt  text of parameter
	 * @return Double from given token.
	 */
	protected double doubleValue(String txt) {
		try {
        	return Double.parseDouble(getToken(txt, 1));
        } catch (NullPointerException e) {
        	warning("Can't get double token from text '"+txt+"'.");
        	return -1;
        } catch (NumberFormatException e) {
        	exceptionOccured(e, "Wrong double number format in '"+txt+".");
        	return -1; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get double token from text '"+txt+"'.");
        	return -1;
        }
	}
	
	/**
	 * Return a float from num token in txt.
	 * <BR><BR>
	 * Num token is expected to be 'second token' in the 'txt' using delimiters " {}".	 
	 * 
	 * @param  txt  text of parameter
	 * @return Float from given token.
	 */
	protected float floatValue(String txt) {
		try {
        	return Float.parseFloat(getToken(txt, 1));
        } catch (NullPointerException e) {
        	warning("Can't get float token from text '"+txt+"'.");
        	return -1;
        } catch (NumberFormatException e) {
        	exceptionOccured(e, "Wrong float number format in '"+txt+".");
        	return -1; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get float token from text '"+txt+"'.");
        	return -1;
        }
	}
	
        /**
	 * Return a triple (double[]{x,y,z})
	 * starting from num token(tokens are separated by space) in 'txt'
	 * 
	 * @param  txt  text of parameter
	 * @return Array of three doubles from given token.
	 */
	protected double[] getTriple( String txt ) {
		StringTokenizer st = new StringTokenizer(txt, DELIMITERS_EXTENDED);
		
		int num = 1;
		while (num-- > 0 && st.hasMoreTokens()) {
			st.nextToken();
		}
		
		// now we should have an token with integer
		try {
			double t1,t2,t3;
			t1 = new Double(st.nextToken()).doubleValue();
			t2 = new Double(st.nextToken()).doubleValue();
			t3 = new Double(st.nextToken()).doubleValue();
        	return new double[]{t1,t2,t3};
        } catch (NumberFormatException e) {
        	exceptionOccured(e, "Wrong double number format in '"+txt+".");
        	return null; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get triple from text '"+txt+"'.");
        	return null;
        }
	}
	
	/**
	 * Return a Location instance starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @return Location from given token.
	 */
	protected Location locationValue(String txt) {
		double[] triple = getTriple(txt);
		try {
			return new Location(triple[0], triple[1], triple[2]);
		} catch (NullPointerException e) {
			warning("Can't get Location from text '"+txt+"'.");
			return new Location();
		} catch (Exception e) {
			exceptionOccured(e, "Can't get Location from text '"+txt+"'.");
			return null;
		}
	}
	
	/**
     * Return an ItemType instance.
     * 
     * @param  txt  text of parameter
     * @return ItemType from given token.
     */
    protected ItemType itemTypeValue(String txt) {
        return ItemType.getItemType(getToken(txt, 1));
    }
    
    protected ItemDescriptor itemDescriptorValue(ItemType type) {
    	return itemTranslator.getDescriptor(type);
    }
    
    /**
     * Return a Category of the item.
     * @param  txt  text of parameter
     * @return ItemType.Category from given token.
     */ 
    protected ItemType.Category categoryValue(String txt) {
    	try {
    		return ItemType.Category.valueOf(getToken(txt, 1).toUpperCase());
    	} catch (IllegalArgumentException e) {
    		return ItemType.Category.OTHER;
    	}
    }
	
	/**
	 * Return a Velocity instance starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @return Velocity from given token.
	 */
	protected Velocity velocityValue(String txt) {
		double[] triple = getTriple(txt);
		try {
			return new Velocity(triple[0], triple[1], triple[2]);
		} catch (NullPointerException e) {
			warning("Can't get Velocity from text '"+txt+"'.");
			return new Velocity();
		} catch (Exception e) {
			exceptionOccured(e, "Can't get Velocity from text '"+txt+"'.");
			return null;
		}
	}

	/**
	 * Return a Rotation instance starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @return Rotation from given token.
	 */
	protected Rotation rotationValue(String txt) {
		double[] triple = getTriple(txt);
		try {
			return new Rotation(triple[0], triple[1], triple[2]);
		} catch (NullPointerException e) {
			warning("Can't get Rotation from text '"+txt+"'.");
			return new Rotation();
		} catch (Exception e) {
			exceptionOccured(e, "Can't get Rotation from text '"+txt+"'.");
			return null;
		}
	}
	
	/**
	 * Return a Point3d instance starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @return Point3d from given token.
	 */
	protected Point3d point3dValue(String txt) {
		double[] triple = getTriple(txt);
		try {
			return new Point3d(triple[0], triple[1], triple[2]);
		} catch (NullPointerException e) {
			warning("Can't get Point3d from text '"+txt+"'.");
        	return new Point3d(0,0,0);
		} catch (Exception e) {
        	exceptionOccured(e, "Can't get Point3d from text '"+txt+"'.");
        	return null;
        }
	}
	
	/**
	 * Return a Vector3d instance starting from num token(tokens are separated by space) in txt
	 * 
	 * @param  txt  text of parameter
	 * @return Vector3d from given token.
	 */
	protected Vector3d vector3dValue(String txt) {
		double[] triple = getTriple(txt);
		try {
			return new Vector3d(triple[0], triple[1], triple[2]);
		} catch (NullPointerException e) {
			warning("Can't get Vector3d from text '"+txt+"'.");
        	return new Vector3d(0,0,0);
		} catch (Exception e) {
        	exceptionOccured(e, "Can't get Vector3d from text '"+txt+"'.");
        	return null;
        }
	}
	
	/**
	 * Returns string for parsed token.
	 *	 
	 * @param  txt  text of parameter
	 * @return String from given token.
	 */
	protected String stringValue( String txt ) {
		try {
        	int index = txt.indexOf(" ");
			if (index == -1) {
				warning("Can't get string token from text '" + txt + "'.");
				return "";
			}
			String string = txt.substring(index+1, txt.length()-1);
        	if (string != null) {
				return string;        	        		
        	} else {
        		warning("Can't get string token from text '"+txt+"'.");
        		return "";
        	}
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get string token from text '"+txt+"'.");
        	return "";
        }
	}
	
	/**
	 * Returns UnrealId for parsed token.
	 *	 
	 * @param  txt  text of parameter
	 * @return StringId from given token.
	 */
	protected UnrealId stringIdValue( String txt ) {
		return unrealIdValue(txt);				
	}
	
	/**
	 * Return a boolean from boolean token in txt.
	 * <BR><BR>
	 * Boolean token is expected to be 'second token' in the 'txt' using delimiters " {}".	 
	 * 
	 * @param  txt  text of parameter
	 * @return Boolean from given token.
	 */
	protected boolean booleanValue(String txt) {
		try {
        	String token = getToken(txt, 1);
        	if (token.equals("True")) return true;
        	else return false;
        } catch (NullPointerException e) {
        	warning("Can't get boolean token from text '"+txt+"'.");
        	return false; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get boolean token from text '"+txt+"'.");
        	return false;
        }
	}
	
	/**
	 * Return an UnrealId instance from identificator token in txt.
	 * <BR><BR>
	 * Boolean token is expected to be 'second token' in the 'txt' using delimiters " {}".	 
	 * 
	 * @param  txt  text of parameter
	 * @return UnrealId from given token.
	 */
	protected UnrealId unrealIdValue(String txt) {
		try {
        	String token = getToken(txt, 1);
        	if (token == null) {
        		warning("Can't get UnrealId token from text '"+txt+"'.");
        		return null;
        	}
        	return translator.getId(token);
        } catch (NullPointerException e) {
        	warning("Can't get UnrealId token from text '"+txt+"' (translator not set?).");
        	return null; 
        } catch (Exception e) {
        	exceptionOccured(e, "Can't get UnrealId token from text '"+txt+"'.");
        	return null;
        }
	}
		
    // this is stack with static size, so it can overflow... theoreticly... No.
    private int[] stack = new int[10];
    private int stack_pos = 0;
  
 	// actual object that is being parsed 
    protected Object actObj;
  
    /**
     * Change state to state and push original state to stack, so parser can return in state_return
     */
    private void state_go(int state)
    {
  	    stack[stack_pos++] = yystate();
  	    yybegin(state);
    }
  
    /**
     * Return to previous state.
     */
    private void state_return()
    {
  	    yybegin(stack[--stack_pos]);
    }
%} 

%line
%char]]>
%state DUMMY<xsl:for-each select="/messages/infomessages/messageobject">, MSG_<xsl:value-of select="@message"/></xsl:for-each>
<![CDATA[%full
%standalone

ALPHA=[A-Za-z]
ALPHA_NUMERIC={ALPHA}|{DIGIT}
SEP=[_\-.]
ALPHA_NUMERIC_SEP = {ALPHA}|{DIGIT}|{SEP}
UNREALID={ALPHA_NUMERIC_SEP}+

DIGIT=[0-9]
NONNEWLINE_WHITE_SPACE_CHAR=[\ \t\b\012]
NEWLINE=\r|\n|\r\n
WHITE_SPACE_CHAR=[\n\r\ \t\b\012]
UINT = {DIGIT}+

FLit1    = {DIGIT}+ \. {DIGIT}* 
FLit2    = \. {DIGIT}+ 
FLit3    = {DIGIT}+

INT = \-? {UINT}
FLOAT    = \-?({FLit1}|{FLit2}|{FLit3})
DOUBLE   = \-?({FLit1}|{FLit2}|{FLit3})
STRING=[^}]* 
STRINGID=[^}]+
ITEMTYPE = [^}]+
CATEGORY = [^}]+
POINT3D = {FLOAT} \, {FLOAT} \, {FLOAT}
VECTOR3D = {FLOAT} \, {FLOAT} \, {FLOAT}
LOCATION = {FLOAT} \, {FLOAT} \, {FLOAT}
VELOCITY = {FLOAT} \, {FLOAT} \, {FLOAT}
ROTATION = {FLOAT} \, {FLOAT} \, {FLOAT}
BOOLEAN = "True" | "False" | "true" | "false" | "Falso" | "falso"
SPACE= " "

%% 

<YYINITIAL> {
]]>
<xsl:for-each select="//messageobject">
  "<xsl:value-of select="@message"/>" {
  	actObj = new <xsl:value-of select="@name"/>();
  	state_go(MSG_<xsl:value-of select="@message"/>);
  }
</xsl:for-each>
<![CDATA[
}
]]>

<xsl:for-each select="//messageobject">
<![CDATA[<MSG_]]><xsl:value-of select="@message"/><![CDATA[>]]> {
  	<xsl:for-each select="property">
	  	<xsl:if test="not(@jflex)">
		  	<xsl:variable name="type" select="@type" />
			"{<xsl:value-of select="@name"/> " {<xsl:value-of select="upper-case($type)"/>} "}" {
				((<xsl:value-of select="../@name"/>)actObj).<xsl:value-of select="@name"/> = <xsl:call-template name="firstLetter"><xsl:with-param name="conversion" select="'lower'"/><xsl:with-param name="toconvert" select="$type"/></xsl:call-template>Value(yytext());
				<xsl:if test="./extra/code/yylex">
					<xsl:value-of select="./extra/code/yylex"/>
				</xsl:if>
			}
		</xsl:if>
  	</xsl:for-each>
  	
	. {
		if (!yytext().equals(" ")) {
			warning("State MSG_<xsl:value-of select="@message"/> unprocessed: " + yytext());
		}
  	}
}
</xsl:for-each>

<![CDATA[

<DUMMY> {
	. {
		warning("Dummy state, should not reach here: " + yytext());
	}
}

{WHITE_SPACE_CHAR} { }

{NEWLINE} { 
		// reset scanning
		stack_pos = 0;
 		yybegin(YYINITIAL);
 		if (actObj != null)
 		{ 			
 			InfoMessage obj = (InfoMessage) actObj;
 			
 			if (obj instanceof BeginMessage) {
                ut2004Time = ((BeginMessage)obj).getTime();
            } else
            if (obj instanceof AliveMessage) {
                ut2004Time = ((AliveMessage)obj).getTime();
            } else
 			if (obj instanceof IWorldObject) {
 				setTime((IWorldObject)obj, ut2004Time);
 			}
 			
 			actObj = null;
 			return obj;
 		}
}


. {
  warning("Illegal character: <" + yytext() + "> + currentstate "+ yystate());  
}
]]>

</xsl:template>

</xsl:stylesheet>
