/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SteeringProperties.SteeringProperties;
import SteeringProperties.WallFollowingeProperties;
import Steerings.RefBoolean;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.RemoveRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.utils.flag.FlagListener;
import interfaces.ISteering;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class WallFollowingSteer
implements ISteering {
    private UT2004Bot botself;
    private Raycasting raycasting;
    int distanceFromTheWall;
    int orderOfTheForce;
    private static final double MAGNITUDE_OF_THE_FORCE = 73.0;
    private static final int DEFAULTCOUNTER = 10;
    State state;
    int counter;
    protected static final String NLEFTFRONT = "nleftfront";
    protected static final String NLEFT = "nleft";
    protected static final String NRIGHTFRONT = "nrightfront";
    protected static final String NRIGHT = "nright";
    AutoTraceRay nleft;
    AutoTraceRay nright;
    AutoTraceRay nleftfront;
    AutoTraceRay nrightfront;
    int shortShortRayLength;
    int shortLongRayLength;
    int longShortRayLength;
    int longLongRayLength;
    boolean fastTrace = false;
    boolean floorCorrection = false;
    boolean traceActor = false;

    public WallFollowingSteer(UT2004Bot bot, Raycasting raycasting, SteeringProperties newProperties) {
        this.botself = bot;
        this.raycasting = raycasting;
        this.setProperties(newProperties);
        this.state = State.NOTHING;
        this.counter = 0;
        this.prepareRays();
    }

    public WallFollowingSteer(UT2004Bot bot, Raycasting raycasting) {
        this.botself = bot;
        this.raycasting = raycasting;
        this.setProperties(new WallFollowingeProperties());
        this.state = State.NOTHING;
        this.counter = 0;
        this.prepareRays();
    }

    private void prepareRays() {
        this.shortShortRayLength = (int)(200.0 * (double)this.distanceFromTheWall / 166.0);
        this.shortLongRayLength = (int)(500.0 * (double)this.distanceFromTheWall / 166.0);
        this.longShortRayLength = (int)(300.0 * (double)this.distanceFromTheWall / 166.0);
        this.longLongRayLength = (int)(750.0 * (double)this.distanceFromTheWall / 166.0);
        this.botself.getAct().act((CommandMessage)new RemoveRay("All"));
        this.raycasting.createRay(NLEFT, new Vector3d(0.0, -1.0, 0.0), this.longShortRayLength, this.fastTrace, this.floorCorrection, this.traceActor);
        this.raycasting.createRay(NLEFTFRONT, new Vector3d(Math.sqrt(3.0), -1.0, 0.0), this.longLongRayLength, this.fastTrace, this.floorCorrection, this.traceActor);
        this.raycasting.createRay(NRIGHTFRONT, new Vector3d(Math.sqrt(3.0), 1.0, 0.0), this.longLongRayLength, this.fastTrace, this.floorCorrection, this.traceActor);
        this.raycasting.createRay(NRIGHT, new Vector3d(0.0, 1.0, 0.0), this.longShortRayLength, this.fastTrace, this.floorCorrection, this.traceActor);
        this.raycasting.getAllRaysInitialized().addListener((FlagListener)new FlagListener<Boolean>(){

            public void flagChanged(Boolean changedValue) {
                WallFollowingSteer.this.nleftfront = WallFollowingSteer.this.raycasting.getRay(WallFollowingSteer.NLEFTFRONT);
                WallFollowingSteer.this.nrightfront = WallFollowingSteer.this.raycasting.getRay(WallFollowingSteer.NRIGHTFRONT);
                WallFollowingSteer.this.nleft = WallFollowingSteer.this.raycasting.getRay(WallFollowingSteer.NLEFT);
                WallFollowingSteer.this.nright = WallFollowingSteer.this.raycasting.getRay(WallFollowingSteer.NRIGHT);
            }
        });
        this.raycasting.endRayInitSequence();
    }

    public Vector3d run(RefBoolean wantsToGoFaster) {
        double multiplier;
        Vector3d normal;
        Vector3d rayToBot;
        Vector3d actualVelocity = this.botself.getVelocity().getVector3d();
        boolean shortrays = false;
        boolean sensornLeft = false;
        boolean sensornRight = false;
        boolean sensornLeftFront = false;
        boolean sensornRightFront = false;
        Vector3d nextVelocity = new Vector3d(0.0, 0.0, 0.0);
        if (!((Boolean)this.raycasting.getAllRaysInitialized().getFlag()).booleanValue()) {
            return nextVelocity;
        }
        if (this.nleftfront != null) {
            sensornLeftFront = this.nleftfront.isResult();
        }
        if (this.nrightfront != null) {
            sensornRightFront = this.nrightfront.isResult();
        }
        if (this.nleft != null) {
            sensornLeft = this.nleft.isResult();
        }
        if (this.nright != null) {
            sensornRight = this.nright.isResult();
        }
        if (sensornLeft) {
            rayToBot = new Vector3d(this.nleft.getHitLocation().x - this.botself.getLocation().x, this.nleft.getHitLocation().y - this.botself.getLocation().y, this.nleft.getHitLocation().z - this.botself.getLocation().z);
            normal = this.nleft.getHitNormal();
            multiplier = Math.pow(1.0 - ((double)this.longShortRayLength - rayToBot.length()) / (double)this.longShortRayLength, this.orderOfTheForce);
            normal.scale(multiplier * 73.0);
            nextVelocity.sub((Tuple3d)normal);
            if (rayToBot.length() < (double)this.shortShortRayLength) {
                shortrays = true;
                multiplier = Math.pow(((double)this.shortShortRayLength - rayToBot.length()) * 2.0 / (double)this.shortShortRayLength, this.orderOfTheForce);
                normal.normalize();
                normal.scale(multiplier * 73.0);
                nextVelocity.add((Tuple3d)normal);
            }
        }
        if (sensornRight) {
            rayToBot = new Vector3d(this.nright.getHitLocation().x - this.botself.getLocation().x, this.nright.getHitLocation().y - this.botself.getLocation().y, this.nright.getHitLocation().z - this.botself.getLocation().z);
            normal = this.nright.getHitNormal();
            multiplier = Math.pow(1.0 - ((double)this.longShortRayLength - rayToBot.length()) / (double)this.longShortRayLength, this.orderOfTheForce);
            normal.scale(multiplier * 73.0);
            nextVelocity.sub((Tuple3d)normal);
            if (rayToBot.length() < (double)this.shortShortRayLength) {
                shortrays = true;
                multiplier = Math.pow(((double)this.shortShortRayLength - rayToBot.length()) * 2.0 / (double)this.shortShortRayLength, this.orderOfTheForce);
                normal.normalize();
                normal.scale(multiplier * 73.0);
                nextVelocity.add((Tuple3d)normal);
            }
        }
        if (sensornLeftFront) {
            rayToBot = new Vector3d(this.nleftfront.getHitLocation().x - this.botself.getLocation().x, this.nleftfront.getHitLocation().y - this.botself.getLocation().y, this.nleftfront.getHitLocation().z - this.botself.getLocation().z);
            normal = this.nleftfront.getHitNormal();
            multiplier = Math.pow(1.0 - ((double)this.longLongRayLength - rayToBot.length()) / (double)this.longLongRayLength, this.orderOfTheForce);
            normal.scale(multiplier * 73.0);
            nextVelocity.sub((Tuple3d)normal);
            if (rayToBot.length() < (double)this.shortLongRayLength) {
                shortrays = true;
                multiplier = Math.pow(((double)this.shortLongRayLength - rayToBot.length()) * 2.0 / (double)this.shortLongRayLength, this.orderOfTheForce);
                normal.normalize();
                normal.scale(multiplier * 73.0);
                nextVelocity.add((Tuple3d)normal);
            }
        }
        if (sensornRightFront) {
            rayToBot = new Vector3d(this.nrightfront.getHitLocation().x - this.botself.getLocation().x, this.nrightfront.getHitLocation().y - this.botself.getLocation().y, this.nrightfront.getHitLocation().z - this.botself.getLocation().z);
            normal = this.nrightfront.getHitNormal();
            multiplier = Math.pow(1.0 - ((double)this.longLongRayLength - rayToBot.length()) / (double)this.longLongRayLength, this.orderOfTheForce);
            normal.scale(multiplier * 73.0);
            nextVelocity.sub((Tuple3d)normal);
            if (rayToBot.length() < (double)this.shortLongRayLength) {
                shortrays = true;
                multiplier = Math.pow(((double)this.shortLongRayLength - rayToBot.length()) * 2.0 / (double)this.shortLongRayLength, this.orderOfTheForce);
                normal.normalize();
                normal.scale(multiplier * 73.0);
                nextVelocity.add((Tuple3d)normal);
            }
        }
        if (this.state == State.NOTHING) {
            if (sensornRight && sensornRightFront) {
                this.state = State.RIGHT;
                this.counter = 10;
            }
            if (sensornLeft && sensornLeftFront) {
                this.state = State.LEFT;
                this.counter = 10;
            }
        } else if (this.state == State.LEFT) {
            if (sensornLeft && sensornLeftFront) {
                this.counter = 10;
            }
            if (!sensornLeft && !sensornLeftFront) {
                if (this.counter > 0) {
                    --this.counter;
                    Vector3d turningVector = new Vector3d(actualVelocity.y, -actualVelocity.x, 0.0);
                    turningVector.scale(1.0 / Math.sqrt(2.0));
                    Vector3d negativeVector = new Vector3d(-actualVelocity.x, -actualVelocity.y, 0.0);
                    negativeVector.scale(1.0 - 1.0 / Math.sqrt(2.0));
                    turningVector.add((Tuple3d)negativeVector);
                    return turningVector;
                }
                this.state = State.NOTHING;
            }
        } else if (this.state == State.RIGHT) {
            if (sensornRight && sensornRightFront) {
                this.counter = 10;
            }
            if (!sensornRight && !sensornRightFront) {
                if (this.counter > 0) {
                    --this.counter;
                    Vector3d turningVector = new Vector3d(-actualVelocity.y, actualVelocity.x, 0.0);
                    turningVector.scale(1.0 / Math.sqrt(2.0));
                    Vector3d negativeVector = new Vector3d(-actualVelocity.x, -actualVelocity.y, 0.0);
                    negativeVector.scale(1.0 - 1.0 / Math.sqrt(2.0));
                    turningVector.add((Tuple3d)negativeVector);
                    return turningVector;
                }
                this.state = State.NOTHING;
            }
        }
        if (!shortrays) {
            wantsToGoFaster.setValue(true);
        }
        return nextVelocity;
    }

    public void setProperties(SteeringProperties newProperties) {
        this.orderOfTheForce = ((WallFollowingeProperties)newProperties).getOrderOfTheForce();
        this.distanceFromTheWall = ((WallFollowingeProperties)newProperties).getDistanceFromTheWall();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NOTHING,
        LEFT,
        RIGHT;

    }
}

