/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SteeringProperties.SteeringProperties;
import SteeringProperties.WalkAlongProperties;
import Steerings.RefBoolean;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import interfaces.ISteering;
import java.util.Collection;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class WalkAlongSteer
implements ISteering {
    private UT2004Bot botself;
    private Location targetLocation;
    private int attractiveForce;
    private int distanceFromThePartner;
    private String partnerName;
    private Player partner;

    public WalkAlongSteer(UT2004Bot bot) {
        this.botself = bot;
    }

    public Vector3d run(RefBoolean wantsToGoFaster) {
        Vector3d actualVelocity = this.botself.getVelocity().getVector3d();
        Vector3d nextVelocity = new Vector3d(0.0, 0.0, 0.0);
        if (this.partner == null || this.partner.getLocation() == null) {
            this.partner = this.getPartner();
            Vector3d turningVector = new Vector3d(actualVelocity.y, -actualVelocity.x, 0.0);
            turningVector.scale(1.0 / Math.sqrt(2.0));
            Vector3d negativeVector = new Vector3d(-actualVelocity.x, -actualVelocity.y, 0.0);
            negativeVector.scale(1.0 - 1.0 / Math.sqrt(2.0));
            turningVector.add((Tuple3d)negativeVector);
            return turningVector;
        }
        Vector3d myVectorToTarget = new Vector3d(this.targetLocation.asPoint3d().x - this.botself.getLocation().x, this.targetLocation.asPoint3d().y - this.botself.getLocation().y, this.targetLocation.asPoint3d().z - this.botself.getLocation().z);
        Vector3d partnersVectorToTarget = new Vector3d(this.targetLocation.asPoint3d().x - this.partner.getLocation().x, this.targetLocation.asPoint3d().y - this.partner.getLocation().y, this.targetLocation.asPoint3d().z - this.partner.getLocation().z);
        Vector3d vectorInFrontOfPartner = new Vector3d();
        System.out.println("Ja k cili " + myVectorToTarget.length());
        System.out.println("Partner k cili " + partnersVectorToTarget.length());
        if (partnersVectorToTarget.length() > myVectorToTarget.length()) {
            System.out.println("Je dal.");
        } else {
            System.out.println("Musim ho dohnat.");
        }
        vectorInFrontOfPartner.x = (this.targetLocation.asPoint3d().x + this.partner.getLocation().x) / 2.0 - this.botself.getLocation().x;
        vectorInFrontOfPartner.y = (this.targetLocation.asPoint3d().y + this.partner.getLocation().y) / 2.0 - this.botself.getLocation().y;
        vectorInFrontOfPartner.z = (this.targetLocation.asPoint3d().z + this.partner.getLocation().z) / 2.0 - this.botself.getLocation().z;
        vectorInFrontOfPartner.normalize();
        double diff = (myVectorToTarget.length() - partnersVectorToTarget.length()) / 500.0;
        diff = diff > 0.0 ? Math.max(diff, 1.5) : Math.min(diff, -8.0);
        vectorInFrontOfPartner.scale((double)this.attractiveForce * Math.pow(2.0, diff));
        System.out.println("ToTarget " + vectorInFrontOfPartner.length());
        Vector3d vectorToPartner = new Vector3d(0.0, 0.0, 0.0);
        vectorToPartner.x = this.partner.getLocation().x - this.botself.getLocation().x;
        vectorToPartner.y = this.partner.getLocation().y - this.botself.getLocation().y;
        vectorToPartner.z = this.partner.getLocation().z - this.botself.getLocation().z;
        vectorToPartner.normalize();
        vectorToPartner.scale((double)this.attractiveForce * Math.pow(this.botself.getLocation().getDistance(this.partner.getLocation()) / (double)this.distanceFromThePartner, 2.0));
        System.out.println("To partner " + vectorToPartner.length());
        vectorToPartner.scale(0.4);
        vectorInFrontOfPartner.scale(0.5);
        nextVelocity.add((Tuple3d)vectorToPartner);
        nextVelocity.add((Tuple3d)vectorInFrontOfPartner);
        System.out.println("Vektor vysledny " + nextVelocity.length());
        return nextVelocity;
    }

    private Player getPartner() {
        UnrealId myId = ((Self)this.botself.getWorldView().getSingle(Self.class)).getId();
        Collection col = this.botself.getWorldView().getAll(Player.class).values();
        for (Player p : col) {
            System.out.println("Player " + p.getName());
            if (!p.getName().equals(this.partnerName) || p.getId() == myId) continue;
            System.out.println("Got the partner " + p.toString());
            return p;
        }
        return null;
    }

    public void setProperties(SteeringProperties newProperties) {
        this.attractiveForce = ((WalkAlongProperties)newProperties).getAttractiveForce();
        this.targetLocation = ((WalkAlongProperties)newProperties).getTargetLocation();
        this.distanceFromThePartner = ((WalkAlongProperties)newProperties).getDistanceFromThePartner();
        this.partnerName = ((WalkAlongProperties)newProperties).getPartnerName();
    }
}

