/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SteeringProperties.SteeringProperties;
import Steerings.LeaderFollowingSteer;
import Steerings.ObstacleAvoidanceSteer;
import Steerings.PathFollowingSteer;
import Steerings.PeopleAvoidanceSteer;
import Steerings.RefBoolean;
import Steerings.SteeringType;
import Steerings.TargetApproachingSteer;
import Steerings.WalkAlongSteer;
import Steerings.WallFollowingSteer;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import interfaces.ISteering;
import java.util.HashMap;
import java.util.Random;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class SteeringManager {
    public static final boolean DEBUG = true;
    private UT2004Bot botself;
    private Raycasting raycasting;
    private AdvancedLocomotion locomotion;
    private HashMap<SteeringType, ISteering> mySteerings;
    protected static final double WALK_VELOCITY_LENGTH = 220.0;
    protected static final double RUN_VELOCITY_LENGTH = 440.0;
    public static final Location BASIC_LOCATION = new Location(800.0, -1500.0, -3446.65);

    public SteeringManager(UT2004Bot bot, Raycasting raycasting, AdvancedLocomotion locomotion) {
        this.botself = bot;
        this.raycasting = raycasting;
        this.locomotion = locomotion;
        this.mySteerings = new HashMap();
        this.steeringManagerInitialized();
    }

    public void steeringManagerInitialized() {
        this.locomotion.setWalk();
        this.botself.getAct().act((CommandMessage)new Configuration().setDrawTraceLines(Boolean.valueOf(true)).setAutoTrace(Boolean.valueOf(true)).setSpeedMultiplier(Double.valueOf(1.0)));
    }

    public void addSteering(SteeringType type) {
        switch (type) {
            case OBSTACLE_AVOIDANCE: {
                this.mySteerings.put(type, new ObstacleAvoidanceSteer(this.botself, this.raycasting));
                break;
            }
            case TARGET_APPROACHING: {
                this.mySteerings.put(type, new TargetApproachingSteer(this.botself));
                break;
            }
            case LEADER_FOLLOWING: {
                this.mySteerings.put(type, new LeaderFollowingSteer(this.botself));
                break;
            }
            case PATH_FOLLOWING: {
                this.mySteerings.put(type, new PathFollowingSteer(this.botself));
                break;
            }
            case PEOPLE_AVOIDANCE: {
                this.mySteerings.put(type, new PeopleAvoidanceSteer(this.botself));
                break;
            }
            case WALK_ALONG: {
                this.mySteerings.put(type, new WalkAlongSteer(this.botself));
                break;
            }
            case WALL_FOLLOWING: {
                this.mySteerings.put(type, new WallFollowingSteer(this.botself, this.raycasting));
            }
        }
    }

    public boolean hasSteering(SteeringType type) {
        return this.mySteerings.containsKey(type);
    }

    public void removeSteering(SteeringType type) {
        this.mySteerings.remove(type);
    }

    public void setSteeringProperties(SteeringType type, SteeringProperties newProperties) {
        ISteering steer = this.mySteerings.get(type);
        if (steer != null) {
            steer.setProperties(newProperties);
        }
    }

    public void run() {
        Vector3d velocity = this.botself.getVelocity().getVector3d();
        System.out.println("real velocity length " + this.botself.getVelocity().getVector3d().length());
        Vector3d nextVelocity = new Vector3d(velocity.x, velocity.y, velocity.z);
        boolean everyoneWantsToGoFaster = true;
        RefBoolean wantsToGoFaster = new RefBoolean(false);
        for (ISteering steering : this.mySteerings.values()) {
            Vector3d newVelocity = steering.run(wantsToGoFaster);
            nextVelocity.add((Tuple3d)newVelocity);
            everyoneWantsToGoFaster = everyoneWantsToGoFaster && wantsToGoFaster.getValue();
            System.out.println(steering.toString() + "| " + newVelocity.length() + "| newVelocity: " + newVelocity);
        }
        this.moveTheBot(nextVelocity, everyoneWantsToGoFaster);
    }

    public void moveTheBot(Vector3d nextVelocity, boolean everyoneWantsToGoFaster) {
        double nextVelocityLength = nextVelocity.length();
        if (nextVelocityLength < 220.0 && everyoneWantsToGoFaster) {
            nextVelocityLength = 220.0;
        }
        if (nextVelocityLength > 550.0) {
            this.locomotion.setRun();
            System.out.println("run");
            System.out.println("length " + nextVelocityLength);
            if (nextVelocityLength > 4510.0) {
                nextVelocityLength = 4510.0;
            }
            nextVelocityLength -= 550.0;
            nextVelocityLength /= 3960.0;
            nextVelocityLength = (0.9 + nextVelocityLength) * 220.0;
        } else {
            this.locomotion.setWalk();
            System.out.println("walk");
            if (nextVelocityLength > 220.0) {
                nextVelocityLength = 220.0;
                System.out.println("We cut the velocity.");
            } else if (nextVelocityLength < 110.0 && (nextVelocityLength *= 1.5) == 0.0) {
                nextVelocityLength = 55.0;
            }
        }
        nextVelocity.scale(nextVelocityLength / nextVelocity.length());
        this.botself.getAct().act((CommandMessage)new Configuration().setSpeedMultiplier(Double.valueOf(nextVelocityLength / 220.0)).setAutoTrace(Boolean.valueOf(true)).setDrawTraceLines(Boolean.valueOf(true)));
        this.locomotion.moveTo((ILocated)new Location(this.botself.getLocation().x + nextVelocity.x, this.botself.getLocation().y + nextVelocity.y, this.botself.getLocation().z));
    }

    public static Location getRandomStartLocation() {
        Random random = new Random();
        int znam = 1;
        if (random.nextBoolean()) {
            znam = -1;
        }
        SteeringManager.BASIC_LOCATION.x -= (double)(random.nextInt(500) * znam);
        SteeringManager.BASIC_LOCATION.y -= (double)(random.nextInt(500) * znam);
        return BASIC_LOCATION;
    }
}

