/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.SteeringProperties;
import Steerings.RefBoolean;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.RemoveRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.utils.flag.FlagListener;
import interfaces.ISteering;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ObstacleAvoidanceSteer
implements ISteering {
    private UT2004Bot botself;
    private Raycasting raycasting;
    private int orderOfTheForce = 1;
    protected static final double VELOCITY_LENGTH = 220.0;
    protected static final String LEFTFRONT = "leftfront";
    protected static final String LEFT = "left";
    protected static final String RIGHTFRONT = "rightfront";
    protected static final String RIGHT = "right";
    protected static final String FRONT = "front";
    boolean sensorLeft = false;
    boolean sensorRight = false;
    boolean sensorLeftFront = false;
    boolean sensorRightFront = false;
    boolean sensorFront = false;
    AutoTraceRay left;
    AutoTraceRay right;
    AutoTraceRay leftfront;
    AutoTraceRay rightfront;
    AutoTraceRay front;
    final int shortRayLength = 125;
    final int longRayLength = 375;
    boolean fastTrace = false;
    boolean floorCorrection = false;
    boolean traceActor = false;

    public ObstacleAvoidanceSteer(UT2004Bot bot, Raycasting raycasting) {
        this.botself = bot;
        this.raycasting = raycasting;
        this.prepareRays();
    }

    private void prepareRays() {
        this.botself.getAct().act((CommandMessage)new RemoveRay("All"));
        this.raycasting.createRay(LEFT, new Vector3d(0.0, -1.0, 0.0), 125, this.fastTrace, this.floorCorrection, this.traceActor);
        this.raycasting.createRay(LEFTFRONT, new Vector3d(Math.sqrt(3.0) * 2.0, -1.0, 0.0), 375, this.fastTrace, this.floorCorrection, this.traceActor);
        this.raycasting.createRay(RIGHTFRONT, new Vector3d(Math.sqrt(3.0) * 2.0, 1.0, 0.0), 375, this.fastTrace, this.floorCorrection, this.traceActor);
        this.raycasting.createRay(RIGHT, new Vector3d(0.0, 1.0, 0.0), 125, this.fastTrace, this.floorCorrection, this.traceActor);
        this.raycasting.createRay(FRONT, new Vector3d(1.0, 0.0, 0.0), 375, this.fastTrace, this.floorCorrection, this.traceActor);
        this.raycasting.getAllRaysInitialized().addListener((FlagListener)new FlagListener<Boolean>(){

            public void flagChanged(Boolean changedValue) {
                ObstacleAvoidanceSteer.this.leftfront = ObstacleAvoidanceSteer.this.raycasting.getRay(ObstacleAvoidanceSteer.LEFTFRONT);
                ObstacleAvoidanceSteer.this.rightfront = ObstacleAvoidanceSteer.this.raycasting.getRay(ObstacleAvoidanceSteer.RIGHTFRONT);
                ObstacleAvoidanceSteer.this.left = ObstacleAvoidanceSteer.this.raycasting.getRay(ObstacleAvoidanceSteer.LEFT);
                ObstacleAvoidanceSteer.this.right = ObstacleAvoidanceSteer.this.raycasting.getRay(ObstacleAvoidanceSteer.RIGHT);
                ObstacleAvoidanceSteer.this.front = ObstacleAvoidanceSteer.this.raycasting.getRay(ObstacleAvoidanceSteer.FRONT);
            }
        });
        this.raycasting.endRayInitSequence();
    }

    public Vector3d run(RefBoolean wantsToGoFaster) {
        double multiplier;
        Vector3d normal;
        Vector3d rayToBot;
        if (this.leftfront != null) {
            this.sensorLeftFront = this.leftfront.isResult();
        }
        if (this.rightfront != null) {
            this.sensorRightFront = this.rightfront.isResult();
        }
        if (this.left != null) {
            this.sensorLeft = this.left.isResult();
        }
        if (this.right != null) {
            this.sensorRight = this.right.isResult();
        }
        if (this.front != null) {
            this.sensorFront = this.front.isResult();
        }
        boolean sensor = this.sensorFront || this.sensorLeft || this.sensorLeftFront || this.sensorRight || this.sensorRightFront;
        Vector3d nextVelocity = new Vector3d(0.0, 0.0, 0.0);
        if (this.sensorLeft) {
            rayToBot = new Vector3d(this.left.getHitLocation().x - this.botself.getLocation().x, this.left.getHitLocation().y - this.botself.getLocation().y, this.left.getHitLocation().z - this.botself.getLocation().z);
            normal = this.left.getHitNormal();
            multiplier = Math.pow((125.0 - rayToBot.length()) * 2.0 / 125.0, this.orderOfTheForce);
            normal.scale(220.0 * multiplier);
            nextVelocity.add((Tuple3d)normal);
        }
        if (this.sensorRight) {
            rayToBot = new Vector3d(this.right.getHitLocation().x - this.botself.getLocation().x, this.right.getHitLocation().y - this.botself.getLocation().y, this.right.getHitLocation().z - this.botself.getLocation().z);
            normal = this.right.getHitNormal();
            multiplier = Math.pow((125.0 - rayToBot.length()) * 2.0 / 125.0, this.orderOfTheForce);
            normal.scale(220.0 * multiplier);
            nextVelocity.add((Tuple3d)normal);
        }
        if (this.sensorLeftFront) {
            rayToBot = new Vector3d(this.leftfront.getHitLocation().x - this.botself.getLocation().x, this.leftfront.getHitLocation().y - this.botself.getLocation().y, this.leftfront.getHitLocation().z - this.botself.getLocation().z);
            normal = this.leftfront.getHitNormal();
            multiplier = Math.pow((375.0 - rayToBot.length()) * 2.0 / 375.0, this.orderOfTheForce);
            normal.scale(220.0 * multiplier);
            nextVelocity.add((Tuple3d)normal);
        }
        if (this.sensorRightFront) {
            rayToBot = new Vector3d(this.rightfront.getHitLocation().x - this.botself.getLocation().x, this.rightfront.getHitLocation().y - this.botself.getLocation().y, this.rightfront.getHitLocation().z - this.botself.getLocation().z);
            normal = this.rightfront.getHitNormal();
            multiplier = Math.pow((375.0 - rayToBot.length()) * 2.0 / 375.0, this.orderOfTheForce);
            normal.scale(220.0 * multiplier);
            nextVelocity.add((Tuple3d)normal);
        }
        if (this.sensorFront) {
            rayToBot = new Vector3d(this.front.getHitLocation().x - this.botself.getLocation().x, this.front.getHitLocation().y - this.botself.getLocation().y, this.front.getHitLocation().z - this.botself.getLocation().z);
            normal = this.front.getHitNormal();
            multiplier = Math.pow((375.0 - rayToBot.length()) * 2.0 / 375.0, this.orderOfTheForce);
            normal.scale(220.0 * multiplier);
            nextVelocity.add((Tuple3d)normal);
        }
        if (!sensor) {
            wantsToGoFaster.setValue(true);
        }
        return nextVelocity;
    }

    public void setProperties(SteeringProperties newProperties) {
        this.orderOfTheForce = ((ObstacleAvoidanceProperties)newProperties).getOrderOfTheForce();
    }
}

