/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SteeringProperties.LeaderFollowingProperties;
import SteeringProperties.SteeringProperties;
import Steerings.RefBoolean;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import interfaces.ISteering;
import java.util.Collection;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class LeaderFollowingSteer
implements ISteering {
    private UT2004Bot botself;
    int distanceFromTheLeader;
    double angleFromTheLeader;
    String leaderName;
    private Player leader;

    public LeaderFollowingSteer(UT2004Bot bot) {
        this.botself = bot;
    }

    public LeaderFollowingSteer(UT2004Bot bot, int distance, double angleFromTheLeader, String leaderName) {
        this.botself = bot;
        this.distanceFromTheLeader = distance;
        this.angleFromTheLeader = angleFromTheLeader;
        this.leaderName = leaderName;
    }

    public Vector3d run(RefBoolean wantsToGoFaster) {
        Vector3d actualVelocity = this.botself.getVelocity().getVector3d();
        Vector3d nextVelocity = new Vector3d(0.0, 0.0, 0.0);
        if (this.leader == null || !this.leader.isVisible()) {
            this.leader = this.getLeader();
            Vector3d turningVector = new Vector3d(actualVelocity.y, -actualVelocity.x, 0.0);
            turningVector.scale(1.0 / Math.sqrt(2.0));
            Vector3d negativeVector = new Vector3d(-actualVelocity.x, -actualVelocity.y, 0.0);
            negativeVector.scale(1.0 - 1.0 / Math.sqrt(2.0));
            turningVector.add((Tuple3d)negativeVector);
            return turningVector;
        }
        Vector3d leadersVelocity = this.leader.getVelocity().getVector3d();
        System.out.println("leaders velocity " + leadersVelocity.length());
        if (leadersVelocity.length() == 0.0) {
            nextVelocity.x = this.leader.getLocation().x - this.botself.getLocation().x;
            nextVelocity.y = this.leader.getLocation().y - this.botself.getLocation().y;
            nextVelocity.z = this.leader.getLocation().z - this.botself.getLocation().z;
            nextVelocity.scale(100.0 / nextVelocity.length());
            return nextVelocity;
        }
        Vector3d vectorSituationToTheLeader = new Vector3d(leadersVelocity.x * Math.cos(this.angleFromTheLeader) - leadersVelocity.y * Math.sin(this.angleFromTheLeader), leadersVelocity.x * Math.sin(this.angleFromTheLeader) + leadersVelocity.y * Math.cos(this.angleFromTheLeader), 0.0);
        vectorSituationToTheLeader.scale((double)this.distanceFromTheLeader / vectorSituationToTheLeader.length());
        leadersVelocity.scale(0.8 / leadersVelocity.length());
        Vector3d botToSituation = new Vector3d(this.leader.getLocation().x + leadersVelocity.x + vectorSituationToTheLeader.x - this.botself.getLocation().x, this.leader.getLocation().y + leadersVelocity.y + vectorSituationToTheLeader.y - this.botself.getLocation().y, this.leader.getLocation().z + leadersVelocity.z + vectorSituationToTheLeader.z - this.botself.getLocation().z);
        nextVelocity.add((Tuple3d)botToSituation);
        nextVelocity.scale(Math.log(botToSituation.length()));
        nextVelocity.scale(0.5);
        return nextVelocity;
    }

    private Player getLeader() {
        Collection col = this.botself.getWorldView().getAll(Player.class).values();
        for (Player p : col) {
            if (!p.getName().equals(this.leaderName)) continue;
            System.out.println("Got the leader");
            return p;
        }
        return null;
    }

    public void setProperties(SteeringProperties newProperties) {
        this.distanceFromTheLeader = ((LeaderFollowingProperties)newProperties).getDistanceFromTheLeader();
        this.angleFromTheLeader = ((LeaderFollowingProperties)newProperties).getAngleFromTheLeader();
        this.leaderName = ((LeaderFollowingProperties)newProperties).getLeaderName();
    }
}

