/*
 * Decompiled with CFR 0.152.
 */
package view;

import SteeringProperties.WallFollowingeProperties;
import Steerings.SteeringType;
import controller.ControllerMain;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import view.ViewSteeringTabs;
import view.ViewTabAbstract;

public class ViewTabWallFollowing
extends ViewTabAbstract {
    private JLabel orderOfTheForceLabel;
    private JTextField orderOfTheForceTextField;
    private JLabel distanceFromTheWallLabel;
    private JTextField distanceFromTheWallTextField;

    public ViewTabWallFollowing(ControllerMain controller, int order) {
        super(controller, order);
        this.description = "   A bot using this steering uses rays to detect walls; therefore the\nsteering works only if a wall is within reach of his rays. When a wall\nis detected, the bot \"touches\" it and follows it - walks in parallel\nwith the wall. When the wall is curved, it should follow it as well.\n   There are two parameters - order of the force (1-10) and a distance\nfrom the wall which is to be followed (100-200).";
        this.descriptionTextArea.setText(this.description);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 20;
        this.orderOfTheForceLabel = new JLabel("Order of the force");
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.orderOfTheForceLabel, c);
        int oldOrderOfTheForce = ((WallFollowingeProperties)controller.getActiveProperties(SteeringType.WALL_FOLLOWING)).getOrderOfTheForce();
        this.orderOfTheForceTextField = new JTextField(Integer.toString(oldOrderOfTheForce));
        this.orderOfTheForceTextField.setPreferredSize(new Dimension(100, 20));
        this.orderOfTheForceTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabWallFollowing.this.orderOfTheForceActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 5;
        this.add((Component)this.orderOfTheForceTextField, c);
        this.distanceFromTheWallLabel = new JLabel("Distance from the wall");
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)this.distanceFromTheWallLabel, c);
        int oldDistance = ((WallFollowingeProperties)controller.getActiveProperties(SteeringType.WALL_FOLLOWING)).getDistanceFromTheWall();
        this.distanceFromTheWallTextField = new JTextField(Integer.toString(oldDistance));
        this.distanceFromTheWallTextField.setPreferredSize(new Dimension(100, 20));
        this.distanceFromTheWallTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabWallFollowing.this.distanceFromTheWallActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 6;
        this.add((Component)this.distanceFromTheWallTextField, c);
        boolean isActive = controller.getActiveProperties(SteeringType.WALL_FOLLOWING).isActive();
        this.activeCheckBox = new JCheckBox("Active", isActive);
        this.activeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabWallFollowing.this.activeCheckBoxActionPerformed();
            }
        });
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.activeCheckBox, c);
    }

    private void orderOfTheForceActionPerformed() {
        ((WallFollowingeProperties)this.controller.getActiveProperties(SteeringType.WALL_FOLLOWING)).setOrderOfTheForce(Integer.parseInt(this.orderOfTheForceTextField.getText()));
    }

    private void distanceFromTheWallActionPerformed() {
        ((WallFollowingeProperties)this.controller.getActiveProperties(SteeringType.WALL_FOLLOWING)).setDistanceFromTheWall(Integer.parseInt(this.distanceFromTheWallTextField.getText()));
    }

    public void activeCheckBoxActionPerformed() {
        boolean isActive = this.activeCheckBox.isSelected();
        this.controller.getActiveProperties(SteeringType.WALL_FOLLOWING).setActive(isActive);
        this.controller.getView().getTabsPanel().setBackgroundAt(this.order, ViewSteeringTabs.getActiveTabColor(isActive));
    }
}

