/*
 * Decompiled with CFR 0.152.
 */
package view;

import SteeringProperties.WalkAlongProperties;
import Steerings.SteeringType;
import controller.ControllerMain;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import model.ModelChar;
import view.ViewSteeringTabs;
import view.ViewTabAbstract;

public class ViewTabWalkAlong
extends ViewTabAbstract {
    private JLabel forceToThePartnerLabel;
    private JTextField forceToThePartnerTextField;
    private JLabel distanceFromThePartnerPeopleLabel;
    private JTextField distanceFromThePartnerTextField;
    private JLabel endLocationLabel;
    private JTextField endLocationTextField;
    private JComboBox partnerComboBox;
    private String[] listOfCharactersString;

    public ViewTabWalkAlong(ControllerMain controller, int order) {
        super(controller, order);
        this.description = "   A special steering for a pair of bots. These \"partners\" are supposed\nto move to each other (They need to see each other at the beginning,\notherwise they just stand and turn around.), then to walk to the\nspecified target location together (to walk along there). An attractive\nforce towards the partner can be set (reasonable values being about\n100-200), as well as desired distance from the partner (which should\nbe about 300-600).";
        this.descriptionTextArea.setText(this.description);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 20;
        this.forceToThePartnerLabel = new JLabel("Attractive force to the partner");
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.forceToThePartnerLabel, c);
        int oldForce = ((WalkAlongProperties)controller.getActiveProperties(SteeringType.WALK_ALONG)).getAttractiveForce();
        this.forceToThePartnerTextField = new JTextField(Integer.toString(oldForce));
        this.forceToThePartnerTextField.setPreferredSize(new Dimension(100, 20));
        this.forceToThePartnerTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabWalkAlong.this.forceToThePartnerActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 5;
        this.add((Component)this.forceToThePartnerTextField, c);
        this.distanceFromThePartnerPeopleLabel = new JLabel("Distance from the partner");
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)this.distanceFromThePartnerPeopleLabel, c);
        int oldDistance = ((WalkAlongProperties)controller.getActiveProperties(SteeringType.WALK_ALONG)).getDistanceFromThePartner();
        this.distanceFromThePartnerTextField = new JTextField(Integer.toString(oldDistance));
        this.distanceFromThePartnerTextField.setPreferredSize(new Dimension(100, 20));
        this.distanceFromThePartnerTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabWalkAlong.this.distanceFromThePartnerActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 6;
        this.add((Component)this.distanceFromThePartnerTextField, c);
        this.endLocationLabel = new JLabel("Target location");
        c.gridx = 2;
        c.gridy = 5;
        this.add((Component)this.endLocationLabel, c);
        Location oldEndLocation = ((WalkAlongProperties)controller.getActiveProperties(SteeringType.WALK_ALONG)).getTargetLocation();
        this.endLocationTextField = new JTextField(oldEndLocation.x + "," + oldEndLocation.y + "," + oldEndLocation.z);
        this.endLocationTextField.setPreferredSize(new Dimension(100, 20));
        this.endLocationTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabWalkAlong.this.endLocationActionPerformed();
            }
        });
        c.gridx = 3;
        c.gridy = 5;
        this.add((Component)this.endLocationTextField, c);
        JLabel partnerLabel = new JLabel("Partner");
        c.gridx = 2;
        c.gridy = 6;
        this.add((Component)partnerLabel, c);
        this.listOfCharactersString = new String[controller.getCharacterCount() - 1];
        int i = 0;
        for (ModelChar character : controller.getAllCharacters()) {
            if (character == controller.getActiveCharacter()) continue;
            this.listOfCharactersString[i] = character.getName();
            ++i;
        }
        String oldPartner = ((WalkAlongProperties)controller.getActiveProperties(SteeringType.WALK_ALONG)).getPartnerName();
        this.partnerComboBox = new JComboBox<String>(this.listOfCharactersString);
        this.partnerComboBox.setSelectedItem(oldPartner);
        this.partnerComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabWalkAlong.this.partnerComboBoxActionPerformed();
            }
        });
        c.gridx = 3;
        c.gridy = 6;
        this.add((Component)this.partnerComboBox, c);
        boolean isActive = controller.getActiveProperties(SteeringType.WALK_ALONG).isActive();
        this.activeCheckBox = new JCheckBox("Active", isActive);
        this.activeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabWalkAlong.this.activeCheckBoxActionPerformed();
            }
        });
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.activeCheckBox, c);
    }

    private void forceToThePartnerActionPerformed() {
        ((WalkAlongProperties)this.controller.getActiveProperties(SteeringType.WALK_ALONG)).setAttractiveForce(Integer.parseInt(this.forceToThePartnerTextField.getText()));
    }

    private void distanceFromThePartnerActionPerformed() {
        ((WalkAlongProperties)this.controller.getActiveProperties(SteeringType.WALK_ALONG)).setDistanceFromThePartner(Integer.parseInt(this.distanceFromThePartnerTextField.getText()));
    }

    private void partnerComboBoxActionPerformed() {
        ((WalkAlongProperties)this.controller.getActiveProperties(SteeringType.WALK_ALONG)).setPartner((String)this.partnerComboBox.getSelectedItem());
        System.out.println("We set partner " + (String)this.partnerComboBox.getSelectedItem());
    }

    private void endLocationActionPerformed() {
        String[] text = this.endLocationTextField.getText().split(",");
        Location targetLocation = new Location(Float.parseFloat(text[0]), Float.parseFloat(text[1]), Float.parseFloat(text[2]));
        ((WalkAlongProperties)this.controller.getActiveProperties(SteeringType.WALK_ALONG)).setTargetLocation(targetLocation);
    }

    public void activeCheckBoxActionPerformed() {
        boolean isActive = this.activeCheckBox.isSelected();
        if (isActive) {
            this.partnerComboBoxActionPerformed();
        }
        this.controller.getActiveProperties(SteeringType.WALK_ALONG).setActive(isActive);
        this.controller.getView().getTabsPanel().setBackgroundAt(this.order, ViewSteeringTabs.getActiveTabColor(isActive));
    }
}

