/*
 * Decompiled with CFR 0.152.
 */
package view;

import SteeringProperties.TargetApproachingProperties;
import Steerings.SteeringType;
import controller.ControllerMain;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import view.ViewSteeringTabs;
import view.ViewTabAbstract;

public class ViewTabTargetApproaching
extends ViewTabAbstract {
    private JLabel attractiveForceLabel;
    private JTextField attractiveForceTextField;
    private JLabel endLocationLabel;
    private JTextField endLocationTextField;

    public ViewTabTargetApproaching(ControllerMain controller, int order) {
        super(controller, order);
        this.description = "   The bot is attracted towards certain target location. All the time the\nsteering works, a vector from the bot to the target location is added to\nhis velocity. The length of the vector is given as the second parameter\n(reasonable values are about 100-300).";
        this.descriptionTextArea.setText(this.description);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 20;
        this.attractiveForceLabel = new JLabel("Attractive force");
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.attractiveForceLabel, c);
        int oldAttractiveForce = ((TargetApproachingProperties)controller.getActiveProperties(SteeringType.TARGET_APPROACHING)).getAttractiveForce();
        this.attractiveForceTextField = new JTextField(Integer.toString(oldAttractiveForce));
        this.attractiveForceTextField.setPreferredSize(new Dimension(100, 20));
        this.attractiveForceTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabTargetApproaching.this.attractiveForceActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 5;
        this.add((Component)this.attractiveForceTextField, c);
        this.endLocationLabel = new JLabel("Target location");
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)this.endLocationLabel, c);
        Location oldEndLocation = ((TargetApproachingProperties)controller.getActiveProperties(SteeringType.TARGET_APPROACHING)).getEndLocation();
        this.endLocationTextField = new JTextField(oldEndLocation.x + "," + oldEndLocation.y + "," + oldEndLocation.z);
        this.endLocationTextField.setPreferredSize(new Dimension(100, 20));
        this.endLocationTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabTargetApproaching.this.endLocationActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 6;
        this.add((Component)this.endLocationTextField, c);
        boolean isActive = controller.getActiveProperties(SteeringType.TARGET_APPROACHING).isActive();
        this.activeCheckBox = new JCheckBox("Active", isActive);
        this.activeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabTargetApproaching.this.activeCheckBoxActionPerformed();
            }
        });
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.activeCheckBox, c);
    }

    private void attractiveForceActionPerformed() {
        ((TargetApproachingProperties)this.controller.getActiveProperties(SteeringType.TARGET_APPROACHING)).setAttractiveForce(Integer.parseInt(this.attractiveForceTextField.getText()));
    }

    private void endLocationActionPerformed() {
        String[] text = this.endLocationTextField.getText().split(",");
        Location targetLocation = new Location(Float.parseFloat(text[0]), Float.parseFloat(text[1]), Float.parseFloat(text[2]));
        ((TargetApproachingProperties)this.controller.getActiveProperties(SteeringType.TARGET_APPROACHING)).setEndLocation(targetLocation);
    }

    public void activeCheckBoxActionPerformed() {
        boolean isActive = this.activeCheckBox.isSelected();
        this.controller.getActiveProperties(SteeringType.TARGET_APPROACHING).setActive(isActive);
        this.controller.getView().getTabsPanel().setBackgroundAt(this.order, ViewSteeringTabs.getActiveTabColor(isActive));
    }
}

