/*
 * Decompiled with CFR 0.152.
 */
package view;

import SteeringProperties.PeopleAvoidanceProperties;
import Steerings.SteeringType;
import controller.ControllerMain;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import view.ViewSteeringTabs;
import view.ViewTabAbstract;

public class ViewTabPeopleAvoidance
extends ViewTabAbstract {
    private JLabel forceFromOtherPeopleLabel;
    private JTextField forceFromOtherPeopleTextField;
    private JLabel distanceFromOtherPeopleLabel;
    private JTextField distanceFromOtherPeopleTextField;

    public ViewTabPeopleAvoidance(ControllerMain controller, int order) {
        super(controller, order);
        this.description = "This steering affects the bot only when another bot is too close. The\n\"too close\" distance is one of two parameters of this steering\n(reasonable values are about 200-600). The second parameter is the\nforce, with which the bot is repulsed from other bots who are too\nclose (reasonable values are about 100-200).\n";
        this.descriptionTextArea.setText(this.description);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 20;
        this.forceFromOtherPeopleLabel = new JLabel("Force from other bots");
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.forceFromOtherPeopleLabel, c);
        int oldForce = ((PeopleAvoidanceProperties)controller.getActiveProperties(SteeringType.PEOPLE_AVOIDANCE)).getForceFromOtherPeople();
        this.forceFromOtherPeopleTextField = new JTextField(Integer.toString(oldForce));
        this.forceFromOtherPeopleTextField.setPreferredSize(new Dimension(100, 20));
        this.forceFromOtherPeopleTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabPeopleAvoidance.this.forceFromOtherPeopleActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 5;
        this.add((Component)this.forceFromOtherPeopleTextField, c);
        this.distanceFromOtherPeopleLabel = new JLabel("Distance from other bots");
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)this.distanceFromOtherPeopleLabel, c);
        int oldDistance = ((PeopleAvoidanceProperties)controller.getActiveProperties(SteeringType.PEOPLE_AVOIDANCE)).getDistanceFromOtherPeople();
        this.distanceFromOtherPeopleTextField = new JTextField(Integer.toString(oldDistance));
        this.distanceFromOtherPeopleTextField.setPreferredSize(new Dimension(100, 20));
        this.distanceFromOtherPeopleTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabPeopleAvoidance.this.distanceFromOtherPeopleActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 6;
        this.add((Component)this.distanceFromOtherPeopleTextField, c);
        boolean isActive = controller.getActiveProperties(SteeringType.PEOPLE_AVOIDANCE).isActive();
        this.activeCheckBox = new JCheckBox("Active", isActive);
        this.activeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabPeopleAvoidance.this.activeCheckBoxActionPerformed();
            }
        });
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.activeCheckBox, c);
    }

    private void forceFromOtherPeopleActionPerformed() {
        ((PeopleAvoidanceProperties)this.controller.getActiveProperties(SteeringType.PEOPLE_AVOIDANCE)).setForceFromOtherPeople(Integer.parseInt(this.forceFromOtherPeopleTextField.getText()));
    }

    private void distanceFromOtherPeopleActionPerformed() {
        ((PeopleAvoidanceProperties)this.controller.getActiveProperties(SteeringType.PEOPLE_AVOIDANCE)).setDistanceFromOtherPeople(Integer.parseInt(this.distanceFromOtherPeopleTextField.getText()));
    }

    public void activeCheckBoxActionPerformed() {
        boolean isActive = this.activeCheckBox.isSelected();
        this.controller.getActiveProperties(SteeringType.PEOPLE_AVOIDANCE).setActive(isActive);
        this.controller.getView().getTabsPanel().setBackgroundAt(this.order, ViewSteeringTabs.getActiveTabColor(isActive));
    }
}

