/*
 * Decompiled with CFR 0.152.
 */
package view;

import SteeringProperties.PathFollowingProperties;
import Steerings.SteeringType;
import controller.ControllerMain;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import view.ViewSteeringTabs;
import view.ViewTabAbstract;

public class ViewTabPathFollowing
extends ViewTabAbstract {
    private JLabel distanceFromThePathLabel;
    private JTextField distanceFromThePathTextField;
    private JLabel targetLocationLabel;
    private JTextField targetLocationTextField;

    public ViewTabPathFollowing(ControllerMain controller, int order) {
        super(controller, order);
        this.description = "    The bot using this steering receives a path to follow; the path is\ngiven to the bot as the starting and the target location. Then, a path\n(a list of navigation points) to be followed (It should be the shortest\npath possible.) is obtained.\n   The bot isn't supposed to go straightly from one navigation point to\nanother - he should walk in certain distance (reasonable values are\nabout 300-700) from the path (a set of lines drawn between navigation\npoints). Each tick, he obtains his projection in future (where would he\nget if he had the same velocity for some while). If this projection is\nfurther than the maximal allowed distance (i.e. he would stray too far\naway from the path), he is steered towards the path again (A vector from\nthe bot's projection to the path (perpendicular to the path) is obtained\nand its multiple added to the bot's velocity.).\n   Meanwhile, it is detected, whether the bot follows the path in the\n correct direction. If not, he's turned to walk in a proper way.";
        this.descriptionTextArea.setText(this.description);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 20;
        this.distanceFromThePathLabel = new JLabel("Distance from the path");
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.distanceFromThePathLabel, c);
        int oldDistance = ((PathFollowingProperties)controller.getActiveProperties(SteeringType.PATH_FOLLOWING)).getDistanceFromThePath();
        this.distanceFromThePathTextField = new JTextField(Integer.toString(oldDistance));
        this.distanceFromThePathTextField.setPreferredSize(new Dimension(100, 20));
        this.distanceFromThePathTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabPathFollowing.this.distanceFromThePathActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 5;
        this.add((Component)this.distanceFromThePathTextField, c);
        this.targetLocationLabel = new JLabel("Target location");
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)this.targetLocationLabel, c);
        Location oldTarget = ((PathFollowingProperties)controller.getActiveProperties(SteeringType.PATH_FOLLOWING)).getTargetLocation();
        this.targetLocationTextField = new JTextField(oldTarget.x + "," + oldTarget.y + "," + oldTarget.z);
        this.targetLocationTextField.setPreferredSize(new Dimension(100, 20));
        this.targetLocationTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabPathFollowing.this.targetLocationActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 6;
        this.add((Component)this.targetLocationTextField, c);
        boolean isActive = controller.getActiveProperties(SteeringType.PATH_FOLLOWING).isActive();
        this.activeCheckBox = new JCheckBox("Active", isActive);
        this.activeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabPathFollowing.this.activeCheckBoxActionPerformed();
            }
        });
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.activeCheckBox, c);
    }

    private void distanceFromThePathActionPerformed() {
        ((PathFollowingProperties)this.controller.getActiveProperties(SteeringType.PATH_FOLLOWING)).setDistanceFromThePath(Integer.parseInt(this.distanceFromThePathTextField.getText()));
    }

    private void targetLocationActionPerformed() {
        String[] text = this.targetLocationTextField.getText().split(",");
        Location targetLocation = new Location(Float.parseFloat(text[0]), Float.parseFloat(text[1]), Float.parseFloat(text[2]));
        ((PathFollowingProperties)this.controller.getActiveProperties(SteeringType.PATH_FOLLOWING)).setTargetLocation(targetLocation);
    }

    public void activeCheckBoxActionPerformed() {
        boolean isActive = this.activeCheckBox.isSelected();
        this.controller.getActiveProperties(SteeringType.PATH_FOLLOWING).setActive(isActive);
        this.controller.getView().getTabsPanel().setBackgroundAt(this.order, ViewSteeringTabs.getActiveTabColor(isActive));
    }
}

