/*
 * Decompiled with CFR 0.152.
 */
package view;

import SteeringProperties.ObstacleAvoidanceProperties;
import Steerings.SteeringType;
import controller.ControllerMain;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import view.ViewSteeringTabs;
import view.ViewTabAbstract;

public class ViewTabObstacleAvoidance
extends ViewTabAbstract {
    private JLabel orderOfTheForceLabel;
    private JTextField orderOfTheForceTextField;

    public ViewTabObstacleAvoidance(ControllerMain controller, int order) {
        super(controller, order);
        this.description = "    The bot using obstacle avoidance steering uses ray-casting to detect\npossible collisions with other objects in the game world and to evade\nthem. In case no ray hits (i.e. collides with an obstacle), this\nsteering doesn't affect the bot's movement at all. If a ray hits, a\nmultiple of the normal vector to the part of hit object, where the ray\nintersected it, is added to the bot's velocity vector. In this way, the \nbot is steered away from the obstacle. The closer the bot is to the\nobstacle, the more powerful is the force steering him away.\n   Furthermore, it can be chosen how the steering force grows with the\nbot's distance from the obstacle, whether is linear, quadratic etc.";
        this.descriptionTextArea.setText(this.description);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 20;
        this.orderOfTheForceLabel = new JLabel("Order of the force");
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.orderOfTheForceLabel, c);
        int oldOrderOfTheForce = ((ObstacleAvoidanceProperties)controller.getActiveProperties(SteeringType.OBSTACLE_AVOIDANCE)).getOrderOfTheForce();
        this.orderOfTheForceTextField = new JTextField(Integer.toString(oldOrderOfTheForce));
        this.orderOfTheForceTextField.setPreferredSize(new Dimension(100, 20));
        this.orderOfTheForceTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabObstacleAvoidance.this.orderOfTheForceActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 5;
        this.add((Component)this.orderOfTheForceTextField, c);
        boolean isActive = controller.getActiveProperties(SteeringType.OBSTACLE_AVOIDANCE).isActive();
        this.activeCheckBox = new JCheckBox("Active", isActive);
        this.activeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabObstacleAvoidance.this.activeCheckBoxActionPerformed();
            }
        });
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.activeCheckBox, c);
    }

    private void orderOfTheForceActionPerformed() {
        ((ObstacleAvoidanceProperties)this.controller.getActiveProperties(SteeringType.OBSTACLE_AVOIDANCE)).setOrderOfTheForce(Integer.parseInt(this.orderOfTheForceTextField.getText()));
    }

    public void activeCheckBoxActionPerformed() {
        boolean isActive = this.activeCheckBox.isSelected();
        this.controller.getActiveProperties(SteeringType.OBSTACLE_AVOIDANCE).setActive(isActive);
        this.controller.getView().getTabsPanel().setBackgroundAt(this.order, ViewSteeringTabs.getActiveTabColor(isActive));
    }
}

