/*
 * Decompiled with CFR 0.152.
 */
package view;

import SteeringProperties.LeaderFollowingProperties;
import Steerings.SteeringType;
import controller.ControllerMain;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import model.ModelChar;
import view.ViewSteeringTabs;
import view.ViewTabAbstract;

public class ViewTabLeaderFollowing
extends ViewTabAbstract {
    private JLabel angleFromTheLeaderLabel;
    private JTextField angleFromTheLeaderTextField;
    private JLabel distanceFromTheLeaderLabel;
    private JTextField distanceFromTheLeaderTextField;
    private JComboBox leaderComboBox;
    private String[] listOfCharactersString;

    public ViewTabLeaderFollowing(ControllerMain controller, int order) {
        super(controller, order);
        this.description = "   Bot follows one leader. You may change the position of situation to the\nleader. You can set the optimal distance from the leader - bot makes \nefforts to keep this distance (reasonable values are 200-600) and the \nangle (in degrees) from the leader's direction of move.\n   E.g. directly in front of the leader is the angle 0, slightly right \nin front of the leader 30, next to the leader from the right side 90, \nbehind -180, next to but from the left side -90, etc.";
        this.descriptionTextArea.setText(this.description);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 20;
        this.angleFromTheLeaderLabel = new JLabel("Angle");
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.angleFromTheLeaderLabel, c);
        double oldAngleRadians = ((LeaderFollowingProperties)controller.getActiveProperties(SteeringType.LEADER_FOLLOWING)).getAngleFromTheLeader();
        int oldAngle = (int)Math.round(oldAngleRadians * 180.0 / Math.PI);
        this.angleFromTheLeaderTextField = new JTextField(Integer.toString(oldAngle));
        this.angleFromTheLeaderTextField.setPreferredSize(new Dimension(100, 20));
        this.angleFromTheLeaderTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabLeaderFollowing.this.angleFromTheLeaderActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 5;
        this.add((Component)this.angleFromTheLeaderTextField, c);
        this.distanceFromTheLeaderLabel = new JLabel("Distance from the leader");
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)this.distanceFromTheLeaderLabel, c);
        int oldDistance = ((LeaderFollowingProperties)controller.getActiveProperties(SteeringType.LEADER_FOLLOWING)).getDistanceFromTheLeader();
        this.distanceFromTheLeaderTextField = new JTextField(Integer.toString(oldDistance));
        this.distanceFromTheLeaderTextField.setPreferredSize(new Dimension(100, 20));
        this.distanceFromTheLeaderTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabLeaderFollowing.this.distanceFromOtherPeopleActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 6;
        this.add((Component)this.distanceFromTheLeaderTextField, c);
        JLabel partnerLabel = new JLabel("Leader");
        c.gridx = 2;
        c.gridy = 5;
        this.add((Component)partnerLabel, c);
        this.listOfCharactersString = new String[controller.getCharacterCount() - 1];
        int i = 0;
        for (ModelChar character : controller.getAllCharacters()) {
            if (character == controller.getActiveCharacter()) continue;
            this.listOfCharactersString[i] = character.getName();
            ++i;
        }
        String oldLeader = ((LeaderFollowingProperties)controller.getActiveProperties(SteeringType.LEADER_FOLLOWING)).getLeaderName();
        this.leaderComboBox = new JComboBox<String>(this.listOfCharactersString);
        this.leaderComboBox.setSelectedItem(oldLeader);
        this.leaderComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabLeaderFollowing.this.leaderComboBoxActionPerformed();
            }
        });
        c.gridx = 3;
        c.gridy = 5;
        this.add((Component)this.leaderComboBox, c);
        boolean isActive = controller.getActiveProperties(SteeringType.LEADER_FOLLOWING).isActive();
        this.activeCheckBox = new JCheckBox("Active", isActive);
        this.activeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTabLeaderFollowing.this.activeCheckBoxActionPerformed();
            }
        });
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.activeCheckBox, c);
    }

    private void angleFromTheLeaderActionPerformed() {
        int angleInDegrees = Integer.parseInt(this.angleFromTheLeaderTextField.getText());
        double angleInRadians = Math.PI * (double)angleInDegrees / 180.0;
        ((LeaderFollowingProperties)this.controller.getActiveProperties(SteeringType.LEADER_FOLLOWING)).setAngleFromTheLeader(angleInRadians);
    }

    private void distanceFromOtherPeopleActionPerformed() {
        ((LeaderFollowingProperties)this.controller.getActiveProperties(SteeringType.LEADER_FOLLOWING)).setDistanceFromTheLeader(Integer.parseInt(this.distanceFromTheLeaderTextField.getText()));
    }

    private void leaderComboBoxActionPerformed() {
        ((LeaderFollowingProperties)this.controller.getActiveProperties(SteeringType.LEADER_FOLLOWING)).setLeaderName((String)this.leaderComboBox.getSelectedItem());
        System.out.println("We set leader " + (String)this.leaderComboBox.getSelectedItem());
    }

    public void activeCheckBoxActionPerformed() {
        boolean isActive = this.activeCheckBox.isSelected();
        if (isActive) {
            this.leaderComboBoxActionPerformed();
        }
        this.controller.getActiveProperties(SteeringType.LEADER_FOLLOWING).setActive(isActive);
        this.controller.getView().getTabsPanel().setBackgroundAt(this.order, ViewSteeringTabs.getActiveTabColor(isActive));
    }
}

