/*
 * Decompiled with CFR 0.152.
 */
package view;

import Steerings.SteeringType;
import controller.ControllerMain;
import java.awt.Color;
import javax.swing.JTabbedPane;
import view.ViewTabEmpty;
import view.ViewTabLeaderFollowing;
import view.ViewTabObstacleAvoidance;
import view.ViewTabPathFollowing;
import view.ViewTabPeopleAvoidance;
import view.ViewTabTargetApproaching;
import view.ViewTabWalkAlong;
import view.ViewTabWallFollowing;

public class ViewSteeringTabs
extends JTabbedPane {
    private ControllerMain controller;
    public static final Color ACTIVE_TAB_COLOR = new Color(184, 207, 229);
    public static final Color INACTIVE_TAB_COLOR = new Color(238, 238, 238);

    public static Color getActiveTabColor(boolean isActive) {
        if (isActive) {
            return ACTIVE_TAB_COLOR;
        }
        return INACTIVE_TAB_COLOR;
    }

    public ViewSteeringTabs(ControllerMain controller) {
        this.controller = controller;
        this.displayEmpty();
    }

    public void displayEmpty() {
        this.removeAll();
        this.addTab("", new ViewTabEmpty(this.controller, 0));
    }

    public void display() {
        if (this.controller.getActiveCharacter() == null) {
            this.displayEmpty();
            return;
        }
        this.removeAll();
        int i = 0;
        for (SteeringType type : this.controller.getActiveCharacter().getMySteerings().keySet()) {
            switch (type) {
                case OBSTACLE_AVOIDANCE: {
                    this.addTab("Obstacle Avoidance", new ViewTabObstacleAvoidance(this.controller, i));
                    break;
                }
                case PEOPLE_AVOIDANCE: {
                    this.addTab("People Avoidance", new ViewTabPeopleAvoidance(this.controller, i));
                    break;
                }
                case TARGET_APPROACHING: {
                    this.addTab("Target Approaching", new ViewTabTargetApproaching(this.controller, i));
                    break;
                }
                case PATH_FOLLOWING: {
                    this.addTab("Path Following", new ViewTabPathFollowing(this.controller, i));
                    break;
                }
                case WALL_FOLLOWING: {
                    this.addTab("Wall Following", new ViewTabWallFollowing(this.controller, i));
                    break;
                }
                case LEADER_FOLLOWING: {
                    this.addTab("Leader Following", new ViewTabLeaderFollowing(this.controller, i));
                    break;
                }
                case WALK_ALONG: {
                    this.addTab("Walk Along", new ViewTabWalkAlong(this.controller, i));
                }
            }
            if (this.controller.getActiveCharacter().getMySteerings().get(type).isActive()) {
                this.setBackgroundAt(i, ACTIVE_TAB_COLOR);
            }
            ++i;
        }
    }
}

