/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.ControllerMain;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ViewCharacterProperties
extends JPanel {
    private ControllerMain controller;
    private JLabel propertiesLabel;
    private JTextField textFieldName;
    private JLabel startLocationLabel;
    private JTextField startLocationTextField;

    public ViewCharacterProperties(ControllerMain controller) {
        this.controller = controller;
        this.initComponents();
        this.displayEmpty();
    }

    public void initComponents() {
        Dimension myElementDimension = new Dimension(180, 20);
        this.propertiesLabel = new JLabel("Properties");
        this.propertiesLabel.setFont(new Font(this.propertiesLabel.getFont().getFamily(), 1, 18));
        this.propertiesLabel.setPreferredSize(myElementDimension);
        this.propertiesLabel.setAlignmentX(0.5f);
        this.add(this.propertiesLabel);
        Dimension lesserDimension = new Dimension((int)Math.round((double)myElementDimension.width * 0.7), (int)Math.round((double)myElementDimension.height * 0.7));
        JLabel emptyLabel = new JLabel();
        emptyLabel.setPreferredSize(lesserDimension);
        this.add(emptyLabel);
        JLabel nameLabel = new JLabel("Name");
        nameLabel.setPreferredSize(myElementDimension);
        nameLabel.setAlignmentX(0.5f);
        this.add(nameLabel);
        this.textFieldName = new JTextField("");
        this.textFieldName.setMaximumSize(myElementDimension);
        this.textFieldName.setAlignmentX(0.5f);
        this.add(this.textFieldName);
        this.startLocationLabel = new JLabel("Starting location");
        this.startLocationLabel.setAlignmentX(0.5f);
        this.add(this.startLocationLabel);
        this.startLocationTextField = new JTextField("");
        this.startLocationTextField.setMaximumSize(myElementDimension);
        this.startLocationTextField.setAlignmentX(0.5f);
        this.add(this.startLocationTextField);
        this.add(Box.createVerticalGlue());
    }

    public void displayEmpty() {
        this.textFieldName.setText("");
        this.startLocationTextField.setText("");
    }

    public void display() {
        if (this.controller.getActiveCharacter() == null) {
            this.displayEmpty();
            return;
        }
        this.textFieldName.setText(this.controller.getActiveCharacter().getName());
        this.textFieldName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(ViewCharacterProperties.this.textFieldName.getText());
                ViewCharacterProperties.this.controller.setNameOfActiveCharacter(ViewCharacterProperties.this.textFieldName.getText());
            }
        });
        Location startLocation = this.controller.getActiveCharacter().getStartLocation();
        this.startLocationTextField.setText(startLocation.x + "," + startLocation.y + "," + startLocation.z);
        this.startLocationTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(ViewCharacterProperties.this.startLocationTextField.getText());
                String[] text = ViewCharacterProperties.this.startLocationTextField.getText().split(",");
                Location startLocation = new Location(Float.parseFloat(text[0]), Float.parseFloat(text[1]), Float.parseFloat(text[2]));
                ViewCharacterProperties.this.controller.getActiveCharacter().setStartLocation(startLocation);
            }
        });
    }
}

