/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.ControllerMain;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.border.LineBorder;
import model.ModelChar;

public class ViewCharacterPane
extends JButton {
    private ControllerMain controller;
    private ModelChar myCharacter;

    public ViewCharacterPane(ControllerMain controller, ModelChar character) {
        this.controller = controller;
        this.myCharacter = character;
        character.setViewCharacterPane(this);
        this.setPreferredSize(new Dimension(200, 20));
        this.display();
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewCharacterPane.this.myActionPerformed();
                System.out.println(e.getActionCommand().toString());
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    ViewCharacterPane.this.mouseRightClick();
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void mouseRightClick() {
        int result = JOptionPane.showConfirmDialog(this.controller.getView(), "Do you want to delete this character?", "Delete the character " + this.myCharacter.getName() + "?", 0);
        if (result == 0) {
            this.controller.removeCharacter(this.myCharacter);
        }
    }

    private void myActionPerformed() {
        this.controller.setActiveCharacter(this.myCharacter);
    }

    public void display() {
        if (this.myCharacter.isActive()) {
            this.setBorder(new LineBorder(Color.BLACK, 3));
        } else {
            this.setBorder(new LineBorder(Color.BLACK, 1));
        }
        this.setText(this.myCharacter.getName());
    }
}

