/*
 * Decompiled with CFR 0.152.
 */
package model;

import SteeringProperties.LeaderFollowingProperties;
import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.PathFollowingProperties;
import SteeringProperties.PeopleAvoidanceProperties;
import SteeringProperties.SteeringProperties;
import SteeringProperties.TargetApproachingProperties;
import SteeringProperties.WalkAlongProperties;
import SteeringProperties.WallFollowingeProperties;
import Steerings.SteeringManager;
import Steerings.SteeringType;
import controller.ControllerMain;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import java.io.Serializable;
import java.util.HashMap;
import view.ViewCharacterPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelChar
implements Serializable {
    protected transient ControllerMain controller;
    protected transient ViewCharacterPane myPane;
    public transient UT2004Bot myBot;
    protected boolean active;
    protected int id;
    protected String name;
    protected Location startLocation;
    private HashMap<SteeringType, SteeringProperties> mySteerings;

    public ModelChar(ControllerMain controller) {
        this.controller = controller;
        this.id = controller.getCharacterCount() + 1;
        this.name = "Bot " + this.id;
        this.startLocation = SteeringManager.getRandomStartLocation();
        this.mySteerings = new HashMap();
        this.active = false;
        this.addAllSteeringProperties();
    }

    public void setAfterSerialization(ControllerMain controller, ViewCharacterPane pane) {
        this.controller = controller;
        this.myPane = pane;
        this.myBot = null;
    }

    private void addAllSteeringProperties() {
        this.mySteerings.put(SteeringType.OBSTACLE_AVOIDANCE, (SteeringProperties)new ObstacleAvoidanceProperties());
        this.mySteerings.put(SteeringType.PEOPLE_AVOIDANCE, (SteeringProperties)new PeopleAvoidanceProperties());
        this.mySteerings.put(SteeringType.PATH_FOLLOWING, (SteeringProperties)new PathFollowingProperties());
        this.mySteerings.put(SteeringType.WALL_FOLLOWING, (SteeringProperties)new WallFollowingeProperties());
        this.mySteerings.put(SteeringType.TARGET_APPROACHING, (SteeringProperties)new TargetApproachingProperties());
        this.mySteerings.put(SteeringType.LEADER_FOLLOWING, (SteeringProperties)new LeaderFollowingProperties());
        this.mySteerings.put(SteeringType.WALK_ALONG, (SteeringProperties)new WalkAlongProperties());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public ViewCharacterPane getViewCharacterPane() {
        return this.myPane;
    }

    public void setViewCharacterPane(ViewCharacterPane pane) {
        this.myPane = pane;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.myPane.display();
    }

    public Location getStartLocation() {
        return this.startLocation;
    }

    public void setStartLocation(Location startLocation) {
        this.startLocation = startLocation;
    }

    public HashMap<SteeringType, SteeringProperties> getMySteerings() {
        return this.mySteerings;
    }

    public SteeringProperties getActiveProperties(SteeringType type) {
        return this.mySteerings.get(type);
    }
}

