/*
 * Decompiled with CFR 0.152.
 */
package controller;

import SteeringProperties.SteeringProperties;
import Steerings.SteeringType;
import controller.Bot;
import controller.ControllerMain;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.HashMap;
import java.util.LinkedList;
import model.ModelChar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerServer {
    private ControllerMain controller;

    public ControllerServer(ControllerMain controller) {
        this.controller = controller;
    }

    public void play() {
        LinkedList<ModelChar> allCharacters = this.controller.getAllCharacters();
        for (ModelChar character : allCharacters) {
            if (character.myBot != null) continue;
            character.myBot = this.createBot(character.getName(), character.getStartLocation(), character.getMySteerings());
        }
    }

    private UT2004Bot createBot(final String botName, final Location startingLocation, final HashMap<SteeringType, SteeringProperties> mapOfSteerings) {
        UT2004BotFactory factory = new UT2004BotFactory(new UT2004BotModule(Bot.class));
        UT2004BotRunner botRunner = new UT2004BotRunner((IAgentFactory)factory){

            protected void preStartHook(IAgent agent) throws PogamutException {
                super.preStartHook(agent);
                Bot bot = (Bot)((UT2004Bot)agent).getController();
                bot.init(botName, startingLocation, mapOfSteerings);
            }
        };
        return (UT2004Bot)botRunner.startAgent();
    }

    public void pause() {
        LinkedList<ModelChar> allCharacters = this.controller.getAllCharacters();
        for (ModelChar character : allCharacters) {
            if (character.myBot == null) continue;
            ((Bot)character.myBot.getController()).pause();
        }
    }

    public void stop() {
        LinkedList<ModelChar> allCharacters = this.controller.getAllCharacters();
        for (ModelChar character : allCharacters) {
            if (character.myBot == null) continue;
            character.myBot.stop();
            character.myBot = null;
        }
    }
}

