/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.ControllerMain;
import controller.ExtensionFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ControllerSaveAndLoad {
    private ControllerMain controller;
    private String currentSavingFile;
    private File currentSaveLoadDir;

    public ControllerSaveAndLoad(ControllerMain controller) {
        this.controller = controller;
    }

    public void setCurrentFileNull() {
        this.currentSavingFile = null;
    }

    public void saveAs() {
        JFileChooser chooser = new JFileChooser();
        if (this.currentSaveLoadDir == null) {
            this.currentSaveLoadDir = new File(".");
        }
        chooser.setCurrentDirectory(this.currentSaveLoadDir);
        ExtensionFileFilter filter = new ExtensionFileFilter("steer", new String[]{"steer"});
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this.controller.getView());
        this.currentSaveLoadDir = chooser.getCurrentDirectory();
        if (returnVal == 0) {
            try {
                int result;
                this.currentSavingFile = chooser.getSelectedFile().getCanonicalPath();
                if (!filter.acceptFileString(this.currentSavingFile)) {
                    this.currentSavingFile = this.currentSavingFile + ".steer";
                }
                if (new File(this.currentSavingFile).exists() && (result = JOptionPane.showConfirmDialog(this.controller.getView(), "Do you want to overwite existing file?")) != 0) {
                    this.saveAs();
                    return;
                }
                this.save(this.currentSavingFile);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.controller.getView(), "Error with saving the file as.");
            }
        }
    }

    public void save() {
        if (this.currentSavingFile == null) {
            this.saveAs();
        } else {
            try {
                int result;
                File currentFile = new File(this.currentSavingFile);
                if (new File(this.currentSavingFile).exists() && (result = JOptionPane.showConfirmDialog(this.controller.getView(), "Do you want to overwite file " + currentFile.getName() + "?")) != 0) {
                    this.saveAs();
                    return;
                }
                this.save(this.currentSavingFile);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.controller.getView(), "Error with saving the file.");
            }
        }
    }

    public void save(String file) throws IOException {
        System.out.println("We want to save file " + file);
        FileOutputStream f_out = new FileOutputStream(file);
        ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
        obj_out.writeObject(this.controller.getAllCharacters());
        obj_out.close();
        f_out.close();
    }

    public void load() {
        if (this.controller.getCharacterCount() > 0) {
            int result = JOptionPane.showConfirmDialog(this.controller.getView(), "Do you want to save your project?");
            if (result == 0) {
                this.save();
            } else if (result == 2) {
                return;
            }
        }
        JFileChooser chooser = new JFileChooser();
        if (this.currentSaveLoadDir == null) {
            this.currentSaveLoadDir = new File(".");
        }
        chooser.setCurrentDirectory(this.currentSaveLoadDir);
        ExtensionFileFilter filter = new ExtensionFileFilter("steer", new String[]{"steer"});
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this.controller.getView());
        this.currentSaveLoadDir = chooser.getCurrentDirectory();
        if (returnVal == 0) {
            try {
                this.currentSavingFile = chooser.getSelectedFile().getCanonicalPath();
                this.load(this.currentSavingFile);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(null, "FILE NOT FOUND");
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "INCORRECT FILE TYPE");
            }
            catch (ClassNotFoundException ex) {
                JOptionPane.showMessageDialog(null, "CANNOT READ THE FILE");
            }
        }
    }

    private void load(String file) throws FileNotFoundException, IOException, ClassNotFoundException {
        this.controller.reset();
        FileInputStream f_in = new FileInputStream(file);
        ObjectInputStream obj_in = new ObjectInputStream(f_in);
        LinkedList characters = (LinkedList)obj_in.readObject();
        this.controller.setCharacters(characters);
        this.controller.displayNewCharacters();
        obj_in.close();
        f_in.close();
    }
}

