/*
 * Decompiled with CFR 0.152.
 */
package controller;

import SteeringProperties.SteeringProperties;
import Steerings.SteeringType;
import controller.ControllerSaveAndLoad;
import controller.ControllerServer;
import java.util.LinkedList;
import model.ModelChar;
import model.ModelMain;
import view.ViewCharacterPane;
import view.ViewCharacterProperties;
import view.ViewCharacters;
import view.ViewMain;
import view.ViewSteeringTabs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerMain {
    private ModelMain model = new ModelMain(this);
    private ViewMain view;
    private ControllerServer server;
    private ControllerSaveAndLoad saveAndLoad;

    public ControllerMain(ViewMain view) {
        this.view = view;
        this.server = new ControllerServer(this);
        this.saveAndLoad = new ControllerSaveAndLoad(this);
    }

    public void setView(ViewMain view) {
        this.view = view;
    }

    public ViewMain getView() {
        return this.view;
    }

    public int getCharacterCount() {
        return this.model.getCharacterCount();
    }

    public void setActiveCharacter(ModelChar character) {
        this.model.setActiveCharacter(character);
        ((ViewSteeringTabs)this.view.getTabsPanel()).display();
        ((ViewCharacterProperties)this.view.getCharacterPropertiesPanel()).display();
    }

    public ModelChar getActiveCharacter() {
        return this.model.getActiveCharacter();
    }

    public void setNameOfActiveCharacter(String name) {
        this.model.getActiveCharacter().setName(name);
    }

    public void reset() {
        this.model.setCharacters(new LinkedList<ModelChar>());
        this.model.setCharacterCount(0);
        this.view.getCharacterPanel().removeAll();
        ((ViewCharacterProperties)this.view.getCharacterPropertiesPanel()).displayEmpty();
        ((ViewSteeringTabs)this.view.getTabsPanel()).displayEmpty();
        this.setActiveCharacter(null);
        this.saveAndLoad.setCurrentFileNull();
        this.view.getCharacterPanel().repaint();
        this.view.pack();
    }

    public void displayNewCharacters() {
        this.view.validate();
        for (ModelChar character : this.getAllCharacters()) {
            ViewCharacterPane newPanel = new ViewCharacterPane(this, character);
            ((ViewCharacters)this.view.getCharacterPanel()).addCharPanel(newPanel);
            if (!character.isActive()) continue;
            this.setActiveCharacter(character);
        }
        this.view.getCharacterPanel().repaint();
        this.view.pack();
    }

    public void addNewCharacter() {
        ModelChar newCharacter = new ModelChar(this);
        this.model.addCharacter(newCharacter);
        ViewCharacterPane newPanel = new ViewCharacterPane(this, newCharacter);
        ((ViewCharacters)this.view.getCharacterPanel()).addCharPanel(newPanel);
    }

    public SteeringProperties getActiveProperties(SteeringType type) {
        return this.getActiveCharacter().getActiveProperties(type);
    }

    public LinkedList<ModelChar> getAllCharacters() {
        return this.model.getCharacters();
    }

    public void setCharacters(LinkedList<ModelChar> characters) {
        this.model.setCharacters(characters);
        this.model.setCharacterCount(this.getAllCharacters().size());
        for (ModelChar character : this.getAllCharacters()) {
            character.setAfterSerialization(this, null);
        }
    }

    public void play() {
        this.server.play();
    }

    public void stop() {
        this.server.stop();
    }

    public void pause() {
        this.server.pause();
    }

    public void save() {
        this.saveAndLoad.save();
    }

    public void load() {
        this.saveAndLoad.load();
    }

    public void removeCharacter(ModelChar character) {
        if (this.getActiveCharacter() == character) {
            this.setActiveCharacter(null);
        }
        this.view.getCharacterPanel().remove(character.getViewCharacterPane());
        this.model.removeCharacter(character);
        this.view.getCharacterPanel().repaint();
        this.view.pack();
    }

    public void saveAs() {
        this.saveAndLoad.saveAs();
    }
}

